/*
 * Decompiled with CFR 0.152.
 */
package s1040validator.v9;

import dec.DECDbAccessRoot;
import dec.DECTag;
import dec.DECValidatorRoot;
import dec.Info;
import dec.Params;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import s1040validator.v9.Bilant1040;
import s1040validator.v9.DbAccessImpl;
import s1040validator.v9.F10;

public class ValidatorImpl
extends DECValidatorRoot {
    static final String DEC_NAMESPACE = "mfp:anaf:dgti:s1040:declaratie:v10";
    static final int ID_BILANT1040 = 0;
    static final int ID_F10 = 1;
    static final int ID_F20 = 2;
    static final int ID_F30 = 3;
    static final int ID_F40 = 4;
    private static DECTag[] _taguri = new DECTag[]{new DECTag("Bilant1040", 0, 1, 1, true), new DECTag("F10", 1, 1, 1, false), new DECTag("F20", 2, 1, 1, false), new DECTag("F30", 3, 1, 1, false), new DECTag("F40", 4, 1, 1, false)};
    private static long[] _tabelPrecedenta = new long[]{ValidatorImpl.start((int)0), ValidatorImpl.startStart((int)1, (int)0), ValidatorImpl.startEnd((int)2, (int)1), ValidatorImpl.startEnd((int)3, (int)2), ValidatorImpl.startEnd((int)4, (int)3), ValidatorImpl.endEnd((int)0, (int)4), ValidatorImpl.endStart((int)1, (int)1), ValidatorImpl.endStart((int)2, (int)2), ValidatorImpl.endStart((int)3, (int)3), ValidatorImpl.endStart((int)4, (int)4)};
    private DbAccessImpl _dbObj = null;
    public String _xmlContext;
    Bilant1040 _Bilant1040 = null;
    F10 _F10 = null;
    boolean _existsF10;
    boolean _existsF20;
    boolean _existsF30;
    boolean _existsF40;

    public ValidatorImpl() {
        this.init(_taguri, _tabelPrecedenta, DEC_NAMESPACE);
    }

    public void initializareDocument() {
        if (this._Bilant1040 == null) {
            this._Bilant1040 = new Bilant1040(this, null);
            this._F10 = new F10(this, this._Bilant1040);
        } else {
            this._Bilant1040.setParams();
            this._F10.setParams();
        }
    }

    public void finalizareDocument(Info info) {
        if (this._dbObj != null) {
            return;
        }
        info._decName = "s1040";
        info._tipPerioada = "L";
        info._luna = this.adjustString(this._Bilant1040._luna);
        info._perioada = this.adjustString(this._Bilant1040._luna);
        info._an = this.adjustString(this._Bilant1040._an);
        if (this._extractValuesFlag != 0) {
            return;
        }
        info._cif = this.adjustString(this._Bilant1040._cui);
        info._denumire = this.adjustString(this._Bilant1040._den);
        info._adresa = this.adjustString(this._Bilant1040._adresa);
        info._telefon = this.adjustString(this._Bilant1040._telefon);
        info._numeDeclar = this.adjustString(this._Bilant1040._nume_admin);
        info._prenumeDeclar = this.adjustString(this._Bilant1040._nume_intocmit);
        info._sumaControl = this.adjustString(this._Bilant1040._totalPlata_A);
        info.setValue("regCom", (Object)this.adjustString(this._Bilant1040._regCom));
        info.setValue("caen", (Object)this.adjustString(this._Bilant1040._caen));
        info.setValue("caen_1", (Object)this.adjustString(this._Bilant1040._caen_1));
        info.setValue("codPP", (Object)this.adjustString(this._Bilant1040._codPP));
        info.setValue("bifaMC", (Object)this.adjustString(this._Bilant1040._bifaMC));
        info.setValue("bifaDD", (Object)this.adjustString(this._Bilant1040._bifaDD));
        info.setValue("bifaAA", (Object)this.adjustString(this._Bilant1040._bifaAA));
        info.setValue("tipBIL", (Object)this.adjustString(this._Bilant1040._tipBIL));
        info.setValue("codTT", (Object)this.adjustString(this._Bilant1040._codTT));
        info.setValue("codJJ", (Object)this.adjustString(this._Bilant1040._codJJ));
        info.setValue("calit_intocmit", (Object)this.adjustString(this._Bilant1040._calit_intocmit));
        info.setValue("nri_intocmit", (Object)this.adjustString(this._Bilant1040._nri_intocmit));
        info.setValue("capitaluri_total", (Object)this.adjustString(this._Bilant1040._capitaluri_total));
        info.setValue("profit_pierdere", (Object)this.adjustString(this._Bilant1040._profit_pierdere));
    }

    protected DECDbAccessRoot getDbAccess() {
        this._dbObj = new DbAccessImpl();
        return this._dbObj;
    }

    public int validareStartTag(int index) {
        this._xmlContext = this.getXmlContext();
        switch (index) {
            case 0: {
                this._existsF10 = false;
                this._existsF20 = false;
                this._existsF30 = false;
                this._existsF40 = false;
                this._Bilant1040.initialization();
                this._Bilant1040.checkTag(0);
                if (this._extractValuesFlag != 1) break;
                this._extractValuesFlag = 2;
                break;
            }
            case 1: {
                this._existsF10 = true;
                this._F10.initialization();
                this._F10.checkTag(0);
                break;
            }
            case 2: {
                this._existsF20 = true;
                this._F10.checkTag(1);
                break;
            }
            case 3: {
                this._existsF30 = true;
                this._F10.checkTag(2);
                break;
            }
            case 4: {
                this._existsF40 = true;
                this._F10.checkTag(3);
            }
        }
        return 0;
    }

    public int validareEndTag(int index) {
        String pathSou = null;
        String pathDest = null;
        String fileName = null;
        String savePdf = null;
        long id = 0L;
        String cuiSuffix = null;
        String existaZIP = null;
        this._xmlContext = this.getXmlContext();
        switch (index) {
            case 0: {
                String rez;
                this._Bilant1040.aggregation(0);
                if (this._writeDB) {
                    this._dbObj.insertBilant1040(this._Bilant1040);
                }
                if (this._writeDB) {
                    this._dbObj.insertF10(this._F10);
                }
                if (this._writeDB) {
                    fileName = this._dbObj.validariFinale();
                    existaZIP = this._dbObj._existaZIP;
                }
                if (!this._writeDB) break;
                id = this._info._decId;
                cuiSuffix = this._Bilant1040._cui.substring(this._Bilant1040._cui.length() - 2);
                pathSou = Params.getProperty((String)"sursaaixPath");
                pathSou = Params.establishPath((String)pathSou, (long)id, (String)".pdf");
                String cale = "bilantpdfPath_" + this._Bilant1040._an;
                pathDest = ValidatorImpl.padPath(ValidatorImpl.padPath(ValidatorImpl.padPath(Params.getProperty((String)cale)) + "s1040".toUpperCase()) + cuiSuffix);
                pathDest = Params.establishPath((String)pathDest, (long)0L, null) + fileName + ".pdf";
                if (pathSou == null || !new File(pathSou).exists() || pathDest == null) {
                    this.addError(3, "", "", this.fillParams("cale sursa PDF (@0@) sau cale destinatie PDF (@1@) necompletate sau incorecte", new Object[]{pathSou, pathDest}), 3);
                    break;
                }
                if (new File(pathDest).exists()) {
                    new File(pathDest).delete();
                }
                if ((rez = this.copyFile(pathSou, pathDest)) != null) {
                    this.addError(3, "", "", this.fillParams("eroare copiere sursa PDF (@0@) la destinatie PDF (@1@): @2@", new Object[]{pathSou, pathDest, rez}), 3);
                    break;
                }
                savePdf = pathDest;
                if (existaZIP == null || !existaZIP.equals("D")) break;
                pathSou = ValidatorImpl.padPath(ValidatorImpl.padPath(Params.getProperty((String)"sursaZipPath")) + (id % 100L < 10L ? "0" : "") + Long.toString(id % 100L));
                pathSou = Params.establishPath((String)pathSou, (long)id, (String)".zip");
                cale = "bilantPath_" + this._Bilant1040._an;
                pathDest = ValidatorImpl.padPath(ValidatorImpl.padPath(ValidatorImpl.padPath(Params.getProperty((String)cale)) + "s1040".toUpperCase()) + cuiSuffix);
                pathDest = Params.establishPath((String)pathDest, (long)0L, null) + fileName + ".zip";
                if (pathSou == null || !new File(pathSou).exists() || pathDest == null) {
                    this.addError(3, "", "", this.fillParams("cale sursa ZIP (@0@) sau cale destinatie ZIP (@1@) necompletate sau incorecte", new Object[]{pathSou, pathDest}), 3);
                    new File(savePdf).delete();
                    break;
                }
                if (new File(pathDest).exists()) {
                    new File(pathDest).delete();
                }
                if ((rez = this.copyFile(pathSou, pathDest)) != null) {
                    this.addError(3, "", "", this.fillParams("eroare copiere sursa ZIP (@0@) la destinatie ZIP (@1@): @2@", new Object[]{pathSou, pathDest, rez}), 3);
                    new File(savePdf).delete();
                    break;
                }
                new File(pathSou).delete();
                break;
            }
            case 1: {
                this._F10.aggregation(0);
                break;
            }
            case 2: {
                this._F10.aggregation(1);
                break;
            }
            case 3: {
                this._F10.aggregation(2);
                break;
            }
            case 4: {
                this._F10.aggregation(3);
            }
        }
        return 0;
    }

    private static String padPath(String path) {
        if (path != null && !path.endsWith("/") && !path.endsWith("\\")) {
            return path + File.separator;
        }
        return path;
    }

    private String copyFile(String in, String out) {
        try {
            FileInputStream pdf_contribuabil = new FileInputStream(in);
            FileOutputStream pdf_copiat = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = pdf_contribuabil.read(buf)) != -1) {
                pdf_copiat.write(buf, 0, i);
            }
            pdf_contribuabil.close();
            pdf_copiat.close();
        }
        catch (Throwable ex) {
            return ex.toString();
        }
        return null;
    }

    protected void endDeclaratie(int val) {
        this._dbObj.endDeclaratie(val);
    }
}

