/*
 * Decompiled with CFR 0.152.
 */
package s1015validator.v1;

import dec.DECDbAccessRoot;
import dec.DECTag;
import dec.DECValidatorRoot;
import dec.Info;
import dec.Params;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import s1015validator.v1.DbAccessImpl;
import s1015validator.v1.F10;
import s1015validator.v1.F20;
import s1015validator.v1.F21;
import s1015validator.v1.F25;
import s1015validator.v1.F26;

public class ValidatorImpl
extends DECValidatorRoot {
    static final String DEC_NAMESPACE = "mfp:anaf:dgti:s1015:declaratie:v1";
    static final int ID_DECLARATIE = 0;
    static final int ID_F10 = 1;
    static final int ID_F20 = 2;
    static final int ID_F21 = 3;
    static final int ID_F25 = 4;
    static final int ID_F26 = 5;
    private static DECTag[] _taguri = new DECTag[]{new DECTag("Bilant1015", 0, 0, 1, true), new DECTag("F10", 1, 1, 1), new DECTag("F20", 2, 1, 1), new DECTag("F21", 3, 1, 1), new DECTag("F25", 4, 1, 1), new DECTag("F26", 5, 1, 1)};
    private static long[] _tabelPrecedenta = new long[]{ValidatorImpl.start((int)0), ValidatorImpl.startStart((int)1, (int)0), ValidatorImpl.startEnd((int)2, (int)1), ValidatorImpl.startEnd((int)3, (int)1), ValidatorImpl.startEnd((int)3, (int)2), ValidatorImpl.startEnd((int)4, (int)3), ValidatorImpl.startEnd((int)5, (int)3), ValidatorImpl.startEnd((int)5, (int)4), ValidatorImpl.endEnd((int)0, (int)4), ValidatorImpl.endEnd((int)0, (int)5), ValidatorImpl.endEnd((int)0, (int)3), ValidatorImpl.endStart((int)1, (int)1), ValidatorImpl.endStart((int)2, (int)2), ValidatorImpl.endStart((int)3, (int)3), ValidatorImpl.endStart((int)4, (int)4), ValidatorImpl.endStart((int)5, (int)5)};
    DbAccessImpl _dbObj = null;
    private F10 _identificareF10 = null;
    private F20 _F20 = null;
    private F21 _F21 = null;
    private F25 _F25 = null;
    private F26 _F26 = null;

    public ValidatorImpl() {
        this.init(_taguri, _tabelPrecedenta, DEC_NAMESPACE);
    }

    public void initializareDocument() {
        if (this._identificareF10 == null) {
            this._identificareF10 = new F10(this, null);
            this._F21 = new F21(this, this._identificareF10);
            this._F20 = new F20(this, this._identificareF10);
            this._F25 = new F25(this, this._identificareF10);
            this._F26 = new F26(this, this._identificareF10);
        } else {
            this._identificareF10.setParams();
            this._F20.setParams();
            this._F21.setParams();
            this._F25.setParams();
            this._F26.setParams();
        }
    }

    public void finalizareDocument(Info info) {
        info._an = this.adjustString(this._identificareF10.an);
        info._perioada = info._luna = this.adjustString(this._identificareF10.luna);
        info._tipPerioada = "L";
        info._numeDeclar = this.adjustString(this._identificareF10.nume_intocmit);
        info._prenumeDeclar = this.adjustString(this._identificareF10.nume_admin);
        info._functieDeclar = this.adjustString(this._identificareF10.calit_intocmit);
        info._cif = this.adjustString(this._identificareF10.cui);
        info._denumire = this.adjustString(this._identificareF10.den);
        info._adresa = this.adjustString(this._identificareF10.adresa);
        info._telefon = this.adjustString(this._identificareF10.durata);
        info._fax = this.adjustString(this._identificareF10.caen_AEF);
        info._mail = this.adjustString(this._identificareF10.caen_AFSP);
        info.setValue("nri", (Object)this.adjustString(this._identificareF10.nri_intocmit));
        info.setValue("capitaluri", (Object)this.adjustString(this._identificareF10.F10_0292));
        info.setValue("profit", (Object)this.adjustString(Long.toString(this._identificareF10.F10_0242_f - this._identificareF10.F10_0252_f)));
        info.setValue("tip_bilant", (Object)this.adjustString(this._identificareF10.tipBIL));
        info.setValue("efectiv_AEF", (Object)this.adjustString(this._identificareF10.efectiv_AEF));
        info.setValue("efectiv_AFSP", (Object)this.adjustString(this._identificareF10.efectiv_AFSP));
        info._sumaControl = this.adjustString(this._identificareF10.totalPlata_A);
    }

    protected DECDbAccessRoot getDbAccess() {
        this._dbObj = new DbAccessImpl();
        return this._dbObj;
    }

    public int validareStartTag(int index) {
        switch (index) {
            case 0: {
                this._identificareF10.initialization();
                this._identificareF10.checkTag(0);
                this._F20.initialization();
                this._F21.initialization();
                this._F25.initialization();
                this._F26.initialization();
                if (this._extractValuesFlag != 1) break;
                this._extractValuesFlag = 2;
                break;
            }
            case 1: {
                this._identificareF10.checkTag(1);
                break;
            }
            case 2: {
                this._F20.checkTag(0);
                break;
            }
            case 3: {
                this._F21.checkTag(0);
                break;
            }
            case 4: {
                this._F25.checkTag(0);
                break;
            }
            case 5: {
                this._F26.checkTag(0);
            }
        }
        return 0;
    }

    public int validareEndTag(int index) {
        switch (index) {
            case 0: {
                this._identificareF10.aggregation(0);
                long id = -1L;
                String data_inregistrare = "";
                String numar_inregistrare = "";
                String pathSou = null;
                String pathDest = null;
                String pathSouPdf = null;
                String pathDestPdf = null;
                if (!this._writeDB) break;
                this._dbObj.validariFinale();
                id = this._dbObj.getId();
                data_inregistrare = this._dbObj.getData_inregistrare();
                numar_inregistrare = this._dbObj.getNumar_inregistrare();
                pathSouPdf = Params.getProperty((String)"sursaaixPath");
                pathDestPdf = Params.getProperty((String)"bilantpdfPath_2013");
                pathSouPdf = pathSouPdf + "/" + Long.toString(id) + ".pdf";
                String denumireBilant = "s1015".substring(1);
                pathDestPdf = pathDestPdf + "/" + "s1015".toUpperCase() + "/" + this.adjustString(this._identificareF10.cui).substring(this.adjustString(this._identificareF10.cui).length() - 2) + "/" + denumireBilant + "_" + this.adjustString(this._identificareF10.an) + this.adjustString(this._identificareF10.luna) + "_" + this.adjustString(this._identificareF10.cui) + "_" + data_inregistrare + "_" + numar_inregistrare + ".pdf";
                if (pathSouPdf == null || !new File(pathSouPdf).exists() || pathDestPdf == null) {
                    this.addError(3, "", "", this.fillParams("cale sursa PDF (@0@) sau cale destinatie PDF (@1@) necompletate sau incorecte", new Object[]{pathSouPdf, pathDestPdf}), 3);
                    break;
                }
                String rez = this.copyFile(pathSouPdf, pathDestPdf);
                if (rez != null) {
                    this.addError(3, "", "", this.fillParams("eroare copiere sursa PDF (@0@) la destinatie PDF (@1@): @2@", new Object[]{pathSouPdf, pathDestPdf, rez}), 3);
                    break;
                }
                pathSou = Params.getProperty((String)"sursaZipPath");
                pathDest = Params.getProperty((String)"bilantPath_2013");
                long id1 = id % 100L;
                String idd = Long.toString(id1);
                idd = idd.length() == 1 ? "0" + idd : idd;
                pathSou = pathSou + "/" + idd + "/" + Long.toString(id) + ".zip";
                pathDest = pathDest + "/" + "s1015".toUpperCase() + "/" + this.adjustString(this._identificareF10.cui).substring(this.adjustString(this._identificareF10.cui).length() - 2) + "/" + denumireBilant + "_" + this.adjustString(this._identificareF10.an) + this.adjustString(this._identificareF10.luna) + "_" + this.adjustString(this._identificareF10.cui) + "_" + data_inregistrare + "_" + numar_inregistrare + ".zip";
                if (pathSou == null || !new File(pathSou).exists() || pathDest == null) {
                    this.addError(3, "", "", this.fillParams("cale sursa ZIP (@0@) sau cale destinatie ZIP (@1@) necompletate sau incorecte", new Object[]{pathSou, pathDest}), 3);
                    File f = new File(pathDestPdf);
                    f.delete();
                    break;
                }
                rez = this.copyFile(pathSou, pathDest);
                if (rez != null) {
                    this.addError(3, "", "", this.fillParams("eroare copiere sursa ZIP (@0@) la destinatie ZIP (@1@): @2@", new Object[]{pathSou, pathDest, rez}), 3);
                    File f = new File(pathDestPdf);
                    f.delete();
                    break;
                }
                File f = new File(pathSou);
                boolean success = f.delete();
                if (success) break;
                this.addError(3, "", "", this.fillParams("eroare redenumire sursa ZIP (@0@) la destinatie ZIP (@1@): @2@", new Object[]{pathSou, pathDest, rez}), 3);
                File fPdf = new File(pathDestPdf);
                fPdf.delete();
                break;
            }
            case 1: {
                this._identificareF10.aggregation(1);
                if (!this._writeDB) break;
                this._dbObj.insertIdentificare(this._identificareF10);
                break;
            }
            case 2: {
                this._F20.aggregation(0);
                break;
            }
            case 3: {
                this._F21.aggregation(0);
                break;
            }
            case 4: {
                this._F25.aggregation(0);
                break;
            }
            case 5: {
                this._F26.aggregation(0);
                if (!this._writeDB) break;
                this._dbObj.insertF10F26(this._identificareF10, this._F20, this._F21, this._F25, this._F26);
            }
        }
        return 0;
    }

    private static String padPath(String path) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            return path + File.separator;
        }
        return path;
    }

    public String copyFile(String in, String out) {
        try {
            FileInputStream pdf_contribuabil = new FileInputStream(in);
            FileOutputStream pdf_copiat = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = pdf_contribuabil.read(buf)) != -1) {
                pdf_copiat.write(buf, 0, i);
            }
            pdf_contribuabil.close();
            pdf_copiat.close();
        }
        catch (Throwable ex) {
            return ex.toString();
        }
        return null;
    }

    public void endDeclaratie(int val) {
        this._dbObj.endDeclaratie(val);
    }
}

