/*
 * Decompiled with CFR 0.152.
 */
package s1005validator.v0;

import dec.DECDbAccessRoot;
import dec.DECTag;
import dec.DECValidatorRoot;
import dec.Info;
import dec.Params;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import s1005validator.Validator;
import s1005validator.v0.DbAccessImpl;
import s1005validator.v0.F10;
import s1005validator.v0.F20;
import s1005validator.v0.F30;
import s1005validator.v0.F40;

public class ValidatorImpl
extends DECValidatorRoot {
    static final String DEC_NAMESPACE = "mfp:anaf:dgti:" + Validator.DECLARATION_name + ":declaratie:v1";
    static final int ID_DECLARATIE = 0;
    static final int ID_F10 = 1;
    static final int ID_F20 = 2;
    static final int ID_F30 = 3;
    static final int ID_F40 = 4;
    private static DECTag[] _taguri = new DECTag[]{new DECTag("Bilant1005", 0, 0, 1, true), new DECTag("F10", 1, 1, 1), new DECTag("F20", 2, 1, 1), new DECTag("F30", 3, 1, 1), new DECTag("F40", 4, 1, 1)};
    private static long[] _tabelPrecedenta = new long[]{ValidatorImpl.start((int)0), ValidatorImpl.startStart((int)1, (int)0), ValidatorImpl.startEnd((int)2, (int)1), ValidatorImpl.startEnd((int)3, (int)1), ValidatorImpl.startEnd((int)3, (int)2), ValidatorImpl.startEnd((int)4, (int)3), ValidatorImpl.endEnd((int)0, (int)4), ValidatorImpl.endEnd((int)0, (int)3), ValidatorImpl.endStart((int)1, (int)1), ValidatorImpl.endStart((int)2, (int)2), ValidatorImpl.endStart((int)3, (int)3), ValidatorImpl.endStart((int)4, (int)4)};
    DbAccessImpl _dbObj = null;
    private F10 _identificareF10 = null;
    private F20 _F20 = null;
    private F30 _F30 = null;
    private F40 _F40 = null;

    public ValidatorImpl() {
        this.init(_taguri, _tabelPrecedenta, DEC_NAMESPACE);
    }

    public void initializareDocument() {
        if (this._identificareF10 == null) {
            this._identificareF10 = new F10(this, null);
            this._F30 = new F30(this, this._identificareF10);
            this._F20 = new F20(this, this._identificareF10);
            this._F40 = new F40(this, this._identificareF10);
        } else {
            this._identificareF10.setParams();
            this._F20.setParams();
            this._F30.setParams();
            this._F40.setParams();
        }
    }

    public void finalizareDocument(Info info) {
        info._an = this.adjustString(this._identificareF10.an);
        info._perioada = info._luna = this.adjustString(this._identificareF10.luna);
        info._tipPerioada = "L";
        info._numeDeclar = this.adjustString(this._identificareF10.nume_intocmit);
        info._prenumeDeclar = this.adjustString(this._identificareF10.nume_admin);
        info._functieDeclar = this.adjustString(this._identificareF10.calit_intocmit);
        info._cif = this.adjustString(this._identificareF10.cui);
        info._denumire = this.adjustString(this._identificareF10.den);
        info._adresa = this.adjustString(this._identificareF10.adresa);
        info._telefon = this.adjustString(this._identificareF10.regCom);
        info._fax = this.adjustString(this._identificareF10.codPP);
        info._mail = this.adjustString(this._identificareF10.caen);
        info.setValue("nri", (Object)this.adjustString(this._identificareF10.nri_intocmit));
        info.setValue("capitaluri", (Object)this.adjustString(this._identificareF10.F10_0332));
        info.setValue("profit", (Object)this.adjustString(Long.toString(this._identificareF10.F10_0302_f - this._identificareF10.F10_0312_f)));
        info.setValue("tip_bilant", (Object)this.adjustString(this._identificareF10.tipBIL));
        info._sumaControl = this.adjustString(this._identificareF10.totalPlata_A);
    }

    protected DECDbAccessRoot getDbAccess() {
        this._dbObj = new DbAccessImpl();
        return this._dbObj;
    }

    public int validareStartTag(int index) {
        switch (index) {
            case 0: {
                this._identificareF10.initialization();
                this._identificareF10.checkTag(0);
                this._F20.initialization();
                this._F30.initialization();
                this._F40.initialization();
                if (this._extractValuesFlag != 1) break;
                this._extractValuesFlag = 2;
                break;
            }
            case 1: {
                this._identificareF10.checkTag(1);
                break;
            }
            case 2: {
                this._F20.checkTag(0);
                break;
            }
            case 3: {
                this._F30.checkTag(0);
                break;
            }
            case 4: {
                this._F40.checkTag(0);
            }
        }
        return 0;
    }

    public int validareEndTag(int index) {
        switch (index) {
            case 0: {
                this._identificareF10.aggregation(0);
                if (this._writeDB) {
                    this._dbObj.insertF10F40(this._identificareF10, this._F20, this._F30, this._F40);
                }
                long id = -1L;
                String data_inregistrare = "";
                String numar_inregistrare = "";
                String pathSou = null;
                String pathDest = null;
                String pathSouPdf = null;
                String pathDestPdf = null;
                if (!this._writeDB) break;
                this._dbObj.validariFinale();
                id = this._dbObj.getId();
                data_inregistrare = this._dbObj.getData_inregistrare();
                numar_inregistrare = this._dbObj.getNumar_inregistrare();
                pathSouPdf = Params.getProperty((String)"sursaaixPath");
                pathDestPdf = Params.getProperty((String)"bilantpdfPath");
                pathSouPdf = pathSouPdf + "/" + Long.toString(id) + ".pdf";
                String denumireBilant = Validator.DECLARATION_name.substring(1);
                pathDestPdf = pathDestPdf + "/" + Validator.DECLARATION_name.toUpperCase() + "/" + this.adjustString(this._identificareF10.cui).substring(this.adjustString(this._identificareF10.cui).length() - 2) + "/" + denumireBilant + "_" + this.adjustString(this._identificareF10.an) + this.adjustString(this._identificareF10.luna) + "_" + this.adjustString(this._identificareF10.cui) + "_" + data_inregistrare + "_" + numar_inregistrare + ".pdf";
                if (pathSouPdf == null || !new File(pathSouPdf).exists() || pathDestPdf == null) {
                    this.addError(3, "", "", this.fillParams("cale sursa PDF (@0@) sau cale destinatie PDF (@1@) necompletate sau incorecte", new Object[]{pathSouPdf, pathDestPdf}), 3);
                    break;
                }
                String rez = this.copyFile(pathSouPdf, pathDestPdf);
                if (rez != null) {
                    this.addError(3, "", "", this.fillParams("eroare copiere sursa PDF (@0@) la destinatie PDF (@1@): @2@", new Object[]{pathSouPdf, pathDestPdf, rez}), 3);
                    break;
                }
                pathSou = Params.getProperty((String)"sursaZipPath");
                pathDest = Params.getProperty((String)"bilantPath");
                long id1 = id % 100L;
                String idd = Long.toString(id1);
                idd = idd.length() == 1 ? "0" + idd : idd;
                pathSou = pathSou + "/" + idd + "/" + Long.toString(id) + ".zip";
                pathDest = pathDest + "/" + Validator.DECLARATION_name.toUpperCase() + "/" + this.adjustString(this._identificareF10.cui).substring(this.adjustString(this._identificareF10.cui).length() - 2) + "/" + denumireBilant + "_" + this.adjustString(this._identificareF10.an) + this.adjustString(this._identificareF10.luna) + "_" + this.adjustString(this._identificareF10.cui) + "_" + data_inregistrare + "_" + numar_inregistrare + ".zip";
                if (pathSou == null || !new File(pathSou).exists() || pathDest == null) {
                    this.addError(3, "", "", this.fillParams("cale sursa ZIP (@0@) sau cale destinatie ZIP (@1@) necompletate sau incorecte", new Object[]{pathSou, pathDest}), 3);
                    File f = new File(pathDestPdf);
                    f.delete();
                    break;
                }
                rez = this.copyFile(pathSou, pathDest);
                if (rez != null) {
                    this.addError(3, "", "", this.fillParams("eroare copiere sursa ZIP (@0@) la destinatie ZIP (@1@): @2@", new Object[]{pathSou, pathDest, rez}), 3);
                    File f = new File(pathDestPdf);
                    f.delete();
                    break;
                }
                File f = new File(pathSou);
                boolean success = f.delete();
                if (success) break;
                this.addError(3, "", "", this.fillParams("eroare redenumire sursa ZIP (@0@) la destinatie ZIP (@1@): @2@", new Object[]{pathSou, pathDest, rez}), 3);
                File fPdf = new File(pathDestPdf);
                fPdf.delete();
                break;
            }
            case 1: {
                this._identificareF10.aggregation(1);
                if (!this._writeDB) break;
                this._dbObj.insertIdentificare(this._identificareF10);
                break;
            }
            case 2: {
                this._F20.aggregation(0);
                break;
            }
            case 3: {
                this._F30.aggregation(0);
                break;
            }
            case 4: {
                this._F40.aggregation(0);
            }
        }
        return 0;
    }

    private static String padPath(String path) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            return path + File.separator;
        }
        return path;
    }

    public String copyFile(String in, String out) {
        try {
            FileInputStream pdf_contribuabil = new FileInputStream(in);
            FileOutputStream pdf_copiat = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = pdf_contribuabil.read(buf)) != -1) {
                pdf_copiat.write(buf, 0, i);
            }
            pdf_contribuabil.close();
            pdf_copiat.close();
        }
        catch (Throwable ex) {
            return ex.toString();
        }
        return null;
    }

    public void endDeclaratie(int val) {
        this._dbObj.endDeclaratie(val);
    }
}

