/*
 * Decompiled with CFR 0.152.
 */
package f3000validator.v3;

import f3000validator.v3.DataObjectRoot;
import f3000validator.v3.Persoane;
import f3000validator.v3.ValidatorImpl;
import java.util.Arrays;

public class Tin
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_TIN = 0;
    String _tip_in;
    boolean _tip_in_ok;
    String _cod_tara;
    boolean _cod_tara_ok;
    String _identif;
    boolean _identif_ok;
    String codTara;
    long _cod_tara_f;

    public Tin(ValidatorImpl validator, DataObjectRoot parent) {
        super(validator, parent, 1);
    }

    public void checkTag(int codTag) {
        this.startValidation(codTag);
        this._tip_in = this._validator.nextAttribute("tip_in", 50, 4, 0);
        this._tip_in_ok = this._validator._attributeOK;
        if (this._tip_in != null) {
            if (Arrays.binarySearch(this._params._val_nepermise, this._tip_in) >= 0) {
                this._validator.addError(1, "R_tip_in", "", "tip_in nu poate avea valori nepermise ");
            }
            if (this._tip_in.contains("#") || this._tip_in.contains("&") || this._tip_in.contains("--") || this._tip_in.contains("/*")) {
                this._validator.addError(1, "R_tip_in", "", "tip_in nu poate contine valori nepermise ");
            }
        }
        this._cod_tara = this._validator.nextAttributeInList(this._params._nomenclatorTari, "cod_tara", 3, 1, 1);
        this._cod_tara_f = this._validator._integerValue;
        this._cod_tara_ok = this._validator._attributeOK;
        if (this._cod_tara_f == 642L) {
            this._identif = this._validator.nextAttributeAsCif("identif", 1);
            this._identif_ok = this._validator._attributeOK;
        } else {
            this._identif = this._validator.nextAttribute("identif", 50, 4, 1);
            this._identif_ok = this._validator._attributeOK;
        }
        if (this._identif != null) {
            Persoane db = (Persoane)this._parent;
            db._flag_tin = true;
            if (db._tip_pers_f == 1L && db._data_nastere == null && (this._identif.equals("222222222") || this._identif.equals("333333333") || this._identif.equals("444444444") || this._identif.equals("555555555") || this._identif.equals("666666666") || this._identif.equals("777777777") || this._identif.equals("999999999") || this._identif.equals("000222111"))) {
                this._validator.addError(1, "Rdata_nastere1", "", this._validator.fillParams("data_nastere este obligatorie", new Object[]{this.codTara, this._identif}), 0);
                if (this._cod_tara_f == 40L) {
                    this.codTara = "AT";
                }
                if (this._cod_tara_f == 642L) {
                    this.codTara = "RO";
                }
                if (this._cod_tara_f == 56L) {
                    this.codTara = "BE";
                }
                if (this._cod_tara_f == 100L) {
                    this.codTara = "BG";
                }
                if (this._cod_tara_f == 191L) {
                    // empty if block
                }
                if (this._cod_tara_f == 196L) {
                    this.codTara = "CY";
                }
                if (this._cod_tara_f == 203L) {
                    this.codTara = "CZ";
                }
                if (this._cod_tara_f == 208L) {
                    this.codTara = "DK";
                }
            }
        }
        if (this._identif != null) {
            if (Arrays.binarySearch(this._params._val_nepermise, this._identif) >= 0) {
                this._validator.addError(1, "R_identif", "", "identif nu poate avea valori nepermise ");
            }
            if (this._identif.contains("#") || this._identif.contains("&") || this._identif.contains("--") || this._identif.contains("/*") || this._identif.contains(" ")) {
                this._validator.addError(1, "R_identif", "", "identif nu poate contine valori nepermise ");
            }
        }
        if (this._identif == null || this._cod_tara == null || Arrays.binarySearch(this._params._listaTariUE, this._cod_tara) > 0) {
            // empty if block
        }
        this.endValidation(codTag);
    }

    public void aggregation(int codTag) {
        Persoane db = (Persoane)this._parent;
        db._flag_tin = true;
        if (db._tip_pers_f == 1L && this._tip_in != null) {
            this._validator.addError(1, "R26", "", "Pt tip_pers = 1 ,tip_in = null ");
        }
    }

    public void initialization() {
        this._tip_in = null;
        this._tip_in_ok = false;
        this._cod_tara = null;
        this._cod_tara_ok = false;
        this._identif = null;
        this._identif_ok = false;
        this.codTara = null;
        this._cod_tara_f = 0L;
    }
}

