/*
 * Decompiled with CFR 0.152.
 */
package f3000validator.v3;

import dec.DECConst;
import f3000validator.v3.DataObjectRoot;
import f3000validator.v3.F3000;
import f3000validator.v3.ValidatorImpl;

public class PoolReport
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_POOLREPORT = 0;
    String _d_rec1;
    long _d_rec1_f;
    String _tip_corectie;
    long _tip_corectie_f;
    boolean _d_rec1_ok;
    String _id_inreg;
    long _id_inreg_f;
    boolean _id_inreg_ok;
    String _tip_detinator;
    boolean _tip_detinator_ok;
    String _nr_conturi;
    long _nr_conturi_f;
    boolean _nr_conturi_ok;
    long _nr_cont;
    String _balanta;
    double _balanta_f;
    boolean _balanta_ok;
    String _moneda;
    boolean _moneda_ok;
    double _total;

    public PoolReport(ValidatorImpl validator, DataObjectRoot parent) {
        super(validator, parent, 1);
    }

    public void checkTag(int codTag) {
        this.startValidation(codTag);
        F3000 db = (F3000)this._parent;
        this._d_rec1 = this._validator.nextAttributeInInterval(1L, 2L, "d_rec1", 0, 1, 0);
        this._d_rec1_f = this._validator._integerValue;
        this._d_rec1_ok = this._validator._attributeOK;
        this._tip_corectie = this._validator.nextAttributeInInterval(1L, 3L, "tip_corectie", 0, 1, 0);
        this._tip_corectie_f = this._validator._integerValue;
        if (this._d_rec1_f == 1L && this._tip_corectie_f == 0L) {
            this._validator.addError(1, "R.TipCorectie1", "", this._validator.fillParams("tip_corectie se completeaza pt d_rec1=1", new Object[0]));
        }
        if (this._tip_corectie_f > 0L && this._d_rec1_f != 1L) {
            this._validator.addError(1, "R.TipCorectie2", "", this._validator.fillParams("tip_corectie se completeaza pt d_rec1=1", new Object[0]));
        }
        this._id_inreg = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "id_inreg", 0, 1, 1);
        this._id_inreg_f = this._validator._integerValue;
        this._id_inreg_ok = this._validator._attributeOK;
        if (this._id_inreg != null) {
            if (db._idUnic.contains(this._id_inreg)) {
                this._validator.addError(1, "R.IdInregUnic", "id inregistrare multiplu", this._validator.fillParams("id inregistrare = @0@ nu este unic in declaratie", new Object[]{this._id_inreg}));
            } else {
                db._idUnic.add(this._id_inreg);
            }
            this._tip_detinator = this._validator.nextAttributeInList(this._params._listaTipDP, "tip_detinator", 256, 4, 0);
            this._tip_detinator_ok = this._validator._attributeOK;
            if (this._tip_detinator != null && !this._tip_detinator.equals("FATCA203") && db._an_f > 2015L) {
                this._validator.addError(1, "R.PoolReport", "", this._validator.fillParams("Sectiunea Poolreport se declara numai pt conturile inactive ( FATCA203)", new Object[0]));
            }
            this._nr_conturi = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "nr_conturi", 0, 1, 0);
            this._nr_conturi_f = this._validator._integerValue;
            this._nr_conturi_ok = this._validator._attributeOK;
            this._balanta = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "balanta", 0);
            this._balanta_f = this._validator._realValue;
            this._balanta_ok = this._validator._attributeOK;
            this._moneda = this._validator.nextAttributeInList(this._params._valute, "moneda", 256, 4, 0);
            this._moneda_ok = this._validator._attributeOK;
            if (this._d_rec1_f != 2L && (this._tip_detinator == null || this._nr_conturi == null || this._balanta == null || this._moneda == null)) {
                this._validator.addError(1, "R.Init", "", this._validator.fillParams("Pt d_rec1<>2 (@0@), tip_detinator, nr_conturi, balanta, moneda sunt obligatorii", new Object[]{this._d_rec1}));
            }
        }
        this.endValidation(codTag);
    }

    public void aggregation(int codTag) {
        F3000 dd = (F3000)this._parent;
        ++dd._agg_id;
        if (dd._giin == null) {
            this._validator.addError(1, "R.PoolReport", "", this._validator.fillParams("Sectiunea PoolReport nu trebuie sa existe daca raportarea nu este catre FATCA ( GIIN = null)", new Object[0]));
        }
        if (this._nr_conturi_f != this._nr_cont && this._d_rec1_f != 2L) {
            this._validator.addError(1, "R.PoolReport", "nr conturi ", this._validator.fillParams("nr conturi declarat = (@0@) diferit de numar conturi detaliate cu sold (@1@)", new Object[]{this._nr_conturi, Long.toString(this._nr_cont)}));
        }
        if (this._total != this._balanta_f * 100.0 && this._d_rec1_f != 2L) {
            this._validator.addError(1, "R.PoolReport", "balanta ", this._validator.fillParams("balanta declarata = (@0@) diferita de suma soldurilor (@1@)", new Object[]{this._balanta, Double.toString(this._total / 100.0)}));
        }
    }

    public void initialization() {
        this._d_rec1 = null;
        this._d_rec1_f = 0L;
        this._d_rec1_ok = false;
        this._id_inreg = null;
        this._id_inreg_f = 0L;
        this._id_inreg_ok = false;
        this._nr_cont = 0L;
        this._tip_detinator = null;
        this._tip_detinator_ok = false;
        this._nr_conturi = null;
        this._nr_conturi_f = 0L;
        this._nr_conturi_ok = false;
        this._balanta = null;
        this._balanta_f = 0.0;
        this._balanta_ok = false;
        this._moneda = null;
        this._moneda_ok = false;
        this._total = 0.0;
        this._tip_corectie = null;
        this._tip_corectie_f = 0L;
    }
}

