/*
 * Decompiled with CFR 0.152.
 */
package f3000validator.v3;

import f3000validator.v3.DataObjectRoot;
import f3000validator.v3.F3000;
import f3000validator.v3.Inregistrare;
import f3000validator.v3.ValidatorImpl;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;

public class Cont
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CONT = 0;
    String _id_cont;
    boolean _id_cont_ok;
    String _tip_numar_cont;
    boolean _tip_numar_cont_ok;
    String _det_cont;
    boolean _det_cont_ok;
    String _swift;
    boolean _swift_ok;
    String _nr_cont;
    boolean _nr_cont_ok;
    String _tip_cont;
    long _tip_cont_f;
    boolean _tip_cont_ok;
    String _trat_cont;
    boolean _trat_cont_ok;
    String _autocertificare;
    long _autocertificare_f;
    boolean _autocertificare_ok;
    String _cont_inchis;
    long _cont_inchis_f;
    boolean _cont_inchis_ok;
    String _cont_nedocumentat;
    long _cont_nedocumentat_f;
    boolean _cont_nedocumentat_ok;
    String _cont_inactiv;
    long _cont_inactiv_f;
    boolean _cont_inactiv_ok;
    String _valoare_sold;
    double _valoare_sold_f;
    boolean _valoare_sold_ok;
    String _data_sold;
    Date _data_sold_f;
    boolean _data_sold_ok;
    String _moneda_sold;
    boolean _moneda_sold_ok;
    Integer _ann;
    boolean _nr_plati;
    Set _tipSumaUnic;

    public Cont(ValidatorImpl validator, DataObjectRoot parent) {
        super(validator, parent, 1);
    }

    public void checkTag(int codTag) {
        this.startValidation(codTag);
        F3000 db = (F3000)this._parent._parent;
        this._id_cont = this._validator.nextAttribute("id_cont", 30, 4, 1);
        this._id_cont_ok = this._validator._attributeOK;
        this._tip_numar_cont = this._validator.nextAttributeInList(this._params._tipNrCont, "tip_numar_cont", 256, 4, 1);
        this._tip_numar_cont_ok = this._validator._attributeOK;
        this._det_cont = this._validator.nextAttribute("det_cont", 75, 4, 0);
        this._det_cont_ok = this._validator._attributeOK;
        if (this._det_cont != null) {
            if (Arrays.binarySearch(this._params._val_nepermise, this._det_cont) >= 0) {
                this._validator.addError(1, "R_det_cont", "", "det_cont nu poate avea valori nepermise ");
            }
            if (this._det_cont.contains("#") || this._det_cont.contains("&") || this._det_cont.contains("--") || this._det_cont.contains("/*")) {
                this._validator.addError(1, "R_det_cont", "", "det_cont nu poate contine valori nepermise ");
            }
        }
        this._swift = this._validator.nextAttribute("swift", 8, 4, 0);
        this._swift_ok = this._validator._attributeOK;
        this._nr_cont = this._validator.nextAttribute("nr_cont", 50, 4, 1);
        this._nr_cont_ok = this._validator._attributeOK;
        if (this._tip_numar_cont != null) {
            if ((this._tip_numar_cont.equals("OECD602") || this._tip_numar_cont.equals("OECD604") || this._tip_numar_cont.equals("OECD605")) && this._det_cont == null) {
                this._validator.addError(1, "R82", "", "Pt tip_numar_cont in ( OECD602, OECD604, OECD605 ), det_cont diferit de null ");
            }
            if (this._nr_cont != null) {
                if (!this._tip_numar_cont.equals("OECD605") && this._nr_cont.equals("NANUM")) {
                    this._validator.addError(1, "R_NANUM", "", "Pt tip_numar_cont <> OECD605, nu este permisa valoarea NANUM");
                }
                if (this._tip_numar_cont.equals("OECD603") && !ValidatorImpl.ISINtest(this._nr_cont)) {
                    this._validator.addError(1, "R_ISIN", "", "nr_cont trebuie sa fie ISIN valid ");
                }
            }
        }
        long variab = -1L;
        if (this._tip_numar_cont != null && this._tip_numar_cont.equals("OECD601")) {
            if (this._nr_cont == null) {
                variab = 0L;
            } else if (this._validator.checkIban(this._nr_cont) < 0) {
                this._validator.addError(1, "R_IBAN", "cont IBAN incorect", this._validator.fillParams("cont IBAN = @0@ este incorect", new Object[]{this._nr_cont}));
            }
        }
        this._tip_cont = this._validator.nextAttributeInInterval(1L, 6L, "tip_cont", 0, 1, 1);
        this._tip_cont_f = this._validator._integerValue;
        this._tip_cont_ok = this._validator._attributeOK;
        if (this._tip_cont_f == 4L) {
            this._validator.addError(1, "Rtip_cont", "", this._validator.fillParams("tip_cont=4 nu este valabil", new Object[0]));
        }
        this._trat_cont = this._validator.nextAttributeInList(this._params._tratCont, "trat_cont", 256, 4, 0);
        this._trat_cont_ok = this._validator._attributeOK;
        if (db._an_f > 2015L && this._trat_cont == null) {
            this._validator.addError(1, "R86", "trat_cont obligatoriu", this._validator.fillParams("daca anul >2015 trat_cont este diferit de null", new Object[]{this._trat_cont}));
        }
        this._autocertificare = this._validator.nextAttributeInInterval(0L, 1L, "autocertificare", 0, 1, 1);
        this._autocertificare_f = this._validator._integerValue;
        this._autocertificare_ok = this._validator._attributeOK;
        if (this._trat_cont != null && this._trat_cont.equals("CRS982") && this._autocertificare_f != 1L) {
            this._validator.addError(1, "Rautocertificare", "", this._validator.fillParams("Daca trat_cont=CRS982 atunci atutocertificare=1", new Object[0]));
        }
        this._cont_inchis = this._validator.nextAttributeInInterval(0L, 1L, "cont_inchis", 0, 1, 0);
        this._cont_inchis_f = this._validator._integerValue;
        this._cont_inchis_ok = this._validator._attributeOK;
        this._cont_nedocumentat = this._validator.nextAttributeInInterval(0L, 1L, "cont_nedocumentat", 0, 1, 1);
        this._cont_nedocumentat_f = this._validator._integerValue;
        this._cont_nedocumentat_ok = this._validator._attributeOK;
        if (this._trat_cont != null && this._trat_cont.equals("CRS982") && this._cont_nedocumentat_f == 1L) {
            this._validator.addError(1, "R89", "", this._validator.fillParams("daca  trat_cont=CRS982 atunci cont_nedocumentat=0", new Object[]{this._cont_nedocumentat}));
        }
        this._cont_inactiv = this._validator.nextAttributeInInterval(0L, 1L, "cont_inactiv", 0, 1, 0);
        this._cont_inactiv_f = this._validator._integerValue;
        this._cont_inactiv_ok = this._validator._attributeOK;
        if (this._trat_cont != null && this._trat_cont.equals("CRS981") && this._cont_inactiv == null) {
            this._validator.addError(1, "R90", "cont_inactiv obligatoriu", this._validator.fillParams("daca  trat_cont=CRS981 cont_inactiv este diferit de null", new Object[]{this._cont_inactiv}));
        }
        this._valoare_sold = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "valoare_sold", 1);
        this._valoare_sold_f = this._validator._realValue;
        this._valoare_sold_ok = this._validator._attributeOK;
        if (this._cont_inchis_f == 1L && this._valoare_sold_f > 0.0) {
            this._validator.addError(1, "Rsold", "", this._validator.fillParams("daca  avem cont_inchis = 1 atunci valoare_sold = 0", new Object[0]));
        }
        this._data_sold = this._validator.nextAttribute("data_sold", 0, 3, 1);
        this._data_sold_f = this._validator._dateValue;
        this._data_sold_ok = this._validator._attributeOK;
        if (this._data_sold_f != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this._data_sold_f);
            this._ann = cal.get(1);
            if (db._an_f != (long)this._ann.intValue() && this._cont_inchis_f == 0L) {
                this._validator.addError(1, "R92a", "", this._validator.fillParams("data_sold (@0@)trebuie sa fie in anul de raportare(@1@)", new Object[]{this._data_sold, Long.toString(db._an_f)}));
            }
            if (db._an_f < (long)this._ann.intValue() && this._cont_inchis_f == 1L) {
                this._validator.addError(1, "R92b", "", this._validator.fillParams("data_sold (@0@)trebuie sa fie anterioara sau in anul de raportare(@1@) pt conturile inchise", new Object[]{this._data_sold, Long.toString(db._an_f)}));
            }
        }
        this._moneda_sold = this._validator.nextAttributeInList(this._params._valute, "moneda_sold", 256, 4, 1);
        this._moneda_sold_ok = this._validator._attributeOK;
        this.endValidation(codTag);
    }

    public void aggregation(int codTag) {
        F3000 db = (F3000)this._parent._parent;
        if (db._an_f < 2015L && this._nr_plati) {
            this._validator.addError(1, "R95", "<plati> nu se declara pt anul 2014", this._validator.fillParams("daca  anul raportarii este 2014 atunci <plati> nu exista (nr <plati>)", new Object[]{"1"}));
        }
        if (db._an_f > 2015L && this._trat_cont == null) {
            this._validator.addError(1, "R89a", "trat_cont", this._validator.fillParams("daca  anul raportarii >2015 atunci trat_cont este obligatoriu", new Object[0]));
        }
        Inregistrare dbb = (Inregistrare)this._parent;
        ++dbb._nr_cont;
        if (dbb._declar == 1L) {
            if (db._idUnicCont1.contains(this._id_cont)) {
                this._validator.addError(1, "R.IdContUnic1", "id cont multiplu", this._validator.fillParams("id cont = @0@ pt tip_declar = 1 nu este unic in declaratie", new Object[]{this._id_cont}));
            } else {
                db._idUnicCont1.add(this._id_cont);
            }
        }
        if (dbb._declar == 4L) {
            if (db._idUnicCont4.contains(this._id_cont)) {
                this._validator.addError(1, "R.IdContUnic4", "id cont multiplu", this._validator.fillParams("id cont = @0@ pt tip_declar = 4 nu este unic in declaratie", new Object[]{this._id_cont}));
            } else {
                db._idUnicCont4.add(this._id_cont);
            }
        }
    }

    public void initialization() {
        this._id_cont = null;
        this._id_cont_ok = false;
        this._tip_numar_cont = null;
        this._tip_numar_cont_ok = false;
        this._det_cont = null;
        this._det_cont_ok = false;
        this._swift = null;
        this._swift_ok = false;
        this._nr_cont = null;
        this._nr_cont_ok = false;
        this._tip_cont = null;
        this._tip_cont_f = 0L;
        this._tip_cont_ok = false;
        this._trat_cont = null;
        this._trat_cont_ok = false;
        this._autocertificare = null;
        this._autocertificare_f = 0L;
        this._autocertificare_ok = false;
        this._cont_inchis = null;
        this._cont_inchis_f = 0L;
        this._cont_inchis_ok = false;
        this._cont_nedocumentat = null;
        this._cont_nedocumentat_f = 0L;
        this._cont_nedocumentat_ok = false;
        this._cont_inactiv = null;
        this._cont_inactiv_f = 0L;
        this._cont_inactiv_ok = false;
        this._valoare_sold = null;
        this._valoare_sold_f = 0.0;
        this._valoare_sold_ok = false;
        this._data_sold = null;
        this._data_sold_f = null;
        this._data_sold_ok = false;
        this._moneda_sold = null;
        this._moneda_sold_ok = false;
        this._ann = 0;
        this._nr_plati = false;
        if (this._tipSumaUnic == null) {
            this._tipSumaUnic = new TreeSet();
        } else {
            this._tipSumaUnic.clear();
        }
    }
}

