/*
 * Decompiled with CFR 0.152.
 */
package f3000validator.v2;

import f3000validator.v2.DataObjectRoot;
import f3000validator.v2.F3000;
import f3000validator.v2.Inregistrare;
import f3000validator.v2.ValidatorImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class Persoane
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_PERSOANE = 0;
    String _tip_declar;
    long _tip_declar_f;
    boolean _tip_declar_ok;
    String _tip_ctr;
    boolean _tip_ctr_ok;
    String _tip_pers;
    long _tip_pers_f;
    boolean _tip_pers_ok;
    String _alt_tip_pers;
    boolean _alt_tip_pers_ok;
    String _tip_detinator_cont;
    boolean _tip_detinator_cont_ok;
    String _data_nastere;
    boolean _data_nastere_ok;
    String _oras_nastere;
    boolean _oras_nastere_ok;
    String _sub_oras_nastere;
    boolean _sub_oras_nastere_ok;
    String _cod_tara_nastere;
    boolean _cod_tara_nastere_ok;
    String _fost_nume_tara;
    boolean _fost_nume_tara_ok;
    String _cui_pers;
    boolean _cui_pers_ok;
    boolean _flag_pj;
    boolean _flag_mijl;
    boolean _flag_generatie;
    boolean _flag_sufix;
    boolean _flag_titlu;
    boolean _flag_rezidenta;
    boolean _flag_tin;
    boolean _flag_nationalitate;
    boolean _flag_cuipers;

    public Persoane(ValidatorImpl validator, DataObjectRoot parent) {
        super(validator, parent, 1);
    }

    public void checkTag(int codTag) {
        long an_nastere;
        this.startValidation(codTag);
        F3000 db = (F3000)this._parent._parent;
        Inregistrare inreg = (Inregistrare)this._parent;
        this._tip_declar = this._validator.nextAttributeInInterval(1L, 4L, "tip_declar", 0, 1, 1);
        this._tip_declar_f = this._validator._integerValue;
        this._tip_declar_ok = this._validator._attributeOK;
        if ((this._tip_declar_f == 2L || this._tip_declar_f == 4L) && db._an_f < 2016L) {
            this._validator.addError(1, "R15", "", "tip_declar in (2,4)  valabil incepand cu anul de raportare 2016");
        }
        if (this._tip_declar_f == 3L && this._tip_pers_f > 1L) {
            this._validator.addError(1, "R17b", "", "tip_declar = 3 nu poate fi decat individual(tip_pers=1)");
        }
        this._tip_ctr = this._validator.nextAttributeInList(this._params._listaTipCtr, "tip_ctr", 256, 4, 0);
        this._tip_ctr_ok = this._validator._attributeOK;
        if ((this._tip_declar_f == 1L || this._tip_declar_f == 3L || this._tip_declar_f == 4L) && this._tip_ctr != null) {
            this._validator.addError(1, "R16", "", "tip_ctr se declara numai pt tip_declar = 2");
        }
        if (this._tip_declar_f == 2L && this._tip_ctr == null) {
            this._validator.addError(1, "R16b", "", "tip_ctr nu poate fi null pt tip_declar = 2");
        }
        this._tip_pers = this._validator.nextAttributeInInterval(1L, 8L, "tip_pers", 0, 1, 1);
        this._tip_pers_f = this._validator._integerValue;
        this._tip_pers_ok = this._validator._attributeOK;
        if (this._tip_pers_f > 2L && db._an_f < 2016L) {
            this._validator.addError(1, "R17a", "", "tip_pers > 2 este valabil incepand cu anul de raportare 2016");
        }
        if (this._tip_pers_f != 1L && this._flag_nationalitate) {
            this._validator.addError(1, "R35", "", "pt tip_pers diferit de  1 nu se declara nationalitatea");
        }
        if ((this._tip_declar_f == 1L || this._tip_declar_f == 3L) && this._tip_pers_f > 2L) {
            this._validator.addError(1, "R35b", "", "pt tip_declar in (1,3) tip_pers trebuie sa fie in (1,2) ");
        }
        if ((this._tip_declar_f == 2L || this._tip_declar_f == 4L) && this._tip_pers_f == 2L) {
            this._validator.addError(1, "R35c", "", "pt tip_declar in (2,4) tip_pers trebuie sa fie <> 2");
        }
        this._alt_tip_pers = this._validator.nextAttribute("alt_tip_pers", 50, 4, 0);
        this._alt_tip_pers_ok = this._validator._attributeOK;
        if (this._tip_pers_f == 7L && this._alt_tip_pers == null) {
            this._validator.addError(1, "R18", "", "Pt tip_pers=7 , alt_tip_pers diferit de null");
        }
        if (this._tip_pers_f != 7L && this._alt_tip_pers != null) {
            this._validator.addError(1, "R18", "", "Pt tip_pers diferit de 7 , alt_tip_pers e null");
        }
        if (this._alt_tip_pers != null && (this._alt_tip_pers.contains("#") || this._alt_tip_pers.contains("&") || this._alt_tip_pers.contains("--") || this._alt_tip_pers.contains("/*"))) {
            this._validator.addError(1, "Ralt_tip_pers", "", "alt_tip_pers nu poate contine caractere nepermise");
        }
        this._tip_detinator_cont = this._validator.nextAttributeInList(this._params._listaTipDetinator, "tip_detinator_cont", 256, 4, 0);
        this._tip_detinator_cont_ok = this._validator._attributeOK;
        if (this._tip_declar_f == 2L) {
            ++inreg.etip_declar_2;
        }
        if (this._tip_detinator_cont != null) {
            if (this._tip_detinator_cont.equals("CRS101")) {
                inreg.eCRS101 = true;
            }
            if (this._tip_detinator_cont.equals("CRS102") || this._tip_detinator_cont.equals("CRS103")) {
                ++inreg.eCRS102_103;
            }
            if (this._tip_detinator_cont.equals("FATCA102")) {
                inreg.eFATCA102 = true;
            }
            if (this._tip_declar_f != 1L && this._tip_declar_f != 4L && this._tip_detinator_cont != null) {
                this._validator.addError(1, "R19a", "", this._validator.fillParams("Pt tip_declar diferit de 1 si 4  tip_detinator_cont e null la id_reg @0@", new Object[]{inreg._id_inreg}));
            }
            if (this._tip_declar_f == 1L & (this._tip_detinator_cont.equals("CRS101") || this._tip_detinator_cont.equals("CRS102") || this._tip_detinator_cont.equals("CRS103"))) {
                this._validator.addError(1, "R19b", "", this._validator.fillParams("Pt tip_declar =1 , tip_detinator_cont nu poate fi in (CRS101, CRS102, CRS103) la id_reg @0@", new Object[]{inreg._id_inreg}));
            }
            if (this._tip_declar_f == 4L & (this._tip_detinator_cont.equals("FATCA101") || this._tip_detinator_cont.equals("FATCA102") || this._tip_detinator_cont.equals("FATCA103") || this._tip_detinator_cont.equals("FATCA104"))) {
                this._validator.addError(1, "R19b", "", this._validator.fillParams("Pt tip_declar =4, tip_detinator_cont nu poate fi in (FATCA101, FATCA102, FATCA103, FATCA104) la id_reg @0@", new Object[]{inreg._id_inreg}));
            }
        }
        this._data_nastere = this._validator.nextAttribute("data_nastere", 10, 4, 0);
        this._data_nastere_ok = this._validator._attributeOK;
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        if (this._data_nastere != null) {
            try {
                Date data = format.parse(this._data_nastere);
                Date data2 = format.parse("01.01.1900");
                String an = "01.01.";
                long an2 = db._an_f + 1L;
                if (db._an_f > 0L) {
                    an = an + Long.toString(an2);
                }
                Date data3 = format.parse(an);
                if (data.before(data2)) {
                    this._validator.addError(1, "Rdata_nastere", "", this._validator.fillParams("Data nasterii nu poate fi anterioara anului 1900 ", new Object[0]));
                }
                if (data.after(data3)) {
                    this._validator.addError(1, "Rdata_nastere", "", this._validator.fillParams("Data nasterii nu poate fi ulterioara anului de raportare ", new Object[0]));
                }
            }
            catch (ParseException ex) {
                this._validator.addError(1, "Rdata_nastere", "", "Format data_nastere incorect");
            }
        }
        Inregistrare dbb = (Inregistrare)this._parent;
        this._oras_nastere = this._validator.nextAttribute("oras_nastere", 100, 4, 0);
        this._oras_nastere_ok = this._validator._attributeOK;
        if (this._tip_pers_f != 1L && this._oras_nastere != null) {
            this._validator.addError(1, "R21", "", this._validator.fillParams("Pt tip_pers diferit de 1 , oras_nastere=null pt id_inreg=@0@", new Object[]{dbb._id_inreg}));
        }
        if (this._oras_nastere != null && Arrays.binarySearch(this._params._val_nepermise, this._oras_nastere) >= 0) {
            this._validator.addError(1, "R_oras_nastere", "", this._validator.fillParams("Oras nastere nu poate contine valori nepermise pt id_inreg=@0@", new Object[]{dbb._id_inreg}));
        }
        this._sub_oras_nastere = this._validator.nextAttribute("sub_oras_nastere", 100, 4, 0);
        this._sub_oras_nastere_ok = this._validator._attributeOK;
        if (this._sub_oras_nastere != null && Arrays.binarySearch(this._params._val_nepermise, this._sub_oras_nastere) >= 0) {
            this._validator.addError(1, "R_sub_oras_nastere", "", this._validator.fillParams("sub_oras_nastere nu poate contine valori nepermise pt id_inreg=@0@", new Object[]{dbb._id_inreg}));
        }
        if (this._tip_pers_f != 1L && this._sub_oras_nastere != null) {
            this._validator.addError(1, "R22", "", "Pt tip_pers diferit de 1 , sub_oras_nastere=null ");
        }
        this._cod_tara_nastere = this._validator.nextAttributeInList(this._params._nomenclatorTari, "cod_tara_nastere", 3, 1, 0);
        this._cod_tara_nastere_ok = this._validator._attributeOK;
        if (this._tip_pers_f != 1L && this._cod_tara_nastere != null) {
            this._validator.addError(1, "R23", "", "Pt tip_pers diferit de 1 , cod_tara_nastere=null ");
        }
        if (this._tip_pers_f != 1L) {
            this._flag_pj = true;
        }
        this._fost_nume_tara = this._validator.nextAttribute("fost_nume_tara", 100, 4, 0);
        this._fost_nume_tara_ok = this._validator._attributeOK;
        if (this._tip_pers_f != 1L && this._fost_nume_tara != null) {
            this._validator.addError(1, "R24", "", "Pt tip_pers diferit de 1 , fost_nume_tara=null ");
        }
        if (this._fost_nume_tara != null) {
            if (Arrays.binarySearch(this._params._val_nepermise, this._fost_nume_tara) >= 0) {
                this._validator.addError(1, "R_fost_nume_tara", "", "fost_nume_tara nu poate avea valori nepermise ");
            }
            try {
                long x = Long.parseLong(this._fost_nume_tara);
                this._validator.addError(1, "R_fost_nume_tara", "", "fost_nume_tara nu poate avea valori nepermise ");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this._tip_declar_f == 2L && this._tip_pers_f != 1L) {
            this._validator.addError(1, "R.CtrSubst1", "", this._validator.fillParams("Daca persoana este de tip controlling person  ( tip_declar =2) atunci tip_pers=1 ( persoana fizica)", new Object[0]));
        }
        this._cui_pers = this._validator.nextAttributeAsCif("cui_pers", 2);
        this._cui_pers_ok = this._validator._attributeOK;
        F3000 dbbb = (F3000)this._parent._parent;
        if (this._data_nastere != null && (an_nastere = Long.parseLong(this._data_nastere.substring(6, 10))) < dbbb._an_f - 120L) {
            this._validator.addError(1, "R.data_nastere", "", this._validator.fillParams("data nasterii(@1@) nu poate fi mai mica de an_raportare -120 (@0@)", new Object[]{Long.toString(dbbb._an_f - 100L), Long.toString(an_nastere)}));
        }
        this.endValidation(codTag);
    }

    public void aggregation(int codTag) {
        F3000 db = (F3000)this._parent._parent;
        ++db._agg_id;
        Inregistrare dbb = (Inregistrare)this._parent;
        if (this._tip_declar_f == 2L) {
            ++dbb.count_persoane2;
        }
        if (this._tip_declar_f == 3L) {
            ++dbb.count_persoane3;
        }
        ++dbb.count_persoane;
        if (!(this._tip_declar_f != 2L && this._tip_declar_f != 3L || this._flag_rezidenta)) {
            this._validator.addError(1, "R.CtrSubst", "", this._validator.fillParams("Daca persoana este de tip controlling person sau substantial owner ( tip_declar in (2,3)) atunci rezidenta este obligatorie", new Object[0]));
        }
        if (this._tip_declar_f == 1L) {
            dbb._tip_declarat = 1L;
        }
        if (this._tip_declar_f == 4L) {
            dbb._tip_declarat = 4L;
        }
        ++dbb._nr_pers;
        if (this._tip_declar_f == 1L) {
            ++dbb._nr_detinator;
            db.crs = false;
        }
        if (this._tip_declar_f == 4L) {
            ++dbb._nr_detinator;
            db.fatca = false;
        }
        if (this._tip_declar_f == 3L || this._tip_declar_f == 1L) {
            db.eraportare1 = 1L;
        }
        if (this._tip_declar_f == 2L || this._tip_declar_f == 4L) {
            db.eraportare2 = 1L;
        }
        if (db._giin == null && this._tip_declar_f == 1L) {
            this._validator.addError(1, "R.InregFatca", "", this._validator.fillParams("Nu se pot declara inregistrari pt FATCA daca GIIN = null", new Object[0]));
        }
        if (this._tip_declar_f == 2L) {
            ++dbb._nr_ctr;
        }
        if (this._tip_declar_f == 3L) {
            ++dbb._nr_subst;
        }
        if (this._tip_declar_f == 1L && this._tip_pers_f == 1L) {
            dbb._tip_pers = 1L;
        }
        if (this._tip_declar_f == 1L || this._tip_declar_f == 4L) {
            dbb._declar = this._tip_declar_f;
        }
        if (!this._flag_tin && this._data_nastere == null && this._tip_pers_f == 1L) {
            this._validator.addError(1, "R20", "", "Daca nu este declarat tin-ul atunci data_nastere este obligatorie ");
        }
        if (this._tip_pers_f == 1L && this._tip_declar_f != 1L && this._tip_declar_f != 3L && !this._flag_tin && (this._data_nastere == null || this._oras_nastere == null && this._cod_tara_nastere == null && this._fost_nume_tara == null)) {
            this._validator.addError(1, "R20", "", "Daca nu este declarat tin-ul atunci data_nastere si (oras_nastere sau tara_nastere sau fost_nume_tara) sunt obligatorii");
        }
        if (!(this._tip_pers_f <= 1L || this._flag_tin || this._flag_cuipers || this._tip_declar_f != 1L && this._tip_declar_f != 4L)) {
            this._validator.addError(1, "R20.1", "", this._validator.fillParams("Pt persoane juridice sectiunea tin este obligatorie la id_inreg @0@", new Object[]{dbb._id_inreg}));
        }
        if (!(this._tip_pers_f <= 1L || this._flag_tin || this._flag_cuipers || this._tip_declar_f != 2L && this._tip_declar_f != 3L)) {
            this._validator.addError(1, "R20.2", "", this._validator.fillParams("Pt persoane juridice sectiunea tin este obligatorie la id_inreg @0@", new Object[]{dbb._id_inreg}));
        }
        if (this._tip_pers_f > 1L && (this._flag_mijl || this._flag_sufix || this._flag_generatie || this._flag_titlu)) {
            this._validator.addError(1, "R20a", "", "Daca tip_pers diferit de 1 atunci nu se declara urmatoarele sectiuni : mijl , generatie, sufix, titlu ");
        }
        if ((this._tip_declar_f == 1L || this._tip_declar_f == 4L) && this._tip_detinator_cont == null) {
            this._validator.addError(1, "Rtip_detinator_cont", "", "Daca tip_declar in (1,4) atunci tip_detinator_cont <> null ");
            this._validator.addError(1, "Rtip_detinator_cont", "", this._validator.fillParams("Daca tip_declar in (1,4) atunci tip_detinator_cont <> null la id_inreg @0@", new Object[]{dbb._id_inreg}));
        }
    }

    public void initialization() {
        this._tip_declar = null;
        this._tip_declar_f = 0L;
        this._tip_declar_ok = false;
        this._tip_ctr = null;
        this._tip_ctr_ok = false;
        this._tip_pers = null;
        this._tip_pers_f = 0L;
        this._tip_pers_ok = false;
        this._alt_tip_pers = null;
        this._alt_tip_pers_ok = false;
        this._tip_detinator_cont = null;
        this._tip_detinator_cont_ok = false;
        this._data_nastere = null;
        this._data_nastere_ok = false;
        this._oras_nastere = null;
        this._oras_nastere_ok = false;
        this._sub_oras_nastere = null;
        this._sub_oras_nastere_ok = false;
        this._cod_tara_nastere = null;
        this._cod_tara_nastere_ok = false;
        this._fost_nume_tara = null;
        this._fost_nume_tara_ok = false;
        this._cui_pers = null;
        this._cui_pers_ok = false;
        this._flag_pj = false;
        this._flag_mijl = false;
        this._flag_generatie = false;
        this._flag_sufix = false;
        this._flag_titlu = false;
        this._flag_tin = false;
        this._flag_nationalitate = false;
        this._flag_rezidenta = false;
        this._flag_cuipers = false;
    }
}

