/*
 * Decompiled with CFR 0.152.
 */
package f3000validator.v1;

import f3000validator.v1.DataObjectRoot;
import f3000validator.v1.F3000;
import f3000validator.v1.PoolReport;
import f3000validator.v1.ValidatorImpl;
import java.util.Calendar;
import java.util.Date;

public class Sold
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_SOLD = 0;
    String _detalii;
    boolean _detalii_ok;
    String _tip_detalii;
    boolean _tip_detalii_ok;
    String _val_sold;
    double _val_sold_f;
    boolean _val_sold_ok;
    String _data_sold;
    Date _data_sold_f;
    boolean _data_sold_ok;
    String _moneda_sold;
    boolean _moneda_sold_ok;
    Integer _ann;

    public Sold(ValidatorImpl validator, DataObjectRoot parent) {
        super(validator, parent, 1);
    }

    public void checkTag(int codTag) {
        this.startValidation(codTag);
        F3000 db = (F3000)this._parent._parent;
        this._detalii = this._validator.nextAttribute("detalii", 200, 4, 0);
        this._detalii_ok = this._validator._attributeOK;
        this._tip_detalii = this._validator.nextAttribute("tip_detalii", 200, 4, 0);
        this._tip_detalii_ok = this._validator._attributeOK;
        this._val_sold = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "val_sold", 1);
        this._val_sold_f = this._validator._realValue;
        this._val_sold_ok = this._validator._attributeOK;
        PoolReport dbb = (PoolReport)this._parent;
        this._data_sold = this._validator.nextAttribute("data_sold", 0, 3, 1);
        this._data_sold_f = this._validator._dateValue;
        this._data_sold_ok = this._validator._attributeOK;
        if (this._data_sold_f != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this._data_sold_f);
            this._ann = cal.get(1);
            if (db._an_f != (long)this._ann.intValue()) {
                this._validator.addError(1, "R100a", "", this._validator.fillParams("data soldului (@0@)trebuie sa fie in anul de raportare(@1@)", new Object[]{this._data_sold, Long.toString(db._an_f)}));
            }
        }
        this._moneda_sold = this._validator.nextAttributeInList(this._params._valute, "moneda_sold", 256, 4, 1);
        this._moneda_sold_ok = this._validator._attributeOK;
        if (this._moneda_sold != null && !this._moneda_sold.equals(dbb._moneda)) {
            this._validator.addError(1, "R100a", "", this._validator.fillParams("moneda soldului pe cont (@0@)trebuie sa fie aceeasi cu moneda soldului pe poolreport(@1@)", new Object[]{this._moneda_sold, dbb._moneda}));
        }
        this.endValidation(codTag);
    }

    public void aggregation(int codTag) {
        PoolReport db = (PoolReport)this._parent;
        ++db._nr_cont;
        if (this._val_sold != null) {
            db._total += this._val_sold_f * 100.0;
        }
    }

    public void initialization() {
        this._detalii = null;
        this._detalii_ok = false;
        this._tip_detalii = null;
        this._tip_detalii_ok = false;
        this._val_sold = null;
        this._val_sold_f = 0.0;
        this._val_sold_ok = false;
        this._data_sold = null;
        this._data_sold_f = null;
        this._data_sold_ok = false;
        this._moneda_sold = null;
        this._moneda_sold_ok = false;
        this._ann = 0;
    }
}

