/*
 * Decompiled with CFR 0.152.
 */
package f3000validator.v0;

import f3000validator.v0.Cont;
import f3000validator.v0.DataObjectRoot;
import f3000validator.v0.F3000;
import f3000validator.v0.ValidatorImpl;
import java.util.Calendar;
import java.util.Date;

public class Plati
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_PLATI = 0;
    String _tip_suma;
    long _tip_suma_f;
    boolean _tip_suma_ok;
    String _detalii_plata;
    boolean _detalii_plata_ok;
    String _tax_rate;
    double _tax_rate_f;
    boolean _tax_rate_ok;
    String _suma;
    double _suma_f;
    boolean _suma_ok;
    String _data;
    Date _data_f;
    boolean _data_ok;
    String _moneda_plata;
    boolean _moneda_plata_ok;
    Integer _ann;

    public Plati(ValidatorImpl validator, DataObjectRoot parent) {
        super(validator, parent, 1);
    }

    public void checkTag(int codTag) {
        this.startValidation(codTag);
        F3000 db = (F3000)this._parent._parent._parent;
        Cont dbb = (Cont)this._parent;
        this._tip_suma = this._validator.nextAttributeInInterval(1L, 7L, "tip_suma", 0, 1, 1);
        this._tip_suma_f = this._validator._integerValue;
        this._tip_suma_ok = this._validator._attributeOK;
        if (this._tip_suma != null && this._tip_suma_f != 7L) {
            if (dbb._tipSumaUnic.contains(this._tip_suma)) {
                this._validator.addError(1, "R.TipSumaUnic", "tip suma multiplu", this._validator.fillParams("tip suma = @0@ nu este unic la nivel de cont ", new Object[]{this._tip_suma}));
            } else {
                dbb._tipSumaUnic.add(this._tip_suma);
            }
        }
        if (this._tip_suma_f == 4L && db._an_f < 2016L) {
            this._validator.addError(1, "R96", "tip_suma", this._validator.fillParams("valoare tip_suma valabila incepand cu anul de raportare 2016", new Object[]{this._tip_suma}));
        }
        if (!(this._tip_suma_f != 5L && this._tip_suma_f != 6L || dbb._tip_cont_f != 2L && dbb._tip_cont_f != 1L)) {
            this._validator.addError(1, "R96", "tip_suma", this._validator.fillParams("tip_suma(@0@)nu e valabil pt tip_cont(@1@)", new Object[]{this._tip_suma, Long.toString(dbb._tip_cont_f)}));
        }
        if (this._tip_suma_f == 1L && dbb._tip_cont_f != 2L && dbb._tip_cont_f != 1L) {
            this._validator.addError(1, "R96", "tip_suma", this._validator.fillParams("tip_suma(@0@)nu e valabil pt tip_cont(@1@)", new Object[]{this._tip_suma, Long.toString(dbb._tip_cont_f)}));
        }
        if ((this._tip_suma_f == 2L || this._tip_suma_f == 3L || this._tip_suma_f == 4L) && dbb._tip_cont_f != 2L) {
            this._validator.addError(1, "R96", "tip_suma", this._validator.fillParams("tip_suma(@0@)nu e valabil pt tip_cont(@1@)", new Object[]{this._tip_suma, Long.toString(dbb._tip_cont_f)}));
        }
        this._detalii_plata = this._validator.nextAttribute("detalii_plata", 50, 4, 0);
        this._detalii_plata_ok = this._validator._attributeOK;
        if (this._tip_suma_f == 7L && this._detalii_plata == null) {
            this._validator.addError(1, "R97", "detalii_plata", this._validator.fillParams("detalii_plata obligatoriu pt tip_suma=@0@", new Object[]{this._tip_suma}));
        }
        this._tax_rate = this._validator.nextAttributeDblPattern(0.0, null, 2, 2, "tax_rate", 0);
        this._tax_rate_f = this._validator._realValue;
        this._tax_rate_ok = this._validator._attributeOK;
        this._suma = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "suma", 1);
        this._suma_f = this._validator._realValue;
        this._suma_ok = this._validator._attributeOK;
        this._data = this._validator.nextAttribute("data", 0, 3, 1);
        this._data_f = this._validator._dateValue;
        this._data_ok = this._validator._attributeOK;
        if (this._data_f != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this._data_f);
            this._ann = cal.get(1);
            if (db._an_f != (long)this._ann.intValue() && dbb._cont_inchis_f == 0L) {
                this._validator.addError(1, "R100a", "", this._validator.fillParams("data platii (@0@)trebuie sa fie in anul de raportare(@1@)", new Object[]{this._data, Long.toString(db._an_f)}));
            }
            if (db._an_f < (long)this._ann.intValue() && dbb._cont_inchis_f == 1L) {
                this._validator.addError(1, "R100b", "", this._validator.fillParams("data platii (@0@) trebuie sa fie anterioara sau in anul de raportare (@1@) pt conturile inchise", new Object[]{this._data, Long.toString(db._an_f)}));
            }
        }
        this._moneda_plata = this._validator.nextAttributeInList(this._params._valute, "moneda_plata", 256, 4, 1);
        this._moneda_plata_ok = this._validator._attributeOK;
        this.endValidation(codTag);
    }

    public void aggregation(int codTag) {
        Cont db = (Cont)this._parent;
        db._nr_plati = true;
    }

    public void initialization() {
        this._tip_suma = null;
        this._tip_suma_f = 0L;
        this._tip_suma_ok = false;
        this._detalii_plata = null;
        this._detalii_plata_ok = false;
        this._tax_rate = null;
        this._tax_rate_f = 0.0;
        this._tax_rate_ok = false;
        this._suma = null;
        this._suma_f = 0.0;
        this._suma_ok = false;
        this._data = null;
        this._data_f = null;
        this._data_ok = false;
        this._moneda_plata = null;
        this._moneda_plata_ok = false;
        this._ann = 0;
    }
}

