/*
 * Decompiled with CFR 0.152.
 */
package f3000validator.v0;

import f3000validator.v0.DataObjectRoot;
import f3000validator.v0.F3000;
import f3000validator.v0.Inregistrare;
import f3000validator.v0.ValidatorImpl;

public class Persoane
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_PERSOANE = 0;
    String _tip_declar;
    long _tip_declar_f;
    boolean _tip_declar_ok;
    String _tip_ctr;
    boolean _tip_ctr_ok;
    String _tip_pers;
    long _tip_pers_f;
    boolean _tip_pers_ok;
    String _alt_tip_pers;
    boolean _alt_tip_pers_ok;
    String _tip_detinator_cont;
    boolean _tip_detinator_cont_ok;
    String _data_nastere;
    boolean _data_nastere_ok;
    String _oras_nastere;
    boolean _oras_nastere_ok;
    String _sub_oras_nastere;
    boolean _sub_oras_nastere_ok;
    String _cod_tara_nastere;
    boolean _cod_tara_nastere_ok;
    String _fost_nume_tara;
    boolean _fost_nume_tara_ok;
    String _cui_pers;
    boolean _cui_pers_ok;
    boolean _flag_pj;
    boolean _flag_mijl;
    boolean _flag_generatie;
    boolean _flag_sufix;
    boolean _flag_titlu;
    boolean _flag_rezidenta;
    boolean _flag_tin;
    boolean _flag_nationalitate;

    public Persoane(ValidatorImpl validator, DataObjectRoot parent) {
        super(validator, parent, 1);
    }

    public void checkTag(int codTag) {
        this.startValidation(codTag);
        F3000 db = (F3000)this._parent._parent;
        this._tip_declar = this._validator.nextAttributeInInterval(1L, 4L, "tip_declar", 0, 1, 1);
        this._tip_declar_f = this._validator._integerValue;
        this._tip_declar_ok = this._validator._attributeOK;
        if ((this._tip_declar_f == 2L || this._tip_declar_f == 4L) && db._an_f < 2016L) {
            this._validator.addError(1, "R15", "", "tip_declar in (2,4)  valabil incepand cu anul de raportare 2016");
        }
        if (this._tip_declar_f == 3L && this._tip_pers_f > 1L) {
            this._validator.addError(1, "R17b", "", "tip_declar = 3 nu poate fi decat individual(tip_pers=1)");
        }
        this._tip_ctr = this._validator.nextAttributeInList(this._params._listaTipCtr, "tip_ctr", 256, 4, 0);
        this._tip_ctr_ok = this._validator._attributeOK;
        if ((this._tip_declar_f == 1L || this._tip_declar_f == 3L) && this._tip_ctr != null) {
            this._validator.addError(1, "R16", "", "tip_ctr se declara numai pt tip_declar = 2");
        }
        this._tip_pers = this._validator.nextAttributeInInterval(1L, 8L, "tip_pers", 0, 1, 1);
        this._tip_pers_f = this._validator._integerValue;
        this._tip_pers_ok = this._validator._attributeOK;
        if (this._tip_pers_f > 2L && db._an_f < 2016L) {
            this._validator.addError(1, "R17a", "", "tip_pers > 2 este valabil incepand cu anul de raportare 2016");
        }
        if (this._tip_pers_f != 1L && this._flag_nationalitate) {
            this._validator.addError(1, "R35", "", "pt tip_pers diferit de  1 nu se declara nationalitatea");
        }
        this._alt_tip_pers = this._validator.nextAttribute("alt_tip_pers", 50, 4, 0);
        this._alt_tip_pers_ok = this._validator._attributeOK;
        if (this._tip_pers_f == 7L && this._alt_tip_pers == null) {
            this._validator.addError(1, "R18", "", "Pt tip_pers=7 , alt_tip_pers diferit de null");
        }
        if (this._tip_pers_f != 7L && this._alt_tip_pers != null) {
            this._validator.addError(1, "R18", "", "Pt tip_pers diferit de 7 , alt_tip_pers e null");
        }
        this._tip_detinator_cont = this._validator.nextAttributeInList(this._params._listaTipDetinator, "tip_detinator_cont", 256, 4, 0);
        this._tip_detinator_cont_ok = this._validator._attributeOK;
        if (this._tip_detinator_cont != null) {
            if (this._tip_declar_f != 1L && this._tip_declar_f != 4L && this._tip_detinator_cont != null) {
                this._validator.addError(1, "R19a", "", "Pt tip_declar diferit de 1 si 4  tip_detinator_cont e null");
            }
            if (this._tip_declar_f == 1L & (this._tip_detinator_cont.equals("CRS101") || this._tip_detinator_cont.equals("CRS102") || this._tip_detinator_cont.equals("CRS103"))) {
                this._validator.addError(1, "R19b", "", "Pt tip_declar =1 , tip_detinator_cont nu poate fi in (CRS101, CRS102, CRS103");
            }
            if (this._tip_declar_f == 4L & (this._tip_detinator_cont.equals("FATCA101") || this._tip_detinator_cont.equals("FATCA102") || this._tip_detinator_cont.equals("FATCA103") || this._tip_detinator_cont.equals("FATCA104"))) {
                this._validator.addError(1, "R19b", "", "Pt tip_declar =4, tip_detinator_cont nu poate fi in (FATCA101, FATCA102, FATCA103, FATCA104");
            }
        }
        this._data_nastere = this._validator.nextAttribute("data_nastere", 10, 4, 0);
        this._data_nastere_ok = this._validator._attributeOK;
        this._oras_nastere = this._validator.nextAttribute("oras_nastere", 100, 4, 0);
        this._oras_nastere_ok = this._validator._attributeOK;
        if (this._tip_pers_f != 1L && this._oras_nastere != null) {
            this._validator.addError(1, "R21", "", "Pt tip_pers diferit de 1 , oras_nastere=null ");
        }
        this._sub_oras_nastere = this._validator.nextAttribute("sub_oras_nastere", 100, 4, 0);
        this._sub_oras_nastere_ok = this._validator._attributeOK;
        if (this._tip_pers_f != 1L && this._sub_oras_nastere != null) {
            this._validator.addError(1, "R22", "", "Pt tip_pers diferit de 1 , sub_oras_nastere=null ");
        }
        this._cod_tara_nastere = this._validator.nextAttributeInList(this._params._nomenclatorTari, "cod_tara_nastere", 3, 1, 0);
        this._cod_tara_nastere_ok = this._validator._attributeOK;
        if (this._tip_pers_f != 1L && this._cod_tara_nastere != null) {
            this._validator.addError(1, "R23", "", "Pt tip_pers diferit de 1 , cod_tara_nastere=null ");
        }
        if (this._tip_pers_f != 1L) {
            this._flag_pj = true;
        }
        this._fost_nume_tara = this._validator.nextAttribute("fost_nume_tara", 100, 4, 0);
        this._fost_nume_tara_ok = this._validator._attributeOK;
        if (this._tip_pers_f != 1L && this._fost_nume_tara != null) {
            this._validator.addError(1, "R24", "", "Pt tip_pers diferit de 1 , fost_nume_tara=null ");
        }
        this._cui_pers = this._validator.nextAttributeAsCif("cui_pers", 0);
        this._cui_pers_ok = this._validator._attributeOK;
        this.endValidation(codTag);
    }

    public void aggregation(int codTag) {
        F3000 db = (F3000)this._parent._parent;
        ++db._agg_id;
        Inregistrare dbb = (Inregistrare)this._parent;
        if (this._tip_declar_f == 1L) {
            dbb._tip_declarat = 1L;
        }
        if (this._tip_declar_f == 4L) {
            dbb._tip_declarat = 4L;
        }
        ++dbb._nr_pers;
        if (this._tip_declar_f == 1L) {
            ++dbb._nr_detinator;
        }
        if (this._tip_declar_f == 2L) {
            ++dbb._nr_ctr;
        }
        if (this._tip_declar_f == 3L) {
            ++dbb._nr_subst;
        }
        if (this._tip_declar_f == 1L && this._tip_pers_f == 1L) {
            dbb._tip_pers = 1L;
        }
        if (this._tip_declar_f == 1L || this._tip_declar_f == 4L) {
            dbb._declar = this._tip_declar_f;
        }
        if (!this._flag_tin && this._data_nastere == null) {
            this._validator.addError(1, "R20", "", "Daca nu este declarat tin-ul atunci data_nastere este obligatorie");
        }
        if (this._tip_pers_f > 1L && (this._flag_mijl || this._flag_sufix || this._flag_generatie || this._flag_titlu)) {
            this._validator.addError(1, "R20a", "", "Daca tip_pers diferit de 1 atunci nu se declara urmatoarele sectiuni : mijl , generatie, sufix, titlu ");
        }
    }

    public void initialization() {
        this._tip_declar = null;
        this._tip_declar_f = 0L;
        this._tip_declar_ok = false;
        this._tip_ctr = null;
        this._tip_ctr_ok = false;
        this._tip_pers = null;
        this._tip_pers_f = 0L;
        this._tip_pers_ok = false;
        this._alt_tip_pers = null;
        this._alt_tip_pers_ok = false;
        this._tip_detinator_cont = null;
        this._tip_detinator_cont_ok = false;
        this._data_nastere = null;
        this._data_nastere_ok = false;
        this._oras_nastere = null;
        this._oras_nastere_ok = false;
        this._sub_oras_nastere = null;
        this._sub_oras_nastere_ok = false;
        this._cod_tara_nastere = null;
        this._cod_tara_nastere_ok = false;
        this._fost_nume_tara = null;
        this._fost_nume_tara_ok = false;
        this._cui_pers = null;
        this._cui_pers_ok = false;
        this._flag_pj = false;
        this._flag_mijl = false;
        this._flag_generatie = false;
        this._flag_sufix = false;
        this._flag_titlu = false;
        this._flag_tin = false;
        this._flag_nationalitate = false;
        this._flag_rezidenta = false;
    }
}

