/*
 * Decompiled with CFR 0.152.
 */
package d406validator.parameters;

import d406validator.Parameters;
import java.util.Arrays;
import java.util.ResourceBundle;

public class Parameters_v3
extends Parameters {
    public int version;

    /*
     * Opcode count of 18708 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public Parameters_v3() {
        this._ver = this.version = 3;
        this._ISO3166_2 = new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN", "BO", "BQ", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CW", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "EU", "FI", "FJ", "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IR", "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MF", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "SS", "ST", "SV", "SX", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "ZA", "ZM", "ZW", "EL", "XK", "XI"};
        Arrays.sort(this._ISO3166_2);
        this._countryCodIso = new String[]{"004", "248", "008", "012", "016", "020", "024", "660", "010", "028", "032", "051", "533", "036", "040", "031", "044", "048", "050", "052", "112", "056", "084", "204", "060", "064", "068", "535", "070", "072", "074", "076", "086", "096", "100", "854", "108", "116", "120", "124", "132", "136", "140", "148", "152", "156", "162", "166", "170", "174", "178", "180", "184", "188", "384", "191", "192", "531", "196", "203", "208", "262", "212", "214", "218", "818", "222", "226", "232", "233", "231", "238", "234", "242", "246", "250", "254", "258", "260", "266", "270", "268", "276", "288", "292", "300", "304", "308", "312", "316", "320", "831", "324", "624", "328", "332", "334", "336", "340", "344", "348", "352", "356", "360", "364", "368", "372", "833", "376", "380", "388", "392", "832", "400", "398", "404", "296", "408", "410", "414", "417", "418", "428", "422", "426", "430", "434", "438", "440", "442", "446", "807", "450", "454", "458", "462", "466", "470", "584", "474", "478", "480", "175", "484", "583", "498", "492", "496", "499", "500", "504", "508", "104", "516", "520", "524", "528", "540", "554", "558", "562", "566", "570", "574", "580", "578", "512", "586", "585", "275", "591", "598", "600", "604", "608", "612", "616", "620", "630", "634", "638", "642", "643", "646", "652", "654", "659", "662", "663", "666", "670", "882", "674", "678", "682", "686", "688", "690", "694", "702", "534", "703", "705", "090", "706", "710", "239", "728", "724", "144", "729", "740", "744", "748", "752", "756", "760", "158", "762", "834", "764", "626", "768", "772", "776", "780", "788", "792", "795", "796", "798", "800", "804", "784", "826", "840", "581", "858", "860", "548", "862", "704", "092", "850", "876", "732", "887", "894", "716"};
        Arrays.sort(this._countryCodIso);
        this._AddressTypeList = new String[]{"StreetAddress", "PostalAddress", "BillingAddress", "ShipToAddress", "ShipFromAddress"};
        Arrays.sort(this._AddressTypeList);
        this._EnumAnafList = new String[]{"ANAF"};
        Arrays.sort(this._EnumAnafList);
        this._RON = new String[]{"RON"};
        Arrays.sort(this._RON);
        this._selfBillingIndicatorList = new String[]{"389", "0"};
        Arrays.sort(this._selfBillingIndicatorList);
        this._nom_Tipuri_facturi = new String[]{"80", "81", "82", "83", "84", "130", "202", "203", "204", "211", "261", "262", "295", "296", "308", "325", "326", "380", "381", "383", "384", "385", "386", "387", "388", "389", "390", "393", "394", "395", "396", "420", "456", "457", "458", "527", "532", "575", "623", "633", "751", "780", "935"};
        Arrays.sort(this._nom_Tipuri_facturi);
        this._ISO_3166_2_RO = new String[]{"RO-AB", "RO-AR", "RO-AG", "RO-BC", "RO-BH", "RO-BN", "RO-BT", "RO-BV", "RO-BR", "RO-BZ", "RO-CS", "RO-CL", "RO-CJ", "RO-CT", "RO-CV", "RO-DB", "RO-DJ", "RO-GL", "RO-GR", "RO-GJ", "RO-HR", "RO-HD", "RO-IL", "RO-IS", "RO-IF", "RO-MM", "RO-MH", "RO-MS", "RO-NT", "RO-OT", "RO-PH", "RO-SM", "RO-SJ", "RO-SB", "RO-SV", "RO-TR", "RO-TM", "RO-TL", "RO-VS", "RO-VL", "RO-VN", "RO-B"};
        Arrays.sort(this._ISO_3166_2_RO);
        this._plan_conturi_bal_soc_com = ResourceBundle.getBundle("resources/Nomen_v" + this.version).getString("plan_conturi_bal_soc_com").split(",");
        Arrays.sort(this._plan_conturi_bal_soc_com);
        this._plan_conturi_invoice_I = ResourceBundle.getBundle("resources/Nomen_v" + this.version).getString("plan_conturi_invoice_I").split(",");
        Arrays.sort(this._plan_conturi_invoice_I);
        this._plan_conturi_banci = ResourceBundle.getBundle("resources/Nomen_v" + this.version).getString("plan_conturi_banci").split(",");
        Arrays.sort(this._plan_conturi_banci);
        this._plan_conturi_soc_asigurari = ResourceBundle.getBundle("resources/Nomen_v" + this.version).getString("plan_conturi_soc_asigurari").split(",");
        Arrays.sort(this._plan_conturi_soc_asigurari);
        this._plan_conturi_ifrs = ResourceBundle.getBundle("resources/Nomen_v" + this.version).getString("plan_conturi_ifrs").split(",");
        Arrays.sort(this._plan_conturi_ifrs);
        this._plan_conturi_n39 = ResourceBundle.getBundle("resources/Nomen_v" + this.version).getString("plan_conturi_n39").split(",");
        Arrays.sort(this._plan_conturi_n39);
        this._plan_conturi_ifn = ResourceBundle.getBundle("resources/Nomen_v" + this.version).getString("plan_conturi_ifn").split(",");
        Arrays.sort(this._plan_conturi_ifn);
        this._plan_conturi_n36 = ResourceBundle.getBundle("resources/Nomen_v" + this.version).getString("plan_conturi_n36").split(",");
        Arrays.sort(this._plan_conturi_n36);
        this._plan_conturi_norma14 = ResourceBundle.getBundle("resources/Nomen_v" + this.version).getString("plan_conturi_norma14").split(",");
        Arrays.sort(this._plan_conturi_norma14);
        this._plan_conturi_ONG = ResourceBundle.getBundle("resources/Nomen_v" + this.version).getString("plan_conturi_ONG").split(",");
        Arrays.sort(this._plan_conturi_ONG);
        this._plan_conturi_BNR6 = ResourceBundle.getBundle("resources/Nomen_v" + this.version).getString("plan_conturi_BNR6").split(",");
        Arrays.sort(this._plan_conturi_BNR6);
        this._taxAccountingBasis = new String[]{"A", "I", "IFRS", "BANK", "INSURANCE", "NORMA39", "IFN", "NORMA36", "NORMA14", "ONG", "ONGE", "BNR6"};
        Arrays.sort(this._taxAccountingBasis);
        this.taxAccountingBasisNomenMap.put("A", this._plan_conturi_bal_soc_com);
        this.taxAccountingBasisNomenMap.put("I", this._plan_conturi_invoice_I);
        this.taxAccountingBasisNomenMap.put("IFRS", this._plan_conturi_ifrs);
        this.taxAccountingBasisNomenMap.put("BANK", this._plan_conturi_banci);
        this.taxAccountingBasisNomenMap.put("INSURANCE", this._plan_conturi_soc_asigurari);
        this.taxAccountingBasisNomenMap.put("NORMA39", this._plan_conturi_n39);
        this.taxAccountingBasisNomenMap.put("IFN", this._plan_conturi_ifn);
        this.taxAccountingBasisNomenMap.put("NORMA36", this._plan_conturi_n36);
        this.taxAccountingBasisNomenMap.put("NORMA14", this._plan_conturi_norma14);
        this.taxAccountingBasisNomenMap.put("ONG", this._plan_conturi_ONG);
        this.taxAccountingBasisNomenMap.put("ONGE", this._plan_conturi_invoice_I);
        this.taxAccountingBasisNomenMap.put("BNR6", this._plan_conturi_BNR6);
        this._taxCode = new String[]{"000000", "310301", "310302", "310303", "310304", "310305", "310306", "310307", "310308", "310309", "310310", "310311", "310312", "310313", "310314", "310326", "310327", "310315", "310316", "310317", "310318", "310319", "310320", "310328", "310321", "310329", "310322", "310323", "310330", "310331", "310332", "310333", "310334", "310324", "310325", "310335", "310336", "310337", "300", "300101", "300102", "300103", "300201", "300202", "300203", "300401", "300402", "300403", "300501", "300502", "300503", "300601", "300602", "300603", "300701", "300702", "300703", "300801", "300802", "300803", "300901", "300902", "300903", "301101", "301102", "301103", "301201", "301202", "301203", "308301", "308302", "308303", "308304", "308305", "308306", "308307", "309105", "309104", "309101", "309102", "309103", "307301", "307314", "307311", "307312", "307313", "307302", "307324", "307321", "307322", "307323", "307303", "301301", "301302", "301303", "301304", "306301", "306311", "306312", "306302", "306303", "306304", "306309", "306310", "306306", "306307", "306308", "300905", "300904", "320", "320101", "320102", "320103", "320201", "320202", "320203", "320401", "320402", "320403", "320501", "320502", "320503", "320601", "320602", "320603", "320701", "320702", "320703", "320801", "320802", "320803", "320901", "320902", "320903", "321101", "321102", "321103", "321201", "321202", "321203", "328301", "328302", "328303", "328304", "328305", "328306", "329105", "329104", "329101", "329102", "329103", "327301", "327314", "327311", "327312", "327313", "327302", "327324", "327321", "327322", "327323", "327303", "321301", "321302", "321303", "321304", "326301", "326311", "326312", "326302", "326303", "326304", "326309", "326310", "326306", "326307", "326308", "320905", "320904", "330", "330101", "330102", "330103", "330201", "330202", "330203", "330401", "330402", "330403", "330501", "330502", "330503", "330601", "330602", "330603", "330701", "330702", "330703", "330801", "330802", "330803", "330901", "330902", "330903", "331101", "331102", "331103", "331201", "331202", "331203", "338301", "338302", "338303", "338304", "338305", "338306", "339105", "339104", "339101", "339102", "339103", "337301", "337314", "337311", "337312", "337313", "337302", "337324", "337321", "337322", "337323", "337303", "331301", "331302", "331303", "331304", "336301", "336311", "336312", "336302", "336303", "336304", "336309", "336310", "336306", "336307", "336308", "330905", "330904", "340", "340301", "340302", "340303", "340201", "340202", "340203", "340401", "340402", "340403", "340501", "340502", "340503", "340601", "340602", "340603", "340701", "340702", "340703", "340801", "340802", "340803", "340901", "340902", "340903", "341101", "341102", "341103", "341201", "341202", "341203", "348301", "348302", "348303", "348304", "348305", "348306", "349105", "349104", "349101", "349102", "349103", "347301", "347314", "347311", "347312", "347313", "347302", "347324", "347321", "347322", "347323", "347303", "341301", "341302", "341303", "341304", "346301", "346311", "346312", "346302", "346303", "346304", "346309", "346310", "346306", "346307", "346308", "340905", "340904", "350", "350101", "350102", "350103", "350201", "350202", "350203", "350401", "350402", "350403", "350501", "350502", "350503", "350601", "350602", "350603", "350701", "350702", "350703", "350801", "350802", "350803", "350901", "350902", "350903", "351101", "351102", "351103", "351201", "351202", "351203", "358301", "358302", "358303", "358304", "358305", "358306", "359105", "359104", "359101", "359102", "359103", "357301", "357314", "357311", "357312", "357313", "357302", "357324", "357321", "357322", "357323", "357303", "351301", "351302", "351303", "351304", "356301", "356311", "356312", "356302", "356303", "356304", "356309", "356310", "356306", "356307", "356308", "350905", "350904", "360", "360101", "360102", "360103", "360201", "360202", "360203", "360401", "360402", "360403", "360501", "360502", "360503", "360601", "360602", "360603", "360701", "360702", "360703", "360801", "360802", "360803", "360901", "360902", "360903", "361101", "361102", "361103", "361201", "361202", "361203", "368301", "368302", "368303", "368304", "368305", "368306", "369105", "369104", "369101", "369102", "369103", "367301", "367314", "367311", "367312", "367313", "367302", "367324", "367321", "367322", "367323", "367303", "361301", "361302", "361303", "361304", "366301", "366311", "366312", "366302", "366303", "366304", "366309", "366310", "366306", "366307", "366308", "360905", "360904", "370", "370101", "370102", "370103", "370201", "370202", "370203", "370401", "370402", "370403", "370501", "370502", "370503", "370601", "370602", "370603", "370701", "370702", "370703", "370801", "370802", "370803", "370901", "370902", "370903", "371101", "371102", "371103", "371201", "371202", "371203", "378301", "378302", "378303", "378304", "378305", "378306", "379105", "379104", "379101", "379102", "379103", "377301", "377314", "377311", "377312", "377313", "377302", "377324", "377321", "377322", "377323", "377303", "371301", "371302", "371303", "371304", "376301", "376311", "376312", "376302", "376303", "376304", "376309", "376310", "376306", "376307", "376308", "370905", "370904", "380", "380005", "380004", "380001", "380002", "380003", "380101", "380102", "380103", "380200", "380301", "380302", "380303", "380304", "380104", "380105", "390", "399105", "397301", "397302", "390301", "390302", "390303", "390201", "390202", "390203", "390401", "390402", "390403", "390501", "390502", "390503", "390601", "390602", "390603", "390701", "390702", "390703", "390801", "390802", "390803", "390901", "390902", "390903", "391101", "391102", "391103", "391201", "391202", "391203", "398301", "398302", "398303", "398304", "398305", "398306", "399104", "399101", "399102", "399103", "397314", "397311", "397312", "397313", "397324", "397321", "397322", "397323", "397303", "391301", "391302", "391303", "391304", "396301", "396311", "396312", "396302", "396303", "396304", "396309", "396310", "396306", "396307", "396308", "390905", "390904", "150010", "150020", "150030", "150040", "150050", "604010", "604020", "605010", "606010", "606020", "607010", "607020", "608010", "621010", "621020", "621030", "690010", "690020", "631010", "631020", "631030", "631040", "631050", "631060", "632010", "632020", "632030", "632040", "632050", "632060", "632070", "632080", "632090", "632100", "632110", "633010", "633020", "633030", "633040", "633050", "633060", "633070", "633080", "633090", "633100", "633110", "633120", "634010", "634020", "634030", "634040", "634050", "634060", "634070", "634080", "634090", "634100", "634110", "635010", "635020", "636010", "636020", "636030", "637010", "637020", "639010", "639020", "639030", "640010", "640020", "640030", "641010", "641020", "641030", "641040", "631011", "608020", "632120", "632130", "632140", "632150", "633130", "633140", "634120", "634130", "636040", "636050", "639040", "639050", "621040", "621050", "621060", "307304", "307305", "327304", "327305", "337304", "337305", "347304", "347305", "397304", "397305", "357304", "357305", "367304", "367305", "377304", "377305", "310338", "310339", "642010", "642020", "642030", "642040", "310340", "310341", "310342", "607050", "607060", "607070", "607080", "607090", "607100", "607110", "607120", "607130", "607140", "607150", "607160", "628010", "628020", "637030", "637040", "150060", "150070", "604030", "631070", "631080", "310343", "310344", "310345", "310346", "310347", "310348", "310349", "310350", "310351", "310352", "310353", "310354", "310355", "310356", "300104", "300105", "300204", "300205", "300404", "300405", "300504", "300505", "300604", "300605", "300704", "300705", "300804", "300805", "300906", "300907", "301104", "301105", "301204", "301205", "301305", "301306", "306313", "306314", "306315", "306316", "306317", "306318", "306319", "306320", "307325", "307326", "307327", "307328", "307329", "307330", "308308", "308309", "309106", "309107", "320104", "320105", "320204", "320205", "320404", "320405", "320504", "320505", "320604", "320605", "320704", "320705", "320804", "320805", "320906", "320907", "321104", "321105", "321204", "321205", "321305", "321306", "326313", "326314", "326315", "326316", "326317", "326318", "326319", "326320", "327306", "327307", "327315", "327316", "327325", "327326", "328307", "328308", "329106", "329107", "330104", "330105", "330204", "330205", "330404", "330405", "330504", "330505", "330604", "330605", "330704", "330705", "330804", "330805", "330906", "330907", "331104", "331105", "331204", "331205", "331305", "331306", "336313", "336314", "336315", "336316", "336317", "336318", "336319", "336320", "337306", "337307", "337315", "337316", "337325", "337326", "338307", "338308", "339106", "339107", "340304", "340305", "340204", "340205", "340404", "340405", "340504", "340505", "340604", "340605", "340704", "340705", "340804", "340805", "340906", "340907", "341104", "341105", "341204", "341205", "341306", "341305", "346313", "346314", "346315", "346316", "346317", "346318", "346319", "346320", "347306", "347307", "347315", "347316", "347325", "347326", "348307", "348308", "349106", "349107", "390304", "390305", "390204", "390205", "390404", "390405", "390504", "390505", "390604", "390605", "390704", "390705", "390804", "390805", "390906", "390907", "391104", "391105", "391204", "391205", "391305", "391306", "396313", "396314", "396315", "396316", "396317", "396318", "396319", "396320", "397306", "397307", "397315", "397316", "397325", "397326", "398307", "398308", "399106", "399107", "350104", "350105", "350204", "350205", "350404", "350405", "350504", "350505", "350604", "350605", "350704", "350705", "350804", "350805", "350906", "350907", "351104", "351105", "351204", "351205", "358307", "358308", "359106", "359107", "351305", "351306", "356313", "356314", "356315", "356316", "356317", "356318", "356319", "356320", "357306", "357307", "357315", "357316", "357325", "357326", "360104", "360105", "360204", "360205", "360404", "360405", "360504", "360505", "360604", "360605", "360704", "360705", "360804", "360805", "360906", "360907", "361104", "361105", "361204", "361205", "361305", "361306", "366313", "366314", "366315", "366316", "366317", "366318", "366319", "366320", "367306", "367307", "367315", "367316", "367325", "367326", "368307", "368308", "369106", "369107", "370104", "370105", "370204", "370205", "370404", "370405", "370504", "370505", "370604", "370605", "370704", "370705", "370804", "370805", "370906", "370907", "371104", "371105", "371204", "371205", "371305", "371306", "376313", "376314", "376315", "376316", "376317", "376318", "376319", "376320", "377306", "377307", "377315", "377316", "377325", "377326", "378307", "378308", "379106", "379107", "380006", "380007", "380106", "380107", "380305", "380306", "310357", "310358", "310359", "150080", "150090", "631090", "631100", "642050", "642060"};
        Arrays.sort(this._taxCode);
        this._ISO4217 = new String[]{"AED", "AFN", "ALL", "AMD", "ANG", "AOA", "ARS", "AUD", "AWG", "AZN", "BAM", "BBD", "BDT", "BGN", "BHD", "BIF", "BMD", "BND", "BOB", "BOV", "BRL", "BSD", "BTN", "BWP", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLF", "CLP", "CNY", "COP", "COU", "CRC", "CUC", "CUP", "CVE", "CZK", "DJF", "DKK", "DOP", "DZD", "EEK", "EGP", "ERN", "ETB", "EUR", "FJD", "FKP", "GBP", "GEL", "GHS", "GIP", "GMD", "GNF", "GTQ", "GYD", "HKD", "HNL", "HRK", "HTG", "HUF", "IDR", "ILS", "INR", "IQD", "IRR", "ISK", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LVL", "LYD", "MAD", "MDL", "MGA", "MKD", "MMK", "MNT", "MOP", "MRO", "MUR", "MVR", "MWK", "MXN", "MXV", "MYR", "MZN", "NAD", "NGN", "NIO", "NOK", "NPR", "NZD", "OMR", "PAB", "PEN", "PGK", "PHP", "PKR", "PLN", "PYG", "QAR", "RON", "RSD", "RUB", "RWF", "SAR", "SBD", "SCR", "SDG", "SEK", "SGD", "SHP", "SLL", "SOS", "SRD", "STD", "SYP", "SZL", "THB", "TJS", "TMT", "TND", "TOP", "TRY", "TTD", "TWD", "TZS", "UAH", "UGX", "USD", "USN", "USS", "UYU", "UZS", "VEF", "VND", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XFU", "XOF", "XPD", "XPF", "XPT", "XTS", "XXX", "YER", "ZAR", "ZMK", "ZWL"};
        Arrays.sort(this._ISO4217);
        this._UM = new String[]{"10", "11", "13", "14", "15", "20", "21", "22", "23", "24", "25", "27", "28", "33", "34", "35", "37", "38", "40", "41", "56", "57", "58", "59", "60", "61", "74", "77", "80", "81", "85", "87", "89", "91", "1I", "2A", "2B", "2C", "2G", "2H", "2I", "2J", "2K", "2L", "2M", "2N", "2P", "2Q", "2R", "2U", "2X", "2Y", "2Z", "3B", "3C", "4C", "4G", "4H", "4K", "4L", "4M", "4N", "4O", "4P", "4Q", "4R", "4T", "4U", "4W", "4X", "5A", "5B", "5E", "5J", "A10", "A11", "A12", "A13", "A14", "A15", "A16", "A17", "A18", "A19", "A2", "A20", "A21", "A22", "A23", "A24", "A26", "A27", "A28", "A29", "A3", "A30", "A31", "A32", "A33", "A34", "A35", "A36", "A37", "A38", "A39", "A4", "A40", "A41", "A42", "A43", "A44", "A45", "A47", "A48", "A49", "A5", "A53", "A54", "A55", "A56", "A59", "A6", "A68", "A69", "A7", "A70", "A71", "A73", "A74", "A75", "A76", "A8", "A84", "A85", "A86", "A87", "A88", "A89", "A9", "A90", "A91", "A93", "A94", "A95", "A96", "A97", "A98", "A99", "AA", "AB", "ACR", "ACT", "AD", "AE", "AH", "AI", "AK", "AL", "AMH", "AMP", "ANN", "APZ", "AQ", "AS", "ASM", "ASU", "ATM", "AWG", "AY", "AZ", "B1", "B10", "B11", "B12", "B13", "B14", "B15", "B16", "B17", "B18", "B19", "B20", "B21", "B22", "B23", "B24", "B25", "B26", "B27", "B28", "B29", "B3", "B30", "B31", "B32", "B33", "B34", "B35", "B4", "B41", "B42", "B43", "B44", "B45", "B46", "B47", "B48", "B49", "B50", "B52", "B53", "B54", "B55", "B56", "B57", "B58", "B59", "B60", "B61", "B62", "B63", "B64", "B66", "B67", "B68", "B69", "B7", "B70", "B71", "B72", "B73", "B74", "B75", "B76", "B77", "B78", "B79", "B8", "B80", "B81", "B82", "B83", "B84", "B85", "B86", "B87", "B88", "B89", "B90", "B91", "B92", "B93", "B94", "B95", "B96", "B97", "B98", "B99", "BAR", "BB", "BFT", "BHP", "BIL", "BLD", "BLL", "BP", "BPM", "BQL", "BTU", "BUA", "BUI", "C0", "C10", "C11", "C12", "C13", "C14", "C15", "C16", "C17", "C18", "C19", "C20", "C21", "C22", "C23", "C24", "C25", "C26", "C27", "C28", "C29", "C3", "C30", "C31", "C32", "C33", "C34", "C35", "C36", "C37", "C38", "C39", "C40", "C41", "C42", "C43", "C44", "C45", "C46", "C47", "C48", "C49", "C50", "C51", "C52", "C53", "C54", "C55", "C56", "C57", "C58", "C59", "C60", "C61", "C62", "C63", "C64", "C65", "C66", "C67", "C68", "C69", "C7", "C70", "C71", "C72", "C73", "C74", "C75", "C76", "C78", "C79", "C8", "C80", "C81", "C82", "C83", "C84", "C85", "C86", "C87", "C88", "C89", "C9", "C90", "C91", "C92", "C93", "C94", "C95", "C96", "C97", "C99", "CCT", "CDL", "CEL", "CEN", "CG", "CGM", "CKG", "CLF", "CLT", "CMK", "CMQ", "CMT", "CNP", "CNT", "COU", "CTG", "CTM", "CTN", "CUR", "CWA", "CWI", "D03", "D04", "D1", "D10", "D11", "D12", "D13", "D15", "D16", "D17", "D18", "D19", "D2", "D20", "D21", "D22", "D23", "D24", "D25", "D26", "D27", "D29", "D30", "D31", "D32", "D33", "D34", "D36", "D41", "D42", "D43", "D44", "D45", "D46", "D47", "D48", "D49", "D5", "D50", "D51", "D52", "D53", "D54", "D55", "D56", "D57", "D58", "D59", "D6", "D60", "D61", "D62", "D63", "D65", "D68", "D69", "D73", "D74", "D77", "D78", "D80", "D81", "D82", "D83", "D85", "D86", "D87", "D88", "D89", "D91", "D93", "D94", "D95", "DAA", "DAD", "DAY", "DB", "DD", "DEC", "DG", "DJ", "DLT", "DMA", "DMK", "DMO", "DMQ", "DMT", "DN", "DPC", "DPR", "DPT", "DRA", "DRI", "DRL", "DT", "DTN", "DWT", "DZN", "DZP", "E01", "E07", "E08", "E09", "E10", "E12", "E14", "E15", "E16", "E17", "E18", "E19", "E20", "E21", "E22", "E23", "E25", "E27", "E28", "E30", "E31", "E32", "E33", "E34", "E35", "E36", "E37", "E38", "E39", "E4", "E40", "E41", "E42", "E43", "E44", "E45", "E46", "E47", "E48", "E49", "E50", "E51", "E52", "E53", "E54", "E55", "E56", "E57", "E58", "E59", "E60", "E61", "E62", "E63", "E64", "E65", "E66", "E67", "E68", "E69", "E70", "E71", "E72", "E73", "E74", "E75", "E76", "E77", "E78", "E79", "E80", "E81", "E82", "E83", "E84", "E85", "E86", "E87", "E88", "E89", "E90", "E91", "E92", "E93", "E94", "E95", "E96", "E97", "E98", "E99", "EA", "EB", "EQ", "F01", "F02", "F03", "F04", "F05", "F06", "F07", "F08", "F10", "F11", "F12", "F13", "F14", "F15", "F16", "F17", "F18", "F19", "F20", "F21", "F22", "F23", "F24", "F25", "F26", "F27", "F28", "F29", "F30", "F31", "F32", "F33", "F34", "F35", "F36", "F37", "F38", "F39", "F40", "F41", "F42", "F43", "F44", "F45", "F46", "F47", "F48", "F49", "F50", "F51", "F52", "F53", "F54", "F55", "F56", "F57", "F58", "F59", "F60", "F61", "F62", "F63", "F64", "F65", "F66", "F67", "F68", "F69", "F70", "F71", "F72", "F73", "F74", "F75", "F76", "F77", "F78", "F79", "F80", "F81", "F82", "F83", "F84", "F85", "F86", "F87", "F88", "F89", "F90", "F91", "F92", "F93", "F94", "F95", "F96", "F97", "F98", "F99", "FAH", "FAR", "FBM", "FC", "FF", "FH", "FIT", "FL", "FOT", "FP", "FR", "FS", "FTK", "FTQ", "G01", "G04", "G05", "G06", "G08", "G09", "G10", "G11", "G12", "G13", "G14", "G15", "G16", "G17", "G18", "G19", "G2", "G20", "G21", "G23", "G24", "G25", "G26", "G27", "G28", "G29", "G3", "G30", "G31", "G32", "G33", "G34", "G35", "G36", "G37", "G38", "G39", "G40", "G41", "G42", "G43", "G44", "G45", "G46", "G47", "G48", "G49", "G50", "G51", "G52", "G53", "G54", "G55", "G56", "G57", "G58", "G59", "G60", "G61", "G62", "G63", "G64", "G65", "G66", "G67", "G68", "G69", "G70", "G71", "G72", "G73", "G74", "G75", "G76", "G77", "G78", "G79", "G80", "G81", "G82", "G83", "G84", "G85", "G86", "G87", "G88", "G89", "G90", "G91", "G92", "G93", "G94", "G95", "G96", "G97", "G98", "G99", "GB", "GBQ", "GDW", "GE", "GF", "GFI", "GGR", "GIA", "GIC", "GII", "GIP", "GJ", "GL", "GLD", "GLI", "GLL", "GM", "GO", "GP", "GQ", "GRM", "GRN", "GRO", "GV", "GWH", "H03", "H04", "H05", "H06", "H07", "H08", "H09", "H10", "H11", "H12", "H13", "H14", "H15", "H16", "H18", "H19", "H20", "H21", "H22", "H23", "H24", "H25", "H26", "H27", "H28", "H29", "H30", "H31", "H32", "H33", "H34", "H35", "H36", "H37", "H38", "H39", "H40", "H41", "H42", "H43", "H44", "H45", "H46", "H47", "H48", "H49", "H50", "H51", "H52", "H53", "H54", "H55", "H56", "H57", "H58", "H59", "H60", "H61", "H62", "H63", "H64", "H65", "H66", "H67", "H68", "H69", "H70", "H71", "H72", "H73", "H74", "H75", "H76", "H77", "H79", "H80", "H81", "H82", "H83", "H84", "H85", "H87", "H88", "H89", "H90", "H91", "H92", "H93", "H94", "H95", "H96", "H98", "H99", "HA", "HBA", "HBX", "HC", "HDW", "HEA", "HGM", "HH", "HIU", "HKM", "HLT", "HM", "HMQ", "HMT", "HPA", "HTZ", "HUR", "IA", "IE", "INH", "INK", "INQ", "ISD", "IU", "IUG", "IV", "J10", "J12", "J13", "J14", "J15", "J16", "J17", "J18", "J19", "J2", "J20", "J21", "J22", "J23", "J24", "J25", "J26", "J27", "J28", "J29", "J30", "J31", "J32", "J33", "J34", "J35", "J36", "J38", "J39", "J40", "J41", "J42", "J43", "J44", "J45", "J46", "J47", "J48", "J49", "J50", "J51", "J52", "J53", "J54", "J55", "J56", "J57", "J58", "J59", "J60", "J61", "J62", "J63", "J64", "J65", "J66", "J67", "J68", "J69", "J70", "J71", "J72", "J73", "J74", "J75", "J76", "J78", "J79", "J81", "J82", "J83", "J84", "J85", "J87", "J90", "J91", "J92", "J93", "J95", "J96", "J97", "J98", "J99", "JE", "JK", "JM", "JNT", "JOU", "JPS", "JWL", "K1", "K10", "K11", "K12", "K13", "K14", "K15", "K16", "K17", "K18", "K19", "K2", "K20", "K21", "K22", "K23", "K26", "K27", "K28", "K3", "K30", "K31", "K32", "K33", "K34", "K35", "K36", "K37", "K38", "K39", "K40", "K41", "K42", "K43", "K45", "K46", "K47", "K48", "K49", "K50", "K51", "K52", "K53", "K54", "K55", "K58", "K59", "K6", "K60", "K61", "K62", "K63", "K64", "K65", "K66", "K67", "K68", "K69", "K70", "K71", "K73", "K74", "K75", "K76", "K77", "K78", "K79", "K80", "K81", "K82", "K83", "K84", "K85", "K86", "K87", "K88", "K89", "K90", "K91", "K92", "K93", "K94", "K95", "K96", "K97", "K98", "K99", "KA", "KAT", "KB", "KBA", "KCC", "KDW", "KEL", "KGM", "KGS", "KHY", "KHZ", "KI", "KIC", "KIP", "KJ", "KJO", "KL", "KLK", "KLX", "KMA", "KMH", "KMK", "KMQ", "KMT", "KNI", "KNM", "KNS", "KNT", "KO", "KPA", "KPH", "KPO", "KPP", "KR", "KSD", "KSH", "KT", "KTN", "KUR", "KVA", "KVR", "KVT", "KW", "KWH", "KWN", "KWO", "KWS", "KWT", "KX", "L10", "L11", "L12", "L13", "L14", "L15", "L16", "L17", "L18", "L19", "L2", "L20", "L21", "L23", "L24", "L25", "L26", "L27", "L28", "L29", "L30", "L31", "L32", "L33", "L34", "L35", "L36", "L37", "L38", "L39", "L40", "L41", "L42", "L43", "L44", "L45", "L46", "L47", "L48", "L49", "L50", "L51", "L52", "L53", "L54", "L55", "L56", "L57", "L58", "L59", "L60", "L63", "L64", "L65", "L66", "L67", "L68", "L69", "L70", "L71", "L72", "L73", "L74", "L75", "L76", "L77", "L78", "L79", "L80", "L81", "L82", "L83", "L84", "L85", "L86", "L87", "L88", "L89", "L90", "L91", "L92", "L93", "L94", "L95", "L96", "L98", "L99", "LA", "LAC", "LBR", "LBT", "LD", "LEF", "LF", "LH", "LK", "LM", "LN", "LO", "LP", "LPA", "LR", "LS", "LTN", "LTR", "LUB", "LUM", "LUX", "LY", "M1", "M10", "M11", "M12", "M13", "M14", "M15", "M16", "M17", "M18", "M19", "M20", "M21", "M22", "M23", "M24", "M25", "M26", "M27", "M29", "M30", "M31", "M32", "M33", "M34", "M35", "M36", "M37", "M38", "M39", "M4", "M40", "M41", "M42", "M43", "M44", "M45", "M46", "M47", "M48", "M49", "M5", "M50", "M51", "M52", "M53", "M55", "M56", "M57", "M58", "M59", "M60", "M61", "M62", "M63", "M64", "M65", "M66", "M67", "M68", "M69", "M7", "M70", "M71", "M72", "M73", "M74", "M75", "M76", "M77", "M78", "M79", "M80", "M81", "M82", "M83", "M84", "M85", "M86", "M87", "M88", "M89", "M9", "M90", "M91", "M92", "M93", "M94", "M95", "M96", "M97", "M98", "M99", "MAH", "MAL", "MAM", "MAR", "MAW", "MBE", "MBF", "MBR", "MC", "MCU", "MD", "MGM", "MHZ", "MIK", "MIL", "MIN", "MIO", "MIU", "MLD", "MLT", "MMK", "MMQ", "MMT", "MND", "MON", "MPA", "MQH", "MQS", "MSK", "MTK", "MTQ", "MTR", "MTS", "MVA", "MWH", "N1", "N10", "N11", "N12", "N13", "N14", "N15", "N16", "N17", "N18", "N19", "N20", "N21", "N22", "N23", "N24", "N25", "N26", "N27", "N28", "N29", "N3", "N30", "N31", "N32", "N33", "N34", "N35", "N36", "N37", "N38", "N39", "N40", "N41", "N42", "N43", "N44", "N45", "N46", "N47", "N48", "N49", "N50", "N51", "N52", "N53", "N54", "N55", "N56", "N57", "N58", "N59", "N60", "N61", "N62", "N63", "N64", "N65", "N66", "N67", "N68", "N69", "N70", "N71", "N72", "N73", "N74", "N75", "N76", "N77", "N78", "N79", "N80", "N81", "N82", "N83", "N84", "N85", "N86", "N87", "N88", "N89", "N90", "N91", "N92", "N93", "N94", "N95", "N96", "N97", "N98", "N99", "NA", "NAR", "NCL", "NEW", "NF", "NIL", "NIU", "NL", "NM3", "NMI", "NMP", "NPT", "NT", "NU", "NX", "OA", "ODE", "ODG", "ODK", "ODM", "OHM", "ON", "ONZ", "OPM", "OT", "OZA", "OZI", "P1", "P10", "P11", "P12", "P13", "P14", "P15", "P16", "P17", "P18", "P19", "P2", "P20", "P21", "P22", "P23", "P24", "P25", "P26", "P27", "P28", "P29", "P30", "P31", "P32", "P33", "P34", "P35", "P36", "P37", "P38", "P39", "P40", "P41", "P42", "P43", "P44", "P45", "P46", "P47", "P48", "P49", "P5", "P50", "P51", "P52", "P53", "P54", "P55", "P56", "P57", "P58", "P59", "P60", "P61", "P62", "P63", "P64", "P65", "P66", "P67", "P68", "P69", "P70", "P71", "P72", "P73", "P74", "P75", "P76", "P77", "P78", "P79", "P80", "P81", "P82", "P83", "P84", "P85", "P86", "P87", "P88", "P89", "P90", "P91", "P92", "P93", "P94", "P95", "P96", "P97", "P98", "P99", "PAL", "PD", "PFL", "PGL", "PI", "PLA", "PO", "PQ", "PR", "PS", "PTD", "PTI", "PTL", "PTN", "Q10", "Q11", "Q12", "Q13", "Q14", "Q15", "Q16", "Q17", "Q18", "Q19", "Q20", "Q21", "Q22", "Q23", "Q24", "Q25", "Q26", "Q27", "Q28", "Q29", "Q30", "Q31", "Q32", "Q33", "Q34", "Q35", "Q36", "Q37", "Q38", "Q39", "Q40", "Q41", "Q42", "Q3", "QA", "QAN", "QB", "QR", "QTD", "QTI", "QTL", "QTR", "R1", "R9", "RH", "RM", "ROM", "RP", "RPM", "RPS", "RT", "S3", "S4", "SAN", "SCO", "SCR", "SEC", "SET", "SG", "SIE", "SM3", "SMI", "SQ", "SQR", "SR", "STC", "STI", "STK", "STL", "STN", "STW", "SW", "SX", "SYR", "T0", "T3", "TAH", "TAN", "TI", "TIC", "TIP", "TKM", "TMS", "TNE", "TP", "TPI", "TPR", "TQD", "TRL", "TST", "TTS", "U1", "U2", "UB", "UC", "VA", "VLT", "VP", "W2", "WA", "WB", "WCD", "WE", "WEB", "WEE", "WG", "WHR", "WM", "WSD", "WTT", "X1", "YDK", "YDQ", "YRD", "Z11", "ZP", "ZZ", "X1A", "X1B", "X1D", "X1F", "X1G", "X1W", "X2C", "X3A", "X3H", "X43", "X44", "X4A", "X4B", "X4C", "X4D", "X4F", "X4G", "X4H", "X5H", "X5L", "X5M", "X6H", "X6P", "X7A", "X7B", "X8A", "X8B", "X8C", "XAA", "XAB", "XAC", "XAD", "XAE", "XAF", "XAG", "XAH", "XAI", "XAJ", "XAL", "XAM", "XAP", "XAT", "XAV", "XB4", "XBA", "XBB", "XBC", "XBD", "XBE", "XBF", "XBG", "XBH", "XBI", "XBJ", "XBK", "XBL", "XBM", "XBN", "XBO", "XBP", "XBQ", "XBR", "XBS", "XBT", "XBU", "XBV", "XBW", "XBX", "XBY", "XBZ", "XCA", "XCB", "XCC", "XCD", "XCE", "XCF", "XCG", "XCH", "XCI", "XCJ", "XCK", "XCL", "XCM", "XCN", "XCO", "XCP", "XCQ", "XCR", "XCS", "XCT", "XCU", "XCV", "XCW", "XCX", "XCY", "XCZ", "XDA", "XDB", "XDC", "XDG", "XDH", "XDI", "XDJ", "XDK", "XDL", "XDM", "XDN", "XDP", "XDR", "XDS", "XDT", "XDU", "XDV", "XDW", "XDX", "XDY", "XEC", "XED", "XEE", "XEF", "XEG", "XEH", "XEI", "XEN", "XFB", "XFC", "XFD", "XFE", "XFI", "XFL", "XFO", "XFP", "XFR", "XFT", "XFW", "XFX", "XGB", "XGI", "XGL", "XGR", "XGU", "XGY", "XGZ", "XHA", "XHB", "XHC", "XHG", "XHN", "XHR", "XIA", "XIB", "XIC", "XID", "XIE", "XIF", "XIG", "XIH", "XIK", "XIL", "XIN", "XIZ", "XJB", "XJC", "XJG", "XJR", "XJT", "XJY", "XKG", "XKI", "XLE", "XLG", "XLT", "XLU", "XLV", "XLZ", "XMA", "XMB", "XMC", "XME", "XMR", "XMS", "XMT", "XMW", "XMX", "XNA", "XNE", "XNF", "XNG", "XNS", "XNT", "XNU", "XNV", "XOA", "XOB", "XOC", "XOD", "XOE", "XOF", "XOK", "XOT", "XOU", "XP2", "XPA", "XPB", "XPC", "XPD", "XPE", "XPF", "XPG", "XPH", "XPI", "XPJ", "XPK", "XPL", "XPN", "XPO", "XPP", "XPR", "XPT", "XPU", "XPV", "XPX", "XPY", "XPZ", "XQA", "XQB", "XQC", "XQD", "XQF", "XQG", "XQH", "XQJ", "XQK", "XQL", "XQM", "XQN", "XQP", "XQQ", "XQR", "XQS", "XRD", "XRG", "XRJ", "XRK", "XRL", "XRO", "XRT", "XRZ", "XSA", "XSB", "XSC", "XSD", "XSE", "XSH", "XSI", "XSK", "XSL", "XSM", "XSO", "XSP", "XSS", "XST", "XSU", "XSV", "XSW", "XSY", "XSZ", "XT1", "XTB", "XTC", "XTD", "XTE", "XTG", "XTI", "XTK", "XTL", "XTN", "XTO", "XTR", "XTS", "XTT", "XTU", "XTV", "XTW", "XTY", "XTZ", "XUC", "XUN", "XVA", "XVG", "XVI", "XVK", "XVL", "XVO", "XVP", "XVQ", "XVN", "XVR", "XVS", "XVY", "XWA", "XWB", "XWC", "XWD", "XWF", "XWG", "XWH", "XWJ", "XWK", "XWL", "XWM", "XWN", "XWP", "XWQ", "XWR", "XWS", "XWT", "XWU", "XWV", "XWW", "XWX", "XWY", "XWZ", "XXA", "XXB", "XXC", "XXD", "XXF", "XXG", "XXH", "XXJ", "XXK", "XYA", "XYB", "XYC", "XYD", "XYF", "XYG", "XYH", "XYJ", "XYK", "XYL", "XYM", "XYN", "XYP", "XYQ", "XYR", "XYS", "XYT", "XYV", "XYW", "XYX", "XYY", "XYZ", "XZA", "XZB", "XZC", "XZD", "XZF", "XZG", "XZH", "XZJ", "XZK", "XZL", "XZM", "XZN", "XZP", "XZQ", "XZR", "XZS", "XZT", "XZU", "XZV", "XZW", "XZX", "XZY", "XZZ", "XLTR", "B30", "DBM", "DBW", "FNU", "HAD", "HMO", "HWE", "KWY", "MKD", "MKM", "MKW", "MNJ", "MQD", "MQM", "MQW", "MRD", "MRM", "MRW", "MTZ", "NTU", "Z9", "XO1", "XO2", "XO3", "XO4", "XO5", "XO6", "XO7", "XO8", "XO9", "XOG", "XOH", "XOI", "XOJ", "XOL", "XOM", "XON", "XOP", "XOQ", "XOR", "XOS", "XOV", "XOW", "XOX", "XOY", "XOZ", "XP1", "XP3", "XP4", "XSX"};
        Arrays.sort(this._UM);
        this._stoc = new String[]{"10", "20", "30", "40", "50", "60", "70", "80", "90", "100", "101", "110", "120", "130", "140", "150", "160", "170", "180"};
        Arrays.sort(this._stoc);
        this._gsid = new String[]{"01", "02"};
        Arrays.sort(this._gsid);
        this._NC8_2022_TARIC3 = ResourceBundle.getBundle("resources/NC8_2022_TARIC3_v" + this.version).getString("arrayOfValues").split(",");
        Arrays.sort(this._NC8_2022_TARIC3);
        this._SAFcodeType = new String[]{"C", "D"};
        Arrays.sort(this._SAFcodeType);
        this._mPlati = new String[]{"01", "02", "03", "98", "99"};
        Arrays.sort(this._mPlati);
        this._mecPlati = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "74", "75", "76", "77", "78", "91", "92", "93", "94", "95", "96", "97", "ZZZ"};
        Arrays.sort(this._mecPlati);
        String[] payments = ResourceBundle.getBundle("resources/Nomen_v" + this.version).getString("payments").split(",");
        for (int i = 0; i < payments.length; ++i) {
            String[] payment = payments[i].split("\\|");
            this.payMap.put(payment[0], payment[1]);
        }
        this._imobilizari = new String[]{"10", "20", "30", "40", "50", "60", "70", "80", "90", "100", "110", "120", "130"};
        Arrays.sort(this._imobilizari);
        this._taxImp = new String[]{"000", "100", "101", "102", "103", "104", "105", "106", "107", "110", "111", "112", "113", "114", "120", "121", "122", "127", "128", "130", "140", "150", "155", "160", "161", "200", "210", "211", "212", "213", "214", "215", "216", "217", "218", "220", "221", "222", "223", "224", "225", "226", "227", "230", "231", "232", "233", "234", "235", "236", "237", "238", "239", "240", "241", "242", "243", "244", "250", "251", "252", "253", "254", "255", "256", "257", "258", "259", "260", "261", "270", "275", "280", "283", "290", "300", "301", "302", "303", "304", "305", "307", "344", "390", "410", "411", "412", "413", "414", "415", "416", "417", "418", "419", "420", "421", "422", "423", "424", "430", "431", "432", "433", "434", "435", "436", "437", "438", "439", "440", "441", "442", "443", "444", "445", "446", "447", "448", "449", "450", "451", "452", "453", "454", "455", "456", "457", "458", "459", "460", "461", "462", "463", "464", "465", "466", "467", "468", "469", "470", "471", "472", "473", "474", "475", "476", "480", "481", "482", "483", "484", "485", "486", "500", "501", "502", "503", "504", "510", "511", "512", "513", "514", "515", "516", "517", "518", "519", "520", "521", "522", "523", "524", "535", "536", "537", "538", "539", "540", "541", "551", "552", "600", "601", "602", "603", "604", "605", "606", "607", "608", "609", "610", "611", "612", "613", "614", "615", "616", "617", "618", "619", "620", "621", "622", "623", "624", "625", "626", "631", "632", "633", "634", "635", "636", "637", "638", "639", "640", "641", "650", "675", "690", "699", "701", "708", "710", "711", "712", "713", "720", "721", "725", "730", "735", "740", "750", "751", "752", "753", "754", "755", "756", "757", "758", "759", "760", "761", "762", "763", "765", "770", "771", "772", "773", "774", "776", "777", "778", "779", "780", "781", "790", "791", "810", "811", "814", "820", "825", "830", "840", "850", "910", "911", "912", "913", "915", "916", "920", "921", "922", "923", "924", "925", "926", "927", "930", "931", "932", "933", "940", "941", "942", "943", "944", "945", "946", "947", "950", "951", "952", "953", "954", "955", "956", "957", "958", "959", "960", "961", "970", "971", "972", "981", "982", "983", "984", "985", "986", "987", "988", "990", "991", "992", "993", "994", "995", "997", "998", "999", "162", "642", "709", "108", "116", "117", "163", "164", "179", "228", "245", "246", "477", "487", "488", "489", "534", "553", "627", "628", "650", "706", "707", "766", "767"};
        Arrays.sort(this._taxImp);
        this._regFisc = new String[]{"100010", "100020", "100030", "100040", "100050"};
        Arrays.sort(this._regFisc);
        this._tipDeclaratie = new String[]{"L", "T", "A", "C", "NL", "NT"};
        Arrays.sort(this._tipDeclaratie);
        this._accountType = new String[]{"Activ", "Pasiv", "Bifunctional"};
        Arrays.sort(this._accountType);
        this.IBANFormat = ResourceBundle.getBundle("resources/IBANFormat_v" + this.version);
    }
}

