/*
 * Decompiled with CFR 0.152.
 */
package d406.helper;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfLayer;
import com.itextpdf.text.pdf.PdfOCG;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.TextField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import pdf.Pdf;
import pdf.PdfRoot;

public abstract class PdfRootExt
extends PdfRoot
implements Pdf {
    protected static final BaseColor BLUE = new BaseColor(204, 229, 255);
    protected static final BaseColor YELLOW = new BaseColor(255, 255, 204);
    protected PdfLayer layerRO;
    protected PdfLayer layerEN;
    protected PdfContentByte cb;
    protected PdfLayer radioGroup;
    ResourceBundle propsRO = ResourceBundle.getBundle("resources/labels", new Locale("ro", "RO"));
    ResourceBundle propsEN = ResourceBundle.getBundle("resources/labels", new Locale("en", "US"));

    protected String createDoc(boolean withImage) {
        String err = super.createDoc(withImage);
        try {
            this.cb = this._writer.getDirectContent();
            this.radioGroup = PdfLayer.createTitle((String)"Language", (PdfWriter)this._writer);
            this.layerRO = new PdfLayer("RO", this._writer);
            this.layerRO.setOn(true);
            this.layerEN = new PdfLayer("EN", this._writer);
            this.layerEN.setOn(false);
            this.radioGroup.addChild(this.layerRO);
            this.radioGroup.addChild(this.layerEN);
            ArrayList<PdfLayer> options = new ArrayList<PdfLayer>();
            options.add(this.layerRO);
            options.add(this.layerEN);
            this._writer.addOCGRadioGroup(options);
        }
        catch (IOException ex) {
            Logger.getLogger(PdfRootExt.class.getName()).log(Level.SEVERE, null, ex);
        }
        return err;
    }

    protected float drawParag(String label, Object ... list) throws DocumentException {
        float x = this.defX;
        float y = this.defY;
        float h = this.defH;
        float w = this.defW;
        float fSize = this.defFontS;
        int options = this.defOptions;
        if (list != null) {
            int val = list.length;
            if (val > 0 && list[0] != null) {
                x = ((Double)list[0]).floatValue();
            }
            if (val > 1 && list[1] != null) {
                y = ((Double)list[1]).floatValue();
            }
            if (val > 2 && list[2] != null) {
                w = ((Double)list[2]).floatValue();
            }
            if (val > 3 && list[3] != null) {
                h = ((Double)list[3]).floatValue();
            }
            if (val > 4 && list[4] != null) {
                options = (Integer)list[4];
            }
        }
        float yInit = this.defY;
        y -= h;
        int style = 0;
        if ((options & 0x100) != 0) {
            style |= 2;
        }
        if ((options & 0x80) != 0) {
            style |= 1;
        }
        try {
            String pathToFont = "/resources/calibri.ttf";
            String fontname = PdfRootExt.class.getResource(pathToFont).toString();
            this.cb.beginLayer((PdfOCG)this.layerRO);
            ColumnText.showTextAligned((PdfContentByte)this.cb, (int)5, (Phrase)new Phrase(this.propsRO.containsKey(label) ? this.propsRO.getString(label) : label, new Font(BaseFont.createFont((String)fontname, (String)"Identity-H", (boolean)true), fSize, style)), (float)(x + 1.0f), (float)(y + (h - fSize) / 2.0f), (float)0.0f);
            this.cb.endLayer();
            this.cb.beginLayer((PdfOCG)this.layerEN);
            ColumnText.showTextAligned((PdfContentByte)this.cb, (int)5, (Phrase)new Phrase(this.propsEN.containsKey(label) ? this.propsEN.getString(label) : label, new Font(BaseFont.createFont((String)fontname, (String)"Identity-H", (boolean)true), fSize, style)), (float)(x + 1.0f), (float)(y + (h - fSize) / 2.0f), (float)0.0f);
            this.cb.endLayer();
        }
        catch (Throwable var13) {
            ColumnText.showTextAligned((PdfContentByte)this.cb, (int)5, (Phrase)new Phrase(this.propsRO.getString(label), new Font(Font.FontFamily.TIMES_ROMAN, fSize, style)), (float)(x + 1.0f), (float)(y + (h - fSize) / 2.0f), (float)0.0f);
        }
        if ((options & 0x180F) != 0) {
            Rectangle rect = new Rectangle(x, y, x + w, y + h);
            rect.setBorderWidth(0.5f);
            rect.setBorderColor(BaseColor.BLACK);
            rect.setBorder(options & 0xF);
            if ((options & 0x800) != 0) {
                rect.setBackgroundColor(YELLOW);
            } else if ((options & 0x1000) != 0) {
                rect.setBackgroundColor(BLUE);
            }
            this._document.add((Element)rect);
        }
        this.defY = y;
        return yInit;
    }

    protected float drawField(String name, String value, Object ... list) throws DocumentException, IOException {
        float x = this.defX;
        float y = this.defY;
        float h = this.defH;
        float w = this.defW;
        float fSize = this.defFontS;
        int options = this.defOptions;
        String pathToFont = "/resources/calibri.ttf";
        String fontname = PdfRootExt.class.getResource(pathToFont).toString();
        if (list != null) {
            int val = list.length;
            if (val > 0 && list[0] != null) {
                x = ((Double)list[0]).floatValue();
            }
            if (val > 1 && list[1] != null) {
                y = ((Double)list[1]).floatValue();
            }
            if (val > 2 && list[2] != null) {
                w = ((Double)list[2]).floatValue();
            }
            if (val > 3 && list[3] != null) {
                h = ((Double)list[3]).floatValue();
            }
            if (val > 4 && list[4] != null) {
                options = (Integer)list[4];
            }
            if (val > 5 && list[5] != null) {
                fSize = ((Double)list[5]).floatValue();
            }
        }
        if ((options & 0x180F) != 0) {
            Rectangle rect = new Rectangle(x, y, x + w, y - h);
            rect.setBorderWidth(1.0f);
            rect.setBorderColor(BaseColor.BLACK);
            rect.setBorder(options & 0xF);
            if ((options & 0x800) != 0) {
                rect.setBackgroundColor(YELLOW);
            } else if ((options & 0x1000) != 0) {
                rect.setBackgroundColor(BLUE);
            }
            this._document.add((Element)rect);
        }
        TextField field = new TextField(this._writer, new Rectangle(x, y + fSize / 8.0f, x + w, y - h + fSize / 8.0f), name);
        field.setText(value);
        field.setFontSize(fSize);
        field.setFont(BaseFont.createFont((String)fontname, (String)"Identity-H", (boolean)true));
        field.setAlignment((options & 0x10) != 0 ? 0 : ((options & 0x40) != 0 ? 2 : 1));
        field.setOptions(4096);
        field.setOptions(4097);
        if ((options & 0x400) != 0) {
            field.setVisibility(1);
        }
        this._writer.addAnnotation((PdfAnnotation)field.getTextField());
        this.defY = y - h;
        return y;
    }
}

