/*
 * Decompiled with CFR 0.152.
 */
package d406tvalidator.v0;

import d406tvalidator.v0.DataObjectRoot;
import d406tvalidator.v0.ValidatorImpl;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BankAccount
extends DataObjectRoot {
    String id;
    public static final int TAG_COUNT = 5;
    public static final int ID_INT_BANKACCOUNT = 0;
    public static final int ID_INT_BANKACCOUNT_0_1_9_42 = 0;
    public static final String CTX_BANKACCOUNT_0_1_9_42 = "0_1_9_42";
    public static final int ID_INT_BANKACCOUNT_0_64_85_86_87_42 = 0;
    public static final String CTX_BANKACCOUNT_0_64_85_86_87_42 = "0_64_85_86_87_42";
    public static final int ID_INT_BANKACCOUNT_0_64_90_91_87_42 = 0;
    public static final String CTX_BANKACCOUNT_0_64_90_91_87_42 = "0_64_90_91_87_42";
    public static final int ID_INT_BANKACCOUNT_0_64_149_150_87_42 = 0;
    public static final String CTX_BANKACCOUNT_0_64_149_150_87_42 = "0_64_149_150_87_42";
    public static final int ID_INT_IBANNUMBER_0_1_9_42_43 = 1;
    public static final String CTX_IBANNUMBER_0_1_9_42_43 = "0_1_9_42_43";
    public static final int ID_INT_IBANNUMBER_0_64_85_86_87_42_43 = 1;
    public static final String CTX_IBANNUMBER_0_64_85_86_87_42_43 = "0_64_85_86_87_42_43";
    public static final int ID_INT_IBANNUMBER_0_64_90_91_87_42_43 = 1;
    public static final String CTX_IBANNUMBER_0_64_90_91_87_42_43 = "0_64_90_91_87_42_43";
    public static final int ID_INT_IBANNUMBER_0_64_149_150_87_42_43 = 1;
    public static final String CTX_IBANNUMBER_0_64_149_150_87_42_43 = "0_64_149_150_87_42_43";
    public static final int ID_INT_BANKACCOUNTNUMBER_0_1_9_42_44 = 2;
    public static final String CTX_BANKACCOUNTNUMBER_0_1_9_42_44 = "0_1_9_42_44";
    public static final int ID_INT_BANKACCOUNTNUMBER_0_64_85_86_87_42_44 = 2;
    public static final String CTX_BANKACCOUNTNUMBER_0_64_85_86_87_42_44 = "0_64_85_86_87_42_44";
    public static final int ID_INT_BANKACCOUNTNUMBER_0_64_90_91_87_42_44 = 2;
    public static final String CTX_BANKACCOUNTNUMBER_0_64_90_91_87_42_44 = "0_64_90_91_87_42_44";
    public static final int ID_INT_BANKACCOUNTNUMBER_0_64_149_150_87_42_44 = 2;
    public static final String CTX_BANKACCOUNTNUMBER_0_64_149_150_87_42_44 = "0_64_149_150_87_42_44";
    public static final int ID_INT_BANKACCOUNTNAME_0_1_9_42_45 = 3;
    public static final String CTX_BANKACCOUNTNAME_0_1_9_42_45 = "0_1_9_42_45";
    public static final int ID_INT_BANKACCOUNTNAME_0_64_85_86_87_42_45 = 3;
    public static final String CTX_BANKACCOUNTNAME_0_64_85_86_87_42_45 = "0_64_85_86_87_42_45";
    public static final int ID_INT_BANKACCOUNTNAME_0_64_90_91_87_42_45 = 3;
    public static final String CTX_BANKACCOUNTNAME_0_64_90_91_87_42_45 = "0_64_90_91_87_42_45";
    public static final int ID_INT_BANKACCOUNTNAME_0_64_149_150_87_42_45 = 3;
    public static final String CTX_BANKACCOUNTNAME_0_64_149_150_87_42_45 = "0_64_149_150_87_42_45";
    public static final int ID_INT_SORTCODE_0_1_9_42_46 = 4;
    public static final String CTX_SORTCODE_0_1_9_42_46 = "0_1_9_42_46";
    public static final int ID_INT_SORTCODE_0_64_85_86_87_42_46 = 4;
    public static final String CTX_SORTCODE_0_64_85_86_87_42_46 = "0_64_85_86_87_42_46";
    public static final int ID_INT_SORTCODE_0_64_90_91_87_42_46 = 4;
    public static final String CTX_SORTCODE_0_64_90_91_87_42_46 = "0_64_90_91_87_42_46";
    public static final int ID_INT_SORTCODE_0_64_149_150_87_42_46 = 4;
    public static final String CTX_SORTCODE_0_64_149_150_87_42_46 = "0_64_149_150_87_42_46";
    String _IBANNumber;
    boolean _IBANNumber_ok;
    String _BankAccountNumber;
    boolean _BankAccountNumber_ok;
    String _BankAccountName;
    boolean _BankAccountName_ok;
    String _SortCode;
    boolean _SortCode_ok;

    public BankAccount(ValidatorImpl validator, DataObjectRoot parent) {
        super(validator, parent, 5);
    }

    public void checkTag(int codTag) {
        switch (codTag) {
            case 0: {
                this.startValidation(codTag);
                this.endValidation(codTag);
                break;
            }
            case 1: {
                this.startValidation(codTag);
                this.endValidation(codTag);
                break;
            }
            case 2: {
                this.startValidation(codTag);
                this.endValidation(codTag);
                break;
            }
            case 3: {
                this.startValidation(codTag);
                this.endValidation(codTag);
                break;
            }
            case 4: {
                this.startValidation(codTag);
                this.endValidation(codTag);
            }
        }
    }

    public void aggregation(int codTag) {
        switch (codTag) {
            case 0: {
                break;
            }
            case 1: {
                this._IBANNumber = this._validator.nextAttribute("", 35, 4, 0);
                this._IBANNumber_ok = this._validator._attributeOK;
                if (this._IBANNumber == null) break;
                if (this._IBANNumber.length() < 4) {
                    this._validator.addError(1, "IBANNumber", "", this._validator.fillParams("Pentru IBANNumber '@0@' formatul este invalid", new Object[]{this._IBANNumber}));
                    break;
                }
                String countryCode = this._IBANNumber.substring(0, 2);
                if (!this._params.IBANFormat.containsKey(countryCode)) {
                    this._validator.addError(1, "IBANNumber", "", this._validator.fillParams("Pentru IBANNumber '@0@' codul tarii @1@ nu face parte din lista", new Object[]{this._IBANNumber, countryCode}));
                    break;
                }
                String regEx = BankAccount.getRegEx(this._params.IBANFormat.getString(countryCode));
                Pattern pattern = Pattern.compile(regEx);
                Matcher m = pattern.matcher(this._IBANNumber.substring(4));
                if (m.matches()) break;
                this._validator.addError(1, "IBANNumber", "", this._validator.fillParams("Pentru IBANNumber '@0@' formatul este invalid pentru codul tarii '@1@'", new Object[]{this._IBANNumber, countryCode}));
                break;
            }
            case 2: {
                this._BankAccountNumber = this._validator.nextAttribute("", 35, 4, 0);
                this._BankAccountNumber_ok = this._validator._attributeOK;
                break;
            }
            case 3: {
                this._BankAccountName = this._validator.nextAttribute("", 70, 4, 0);
                this._BankAccountName_ok = this._validator._attributeOK;
                break;
            }
            case 4: {
                this._SortCode = this._validator.nextAttribute("", 18, 4, 0);
                this._SortCode_ok = this._validator._attributeOK;
            }
        }
    }

    public void initialization() {
        this.id = null;
        this._IBANNumber = null;
        this._IBANNumber_ok = false;
        this._BankAccountNumber = null;
        this._BankAccountNumber_ok = false;
        this._BankAccountName = null;
        this._BankAccountName_ok = false;
        this._SortCode = null;
        this._SortCode_ok = false;
    }

    public static String getRegEx(String format) {
        List<String> fList = Arrays.asList(format.split(","));
        String regExp = "";
        for (String s : fList) {
            regExp = regExp + s.replaceAll("(\\d+)([a,c,n])$", "$2{$1}").replaceAll("a", "[A-Z]").replaceAll("n", "[0-9]").replaceAll("c", "[a-zA-Z0-9]");
        }
        return regExp + "$";
    }
}

