/*
 * Decompiled with CFR 0.152.
 */
package d406;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import d406.DeDocInfo;
import d406.helper.PdfRootExt;
import d406validator.Validator;
import dec.Info;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import pdf.Pdf;

public class Pdf_v0
extends PdfRootExt
implements Pdf {
    private DeDocInfo deDocInfo = new DeDocInfo();

    public String createPdf(Info info, String pdfFile, String xmlFile, String attFile) {
        this.setParams(pdfFile, xmlFile, attFile);
        try {
            this.createDoc(false);
            this.defOptions = 4271;
            this.defW = 150.0f;
            this.defFontS = 8.0f;
            this.defX = 20.0f;
            this.drawFileHeader(info._decName, info._version);
            String err = this.drawANAFSign();
            if (err != null) {
                return err;
            }
            this.defX = 20.0f;
            this.drawRectangle(this.defX, 8.0f, 550.0f, BaseColor.LIGHT_GRAY);
            this.defH *= 2.0f;
            this.defFontS = 10.0f;
            Object auditFile = info._collection.get("AuditFile");
            this.drawPeriodSection(auditFile);
            this.drawRectangle(this.defX, 8.0f, 550.0f, BaseColor.LIGHT_GRAY);
            this.defFontS = 8.0f;
            this.drawParag("sectionATitle", null, null, 530.0, new Double(this.defH / 2.0f));
            Object taxRegistration = info._collection.get("TaxRegistration");
            Object address = info._collection.get("Address");
            this.drawCompanyInfo(auditFile, taxRegistration, address);
            this.drawRectangle(this.defX, 8.0f, 550.0f, BaseColor.LIGHT_GRAY);
            this.drawParag("sectionBTitle", null, null, 530.0, new Double(this.defH / 2.0f));
            this.drawSectionBMasterFiles(info);
            this.drawSectionBGeneralLedgerEntries(info);
            this.drawSectionBSourceDocuments(info);
            this.drawRectangle(this.defX, 8.0f, 550.0f, BaseColor.LIGHT_GRAY);
            this.drawProxyIdentificationData();
            this.drawRectangle(this.defX, 8.0f, 550.0f, BaseColor.LIGHT_GRAY);
            this.drawSectionDReservedOfficialUse();
            this.drawRectangle(this.defX, 8.0f, 550.0f, BaseColor.LIGHT_GRAY);
            this.drawSectionEUniqueIdentifier(info._sumaControl);
        }
        catch (Throwable e3) {
            e3.printStackTrace();
            return "eroare scriere PDF: " + e3.toString();
        }
        return this.finalizeDoc();
    }

    public void drawFileHeader(String name, String version) throws DocumentException, IOException {
        double y = this.drawParag("docVersion", 60.0, null, null, null, 143);
        this.defY += this.defH;
        this.drawRectangle(this.defX, this.defH, this.defX + this.defW, BLUE);
        String uCode = name.toUpperCase() + "_" + version;
        this.drawField("universalCode", uCode, new Object[0]);
        this.deDocInfo.setUniversalCode(uCode);
        this.drawRectangle(this.defX, this.defH * 4.0f, this.defX + this.defW, BaseColor.WHITE);
        this.defX += this.defW;
        this.defW = 330.0f;
        this.defFontS = 13.0f;
        this.defY = new Float(y).floatValue();
        this.drawRectangle(this.defX, this.defH * 6.0f, this.defX + this.defW, BLUE);
        this.defY -= this.defH * 6.0f;
        this.drawParag("titleLine1", new Double(this.defX + 60.0f), y - 20.0, 270.0, (double)this.defH * 2.0, 128);
        this.drawParag("titleLine2", new Double(this.defX + 50.0f), null, 280.0, (double)this.defH * 2.0, 128);
        this.defFontS = 8.0f;
        this.defX += this.defW;
        this.defW = 50.0f;
        this.drawParag("lang", new Double(this.defX + 15.0f), y, 35.0, (double)this.defH * 2.0, 128);
        this.defY += this.defH * 2.0f;
        this.drawRectangle(this.defX, this.defH * 2.0f, this.defX + this.defW, BLUE);
        String dRec = "I";
        this.drawField("d_rec", dRec, new Double(this.defX + this.defW), y, 20.0, (double)this.defH * 2.0, 1024);
        this.deDocInfo.setD_rec(dRec);
        this.defFontS = 13.0f;
        this.drawParag(name.toUpperCase(), new Double(this.defX + 10.0f), null, 40.0, 50.0, 128);
        this.defY += 50.0f;
        this.drawRectangle(this.defX, this.defH * 4.0f, this.defX + this.defW, BLUE);
    }

    private String drawANAFSign() {
        try {
            URL imageURL = ((Object)((Object)this)).getClass().getResource("images/sigla_anaf.jpg");
            Image img = Image.getInstance((URL)imageURL);
            img.setAbsolutePosition(20.0f, 750.0f);
            this._document.add((Element)img);
        }
        catch (DocumentException var5) {
            return "eroare creare sigla ANAF: " + var5.toString();
        }
        catch (IOException var5) {
            return "eroare creare sigla ANAF: " + var5.toString();
        }
        return null;
    }

    private void drawPeriodSection(Object auditFile) throws DocumentException, IOException, ParseException {
        String anSf;
        String lunaSf;
        String lunaIncep;
        String selectionDate = this.getProdFields(auditFile, "_H_SC_SelectionStartDate");
        if (!"".equals(selectionDate)) {
            Date ld = new SimpleDateFormat("yyyy-MM-dd").parse(selectionDate);
            Calendar cal = Calendar.getInstance();
            cal.setTime(ld);
            lunaIncep = String.format("%02d", cal.get(2) + 1);
            String anIncep = String.valueOf(cal.get(1));
            selectionDate = this.getProdFields(auditFile, "_H_SC_SelectionEndDate");
            ld = new SimpleDateFormat("yyyy-MM-dd").parse(selectionDate);
            cal = Calendar.getInstance();
            cal.setTime(ld);
            lunaSf = String.format("%02d", cal.get(2) + 1);
            anSf = String.valueOf(cal.get(1));
        } else {
            lunaIncep = this.getProdFields(auditFile, "_H_SC_PeriodStart");
            String anIncep = this.getProdFields(auditFile, "_H_SC_PeriodStartYear");
            lunaSf = this.getProdFields(auditFile, "_H_SC_PeriodEnd");
            anSf = this.getProdFields(auditFile, "_H_SC_PeriodEndYear");
        }
        double y = this.drawParag("period", null, null, 90.0, null);
        this.drawParag("start", 110.0, y, 60.0, null);
        this.drawParag("month", 170.0, y, 40.0, null);
        this.drawField("luna_incep", lunaIncep, 210.0, y, 40.0, null, 2095);
        this.drawField("luna_r", lunaSf, 550.0, y, 40.0, null, 1024);
        this.drawParag("year", 250.0, y, 40.0, null);
        this.drawField("an_r", anSf, 290.0, y, 40.0, null, 2095);
        this.drawParag("end", 330.0, y, 60.0, null);
        this.drawParag("month", 390.0, y, 40.0, null);
        this.drawField("luna_sf", lunaSf, 430.0, y, 40.0, null, 2095);
        this.drawParag("year", 470.0, y, 40.0, null);
        this.drawField("an_sf", anSf, 510.0, y, 40.0, null, 2095);
        this.deDocInfo.setAn_r(anSf);
        this.deDocInfo.setLuna_r(lunaSf);
    }

    private void drawCompanyInfo(Object auditFile, Object taxReg, Object address) throws Throwable {
        double y = this.drawParag("companyName", null, null, 90.0, null);
        this.drawField("companyName", this.getProdFields(auditFile, "_H_C_Name"), 110.0, y, 280.0, null, 2079);
        this.drawParag("cif", 390.0, y, 30.0, null);
        String cif = taxReg.toString();
        this.drawField("cif", cif, 420.0, y, 130.0, null, 2079);
        this.deDocInfo.setCif(cif);
        y = this.drawParag("address", null, null, 90.0, new Double(this.defH * 4.0f));
        this.drawParag("street", 110.0, y, 40.0, null);
        this.drawField("street", this.getProdFields(address, "_StreetName"), 150.0, y, 400.0, null, 2079);
        y = this.drawParag("postNo", 110.0, null, 60.0, null);
        this.drawField("postNo", this.getProdFields(address, "_Number"), 170.0, y, 50.0, null, 2079);
        this.drawParag("building", 220.0, y, 60.0, null);
        this.drawField("building", this.getProdFields(address, "_Building"), 280.0, y, 270.0, null, 2079);
        y = this.drawParag("city", 110.0, null, 30.0, null);
        this.drawField("city", this.getProdFields(address, "_City"), 140.0, y, 300.0, null, 2079);
        this.drawParag("postCode", 440.0, y, 60.0, null);
        this.drawField("postCode", this.getProdFields(address, "_PostalCode"), 500.0, y, 50.0, null, 2079);
        y = this.drawParag("region", 110.0, null, 60.0, null);
        this.drawField("region", this.getProdFields(address, "_Region"), 170.0, y, 170.0, null, 2079);
        this.drawParag("country", 340.0, y, 30.0, null);
        this.drawField("country", this.getProdFields(address, "_Country"), 370.0, y, 180.0, null, 2079);
    }

    private void drawSectionBMasterFiles(Info info) throws DocumentException, IOException {
        double y = this.drawField("masterFiles", (Boolean)info._collection.get("MasterFiles") == true ? "X" : "", null, null, 20.0, null, 2095);
        this.drawRectangle(this.defX, this.defH * 2.0f, 40.0f, BLUE);
        this.defY += this.defH * 3.0f;
        this.drawRectangle(40.0f, this.defH * 3.0f, 170.0f, BLUE);
        this.drawParag("masterFiles", 40.0, y, 130.0, null, 128);
        this.drawField("generalLedgerAccounts", (Boolean)info._collection.get("GeneralLedgerAccounts") == true ? "X" : "", 170.0, y, 20.0, null, 2095);
        this.drawParag("generalLedgerAccounts", 190.0, y, 120.0, null);
        this.drawField("customers", (Boolean)info._collection.get("Customers") == true ? "X" : "", 310.0, y, 20.0, null, 2095);
        this.drawParag("customers", 330.0, y, 60.0, null);
        this.drawField("suppliers", (Boolean)info._collection.get("Suppliers") == true ? "X" : "", 390.0, y, 20.0, null, 2095);
        this.drawParag("suppliers", 410.0, y, 60.0, null);
        this.drawField("taxTable", (Boolean)info._collection.get("TaxTable") == true ? "X" : "", 470.0, y, 20.0, null, 2095);
        this.drawParag("taxTable", 490.0, y, 60.0, null);
        y = this.drawField("uomTable", (Boolean)info._collection.get("UOMTable") == true ? "X" : "", 170.0, null, 20.0, null, 2095);
        this.drawParag("uomTable", 190.0, y, 120.0, null);
        this.drawField("analysisTypeTable", (Boolean)info._collection.get("AnalysisTypeTable") == true ? "X" : "", 310.0, y, 20.0, null, 2095);
        this.drawParag("analysisTypeTable", 330.0, y, 70.0, null);
        this.drawField("movementTypeTable", (Boolean)info._collection.get("MovementTypeTable") == true ? "X" : "", 400.0, y, 20.0, null, 2095);
        this.drawParag("movementTypeTable", 420.0, y, 75.0, null);
        this.drawField("products", (Boolean)info._collection.get("Products") == true ? "X" : "", 495.0, y, 20.0, null, 2095);
        this.drawParag("products", 515.0, y, 35.0, null);
        y = this.drawField("physicalStock", (Boolean)info._collection.get("PhysicalStock") == true ? "X" : "", 170.0, null, 20.0, null, 2095);
        this.drawParag("physicalStock", 190.0, y, 110.0, null);
        this.drawField("owners", (Boolean)info._collection.get("Owners") == true ? "X" : "", 300.0, y, 20.0, null, 2095);
        this.drawParag("owners", 320.0, y, 110.0, null);
        this.drawField("assets", (Boolean)info._collection.get("Assets") == true ? "X" : "", 430.0, y, 20.0, null, 2095);
        this.drawParag("assets", 450.0, y, 100.0, null);
    }

    private void drawSectionBGeneralLedgerEntries(Info info) throws DocumentException, IOException {
        double y = this.drawField("generalLedgerEntries", (Boolean)info._collection.get("GeneralLedgerEntries") == true ? "X" : "", null, null, 20.0, null, 2095);
        this.drawParag("generalLedgerEntries", 40.0, y, 130.0, null);
        this.defY += this.defH;
        this.drawRectangle(170.0f, this.defH, 550.0f, BaseColor.LIGHT_GRAY);
    }

    private void drawSectionBSourceDocuments(Info info) throws DocumentException, IOException {
        double y = this.drawField("sourceDocuments", (Boolean)info._collection.get("SourceDocuments") == true ? "X" : "", null, null, 20.0, null, 2095);
        this.drawRectangle(this.defX, this.defH, 40.0f, BLUE);
        this.defY += this.defH * 2.0f;
        this.drawRectangle(40.0f, this.defH * 2.0f, 170.0f, BLUE);
        this.drawParag("sourceDocuments", 40.0, y, 130.0, null, 128);
        this.drawField("salesInvoices", (Boolean)info._collection.get("SalesInvoices") == true ? "X" : "", 170.0, y, 20.0, null, 2095);
        this.drawParag("salesInvoices", 190.0, y, 80.0, null);
        this.drawField("purchaseInvoices", (Boolean)info._collection.get("PurchaseInvoices") == true ? "X" : "", 270.0, y, 20.0, null, 2095);
        this.drawParag("purchaseInvoices", 290.0, y, 80.0, null);
        this.drawField("payments", (Boolean)info._collection.get("Payments") == true ? "X" : "", 370.0, y, 20.0, null, 2095);
        this.drawParag("payments", 390.0, y, 50.0, null);
        this.drawField("movementOfGoods", (Boolean)info._collection.get("MovementOfGoods") == true ? "X" : "", 440.0, y, 20.0, null, 2095);
        this.drawParag("movementOfGoods", 460.0, y, 90.0, null);
        y = this.drawField("assetTransactions", (Boolean)info._collection.get("AssetTransactions") == true ? "X" : "", 170.0, null, 20.0, null, 2095);
        this.drawParag("assetTransactions", 190.0, y, 110.0, null);
        this.defY += this.defH;
        this.drawRectangle(300.0f, this.defH, 550.0f, BaseColor.LIGHT_GRAY);
    }

    private void drawProxyIdentificationData() throws Throwable {
        this.drawParag("sectionCTitle", null, null, 530.0, new Double(this.defH / 2.0f));
        this.drawParag("sectionCDescription1", null, null, 530.0, new Double(this.defH / 2.0f), 384);
        this.drawParag("sectionCDescription2", null, null, 530.0, new Double(this.defH / 2.0f), 384);
        this.defY += this.defH;
        this.drawRectangle(20.0f, this.defH, 550.0f, BLUE);
        double y = this.drawParag("signature", null, null, 50.0, new Double(this.defH * 2.0f));
        this.drawField("signature", "", 70.0, y, 480.0, new Double(this.defH * 2.0f), 2095);
    }

    private void drawSectionDReservedOfficialUse() throws DocumentException, IOException {
        this.drawParag("sectionDTitle", null, null, 530.0, new Double(this.defH / 2.0f));
        double y = this.drawParag("regNo", null, null, 90.0, null);
        this.drawField("regNo", "", 110.0, y, 250.0, null, 2079);
        this.drawParag("date", 360.0, y, 50.0, null);
        this.defFontS = 12.0f;
        this.drawField("day", "", 410.0, y, 30.0, null, 2095);
        this.drawParag("/", 440.0, y, 10.0, null);
        this.drawField("month", "", 450.0, y, 30.0, null, 2095);
        this.drawParag("/", 480.0, y, 10.0, null);
        this.drawField("year", "", 490.0, y, 60.0, null, 2095);
        this.defFontS = 8.0f;
    }

    private void drawSectionEUniqueIdentifier(String controlSum) throws DocumentException, IOException {
        this.drawParag("sectionETitle", null, null, 530.0, new Double(this.defH / 2.0f));
        this.defFontS = 12.0f;
        this.drawField("totalPlata_A", controlSum, null, null, 530.0, null);
        this.deDocInfo.setTotalPlata_A(controlSum);
    }

    public float drawRectangle(float x, float h, float w, BaseColor backgroundColor) throws DocumentException {
        float y = this.defY;
        Rectangle rect = new Rectangle(x, this.defY, w, this.defY - h);
        rect.setBorderWidth(1.0f);
        rect.setBorderColor(BaseColor.BLACK);
        rect.setBackgroundColor(backgroundColor);
        rect.setBorder(15);
        this._document.add((Element)rect);
        this.defY -= h;
        return y;
    }

    private String getProdFields(Object produs, String name) {
        try {
            Field field = produs.getClass().getDeclaredField(name);
            field.setAccessible(true);
            String fld = (String)field.get(produs);
            if (fld == null) {
                return "";
            }
            return fld;
        }
        catch (IllegalAccessException ex) {
            return ex.toString();
        }
        catch (IllegalArgumentException ex) {
            return ex.toString();
        }
        catch (NoSuchFieldException ex) {
            return ex.toString();
        }
        catch (SecurityException ex) {
            return ex.toString();
        }
    }

    public int getZipOption() {
        return -1;
    }

    public static void main(String[] args) {
        Validator vld = new Validator();
        String file = args != null & args.length != 0 && args[0] != null ? args[0] : "C:\\AppData\\NBws\\D406T\\D406TValidator\\test\\Raport SAF-T date valide - stocuri no TaxRegistration.xml";
        int i = vld.parseDocument(file, file + "-msg.txt");
        if (i == 0) {
            System.out.println("Validare fara erori. Cod eroare:" + i);
        } else {
            System.out.println("Validare cu erori. Cod eroare:" + i + ". Verificati erorile in fisierul " + file + "-msg.txt");
        }
        Info info = vld.getInfo();
        Pdf_v0 pdf = new Pdf_v0();
        String rez = pdf.createPdf(info, file + ".pdf", file, null);
        if ("".equals(rez)) {
            System.out.println("Generare pdf fara erori: " + file + ".pdf");
            System.out.println(pdf.getDeDocInfo());
        } else {
            System.out.println("Pdf-ul nu a fost generat. Descriere Eroare:" + rez);
        }
    }

    public DeDocInfo getDeDocInfo() {
        return this.deDocInfo;
    }
}

