/*
 * Decompiled with CFR 0.152.
 */
package d406validator.v0;

import d406validator.v0.Account;
import d406validator.v0.Address;
import d406validator.v0.Analysis;
import d406validator.v0.AnalysisTypeTableEntry;
import d406validator.v0.Asset;
import d406validator.v0.AssetSupplier;
import d406validator.v0.AssetTransaction;
import d406validator.v0.AsstTrnsctnVltn;
import d406validator.v0.AuditFile;
import d406validator.v0.BankAccount;
import d406validator.v0.BaseRate;
import d406validator.v0.BatchRunner;
import d406validator.v0.Contact;
import d406validator.v0.Customer;
import d406validator.v0.ExtrrdnryDprctnForPrd;
import d406validator.v0.Invoice;
import d406validator.v0.InvoiceLine;
import d406validator.v0.Journal;
import d406validator.v0.MovementReference;
import d406validator.v0.MovementTypeTableEntry;
import d406validator.v0.OrderReferences;
import d406validator.v0.OtherCriteria;
import d406validator.v0.OtherTitles;
import d406validator.v0.Owner;
import d406validator.v0.Payment;
import d406validator.v0.PaymentLine;
import d406validator.v0.PhysicalStockEntry;
import d406validator.v0.Product;
import d406validator.v0.StockCharacteristics;
import d406validator.v0.StockMovement;
import d406validator.v0.StockMovementLine;
import d406validator.v0.Supplier;
import d406validator.v0.Tax;
import d406validator.v0.TaxCodeDetails;
import d406validator.v0.TaxInformation;
import d406validator.v0.TaxInformationTotals;
import d406validator.v0.TaxRegistration;
import d406validator.v0.TaxTableEntry;
import d406validator.v0.Taxonomy;
import d406validator.v0.TaxonomyElement;
import d406validator.v0.Transaction;
import d406validator.v0.TransactionLine;
import d406validator.v0.UOMTableEntry;
import d406validator.v0.ValidatorExtension2Impl;
import d406validator.v0.Valuation;
import dec.DECDbAccessRoot;
import dec.LogTrace;
import dec.Params;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.input.ReversedLinesFileReader;

public class DbAccessImpl
extends DECDbAccessRoot {
    protected static ResourceBundle sqlTemplates = null;
    protected static final String TXT_COL_START_TAG = "<ANAF:OBJ>";
    protected static final String TXT_COL_END_TAG = "</ANAF:OBJ>";
    private static final String NEXT_VAL_TEMPLATE = "SELECT 1e14*(mod(to_number(sys_context('userenv','sid')),4)+1)+ TABLE_NAME_SEQ.NEXTVAL ID FROM DUAL CONNECT BY LEVEL < 10000";
    private static final boolean DISABLE_UPDATES = false;
    private static final boolean DISABLE_INSERTS = false;
    private static final String NEW_LINE = "\\u000D\\u000A|[\\u000A\\u000B\\u000C\\u000D\\u0085\\u2028\\u2029]";
    public String _dataInregistrare;
    public String _numarInregistrare;
    public long _decId;
    public long _modId;
    public String _periodStartYear;
    public String _creationDate;
    public String _an_raportare;
    public String _perioada;
    protected Map<String, String> sqlFileMap = new HashMap<String, String>();
    protected Map<String, FileOutputStream> sqlFosMap = new HashMap<String, FileOutputStream>();
    protected Map<String, BufferedOutputStream> sqlBosMap = new HashMap<String, BufferedOutputStream>();
    protected Map<String, Integer> sqlLinesCountMap = new HashMap<String, Integer>();
    protected Connection _connection2;
    protected List<Connection> saftConnections = new ArrayList<Connection>();
    protected long insertCount = 0L;
    private Long TABLE_ID = -1L;
    private Map<String, Queue<Long>> dbIdsCache = new HashMap<String, Queue<Long>>();
    private CallableStatement cstmtEndDeclaratie;
    private CallableStatement cstmtAuditFile;
    private CallableStatement cstmtGetDeclaratieCurenta;
    private CallableStatement cstmtValidariMetadate;
    private CallableStatement cstmtAuditFileCon2;
    private CallableStatement cstmtUpdateAuditFileCon2;
    private CallableStatement cstmtUpdateAuditFileStatusCon2;
    private CallableStatement cstmtDelCon2;

    public String connectDB(Connection connection) {
        String ret = null;
        try {
            ret = super.connectDB(connection);
            this.cstmtEndDeclaratie = this._connection.prepareCall("{? = call d406_loader.end_declaratie(?, ?)}");
            this.cstmtAuditFile = this._connection.prepareCall("{? = call d406_loader.insert_AuditFile(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
            this.cstmtGetDeclaratieCurenta = this._connection.prepareCall("{call d406_loader.get_declaratie_curenta(?, ?, ?)}");
            this.cstmtValidariMetadate = this._connection.prepareCall("{? = call d406_loader.validari_metadate(?, ?, ?, ?, ?)}");
        }
        catch (Throwable ex) {
            return ex.toString();
        }
        return ret;
    }

    public void connectDB2(long id, long sterge) {
        this.openSqlFiles(id);
        LogTrace.log((String)" dupa FCT OPEN SQL FILES IN CONNECT DB", (int)0);
        if (this._connection2 != null) {
            if (sterge != 0L) {
                this.delCon2(id);
            }
            return;
        }
        Object con = null;
        Object mth = null;
        LogTrace.log((String)" INAINTE DE CON2 IN CONNECT DB", (int)0);
        try {
            LogTrace.log((String)" IN try", (int)0);
            this._connection2 = this.getMainSaftConnection();
            LogTrace.log((String)" dupa getsaft CONNECT DB", (int)0);
            if (this._connection2 == null) {
                return;
            }
            LogTrace.log((String)" INAINTE DE cstm IN CONNECT DB", (int)0);
            this.cstmtAuditFileCon2 = this._connection2.prepareCall("{? = call d406_loader.insert_AuditFile(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)}");
            LogTrace.log((String)" dupa cstm insert DB", (int)0);
            this.cstmtUpdateAuditFileCon2 = this._connection2.prepareCall("{? = call d406_loader.update_AuditFile(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?)}");
            LogTrace.log((String)" dupa cstm update DB", (int)0);
            this.cstmtUpdateAuditFileStatusCon2 = this._connection2.prepareCall("{? = call d406_loader.update_AuditFileStatus(?, ?)}");
            LogTrace.log((String)" dupa cstm status DB", (int)0);
            this.cstmtDelCon2 = this._connection2.prepareCall("{? = call d406_loader.delete_all(?, ?)}");
            LogTrace.log((String)" dupa cstm del DB", (int)0);
            if (sterge != 0L) {
                this.delCon2(id);
            }
            LogTrace.log((String)" DUPA CSTM CON2 IN CONNECT DB", (int)0);
        }
        catch (Throwable ex) {
            this.establishResults(ex.toString(), 4, "conectare la BD secundara");
        }
    }

    private Connection getNewSaftConnection(String param) throws Throwable {
        String METHOD_NAME = ((Object)((Object)this)).getClass().getName();
        Connection saftCon = null;
        String text = null;
        String[] parts = null;
        String user = null;
        String pwd = null;
        String[] encPwd = null;
        String driverClass = null;
        String jar = null;
        String prefix = null;
        text = Params.getProperty((String)param);
        if (text == null || text.equals("")) {
            LogTrace.log((String)(METHOD_NAME + " conexiune: " + param + " nedefinita in fisierul de configurare"), (int)2);
            return null;
        }
        try {
            Driver driver;
            parts = text.split(",", 6);
            if (parts.length < 3 || parts.length > 6) {
                LogTrace.log((String)(METHOD_NAME + " Sir conectare la BD (" + param + ") eronat (conexiunea se defineste prin 3, 4, 5 sau 6 componente, separate prin ',') in fisier configurare: '" + text), (int)2);
                return null;
            }
            user = parts[0];
            pwd = parts[1];
            encPwd = DbAccessImpl.getRealPwd(user, pwd);
            if (encPwd[0] == null) {
                LogTrace.log((String)(METHOD_NAME + " eroare decriptare parola pt. conectare la BD: " + param), (int)2);
                return null;
            }
            driverClass = "oracle.jdbc.OracleDriver";
            prefix = "jdbc:oracle:thin:@";
            jar = "./dist/lib/ojdbc6.jar";
            if (parts.length > 3) {
                if (parts[3].trim().length() != 0) {
                    prefix = parts[3].trim();
                }
                if (parts.length > 4 && parts[4].trim().length() != 0) {
                    driverClass = parts[4].trim();
                }
                if (parts.length == 6 && parts[5].trim().length() != 0) {
                    jar = Params.getCanonicalPath((String)parts[5].trim());
                }
            }
            text = parts[2];
            jar = Params.getCanonicalPath((String)jar);
            LogTrace.log((String)"inainte de getDriver", (int)0);
            try {
                driver = this.getDriver(driverClass, jar);
            }
            catch (Throwable ex) {
                LogTrace.log((String)"in exceptie getDriver", (int)2);
                this.establishResults("Exceptie eroare Eroare incarcare driver/conectare la BD ", 4, "Eroare incarcare driver/conectare la BD");
                throw ex;
            }
            if (driver == null) {
                LogTrace.log((String)"driver e null", (int)2);
                this.establishResults("Eroare incarcare driver/conectare la BD ", 4, "Eroare incarcare driver/conectare la BD");
                return null;
            }
            saftCon = DbAccessImpl.getConnection(driver, prefix + text, user, encPwd[0]);
            if (saftCon == null) {
                LogTrace.log((String)(METHOD_NAME + " eroare DriverManager.getConnection pt. conectare la BD: " + param), (int)2);
                this.establishResults("Eroare incarcare driver/conectare la BD, connection=null ", 4, "Eroare incarcare driver/conectare la BD");
                return null;
            }
            saftCon.setAutoCommit(false);
        }
        catch (Throwable ex) {
            LogTrace.logError((int)2, (Throwable)ex);
            LogTrace.log((String)(METHOD_NAME + "!!! Eroare conectare la BD: " + ex.toString()), (int)0);
            LogTrace.log((String)(" Pe catch throwable in getNewSaftConnection: " + ex.toString()), (int)2);
            this.establishResults("Eroare incarcare driver/conectare la BD: " + ex.toString(), 4, "Eroare incarcare driver/conectare la BD");
            throw ex;
        }
        return saftCon;
    }

    private static Connection getConnection(Driver d, String url, String user, String pwd) throws Throwable {
        String METHOD_NAME = Driver.class.getName();
        Connection con = null;
        Properties prop = new Properties();
        try {
            prop.put("user", user);
            prop.put("password", pwd);
            con = d.connect(url, prop);
            return con;
        }
        catch (Throwable ex) {
            LogTrace.log((String)(METHOD_NAME + " eroare conectare la driver BD: " + ex.toString()), (int)2);
            throw ex;
        }
    }

    private static String[] getRealPwd(String user, String pwd) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> con = Class.forName("validator.DECConnection");
        Method mth = con.getMethod("getRealPwd", String.class, String.class);
        return (String[])mth.invoke(null, user, pwd);
    }

    public Driver getDriver(String driverClass, String driverJar) throws Throwable {
        String METHOD_NAME = Driver.class.getName();
        File jarFile = null;
        try {
            jarFile = new File(driverJar);
            if (!jarFile.isFile()) {
                LogTrace.log((String)(METHOD_NAME + " fisier jar driver BD negasit: " + driverJar), (int)2);
                return null;
            }
            URLClassLoader ld = new URLClassLoader(new URL[]{jarFile.toURI().toURL()});
            return (Driver)Class.forName(driverClass, true, ld).newInstance();
        }
        catch (Throwable ex) {
            LogTrace.log((String)(METHOD_NAME + " eroare incarcare jar driver BD: " + ex.toString()), (int)2);
            this.establishResults("Eroare incarcare driver/conectare la BD :" + ex.toString(), 4, "Eroare incarcare driver/conectare la BD");
            LogTrace.log((String)(METHOD_NAME + " eroare incarcare jar driver BD - dupa establishResults"), (int)2);
            throw ex;
        }
    }

    private Connection getMainSaftConnection() throws NoSuchMethodException, IllegalArgumentException, ClassNotFoundException, SecurityException, IllegalAccessException, InvocationTargetException {
        Connection saftCon = null;
        Class<?> con = Class.forName("validator.DECConnection");
        Method mth = con.getMethod("getConnection", String.class);
        saftCon = (Connection)mth.invoke(null, "conFC");
        if (saftCon == null) {
            mth = con.getMethod("getEroareConectare", new Class[0]);
            String err = (String)mth.invoke(null, new Object[0]);
            this.establishResults(err == null || err.trim().length() <= 1 ? "eroare conexiune secundara" : err, 4, "conectare la BD secundara");
            return null;
        }
        return saftCon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String endDeclaratie(int err) {
        int typeErr;
        String str;
        block20: {
            String type = "finalizari declaratie";
            str = null;
            typeErr = 0;
            try {
                if (this._connection2 == null) break block20;
                if (err < 0) {
                    this._connection2.rollback();
                    LogTrace.log((String)"main audit tables rollback", (int)0);
                    break block20;
                }
                try {
                    this._connection2.commit();
                    LogTrace.log((String)"main audit tables commit END DECL", (int)0);
                }
                catch (Throwable ex) {
                    this.updateAuditFileStatusCon2("E");
                    this._connection2.commit();
                    LogTrace.log((String)"main audit tables commit status E - eroare tehnica main audit tables commit", (int)0);
                    throw ex;
                }
                try {
                    this.readSqlFiles();
                    LogTrace.log((String)"in endDeclaratie dupa readSqlFiles", (int)0);
                }
                catch (Throwable ex) {
                    LogTrace.log((String)("updateAuditFileStatusCon2(\"E\"): " + this.updateAuditFileStatusCon2("E")), (int)0);
                    this._connection2.commit();
                    LogTrace.log((String)"final commit status E - eroare tehnica batch inserts", (int)0);
                    throw ex;
                }
                LogTrace.log((String)("updateAuditFileStatusCon2(\"\"): " + this.updateAuditFileStatusCon2("")), (int)0);
                this._connection2.commit();
                LogTrace.log((String)"final commit status F sau D", (int)0);
            }
            catch (Throwable ex) {
                LogTrace.log((String)"in catch pentru terminare agent, typeErr=4", (int)2);
                typeErr = 4;
                err = -3;
                str = "connection2: " + ex.toString();
                try {
                    Class<?> con = Class.forName("validator.DECConnection");
                    Method mth = con.getMethod("terminareAgentLaFinalDeclaratie", new Class[0]);
                    mth.invoke(null, new Object[0]);
                }
                catch (Throwable ex1) {
                    LogTrace.log((String)"Eroare terminare agent, typeErr=4", (int)2);
                }
                str = "eroare endDeclaratie: " + str;
                LogTrace.log((String)str, (int)2);
                this.insertErrorAuto("TErrEndDec2", str);
            }
            finally {
                String folderPath = Params.getProperty((String)"tmpSqlPath") + this._modId;
                if (!DbAccessImpl.deleteDir(new File(folderPath))) {
                    LogTrace.log((String)("WARNING! - stergerea fisierelor SQL pentru declaratia: " + this._decId + " nu s-au putut sterge"), (int)0);
                }
            }
        }
        try {
            this.cstmtEndDeclaratie.registerOutParameter(1, 12);
            this.cstmtEndDeclaratie.registerOutParameter(2, 4);
            this.cstmtEndDeclaratie.setInt(3, err);
            this.cstmtEndDeclaratie.execute();
            try {
                str = this.cstmtEndDeclaratie.getString(1);
                typeErr = this.cstmtEndDeclaratie.getInt(2);
            }
            catch (Throwable ex) {
                typeErr = 4;
                err = -3;
                str = ex.toString();
            }
        }
        catch (Throwable ex) {
            typeErr = 4;
            err = -3;
            str = ex.toString();
        }
        if (typeErr > 1) {
            try {
                Class<?> con = Class.forName("validator.DECConnection");
                Method mth = con.getMethod("terminareAgentLaFinalDeclaratie", new Class[0]);
                mth.invoke(null, new Object[0]);
            }
            catch (Throwable ex1) {
                LogTrace.log((String)"Eroare terminare agent, pt typeErr>1", (int)2);
            }
            str = "eroare endDeclaratie: " + str;
            LogTrace.log((String)str, (int)2);
            this.insertErrorAuto("TErrEndDec", str);
        }
        return str;
    }

    public String insertErrorAuto(String header, String error) {
        try {
            this.cstmtErrorsAuto.registerOutParameter(1, 12);
            this.cstmtErrorsAuto.setString(2, header);
            this.cstmtErrorsAuto.setString(3, error);
            this.cstmtErrorsAuto.execute();
            return this.cstmtErrorsAuto.getString(1);
        }
        catch (Throwable ex) {
            return ex.toString();
        }
    }

    public Map<String, Long> getDeclaratieCurenta() {
        String type = "AuditFile";
        HashMap<String, Long> ret = new HashMap<String, Long>();
        try {
            this.cstmtGetDeclaratieCurenta.registerOutParameter(1, -5);
            this.cstmtGetDeclaratieCurenta.registerOutParameter(2, -5);
            this.cstmtGetDeclaratieCurenta.registerOutParameter(3, -5);
            this.cstmtGetDeclaratieCurenta.execute();
            ret.put("luna", this.cstmtGetDeclaratieCurenta.getLong(1));
            ret.put("an", this.cstmtGetDeclaratieCurenta.getLong(2));
            ret.put("cif", this.cstmtGetDeclaratieCurenta.getLong(3));
            LogTrace.log((String)("getDeclaratieCurenta: luna[" + ret.get("luna") + "]"), (int)0);
            LogTrace.log((String)("getDeclaratieCurenta: an[" + ret.get("an") + "]"), (int)0);
            LogTrace.log((String)("getDeclaratieCurenta: cif[" + ret.get("cif") + "]"), (int)0);
        }
        catch (Throwable ex) {
            LogTrace.log((String)"Eroare getDeclaratieCurenta", (int)0);
            LogTrace.errorText((Throwable)ex);
            this.establishResults(ex.toString(), 4, type);
        }
        return ret;
    }

    public String insertAuditFile(AuditFile objAuditFile) {
        String type = "AuditFile";
        try {
            this.cstmtAuditFile.registerOutParameter(1, 12);
            this.cstmtAuditFile.registerOutParameter(2, -5);
            this.cstmtAuditFile.registerOutParameter(47, 12);
            this.cstmtAuditFile.registerOutParameter(48, 12);
            this.cstmtAuditFile.registerOutParameter(49, -5);
            this.cstmtAuditFile.setString(3, objAuditFile._luna);
            this.cstmtAuditFile.setString(4, objAuditFile._an);
            this.cstmtAuditFile.setString(5, objAuditFile._cif);
            this.cstmtAuditFile.setString(6, objAuditFile._sumaControl);
            this.cstmtAuditFile.setString(7, objAuditFile._H_AuditFileVersion);
            this.cstmtAuditFile.setString(8, objAuditFile._H_AuditFileCountry);
            this.cstmtAuditFile.setString(9, objAuditFile._H_AuditFileRegion);
            this.cstmtAuditFile.setString(10, objAuditFile._H_AuditFileDateCreated);
            this.cstmtAuditFile.setString(11, objAuditFile._H_SoftwareCompanyName);
            this.cstmtAuditFile.setString(12, objAuditFile._H_SoftwareID);
            this.cstmtAuditFile.setString(13, objAuditFile._H_SoftwareVersion);
            this.cstmtAuditFile.setString(14, objAuditFile._H_C_RegistrationNumber);
            this.cstmtAuditFile.setString(15, objAuditFile._H_C_Name);
            this.cstmtAuditFile.setString(16, objAuditFile._H_DefaultCurrencyCode);
            this.cstmtAuditFile.setString(17, objAuditFile._H_SC_TaxRprtngJrsdctn);
            this.cstmtAuditFile.setString(18, objAuditFile._H_SC_CompanyEntity);
            this.cstmtAuditFile.setString(19, objAuditFile._H_SC_SelectionStartDate);
            this.cstmtAuditFile.setString(20, objAuditFile._H_SC_SelectionEndDate);
            this.cstmtAuditFile.setString(21, objAuditFile._H_SC_PeriodStart);
            this.cstmtAuditFile.setString(22, objAuditFile._H_SC_PeriodStartYear);
            this.cstmtAuditFile.setString(23, objAuditFile._H_SC_PeriodEnd);
            this.cstmtAuditFile.setString(24, objAuditFile._H_SC_PeriodEndYear);
            this.cstmtAuditFile.setString(25, objAuditFile._H_SC_DocumentType);
            this.cstmtAuditFile.setString(26, objAuditFile._H_HeaderComment);
            this.cstmtAuditFile.setString(27, objAuditFile._H_SegmentIndex);
            this.cstmtAuditFile.setString(28, objAuditFile._H_TotalSegmentsInsequence);
            this.cstmtAuditFile.setString(29, objAuditFile._H_TaxAccountingBasis);
            this.cstmtAuditFile.setString(30, objAuditFile._H_TaxEntity);
            this.cstmtAuditFile.setString(31, objAuditFile._GLE_NumberOfEntries);
            this.cstmtAuditFile.setString(32, objAuditFile._GLE_TotalDebit);
            this.cstmtAuditFile.setString(33, objAuditFile._GLE_TotalCredit);
            this.cstmtAuditFile.setString(34, objAuditFile._SLI_NumberOfEntries);
            this.cstmtAuditFile.setString(35, objAuditFile._SLI_TotalDebit);
            this.cstmtAuditFile.setString(36, objAuditFile._SLI_TotalCredit);
            this.cstmtAuditFile.setString(37, objAuditFile._PI_NumberOfEntries);
            this.cstmtAuditFile.setString(38, objAuditFile._PI_TotalDebit);
            this.cstmtAuditFile.setString(39, objAuditFile._PI_TotalCredit);
            this.cstmtAuditFile.setString(40, objAuditFile._P_NumberOfEntries);
            this.cstmtAuditFile.setString(41, objAuditFile._P_TotalDebit);
            this.cstmtAuditFile.setString(42, objAuditFile._P_TotalCredit);
            this.cstmtAuditFile.setString(43, objAuditFile._MOG_NumberOfMovementLines);
            this.cstmtAuditFile.setString(44, objAuditFile._MOG_TotalQuantityReceived);
            this.cstmtAuditFile.setString(45, objAuditFile._MOG_TotalQuantityIssued);
            this.cstmtAuditFile.setString(46, objAuditFile._AT_NumberOfAssetTransactions);
            this.cstmtAuditFile.execute();
            this._dataInregistrare = this.cstmtAuditFile.getString(47);
            this._numarInregistrare = this.cstmtAuditFile.getString(48);
            this._modId = this.cstmtAuditFile.getLong(49);
            return this.establishResults(this.cstmtAuditFile, type);
        }
        catch (Throwable ex) {
            return this.establishResults(ex.toString(), 4, type);
        }
    }

    public String validariMetadate(AuditFile objAuditFile) {
        String type = "validari metadate";
        try {
            this.cstmtValidariMetadate.registerOutParameter(1, 12);
            this.cstmtValidariMetadate.registerOutParameter(2, -5);
            this.cstmtValidariMetadate.setString(3, objAuditFile._luna);
            this.cstmtValidariMetadate.setString(4, objAuditFile._an);
            this.cstmtValidariMetadate.setString(5, objAuditFile._cif);
            this.cstmtValidariMetadate.setString(6, objAuditFile._sumaControl);
            this.cstmtValidariMetadate.execute();
            return this.establishResults(this.cstmtValidariMetadate, type);
        }
        catch (Throwable ex) {
            return this.establishResults(ex.toString(), 4, type);
        }
    }

    public String insertAuditFileCon2(AuditFile objAuditFile) {
        String type = "AuditFile Con2";
        try {
            this.cstmtAuditFileCon2.registerOutParameter(1, 12);
            this.cstmtAuditFileCon2.registerOutParameter(2, -5);
            this.cstmtAuditFileCon2.setString(3, objAuditFile._luna);
            this.cstmtAuditFileCon2.setString(4, objAuditFile._an);
            this.cstmtAuditFileCon2.setString(5, objAuditFile._cif);
            this.cstmtAuditFileCon2.setString(6, objAuditFile._sumaControl);
            this.cstmtAuditFileCon2.setString(7, objAuditFile._H_AuditFileVersion);
            this.cstmtAuditFileCon2.setString(8, objAuditFile._H_AuditFileCountry);
            this.cstmtAuditFileCon2.setString(9, objAuditFile._H_AuditFileRegion);
            this.cstmtAuditFileCon2.setString(10, objAuditFile._H_AuditFileDateCreated);
            this.cstmtAuditFileCon2.setString(11, objAuditFile._H_SoftwareCompanyName);
            this.cstmtAuditFileCon2.setString(12, objAuditFile._H_SoftwareID);
            this.cstmtAuditFileCon2.setString(13, objAuditFile._H_SoftwareVersion);
            this.cstmtAuditFileCon2.setString(14, objAuditFile._H_C_RegistrationNumber);
            this.cstmtAuditFileCon2.setString(15, objAuditFile._H_C_Name);
            this.cstmtAuditFileCon2.setString(16, objAuditFile._H_DefaultCurrencyCode);
            this.cstmtAuditFileCon2.setString(17, objAuditFile._H_SC_TaxRprtngJrsdctn);
            this.cstmtAuditFileCon2.setString(18, objAuditFile._H_SC_CompanyEntity);
            this.cstmtAuditFileCon2.setString(19, objAuditFile._H_SC_SelectionStartDate);
            this.cstmtAuditFileCon2.setString(20, objAuditFile._H_SC_SelectionEndDate);
            this.cstmtAuditFileCon2.setString(21, objAuditFile._H_SC_PeriodStart);
            this.cstmtAuditFileCon2.setString(22, objAuditFile._H_SC_PeriodStartYear);
            this.cstmtAuditFileCon2.setString(23, objAuditFile._H_SC_PeriodEnd);
            this.cstmtAuditFileCon2.setString(24, objAuditFile._H_SC_PeriodEndYear);
            this.cstmtAuditFileCon2.setString(25, objAuditFile._H_SC_DocumentType);
            this.cstmtAuditFileCon2.setString(26, objAuditFile._H_HeaderComment);
            this.cstmtAuditFileCon2.setString(27, objAuditFile._H_SegmentIndex);
            this.cstmtAuditFileCon2.setString(28, objAuditFile._H_TotalSegmentsInsequence);
            this.cstmtAuditFileCon2.setString(29, objAuditFile._H_TaxAccountingBasis);
            this.cstmtAuditFileCon2.setString(30, objAuditFile._H_TaxEntity);
            this.cstmtAuditFileCon2.setString(31, objAuditFile._GLE_NumberOfEntries);
            this.cstmtAuditFileCon2.setString(32, objAuditFile._GLE_TotalDebit);
            this.cstmtAuditFileCon2.setString(33, objAuditFile._GLE_TotalCredit);
            this.cstmtAuditFileCon2.setString(34, objAuditFile._SLI_NumberOfEntries);
            this.cstmtAuditFileCon2.setString(35, objAuditFile._SLI_TotalDebit);
            this.cstmtAuditFileCon2.setString(36, objAuditFile._SLI_TotalCredit);
            this.cstmtAuditFileCon2.setString(37, objAuditFile._PI_NumberOfEntries);
            this.cstmtAuditFileCon2.setString(38, objAuditFile._PI_TotalDebit);
            this.cstmtAuditFileCon2.setString(39, objAuditFile._PI_TotalCredit);
            this.cstmtAuditFileCon2.setString(40, objAuditFile._P_NumberOfEntries);
            this.cstmtAuditFileCon2.setString(41, objAuditFile._P_TotalDebit);
            this.cstmtAuditFileCon2.setString(42, objAuditFile._P_TotalCredit);
            this.cstmtAuditFileCon2.setString(43, objAuditFile._MOG_NumberOfMovementLines);
            this.cstmtAuditFileCon2.setString(44, objAuditFile._MOG_TotalQuantityReceived);
            this.cstmtAuditFileCon2.setString(45, objAuditFile._MOG_TotalQuantityIssued);
            this.cstmtAuditFileCon2.setString(46, objAuditFile._AT_NumberOfAssetTransactions);
            this.cstmtAuditFileCon2.setString(47, this._dataInregistrare);
            this.cstmtAuditFileCon2.setString(48, this._numarInregistrare);
            this.cstmtAuditFileCon2.setLong(49, this._modId);
            this.cstmtAuditFileCon2.setString(50, this._periodStartYear);
            this.cstmtAuditFileCon2.setString(51, this._creationDate);
            this.cstmtAuditFileCon2.registerOutParameter(52, -5);
            this.cstmtAuditFileCon2.execute();
            this._decId = this.cstmtAuditFileCon2.getLong(52);
            LogTrace.log((String)"insertAuditFileCon2", (int)0);
            return this.establishResults(this.cstmtAuditFileCon2, type);
        }
        catch (Throwable ex) {
            LogTrace.log((String)("EROARE INSERTAUDITFILE2: " + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
            return this.establishResults(ex.toString(), 4, type);
        }
    }

    public String updateAuditFileCon2(AuditFile objAuditFile, String sectiuni) {
        String type = "update AuditFile Con2";
        try {
            this.cstmtUpdateAuditFileCon2.registerOutParameter(1, 12);
            this.cstmtUpdateAuditFileCon2.registerOutParameter(2, -5);
            this.cstmtUpdateAuditFileCon2.setString(3, objAuditFile._luna);
            this.cstmtUpdateAuditFileCon2.setString(4, objAuditFile._an);
            this.cstmtUpdateAuditFileCon2.setString(5, objAuditFile._cif);
            this.cstmtUpdateAuditFileCon2.setString(6, objAuditFile._sumaControl);
            this.cstmtUpdateAuditFileCon2.setString(7, objAuditFile._H_AuditFileVersion);
            this.cstmtUpdateAuditFileCon2.setString(8, objAuditFile._H_AuditFileCountry);
            this.cstmtUpdateAuditFileCon2.setString(9, objAuditFile._H_AuditFileRegion);
            this.cstmtUpdateAuditFileCon2.setString(10, objAuditFile._H_AuditFileDateCreated);
            this.cstmtUpdateAuditFileCon2.setString(11, objAuditFile._H_SoftwareCompanyName);
            this.cstmtUpdateAuditFileCon2.setString(12, objAuditFile._H_SoftwareID);
            this.cstmtUpdateAuditFileCon2.setString(13, objAuditFile._H_SoftwareVersion);
            this.cstmtUpdateAuditFileCon2.setString(14, objAuditFile._H_C_RegistrationNumber);
            this.cstmtUpdateAuditFileCon2.setString(15, objAuditFile._H_C_Name);
            this.cstmtUpdateAuditFileCon2.setString(16, objAuditFile._H_DefaultCurrencyCode);
            this.cstmtUpdateAuditFileCon2.setString(17, objAuditFile._H_SC_TaxRprtngJrsdctn);
            this.cstmtUpdateAuditFileCon2.setString(18, objAuditFile._H_SC_CompanyEntity);
            this.cstmtUpdateAuditFileCon2.setString(19, objAuditFile._H_SC_SelectionStartDate);
            this.cstmtUpdateAuditFileCon2.setString(20, objAuditFile._H_SC_SelectionEndDate);
            this.cstmtUpdateAuditFileCon2.setString(21, objAuditFile._H_SC_PeriodStart);
            this.cstmtUpdateAuditFileCon2.setString(22, objAuditFile._H_SC_PeriodStartYear);
            this.cstmtUpdateAuditFileCon2.setString(23, objAuditFile._H_SC_PeriodEnd);
            this.cstmtUpdateAuditFileCon2.setString(24, objAuditFile._H_SC_PeriodEndYear);
            this.cstmtUpdateAuditFileCon2.setString(25, objAuditFile._H_SC_DocumentType);
            this.cstmtUpdateAuditFileCon2.setString(26, objAuditFile._H_HeaderComment);
            this.cstmtUpdateAuditFileCon2.setString(27, objAuditFile._H_SegmentIndex);
            this.cstmtUpdateAuditFileCon2.setString(28, objAuditFile._H_TotalSegmentsInsequence);
            this.cstmtUpdateAuditFileCon2.setString(29, objAuditFile._H_TaxAccountingBasis);
            this.cstmtUpdateAuditFileCon2.setString(30, objAuditFile._H_TaxEntity);
            this.cstmtUpdateAuditFileCon2.setString(31, objAuditFile._GLE_NumberOfEntries);
            this.cstmtUpdateAuditFileCon2.setString(32, objAuditFile._GLE_TotalDebit);
            this.cstmtUpdateAuditFileCon2.setString(33, objAuditFile._GLE_TotalCredit);
            this.cstmtUpdateAuditFileCon2.setString(34, objAuditFile._SLI_NumberOfEntries);
            this.cstmtUpdateAuditFileCon2.setString(35, objAuditFile._SLI_TotalDebit);
            this.cstmtUpdateAuditFileCon2.setString(36, objAuditFile._SLI_TotalCredit);
            this.cstmtUpdateAuditFileCon2.setString(37, objAuditFile._PI_NumberOfEntries);
            this.cstmtUpdateAuditFileCon2.setString(38, objAuditFile._PI_TotalDebit);
            this.cstmtUpdateAuditFileCon2.setString(39, objAuditFile._PI_TotalCredit);
            this.cstmtUpdateAuditFileCon2.setString(40, objAuditFile._P_NumberOfEntries);
            this.cstmtUpdateAuditFileCon2.setString(41, objAuditFile._P_TotalDebit);
            this.cstmtUpdateAuditFileCon2.setString(42, objAuditFile._P_TotalCredit);
            this.cstmtUpdateAuditFileCon2.setString(43, objAuditFile._MOG_NumberOfMovementLines);
            this.cstmtUpdateAuditFileCon2.setString(44, objAuditFile._MOG_TotalQuantityReceived);
            this.cstmtUpdateAuditFileCon2.setString(45, objAuditFile._MOG_TotalQuantityIssued);
            this.cstmtUpdateAuditFileCon2.setString(46, objAuditFile._AT_NumberOfAssetTransactions);
            this.cstmtUpdateAuditFileCon2.setString(47, sectiuni);
            this.cstmtUpdateAuditFileCon2.setString(48, this._periodStartYear);
            this.cstmtUpdateAuditFileCon2.setString(49, this._creationDate);
            this.cstmtUpdateAuditFileCon2.execute();
            LogTrace.log((String)"updateAuditFileCon2", (int)0);
            return this.establishResults(this.cstmtUpdateAuditFileCon2, type);
        }
        catch (Throwable ex) {
            return this.establishResults(ex.toString(), 4, type);
        }
    }

    public String updateAuditFileStatusCon2(String status) throws Throwable {
        String type = "update AuditFileStatus Con2";
        this.cstmtUpdateAuditFileStatusCon2.registerOutParameter(1, 12);
        this.cstmtUpdateAuditFileStatusCon2.registerOutParameter(2, -5);
        this.cstmtUpdateAuditFileStatusCon2.setString(3, status);
        this.cstmtUpdateAuditFileStatusCon2.execute();
        String msg = this.cstmtUpdateAuditFileStatusCon2.getString(1);
        Long code = this.cstmtUpdateAuditFileStatusCon2.getLong(2);
        String ret = code.toString() + " - " + msg;
        return ret;
    }

    public void insertAddressCon2(Address objAddress, String xmlContext) {
        String tableName = "D406_ADDRESS";
        objAddress.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objAddress._StreetName);
        paramList.add(objAddress._Number);
        paramList.add(objAddress._AddtnlAddrssDtl);
        paramList.add(objAddress._Building);
        paramList.add(objAddress._City);
        paramList.add(objAddress._PostalCode);
        paramList.add(objAddress._Region);
        paramList.add(objAddress._Country);
        paramList.add(objAddress._AddressType);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objAddress.id, paramList, tableName);
        String sql = null;
        if (xmlContext.equals("0_1_9_12")) {
            sql = this._decId + "," + this._modId + "," + objAddress.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_ADDRESS_COMPANY_LNK", sql);
        } else if (xmlContext.equals("0_64_85_86_87_12")) {
            sql = this._decId + "," + this._modId + "," + objAddress.id + "," + objAddress._validator._Customer.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_ADDRESS_CUST_LNK", sql);
        } else if (xmlContext.equals("0_64_90_91_87_12")) {
            sql = this._decId + "," + this._modId + "," + objAddress.id + "," + objAddress._validator._Supplier.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_ADDRESS_SUPPLIER_LNK", sql);
        } else if (xmlContext.equals("0_64_149_150_87_12")) {
            sql = this._decId + "," + this._modId + "," + objAddress.id + "," + objAddress._validator._Owner.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_ADDRESS_OWNER_LNK", sql);
        } else {
            LogTrace.log((String)("Context XML eronat ('" + xmlContext + "') la insertia intr-o tabela de legatura a tabelei D406_ADDRESS, in functia insert_Address()"), (int)0);
        }
    }

    public void insertContactCon2(Contact objContact) {
        objContact.id = this.getId("D406_CONTACT");
    }

    public void updateContactCon2(Contact objContact, String xmlContext) {
        String tableName = "D406_CONTACT";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objContact._CP_Title);
        paramList.add(objContact._CP_FirstName);
        paramList.add(objContact._CP_Initials);
        paramList.add(objContact._CP_LastNamePrefix);
        paramList.add(objContact._CP_LastName);
        paramList.add(objContact._CP_BirthName);
        paramList.add(objContact._CP_Salutation);
        paramList.add(objContact._Telephone);
        paramList.add(objContact._Fax);
        paramList.add(objContact._Email);
        paramList.add(objContact._Website);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objContact.id, paramList, tableName);
        String sql = null;
        if (xmlContext.equals("0_1_9_22")) {
            sql = this._decId + "," + this._modId + "," + objContact.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_CONTACT_COMPANY_LNK", sql);
        } else if (xmlContext.equals("0_64_85_86_87_22")) {
            sql = this._decId + "," + this._modId + "," + objContact.id + ", " + objContact._validator._Customer.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_CONTACT_CUST_LNK", sql);
        } else if (xmlContext.equals("0_64_90_91_87_22")) {
            sql = this._decId + "," + this._modId + "," + objContact.id + ", " + objContact._validator._Supplier.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_CONTACT_SUPPLIER_LNK", sql);
        } else if (xmlContext.equals("0_64_149_150_87_22")) {
            sql = this._decId + "," + this._modId + "," + objContact.id + ", " + objContact._validator._Owner.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_CONTACT_OWNER_LNK", sql);
        } else {
            LogTrace.log((String)("Context XML eronat ('" + xmlContext + "') la insertia intr-o tabela de legatura a tabelei D406_CONTACT, in functia insert_Contact()"), (int)0);
        }
    }

    public void insertOtherTitlesCon2(OtherTitles objOtherTitles) {
        String tableName = "D406_OTHER_TITLES";
        objOtherTitles.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objOtherTitles._validator._Contact.id);
        paramList.add(objOtherTitles._OtherTitles);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objOtherTitles.id, paramList, tableName);
    }

    public void insertTaxRegistrationCon2(TaxRegistration objTaxRegistration, String xmlContext) {
        String tableName = "D406_TAX_REGISTRATION";
        objTaxRegistration.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objTaxRegistration._TaxRegistrationNumber);
        paramList.add(objTaxRegistration._TaxType);
        paramList.add(objTaxRegistration._TaxNumber);
        paramList.add(objTaxRegistration._TaxAuthority);
        paramList.add(objTaxRegistration._TaxVerificationDate);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objTaxRegistration.id, paramList, tableName);
        String sql = null;
        if (xmlContext.equals("0_1_9_36")) {
            sql = this._decId + "," + this._modId + "," + objTaxRegistration.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_REG_COMP_LNK", sql);
        } else if (xmlContext.equals("0_64_85_86_87_36")) {
            sql = this._decId + "," + this._modId + "," + objTaxRegistration.id + ", " + objTaxRegistration._validator._Customer.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_REG_CUST_LNK", sql);
        } else if (xmlContext.equals("0_64_90_91_87_36")) {
            sql = this._decId + "," + this._modId + "," + objTaxRegistration.id + ", " + objTaxRegistration._validator._Supplier.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_REG_SUP_LNK", sql);
        } else if (xmlContext.equals("0_64_149_150_87_36")) {
            sql = this._decId + "," + this._modId + "," + objTaxRegistration.id + ", " + objTaxRegistration._validator._Owner.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_REG_OWNER_LNK", sql);
        } else {
            LogTrace.log((String)("Context XML eronat ('" + xmlContext + "') la insertia intr-o tabela de legatura a tabelei D406_TAX_REGISTRATION, in functia insert_TaxRegistration()"), (int)0);
        }
    }

    public void insertBankAccountCon2(BankAccount objBankAccount, String xmlContext) {
        String tableName = "D406_BANK_ACCOUNT";
        objBankAccount.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objBankAccount._IBANNumber);
        paramList.add(objBankAccount._BankAccountNumber);
        paramList.add(objBankAccount._BankAccountName);
        paramList.add(objBankAccount._SortCode);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objBankAccount.id, paramList, tableName);
        String sql = null;
        if (xmlContext.equals("0_1_9_42")) {
            sql = this._decId + "," + this._modId + "," + objBankAccount.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_BANK_ACNT_COMP_LNK", sql);
        } else if (xmlContext.equals("0_64_85_86_87_42")) {
            sql = this._decId + "," + this._modId + "," + objBankAccount.id + ", " + objBankAccount._validator._Customer.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_BANK_ACNT_CUST_LNK", sql);
        } else if (xmlContext.equals("0_64_90_91_87_42")) {
            sql = this._decId + "," + this._modId + "," + objBankAccount.id + ", " + objBankAccount._validator._Supplier.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_BANK_ACNT_SUP_LNK", sql);
        } else if (xmlContext.equals("0_64_149_150_87_42")) {
            sql = this._decId + "," + this._modId + "," + objBankAccount.id + ", " + objBankAccount._validator._Owner.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_BANK_ACNT_OWNER_LNK", sql);
        } else {
            LogTrace.log((String)("Context XML eronat ('" + xmlContext + "') la insertia intr-o tabela de legatura a tabelei D406_BANK_ACCOUNT, in functia insert_BankAccount()"), (int)0);
        }
    }

    public void insertOtherCriteriaCon2(OtherCriteria objOtherCriteria) {
        String tableName = "D406_OTHER_CRITERIA";
        objOtherCriteria.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objOtherCriteria._OtherCriteria);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objOtherCriteria.id, paramList, tableName);
    }

    public void insertAccountCon2(Account objAccount) {
        String tableName = "D406_ACCOUNT";
        objAccount.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objAccount._AccountID);
        paramList.add(objAccount._AccountDescription);
        paramList.add(objAccount._StandardAccountID);
        paramList.add(objAccount._GroupingCategory);
        paramList.add(objAccount._GroupingCode);
        paramList.add(objAccount._AccountType);
        paramList.add(objAccount._AccountCreationDate);
        paramList.add(objAccount._OpeningDebitBalance);
        paramList.add(objAccount._OpeningCreditBalance);
        paramList.add(objAccount._ClosingDebitBalance);
        paramList.add(objAccount._ClosingCreditBalance);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objAccount.id, paramList, tableName);
    }

    public void insertTaxonomyCon2(Taxonomy objTaxonomy) {
        String tableName = "D406_TAXONOMY";
        objTaxonomy.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objTaxonomy._TaxonomyReference);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objTaxonomy.id, paramList, tableName);
    }

    public void insertTaxonomyElementCon2(TaxonomyElement objTaxonomyElement) {
        String tableName = "D406_TAXONOMY_ELEMENT";
        objTaxonomyElement.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objTaxonomyElement._validator._Taxonomy.id);
        paramList.add(objTaxonomyElement._TaxonomyCode);
        paramList.add(objTaxonomyElement._TaxonomyClusterID);
        paramList.add(objTaxonomyElement._TaxonomyClusterContextID);
        paramList.add(objTaxonomyElement._AccountID);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objTaxonomyElement.id, paramList, tableName);
    }

    public void insertCustomerCon2(Customer objCustomer) {
        objCustomer.id = this.getId("D406_CUSTOMER");
    }

    public void updateCustomerCon2(Customer objCustomer) {
        String tableName = "D406_CUSTOMER";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objCustomer._CS_RegistrationNumber);
        paramList.add(objCustomer._CS_Name);
        paramList.add(objCustomer._CustomerID);
        paramList.add(objCustomer._SelfBillingIndicator);
        paramList.add(objCustomer._AccountID);
        paramList.add(objCustomer._OpeningDebitBalance);
        paramList.add(objCustomer._OpeningCreditBalance);
        paramList.add(objCustomer._ClosingDebitBalance);
        paramList.add(objCustomer._ClosingCreditBalance);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objCustomer.id, paramList, tableName);
    }

    public void insertSupplierCon2(Supplier objSupplier) {
        objSupplier.id = this.getId("D406_SUPPLIER");
    }

    public void updateSupplierCon2(Supplier objSupplier) {
        String tableName = "D406_SUPPLIER";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objSupplier._CS_RegistrationNumber);
        paramList.add(objSupplier._CS_Name);
        paramList.add(objSupplier._SupplierID);
        paramList.add(objSupplier._SelfBillingIndicator);
        paramList.add(objSupplier._AccountID);
        paramList.add(objSupplier._OpeningDebitBalance);
        paramList.add(objSupplier._OpeningCreditBalance);
        paramList.add(objSupplier._ClosingDebitBalance);
        paramList.add(objSupplier._ClosingCreditBalance);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objSupplier.id, paramList, tableName);
    }

    public void insertTaxTableEntryCon2(TaxTableEntry objTaxTableEntry) {
        String tableName = "D406_TAX_TABLE_ENTRY";
        objTaxTableEntry.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objTaxTableEntry._TaxType);
        paramList.add(objTaxTableEntry._Description);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objTaxTableEntry.id, paramList, tableName);
    }

    public void insertTaxCodeDetailsCon2(TaxCodeDetails objTaxCodeDetails) {
        objTaxCodeDetails.id = this.getId("D406_TAX_CODE_DETAILS");
    }

    public void updateTaxCodeDetailsCon2(TaxCodeDetails objTaxCodeDetails) {
        String tableName = "D406_TAX_CODE_DETAILS";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objTaxCodeDetails._validator._TaxTableEntry.id);
        paramList.add(objTaxCodeDetails._TaxCode);
        paramList.add(objTaxCodeDetails._EffectiveDate);
        paramList.add(objTaxCodeDetails._ExpirationDate);
        paramList.add(objTaxCodeDetails._Description);
        paramList.add(objTaxCodeDetails._TaxPercentage);
        paramList.add(objTaxCodeDetails._FTR_Amount);
        paramList.add(objTaxCodeDetails._FTR_CurrencyCode);
        paramList.add(objTaxCodeDetails._FTR_CurrencyAmount);
        paramList.add(objTaxCodeDetails._FTR_ExchangeRate);
        paramList.add(objTaxCodeDetails._Country);
        paramList.add(objTaxCodeDetails._Region);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objTaxCodeDetails.id, paramList, tableName);
    }

    public void insertBaseRateCon2(BaseRate objBaseRate) {
        String tableName = "D406_BASE_RATE";
        objBaseRate.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objBaseRate._validator._TaxCodeDetails.id);
        paramList.add(objBaseRate._validator._TaxTableEntry.id);
        paramList.add(objBaseRate._BaseRate);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objBaseRate.id, paramList, tableName);
    }

    public void insertUOMTableEntryCon2(UOMTableEntry objUOMTableEntry) {
        String tableName = "D406_UOM_TABLE_ENTRY";
        objUOMTableEntry.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objUOMTableEntry._UnitOfMeasure);
        paramList.add(objUOMTableEntry._Description);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objUOMTableEntry.id, paramList, tableName);
    }

    public void insertAnalysisTypeTableEntryCon2(AnalysisTypeTableEntry objAnalysisTypeTableEntry) {
        String tableName = "D406_ANLS_TYPE_TBL_ENTRY";
        objAnalysisTypeTableEntry.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objAnalysisTypeTableEntry._AnalysisType);
        paramList.add(objAnalysisTypeTableEntry._AnalysisTypeDescription);
        paramList.add(objAnalysisTypeTableEntry._AnalysisID);
        paramList.add(objAnalysisTypeTableEntry._AnalysisIDDescription);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objAnalysisTypeTableEntry.id, paramList, tableName);
    }

    public void insertMovementTypeTableEntryCon2(MovementTypeTableEntry objMovementTypeTableEntry) {
        String tableName = "D406_MVMT_TYPE_TBL_ENTRY";
        objMovementTypeTableEntry.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objMovementTypeTableEntry._MovementType);
        paramList.add(objMovementTypeTableEntry._Description);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objMovementTypeTableEntry.id, paramList, tableName);
    }

    public void insertProductCon2(Product objProduct) {
        String tableName = "D406_PRODUCT";
        objProduct.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objProduct._ProductCode);
        paramList.add(objProduct._GoodsServicesID);
        paramList.add(objProduct._ProductGroup);
        paramList.add(objProduct._Description);
        paramList.add(objProduct._ProductCommodityCode);
        paramList.add(objProduct._ProductNumberCode);
        paramList.add(objProduct._ValuationMethod);
        paramList.add(objProduct._UOMBase);
        paramList.add(objProduct._UOMStandard);
        paramList.add(objProduct._UOMToUOMBaseCnvrsnFctr);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objProduct.id, paramList, tableName);
    }

    public void insertTaxCon2(Tax objTax) {
        String tableName = "D406_TAX";
        objTax.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objTax._validator._Product.id);
        paramList.add(objTax._TaxType);
        paramList.add(objTax._TaxCode);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objTax.id, paramList, tableName);
    }

    public void insertPhysicalStockEntryCon2(PhysicalStockEntry objPhysicalStockEntry) {
        String tableName = "D406_PHYSICAL_STCK_ENTRY";
        objPhysicalStockEntry.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objPhysicalStockEntry._WarehouseID);
        paramList.add(objPhysicalStockEntry._LocationID);
        paramList.add(objPhysicalStockEntry._ProductCode);
        paramList.add(objPhysicalStockEntry._StockAccountNo);
        paramList.add(objPhysicalStockEntry._ProductType);
        paramList.add(objPhysicalStockEntry._ProductStatus);
        paramList.add(objPhysicalStockEntry._StockAccountCommodityCode);
        paramList.add(objPhysicalStockEntry._OwnerID);
        paramList.add(objPhysicalStockEntry._UOMPhysicalStock);
        paramList.add(objPhysicalStockEntry._UOMToUOMBaseCnvrsnFctr);
        paramList.add(objPhysicalStockEntry._UnitPrice);
        paramList.add(objPhysicalStockEntry._OpeningStockQuantity);
        paramList.add(objPhysicalStockEntry._OpeningStockValue);
        paramList.add(objPhysicalStockEntry._ClosingStockQuantity);
        paramList.add(objPhysicalStockEntry._ClosingStockValue);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objPhysicalStockEntry.id, paramList, tableName);
    }

    public void insertStockCharacteristicsCon2(StockCharacteristics objStockCharacteristics) {
        String tableName = "D406_STOCK_CHARACTERISTICS";
        objStockCharacteristics.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objStockCharacteristics._validator._PhysicalStockEntry.id);
        paramList.add(objStockCharacteristics._StockCharacteristic);
        paramList.add(objStockCharacteristics._StockCharacteristicValue);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objStockCharacteristics.id, paramList, tableName);
    }

    public void insertOwnerCon2(Owner objOwner) {
        objOwner.id = this.getId("D406_OWNER");
    }

    public void updateOwnerCon2(Owner objOwner) {
        String tableName = "D406_OWNER";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objOwner._CS_RegistrationNumber);
        paramList.add(objOwner._CS_Name);
        paramList.add(objOwner._OwnerID);
        paramList.add(objOwner._AccountID);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objOwner.id, paramList, tableName);
    }

    public void insertAssetCon2(Asset objAsset) {
        objAsset.id = this.getId("D406_ASSET");
    }

    public void updateAssetCon2(Asset objAsset) {
        String tableName = "D406_ASSET";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objAsset._AssetID);
        paramList.add(objAsset._AccountID);
        paramList.add(objAsset._Description);
        paramList.add(objAsset._PurchaseOrderDate);
        paramList.add(objAsset._DateOfAcquisition);
        paramList.add(objAsset._StartUpDate);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objAsset.id, paramList, tableName);
    }

    public void insertAssetSupplierCon2(AssetSupplier objAssetSupplier) {
        String tableName = "D406_ASSET_SUPPLIER";
        objAssetSupplier.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objAssetSupplier._validator._Asset.id);
        paramList.add(objAssetSupplier._SupplierName);
        paramList.add(objAssetSupplier._SupplierID);
        paramList.add(objAssetSupplier._PA_StreetName);
        paramList.add(objAssetSupplier._PA_Number);
        paramList.add(objAssetSupplier._PA_AddtnlAddrssDtl);
        paramList.add(objAssetSupplier._PA_Building);
        paramList.add(objAssetSupplier._PA_City);
        paramList.add(objAssetSupplier._PA_PostalCode);
        paramList.add(objAssetSupplier._PA_Region);
        paramList.add(objAssetSupplier._PA_Country);
        paramList.add(objAssetSupplier._PA_AddressType);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objAssetSupplier.id, paramList, tableName);
    }

    public void insertValuationCon2(Valuation objValuation) {
        objValuation.id = this.getId("D406_VALUATION");
    }

    public void updateValuationCon2(Valuation objValuation) {
        String tableName = "D406_VALUATION";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objValuation._validator._Asset.id);
        paramList.add(objValuation._AssetValuationType);
        paramList.add(objValuation._ValuationClass);
        paramList.add(objValuation._AcqstnAndPrdctnCstsBgn);
        paramList.add(objValuation._AcqstnAndPrdctnCstsEnd);
        paramList.add(objValuation._InvestmentSupport);
        paramList.add(objValuation._AssetLifeYear);
        paramList.add(objValuation._AssetLifeMonth);
        paramList.add(objValuation._AssetAddition);
        paramList.add(objValuation._Transfers);
        paramList.add(objValuation._AssetDisposal);
        paramList.add(objValuation._BookValueBegin);
        paramList.add(objValuation._DepreciationMethod);
        paramList.add(objValuation._DepreciationPercentage);
        paramList.add(objValuation._DepreciationForPeriod);
        paramList.add(objValuation._AppreciationForPeriod);
        paramList.add(objValuation._AccumulatedDepreciation);
        paramList.add(objValuation._BookValueEnd);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objValuation.id, paramList, tableName);
    }

    public void insertExtrrdnryDprctnForPrdCon2(ExtrrdnryDprctnForPrd objExtrrdnryDprctnForPrd) {
        String tableName = "D406_EXTRNRY_DPRTN_FOR_PR";
        objExtrrdnryDprctnForPrd.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objExtrrdnryDprctnForPrd._validator._Valuation.id);
        paramList.add(objExtrrdnryDprctnForPrd._validator._Asset.id);
        paramList.add(objExtrrdnryDprctnForPrd._ExtrrdnryDprctnMthd);
        paramList.add(objExtrrdnryDprctnForPrd._ExtrrdnryDprctnAmntForPrd);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objExtrrdnryDprctnForPrd.id, paramList, tableName);
    }

    public void insertJournalCon2(Journal objJournal) {
        String tableName = "D406_JOURNAL";
        objJournal.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objJournal._JournalID);
        paramList.add(objJournal._Description);
        paramList.add(objJournal._Type);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objJournal.id, paramList, tableName);
    }

    public void insertTransactionCon2(Transaction objTransaction) {
        objTransaction.id = this.getId("D406_TRANSACTION");
    }

    public void updateTransactionCon2(Transaction objTransaction) {
        String tableName = "D406_TRANSACTION";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objTransaction._validator._Journal.id);
        paramList.add(objTransaction._TransactionID);
        paramList.add(objTransaction._Period);
        paramList.add(objTransaction._PeriodYear);
        paramList.add(objTransaction._TransactionDate);
        paramList.add(objTransaction._SourceID);
        paramList.add(objTransaction._TransactionType);
        paramList.add(objTransaction._Description);
        paramList.add(objTransaction._BatchID);
        paramList.add(objTransaction._SystemEntryDate);
        paramList.add(objTransaction._GLPostingDate);
        paramList.add(objTransaction._CustomerID);
        paramList.add(objTransaction._SupplierID);
        paramList.add(objTransaction._SystemID);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objTransaction.id, paramList, tableName);
    }

    public void insertTransactionLineCon2(TransactionLine objTransactionLine) {
        objTransactionLine.id = this.getId("D406_TRANSACTION_LINE");
    }

    public void updateTransactionLineCon2(TransactionLine objTransactionLine) {
        String tableName = "D406_TRANSACTION_LINE";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objTransactionLine._validator._Transaction.id);
        paramList.add(objTransactionLine._validator._Journal.id);
        paramList.add(objTransactionLine._RecordID);
        paramList.add(objTransactionLine._AccountID);
        paramList.add(objTransactionLine._ValueDate);
        paramList.add(objTransactionLine._SourceDocumentID);
        paramList.add(objTransactionLine._CustomerID);
        paramList.add(objTransactionLine._SupplierID);
        paramList.add(objTransactionLine._Description);
        paramList.add(objTransactionLine._DA_Amount);
        paramList.add(objTransactionLine._DA_CurrencyCode);
        paramList.add(objTransactionLine._DA_CurrencyAmount);
        paramList.add(objTransactionLine._DA_ExchangeRate);
        paramList.add(objTransactionLine._CA_Amount);
        paramList.add(objTransactionLine._CA_CurrencyCode);
        paramList.add(objTransactionLine._CA_CurrencyAmount);
        paramList.add(objTransactionLine._CA_ExchangeRate);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objTransactionLine.id, paramList, tableName);
    }

    public void insertAnalysisCon2(Analysis objAnalysis, String xmlContext) {
        String tableName = "D406_ANALYSIS";
        objAnalysis.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objAnalysis._AnalysisType);
        paramList.add(objAnalysis._AnalysisID);
        paramList.add(objAnalysis._AA_Amount);
        paramList.add(objAnalysis._AA_CurrencyCode);
        paramList.add(objAnalysis._AA_CurrencyAmount);
        paramList.add(objAnalysis._AA_ExchangeRate);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objAnalysis.id, paramList, tableName);
        String sql = null;
        if (xmlContext.equals("0_183_187_190_201_203")) {
            sql = this._decId + "," + this._modId + "," + objAnalysis.id + "," + objAnalysis._validator._TransactionLine.id + "," + objAnalysis._validator._Transaction.id + ", " + objAnalysis._validator._Journal.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_ANALYSIS_TR_LN_LNK", sql);
        } else if (xmlContext.equals("0_215_216_217_232_203")) {
            sql = this._decId + "," + this._modId + "," + objAnalysis.id + "," + objAnalysis._validator._InvoiceLine.id + ", " + objAnalysis._validator._Invoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_ANALYSIS_SINV_LNK", sql);
        } else if (xmlContext.equals("0_215_263_217_232_203")) {
            sql = this._decId + "," + this._modId + "," + objAnalysis.id + "," + objAnalysis._validator._InvoiceLine.id + ", " + objAnalysis._validator._Invoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_ANALYSIS_PINV_LNK", sql);
        } else if (xmlContext.equals("0_215_264_265_268_203")) {
            sql = this._decId + "," + this._modId + "," + objAnalysis.id + "," + objAnalysis._validator._PaymentLine.id + ", " + objAnalysis._validator._Payment.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_ANALYSIS_PAY_LNK", sql);
        } else {
            LogTrace.log((String)("Context XML eronat ('" + xmlContext + "') la insertia intr-o tabela de legatura a tabelei D406_ANALYSIS, in functia insert_Analysis()"), (int)0);
        }
    }

    public void insertTaxInformationCon2(TaxInformation objTaxInformation, String xmlContext) {
        String tableName = "D406_TAX_INFORMATION";
        objTaxInformation.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objTaxInformation._TaxType);
        paramList.add(objTaxInformation._TaxCode);
        paramList.add(objTaxInformation._TaxPercentage);
        paramList.add(objTaxInformation._TaxBase);
        paramList.add(objTaxInformation._TaxBaseDescription);
        paramList.add(objTaxInformation._TA_Amount);
        paramList.add(objTaxInformation._TA_CurrencyCode);
        paramList.add(objTaxInformation._TA_CurrencyAmount);
        paramList.add(objTaxInformation._TA_ExchangeRate);
        paramList.add(objTaxInformation._TaxExemptionReason);
        paramList.add(objTaxInformation._TaxDeclarationPeriod);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objTaxInformation.id, paramList, tableName);
        String sql = null;
        if (xmlContext.equals("0_183_187_190_201_209")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformation.id + "," + objTaxInformation._validator._TransactionLine.id + "," + objTaxInformation._validator._Transaction.id + ", " + objTaxInformation._validator._Journal.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_TR_LN_LNK", sql);
        } else if (xmlContext.equals("0_215_216_217_232_209")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformation.id + "," + objTaxInformation._validator._InvoiceLine.id + ", " + objTaxInformation._validator._Invoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_SINV1_LNK", sql);
        } else if (xmlContext.equals("0_215_216_217_258_259")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformation.id + ", " + objTaxInformation._validator._Invoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_SINV2_LNK", sql);
        } else if (xmlContext.equals("0_215_263_217_232_209")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformation.id + "," + objTaxInformation._validator._InvoiceLine.id + ", " + objTaxInformation._validator._Invoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_PINV1_LNK", sql);
        } else if (xmlContext.equals("0_215_263_217_258_259")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformation.id + ", " + objTaxInformation._validator._Invoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_PINV2_LNK", sql);
        } else if (xmlContext.equals("0_215_264_265_268_209")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformation.id + "," + objTaxInformation._validator._PaymentLine.id + ", " + objTaxInformation._validator._Payment.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_PAY1_LNK", sql);
        } else if (xmlContext.equals("0_215_264_265_271_259")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformation.id + ", " + objTaxInformation._validator._Payment.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_PAY2_LNK", sql);
        } else if (xmlContext.equals("0_215_272_276_283_209")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformation.id + "," + objTaxInformation._validator._StockMovementLine.id + ", " + objTaxInformation._validator._StockMovement.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_ST_MV_LNK", sql);
        } else {
            LogTrace.log((String)("Context XML eronat ('" + xmlContext + "') la insertia intr-o tabela de legatura a tabelei D406_TAX_INFORMATION, in functia insert_TaxInformation()"), (int)0);
        }
    }

    public void insertInvoiceCon2(Invoice objInvoice) {
        objInvoice.id = this.getId("D406_INVOICE");
    }

    public void updateInvoiceCon2(Invoice objInvoice, String xmlContext) {
        String tableName = "D406_INVOICE";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objInvoice._InvoiceNo);
        paramList.add(objInvoice._CI_CustomerID);
        paramList.add(objInvoice._CI_Name);
        paramList.add(objInvoice._CI_BA_StreetName);
        paramList.add(objInvoice._CI_BA_Number);
        paramList.add(objInvoice._CI_BA_AddtnlAddrssDtl);
        paramList.add(objInvoice._CI_BA_Building);
        paramList.add(objInvoice._CI_BA_City);
        paramList.add(objInvoice._CI_BA_PostalCode);
        paramList.add(objInvoice._CI_BA_Region);
        paramList.add(objInvoice._CI_BA_Country);
        paramList.add(objInvoice._CI_BA_AddressType);
        paramList.add(objInvoice._SPI_SupplierID);
        paramList.add(objInvoice._SPI_Name);
        paramList.add(objInvoice._SPI_BA_StreetName);
        paramList.add(objInvoice._SPI_BA_Number);
        paramList.add(objInvoice._SPI_BA_AddtnlAddrssDtl);
        paramList.add(objInvoice._SPI_BA_Building);
        paramList.add(objInvoice._SPI_BA_City);
        paramList.add(objInvoice._SPI_BA_PostalCode);
        paramList.add(objInvoice._SPI_BA_Region);
        paramList.add(objInvoice._SPI_BA_Country);
        paramList.add(objInvoice._SPI_BA_AddressType);
        paramList.add(objInvoice._AccountID);
        paramList.add(objInvoice._BranchStoreNumber);
        paramList.add(objInvoice._Period);
        paramList.add(objInvoice._PeriodYear);
        paramList.add(objInvoice._InvoiceDate);
        paramList.add(objInvoice._InvoiceType);
        paramList.add(objInvoice._ST_DeliveryID);
        paramList.add(objInvoice._ST_DeliveryDate);
        paramList.add(objInvoice._ST_WarehouseID);
        paramList.add(objInvoice._ST_LocationID);
        paramList.add(objInvoice._ST_UCR);
        paramList.add(objInvoice._ST_A_StreetName);
        paramList.add(objInvoice._ST_A_Number);
        paramList.add(objInvoice._ST_A_AddtnlAddrssDtl);
        paramList.add(objInvoice._ST_A_Building);
        paramList.add(objInvoice._ST_A_City);
        paramList.add(objInvoice._ST_A_PostalCode);
        paramList.add(objInvoice._ST_A_Region);
        paramList.add(objInvoice._ST_A_Country);
        paramList.add(objInvoice._ST_A_AddressType);
        paramList.add(objInvoice._SF_DeliveryID);
        paramList.add(objInvoice._SF_DeliveryDate);
        paramList.add(objInvoice._SF_WarehouseID);
        paramList.add(objInvoice._SF_LocationID);
        paramList.add(objInvoice._SF_UCR);
        paramList.add(objInvoice._SF_A_StreetName);
        paramList.add(objInvoice._SF_A_Number);
        paramList.add(objInvoice._SF_A_AddtnlAddrssDtl);
        paramList.add(objInvoice._SF_A_Building);
        paramList.add(objInvoice._SF_A_City);
        paramList.add(objInvoice._SF_A_PostalCode);
        paramList.add(objInvoice._SF_A_Region);
        paramList.add(objInvoice._SF_A_Country);
        paramList.add(objInvoice._SF_A_AddressType);
        paramList.add(objInvoice._PaymentTerms);
        paramList.add(objInvoice._SelfBillingIndicator);
        paramList.add(objInvoice._SourceID);
        paramList.add(objInvoice._GLPostingDate);
        paramList.add(objInvoice._BatchID);
        paramList.add(objInvoice._SystemID);
        paramList.add(objInvoice._TransactionID);
        paramList.add(objInvoice._ReceiptNumbers);
        paramList.add(objInvoice._IS_SettlementDiscount);
        paramList.add(objInvoice._IS_SA_Amount);
        paramList.add(objInvoice._IS_SA_CurrencyCode);
        paramList.add(objInvoice._IS_SA_CurrencyAmount);
        paramList.add(objInvoice._IS_SA_ExchangeRate);
        paramList.add(objInvoice._IS_SettlementDate);
        paramList.add(objInvoice._IS_PaymentMechanism);
        paramList.add(objInvoice._IDT_ShippingCostsAmountTotal);
        paramList.add(objInvoice._IDT_NetTotal);
        paramList.add(objInvoice._IDT_GrossTotal);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objInvoice.id, paramList, tableName);
        String sql = null;
        if (xmlContext.equals("0_215_216_217")) {
            sql = this._decId + "," + this._modId + "," + objInvoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_INVOICE_SINV_LNK", sql);
        } else if (xmlContext.equals("0_215_263_217")) {
            sql = this._decId + "," + this._modId + "," + objInvoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_INVOICE_PINV_LNK", sql);
        } else {
            LogTrace.log((String)("Context XML eronat ('" + xmlContext + "') la insertia intr-o tabela de legatura a tabelei D406_INVOICE, in functia insert_Invoice()"), (int)0);
        }
    }

    public void insertInvoiceLineCon2(InvoiceLine objInvoiceLine) {
        objInvoiceLine.id = this.getId("D406_INVOICE_LINE");
    }

    public void updateInvoiceLineCon2(InvoiceLine objInvoiceLine, String xmlContext) {
        String tableName = "D406_INVOICE_LINE";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objInvoiceLine._validator._Invoice.id);
        paramList.add(objInvoiceLine._LineNumber);
        paramList.add(objInvoiceLine._AccountID);
        paramList.add(objInvoiceLine._ST_DeliveryID);
        paramList.add(objInvoiceLine._ST_DeliveryDate);
        paramList.add(objInvoiceLine._ST_WarehouseID);
        paramList.add(objInvoiceLine._ST_LocationID);
        paramList.add(objInvoiceLine._ST_UCR);
        paramList.add(objInvoiceLine._ST_A_StreetName);
        paramList.add(objInvoiceLine._ST_A_Number);
        paramList.add(objInvoiceLine._ST_A_AddtnlAddrssDtl);
        paramList.add(objInvoiceLine._ST_A_Building);
        paramList.add(objInvoiceLine._ST_A_City);
        paramList.add(objInvoiceLine._ST_A_PostalCode);
        paramList.add(objInvoiceLine._ST_A_Region);
        paramList.add(objInvoiceLine._ST_A_Country);
        paramList.add(objInvoiceLine._ST_A_AddressType);
        paramList.add(objInvoiceLine._SF_DeliveryID);
        paramList.add(objInvoiceLine._SF_DeliveryDate);
        paramList.add(objInvoiceLine._SF_WarehouseID);
        paramList.add(objInvoiceLine._SF_LocationID);
        paramList.add(objInvoiceLine._SF_UCR);
        paramList.add(objInvoiceLine._SF_A_StreetName);
        paramList.add(objInvoiceLine._SF_A_Number);
        paramList.add(objInvoiceLine._SF_A_AddtnlAddrssDtl);
        paramList.add(objInvoiceLine._SF_A_Building);
        paramList.add(objInvoiceLine._SF_A_City);
        paramList.add(objInvoiceLine._SF_A_PostalCode);
        paramList.add(objInvoiceLine._SF_A_Region);
        paramList.add(objInvoiceLine._SF_A_Country);
        paramList.add(objInvoiceLine._SF_A_AddressType);
        paramList.add(objInvoiceLine._GoodsServicesID);
        paramList.add(objInvoiceLine._ProductCode);
        paramList.add(objInvoiceLine._ProductDescription);
        paramList.add(objInvoiceLine._D_DeliveryDate);
        paramList.add(objInvoiceLine._D_DP_FromDate);
        paramList.add(objInvoiceLine._D_DP_ToDate);
        paramList.add(objInvoiceLine._Quantity);
        paramList.add(objInvoiceLine._InvoiceUOM);
        paramList.add(objInvoiceLine._UOMToUOMBaseCnvrsnFctr);
        paramList.add(objInvoiceLine._UnitPrice);
        paramList.add(objInvoiceLine._TaxPointDate);
        paramList.add(objInvoiceLine._CN_Reference);
        paramList.add(objInvoiceLine._CN_Reason);
        paramList.add(objInvoiceLine._Description);
        paramList.add(objInvoiceLine._ILA_Amount);
        paramList.add(objInvoiceLine._ILA_CurrencyCode);
        paramList.add(objInvoiceLine._ILA_CurrencyAmount);
        paramList.add(objInvoiceLine._ILA_ExchangeRate);
        paramList.add(objInvoiceLine._DebitCreditIndicator);
        paramList.add(objInvoiceLine._SCA_Amount);
        paramList.add(objInvoiceLine._SCA_CurrencyCode);
        paramList.add(objInvoiceLine._SCA_CurrencyAmount);
        paramList.add(objInvoiceLine._SCA_ExchangeRate);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objInvoiceLine.id, paramList, tableName);
        String sql = null;
        if (xmlContext.equals("0_215_216_217_232")) {
            sql = this._decId + "," + this._modId + "," + objInvoiceLine.id + ", " + objInvoiceLine._validator._Invoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_INV_LINE_SINV_LNK", sql);
        } else if (xmlContext.equals("0_215_263_217_232")) {
            sql = this._decId + "," + this._modId + "," + objInvoiceLine.id + ", " + objInvoiceLine._validator._Invoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_INV_LINE_PINV_LNK", sql);
        } else {
            LogTrace.log((String)("Context XML eronat ('" + xmlContext + "') la insertia intr-o tabela de legatura a tabelei D406_INVOICE_LINE, in functia insert_InvoiceLine()"), (int)0);
        }
    }

    public void insertOrderReferencesCon2(OrderReferences objOrderReferences) {
        String tableName = "D406_ORDER_REFERENCES";
        objOrderReferences.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objOrderReferences._validator._InvoiceLine.id);
        paramList.add(objOrderReferences._validator._Invoice.id);
        paramList.add(objOrderReferences._OriginatingON);
        paramList.add(objOrderReferences._OrderDate);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objOrderReferences.id, paramList, tableName);
    }

    public void insertMovementReferenceCon2(MovementReference objMovementReference) {
        String tableName = "D406_MOVEMENT_REFERENCE";
        objMovementReference.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objMovementReference._validator._InvoiceLine.id);
        paramList.add(objMovementReference._validator._Invoice.id);
        paramList.add(objMovementReference._MovementReference);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objMovementReference.id, paramList, tableName);
    }

    public void insertTaxInformationTotalsCon2(TaxInformationTotals objTaxInformationTotals, String xmlContext) {
        String tableName = "D406_TAX_INFORMATION";
        objTaxInformationTotals.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objTaxInformationTotals._TaxType);
        paramList.add(objTaxInformationTotals._TaxCode);
        paramList.add(objTaxInformationTotals._TaxPercentage);
        paramList.add(objTaxInformationTotals._TaxBase);
        paramList.add(objTaxInformationTotals._TaxBaseDescription);
        paramList.add(objTaxInformationTotals._TA_Amount);
        paramList.add(objTaxInformationTotals._TA_CurrencyCode);
        paramList.add(objTaxInformationTotals._TA_CurrencyAmount);
        paramList.add(objTaxInformationTotals._TA_ExchangeRate);
        paramList.add(objTaxInformationTotals._TaxExemptionReason);
        paramList.add(objTaxInformationTotals._TaxDeclarationPeriod);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objTaxInformationTotals.id, paramList, tableName);
        String sql = null;
        if (xmlContext.equals("0_183_187_190_201_209")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformationTotals.id + "," + objTaxInformationTotals._validator._TransactionLine.id + "," + objTaxInformationTotals._validator._Transaction.id + ", " + objTaxInformationTotals._validator._Journal.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_TR_LN_LNK", sql);
        } else if (xmlContext.equals("0_215_216_217_232_209")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformationTotals.id + "," + objTaxInformationTotals._validator._InvoiceLine.id + ", " + objTaxInformationTotals._validator._Invoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_SINV1_LNK", sql);
        } else if (xmlContext.equals("0_215_216_217_258_259")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformationTotals.id + ", " + objTaxInformationTotals._validator._Invoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_SINV2_LNK", sql);
        } else if (xmlContext.equals("0_215_263_217_232_209")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformationTotals.id + "," + objTaxInformationTotals._validator._InvoiceLine.id + ", " + objTaxInformationTotals._validator._Invoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_PINV1_LNK", sql);
        } else if (xmlContext.equals("0_215_263_217_258_259")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformationTotals.id + ", " + objTaxInformationTotals._validator._Invoice.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_PINV2_LNK", sql);
        } else if (xmlContext.equals("0_215_264_265_268_209")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformationTotals.id + "," + objTaxInformationTotals._validator._PaymentLine.id + ", " + objTaxInformationTotals._validator._Payment.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_PAY1_LNK", sql);
        } else if (xmlContext.equals("0_215_264_265_271_259")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformationTotals.id + ", " + objTaxInformationTotals._validator._Payment.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_PAY2_LNK", sql);
        } else if (xmlContext.equals("0_215_272_276_283_209")) {
            sql = this._decId + "," + this._modId + "," + objTaxInformationTotals.id + "," + objTaxInformationTotals._validator._StockMovementLine.id + ", " + objTaxInformationTotals._validator._StockMovement.id + "," + this._periodStartYear + "," + this._creationDate + "," + this._perioada + "," + this._an_raportare;
            this.writeSql("D406_TAX_INF_ST_MV_LNK", sql);
        } else {
            LogTrace.log((String)("Context XML eronat ('" + xmlContext + "') la insertia intr-o tabela de legatura a tabelei D406_TAX_INFORMATION, in functia insert_TaxInformationTotals()"), (int)0);
        }
    }

    public void insertPaymentCon2(Payment objPayment) {
        objPayment.id = this.getId("D406_PAYMENT");
    }

    public void updatePaymentCon2(Payment objPayment) {
        String tableName = "D406_PAYMENT";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objPayment._PaymentRefNo);
        paramList.add(objPayment._Period);
        paramList.add(objPayment._PeriodYear);
        paramList.add(objPayment._TransactionID);
        paramList.add(objPayment._TransactionDate);
        paramList.add(objPayment._PaymentMethod);
        paramList.add(objPayment._Description);
        paramList.add(objPayment._BatchID);
        paramList.add(objPayment._SystemID);
        paramList.add(objPayment._SourceID);
        paramList.add(objPayment._PS_SettlementDiscount);
        paramList.add(objPayment._PS_SA_Amount);
        paramList.add(objPayment._PS_SA_CurrencyCode);
        paramList.add(objPayment._PS_SA_CurrencyAmount);
        paramList.add(objPayment._PS_SA_ExchangeRate);
        paramList.add(objPayment._PS_SettlementDate);
        paramList.add(objPayment._PS_PaymentMechanism);
        paramList.add(objPayment._PDT_NetTotal);
        paramList.add(objPayment._PDT_GrossTotal);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objPayment.id, paramList, tableName);
    }

    public void insertPaymentLineCon2(PaymentLine objPaymentLine) {
        objPaymentLine.id = this.getId("D406_PAYMENT_LINE");
    }

    public void updatePaymentLineCon2(PaymentLine objPaymentLine) {
        String tableName = "D406_PAYMENT_LINE";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objPaymentLine._validator._Payment.id);
        paramList.add(objPaymentLine._LineNumber);
        paramList.add(objPaymentLine._SourceDocumentID);
        paramList.add(objPaymentLine._AccountID);
        paramList.add(objPaymentLine._CustomerID);
        paramList.add(objPaymentLine._SupplierID);
        paramList.add(objPaymentLine._TaxPointDate);
        paramList.add(objPaymentLine._Description);
        paramList.add(objPaymentLine._DebitCreditIndicator);
        paramList.add(objPaymentLine._PLA_Amount);
        paramList.add(objPaymentLine._PLA_CurrencyCode);
        paramList.add(objPaymentLine._PLA_CurrencyAmount);
        paramList.add(objPaymentLine._PLA_ExchangeRate);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objPaymentLine.id, paramList, tableName);
    }

    public void insertStockMovementCon2(StockMovement objStockMovement) {
        objStockMovement.id = this.getId("D406_STOCK_MOVEMENT");
    }

    public void updateStockMovementCon2(StockMovement objStockMovement) {
        String tableName = "D406_STOCK_MOVEMENT";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objStockMovement._MovementReference);
        paramList.add(objStockMovement._MovementDate);
        paramList.add(objStockMovement._MovementPostingDate);
        paramList.add(objStockMovement._MovementPostingTime);
        paramList.add(objStockMovement._TaxPointDate);
        paramList.add(objStockMovement._MovementType);
        paramList.add(objStockMovement._SourceID);
        paramList.add(objStockMovement._SystemID);
        paramList.add(objStockMovement._DR_DocumentType);
        paramList.add(objStockMovement._DR_DocumentNumber);
        paramList.add(objStockMovement._DR_DocumentLine);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objStockMovement.id, paramList, tableName);
    }

    public void insertStockMovementLineCon2(StockMovementLine objStockMovementLine) {
        objStockMovementLine.id = this.getId("D406_STOCK_MOVEMENT_LINE");
    }

    public void updateStockMovementLineCon2(StockMovementLine objStockMovementLine) {
        String tableName = "D406_STOCK_MOVEMENT_LINE";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objStockMovementLine._validator._StockMovement.id);
        paramList.add(objStockMovementLine._LineNumber);
        paramList.add(objStockMovementLine._AccountID);
        paramList.add(objStockMovementLine._TransactionID);
        paramList.add(objStockMovementLine._CustomerID);
        paramList.add(objStockMovementLine._SupplierID);
        paramList.add(objStockMovementLine._ST_DeliveryID);
        paramList.add(objStockMovementLine._ST_DeliveryDate);
        paramList.add(objStockMovementLine._ST_WarehouseID);
        paramList.add(objStockMovementLine._ST_LocationID);
        paramList.add(objStockMovementLine._ST_UCR);
        paramList.add(objStockMovementLine._ST_A_StreetName);
        paramList.add(objStockMovementLine._ST_A_Number);
        paramList.add(objStockMovementLine._ST_A_AddtnlAddrssDtl);
        paramList.add(objStockMovementLine._ST_A_Building);
        paramList.add(objStockMovementLine._ST_A_City);
        paramList.add(objStockMovementLine._ST_A_PostalCode);
        paramList.add(objStockMovementLine._ST_A_Region);
        paramList.add(objStockMovementLine._ST_A_Country);
        paramList.add(objStockMovementLine._ST_A_AddressType);
        paramList.add(objStockMovementLine._SF_DeliveryID);
        paramList.add(objStockMovementLine._SF_DeliveryDate);
        paramList.add(objStockMovementLine._SF_WarehouseID);
        paramList.add(objStockMovementLine._SF_LocationID);
        paramList.add(objStockMovementLine._SF_UCR);
        paramList.add(objStockMovementLine._SF_A_StreetName);
        paramList.add(objStockMovementLine._SF_A_Number);
        paramList.add(objStockMovementLine._SF_A_AddtnlAddrssDtl);
        paramList.add(objStockMovementLine._SF_A_Building);
        paramList.add(objStockMovementLine._SF_A_City);
        paramList.add(objStockMovementLine._SF_A_PostalCode);
        paramList.add(objStockMovementLine._SF_A_Region);
        paramList.add(objStockMovementLine._SF_A_Country);
        paramList.add(objStockMovementLine._SF_A_AddressType);
        paramList.add(objStockMovementLine._ProductCode);
        paramList.add(objStockMovementLine._StockAccountNo);
        paramList.add(objStockMovementLine._Quantity);
        paramList.add(objStockMovementLine._UnitOfMeasure);
        paramList.add(objStockMovementLine._UOMToUOMPhysclStckCnvrsnFctr);
        paramList.add(objStockMovementLine._BookValue);
        paramList.add(objStockMovementLine._MovementSubType);
        paramList.add(objStockMovementLine._MovementComments);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objStockMovementLine.id, paramList, tableName);
    }

    public void insertAssetTransactionCon2(AssetTransaction objAssetTransaction) {
        String tableName = "D406_ASSET_TRANSACTION";
        objAssetTransaction.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objAssetTransaction._AssetTransactionID);
        paramList.add(objAssetTransaction._AssetID);
        paramList.add(objAssetTransaction._AssetTransactionType);
        paramList.add(objAssetTransaction._Description);
        paramList.add(objAssetTransaction._AssetTransactionDate);
        paramList.add(objAssetTransaction._AS_SupplierName);
        paramList.add(objAssetTransaction._AS_SupplierID);
        paramList.add(objAssetTransaction._AS_PA_StreetName);
        paramList.add(objAssetTransaction._AS_PA_Number);
        paramList.add(objAssetTransaction._AS_PA_AddtnlAddrssDtl);
        paramList.add(objAssetTransaction._AS_PA_Building);
        paramList.add(objAssetTransaction._AS_PA_City);
        paramList.add(objAssetTransaction._AS_PA_PostalCode);
        paramList.add(objAssetTransaction._AS_PA_Region);
        paramList.add(objAssetTransaction._AS_PA_Country);
        paramList.add(objAssetTransaction._AS_PA_AddressType);
        paramList.add(objAssetTransaction._TransactionID);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objAssetTransaction.id, paramList, tableName);
    }

    public void insertAsstTrnsctnVltnCon2(AsstTrnsctnVltn objAsstTrnsctnVltn) {
        String tableName = "D406_ASST_TRNSCTN_VLTN";
        objAsstTrnsctnVltn.id = this.getId(tableName);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(String.valueOf(this._decId));
        paramList.add(String.valueOf(this._modId));
        paramList.add(objAsstTrnsctnVltn._validator._AssetTransaction.id);
        paramList.add(objAsstTrnsctnVltn._AssetValuationType);
        paramList.add(objAsstTrnsctnVltn._AcqstnAndPrdctnCstsOnTrnsctn);
        paramList.add(objAsstTrnsctnVltn._BookValueOnTransaction);
        paramList.add(objAsstTrnsctnVltn._AssetTransactionAmount);
        paramList.add(this._periodStartYear);
        paramList.add(this._creationDate);
        paramList.add(this._perioada);
        paramList.add(this._an_raportare);
        this.appendSql(objAsstTrnsctnVltn.id, paramList, tableName);
    }

    public String delCon2(long id) {
        String type = "del_Con2";
        LogTrace.log((String)" IN DELCON2", (int)0);
        try {
            LogTrace.log((String)" IN TRY DELCON2", (int)0);
            this.cstmtDelCon2.registerOutParameter(1, 12);
            this.cstmtDelCon2.registerOutParameter(2, 4);
            this.cstmtDelCon2.setLong(2, id);
            this.cstmtDelCon2.setLong(3, 0L);
            LogTrace.log((String)" INAINTE DE EXEC  DELCON2", (int)0);
            this.cstmtDelCon2.execute();
            LogTrace.log((String)" DUPA EXEC DELCON2", (int)0);
            return this.establishResults(this.cstmtDelCon2, type);
        }
        catch (Throwable ex) {
            return this.establishResults(ex.toString(), 4, type);
        }
    }

    public void setInsertCount(long insertCount) {
        this.insertCount = insertCount;
    }

    public long getInsertCount() {
        return this.insertCount;
    }

    private void appendSql(String id, List<String> param, String tableName) {
        String result = id + ",";
        for (int i = 0; i < param.size(); ++i) {
            String value = param.get(i) == null ? "NULL" : param.get(i);
            if ((value = value.replaceAll(NEW_LINE, " ")).contains(",")) {
                value = TXT_COL_START_TAG + value + TXT_COL_END_TAG;
            }
            result = result + value;
            result = result + (i != param.size() - 1 ? "," : "");
        }
        this.writeSql(tableName, result);
    }

    private String getParamValue(String value, String templateParam) {
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getId(String tableName) {
        Queue<Object> tableIdCache = null;
        if (this.dbIdsCache.containsKey(tableName)) {
            tableIdCache = this.dbIdsCache.get(tableName);
        } else {
            tableIdCache = new LinkedList();
            this.dbIdsCache.put(tableName, tableIdCache);
        }
        if (!tableIdCache.isEmpty()) {
            return ((Long)tableIdCache.poll()).toString();
        }
        if (this._connection2 != null) {
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = this._connection2.prepareStatement(NEXT_VAL_TEMPLATE.replace("TABLE_NAME", tableName));
                rs = ps.executeQuery();
                while (rs.next()) {
                    tableIdCache.add(rs.getLong(1));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                Long l = this.TABLE_ID;
                Long l2 = this.TABLE_ID = Long.valueOf(this.TABLE_ID - 1L);
                tableIdCache.add(l);
            }
        }
        return ((Long)tableIdCache.poll()).toString();
    }

    protected void writeSql(String tableName, String sql) {
        String METHOD_NAME = ((Object)((Object)this)).getClass().getName();
        sql = sql + "\n";
        try {
            Integer count;
            this.sqlBosMap.get(tableName).write(sql.getBytes());
            Integer n = count = this.sqlLinesCountMap.get(tableName);
            Integer n2 = count = Integer.valueOf(count + 1);
            this.sqlLinesCountMap.put(tableName, count);
            ++this.insertCount;
        }
        catch (IOException ex) {
            LogTrace.log((String)(METHOD_NAME + " IOException: Error on write bites for " + tableName + ".sql\n" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
        }
    }

    /*
     * Exception decompiling
     */
    protected void readSqlFiles() throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long readSql(ExecutorService exec, String sqlFile, String tableName) throws Throwable {
        String METHOD_NAME = ((Object)((Object)this)).getClass().getName();
        LogTrace.log((String)("==============START READING SQL FILE " + sqlFile + " ============"), (int)0);
        ArrayList<BatchRunner> batchRunners = new ArrayList<BatchRunner>();
        String encoding = "UTF-8";
        ReversedLinesFileReader reader = null;
        String line = null;
        long totalSqlCount = 0L;
        String statement = DbAccessImpl.getPreparedStatement(tableName);
        try {
            reader = new ReversedLinesFileReader(new File(sqlFile), 8192, encoding);
            for (Connection saftCon : this.saftConnections) {
                batchRunners.add(new BatchRunner(saftCon.prepareStatement(statement)));
            }
            Iterator iterator = batchRunners.iterator();
            BatchRunner batchRunner = (BatchRunner)iterator.next();
            List<Future<Object>> jobs = null;
            do {
                if ((line = reader.readLine()) == null) continue;
                if (batchRunner.getCounter() >= 5000 && iterator.hasNext()) {
                    batchRunner = (BatchRunner)iterator.next();
                }
                batchRunner.addBatch(line, statement, tableName);
                ++totalSqlCount;
                if (iterator.hasNext() || batchRunner.getCounter() < 5000) continue;
                LogTrace.log((String)("READ SQL executeBatch BEFORE: " + totalSqlCount), (int)0);
                try {
                    jobs = exec.invokeAll(batchRunners);
                }
                catch (InterruptedException ex) {
                    LogTrace.log((String)(METHOD_NAME + " InterruptedException: exec.invokeAll\n" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
                    this.establishResults(ex.toString(), 4, "eroare executie insert InterruptedException");
                    throw ex;
                }
                catch (Exception ex) {
                    LogTrace.log((String)("Exceptie generala:" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
                    this.establishResults(ex.toString(), 4, "eroare executie insert Exceptie generala");
                    throw ex;
                }
                catch (Throwable ex) {
                    LogTrace.log((String)("Exceptie generala THROWABLE:" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
                    this.establishResults(ex.toString(), 4, "eroare executie insert Exceptie generala THROWABLE");
                    throw ex;
                }
                LogTrace.log((String)"READ SQL executeBatch COMMIT", (int)0);
                try {
                    for (Connection con : this.saftConnections) {
                        con.commit();
                    }
                }
                catch (SQLException ex) {
                    LogTrace.log((String)(METHOD_NAME + " SQLException: commit batch\n" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
                    this.establishResults(ex.toString(), 4, "eroare executie commit dupa insert");
                    throw ex;
                }
                catch (Throwable ex) {
                    LogTrace.log((String)("Exceptie commit:" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
                    this.establishResults(ex.toString(), 4, "eroare executie commit");
                    throw ex;
                }
                iterator = batchRunners.iterator();
                this.logInsertExecution(jobs, METHOD_NAME, totalSqlCount);
            } while (line != null);
            try {
                jobs = exec.invokeAll(batchRunners);
            }
            catch (InterruptedException ex) {
                LogTrace.log((String)(METHOD_NAME + " InterruptedException: exec.invokeAll\n" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
                throw ex;
            }
            catch (Exception ex) {
                LogTrace.log((String)("Exceptie generala:" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
                this.establishResults(ex.toString(), 4, "eroare executie insert");
                throw ex;
            }
            catch (Throwable ex) {
                LogTrace.log((String)("Exceptie generala:" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
                this.establishResults(ex.toString(), 4, "eroare executie insert Exceptie generala");
                throw ex;
            }
            try {
                for (Connection con : this.saftConnections) {
                    con.commit();
                }
            }
            catch (SQLException ex) {
                LogTrace.log((String)(METHOD_NAME + " SQLException: commit batch final\n" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
                throw ex;
            }
            this.logInsertExecution(jobs, METHOD_NAME, totalSqlCount);
        }
        catch (IOException ex) {
            LogTrace.log((String)(METHOD_NAME + " IOException: fileChannel.map\n" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
            throw ex;
        }
        catch (SQLException ex) {
            LogTrace.log((String)(METHOD_NAME + " SQLException: batch execute\n" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
            throw ex;
        }
        catch (Throwable ex) {
            LogTrace.log((String)(METHOD_NAME + " Throwable: batch execute\n" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
            throw ex;
        }
        finally {
            for (BatchRunner br : batchRunners) {
                if (br.getStatement() == null) continue;
                try {
                    br.getStatement().close();
                }
                catch (SQLException ex) {
                    LogTrace.log((String)(METHOD_NAME + " SQLException: Statement close\n" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
                    throw ex;
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LogTrace.log((String)(METHOD_NAME + " IOException: fileChannel.close\n" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
                    throw ex;
                }
            }
        }
        LogTrace.log((String)("==============END READING SQL FILE COUNT: " + totalSqlCount + " fileName: " + sqlFile + " ============"), (int)0);
        return totalSqlCount;
    }

    private void logInsertExecution(List<Future<int[]>> jobs, String METHOD_NAME, long totalSqlCount) throws InterruptedException, ExecutionException {
        int execBatchSize = 0;
        int executedCount = 0;
        LogTrace.log((String)"IN LOGINSERTEXEC:", (int)0);
        try {
            for (Future<int[]> job : jobs) {
                int[] affectedRows = job.get();
                for (int i = 0; i < affectedRows.length; ++i) {
                    executedCount += affectedRows[i];
                }
                execBatchSize += affectedRows.length;
            }
        }
        catch (InterruptedException ex) {
            LogTrace.log((String)(METHOD_NAME + "!! InterruptedException: job.get()\n" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
            this.establishResults(ex.toString(), 4, "eroare executie insert InterruptedException  job.get()");
            throw ex;
        }
        catch (ExecutionException ex) {
            LogTrace.log((String)(METHOD_NAME + "! ExecutionException: job.get()\n" + ValidatorExtension2Impl.getStackTrace(ex)), (int)0);
            this.establishResults(ex.toString(), 4, "eroare executie insert ExecutionException: job.get()");
            LogTrace.log((String)"dupa establish", (int)0);
            throw ex;
        }
        LogTrace.log((String)("BATCH INSERT COUNTERS: " + totalSqlCount + " / " + executedCount + " / " + execBatchSize), (int)0);
        if (totalSqlCount != (long)execBatchSize) {
            LogTrace.log((String)"BATCH INSERT COUNTERS: nok !!!!!!!!!!!", (int)0);
        }
    }

    public static boolean deleteDir(File file) {
        File[] contents = file.listFiles();
        if (contents != null) {
            for (File f : contents) {
                DbAccessImpl.deleteDir(f);
            }
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle fromFile(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        try {
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(fis);
            return propertyResourceBundle;
        }
        finally {
            fis.close();
        }
    }

    protected void openSqlFiles(long id) {
        String METHOD_NAME = ((Object)((Object)this)).getClass().getName();
        try {
            sqlTemplates = DbAccessImpl.fromFile(Params.getProperty((String)"sqlTemplatesFilePath"));
        }
        catch (IOException e) {
            LogTrace.log((String)("SQL TEMPLATE FILE: " + Params.getProperty((String)"sqlTemplatesFilePath") + " cannot be obtained"), (int)0);
        }
        LogTrace.log((String)("==============START WRITING SQL FILES FOR: " + id + " ================="), (int)0);
        String folderPath = Params.getProperty((String)"tmpSqlPath") + id;
        File folder = new File(folderPath);
        if (folder.exists() && !DbAccessImpl.deleteDir(folder)) {
            LogTrace.log((String)(METHOD_NAME + " Cannot write sql files. Folder " + folderPath + " already exists and cannot be deleted!"), (int)0);
            return;
        }
        folder.mkdir();
        this.sqlFileMap.clear();
        this.sqlFosMap.clear();
        this.sqlBosMap.clear();
        this.sqlLinesCountMap.clear();
        for (String tableName : sqlTemplates.keySet()) {
            String sqlFile = folderPath + File.separator + tableName + ".sql";
            this.sqlFileMap.put(tableName, sqlFile);
            try {
                LogTrace.log((String)("FUNCTIE WRITING SQL FILES , IN TRY, FOR: " + id + " ================="), (int)0);
                FileOutputStream sqlFos = new FileOutputStream(sqlFile);
                this.sqlFosMap.put(tableName, sqlFos);
                this.sqlBosMap.put(tableName, new BufferedOutputStream(sqlFos, 8192));
                this.sqlLinesCountMap.put(tableName, 0);
            }
            catch (FileNotFoundException ex) {
                LogTrace.log((String)(METHOD_NAME + " FileNotFoundException: " + sqlFile), (int)0);
                this.establishResults(ex.toString(), 4, "deschidere fisier sql");
                break;
            }
        }
        LogTrace.log((String)("==============FINAL FUNCTIE WRITING SQL FILES FOR: " + id + " ================="), (int)0);
    }

    protected static Integer getTableLevel(String tableName) {
        return Integer.valueOf(sqlTemplates.getString(tableName).split("#")[0]);
    }

    protected static String getPreparedStatement(String tableName) {
        String ps = sqlTemplates.getString(tableName).split("#")[1];
        ps = ps.replace("N?", "?");
        ps = ps.replace("D?", "?");
        return ps;
    }

    protected static String[] getPreparedStatementTypes(String tableName) {
        String ps = sqlTemplates.getString(tableName).split("#")[1];
        return ps.toUpperCase().split("VALUES")[1].split(",");
    }

    private static TreeMap<Integer, List<String>> getSortedTables() {
        TreeMap<Integer, List<String>> tables = new TreeMap<Integer, List<String>>();
        for (String tableName : sqlTemplates.keySet()) {
            if (!tables.containsKey(DbAccessImpl.getTableLevel(tableName))) {
                tables.put(DbAccessImpl.getTableLevel(tableName), new ArrayList());
            }
            tables.get(DbAccessImpl.getTableLevel(tableName)).add(tableName);
        }
        return tables;
    }

    private static void closeExecutor(ExecutorService executorService, int timeoutMinutes) {
        if (executorService != null) {
            executorService.shutdown();
            try {
                if (!executorService.awaitTermination(timeoutMinutes, TimeUnit.MINUTES)) {
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executorService.shutdownNow();
            }
        }
    }
}

