/*
 * Decompiled with CFR 0.152.
 */
package d406validator.v0;

import d406validator.v0.DbAccessImpl;
import d406validator.v0.ValidatorExtension2Impl;
import dec.LogTrace;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.Callable;

class BatchRunner
implements Callable<int[]> {
    private PreparedStatement prepStatement;
    private short counter = 0;

    @Override
    public int[] call() throws SQLException {
        try {
            this.counter = 0;
            return this.prepStatement.executeBatch();
        }
        catch (SQLException e) {
            LogTrace.log((String)("THREAD call executeBatch SQLException threadID:[" + Thread.currentThread().getId() + "]\n" + ValidatorExtension2Impl.getStackTrace(e)), (int)0);
            Connection con = this.prepStatement.getConnection();
            con.rollback();
            throw e;
        }
    }

    public void addBatch(String sql, String statement, String tableName) throws Throwable {
        String[] types = DbAccessImpl.getPreparedStatementTypes(tableName);
        String[] val = sql.split(",");
        int valIndex = 0;
        String value = null;
        String rowDebug = "";
        try {
            StringBuilder tokens = new StringBuilder("");
            boolean isReadingTxtTag = false;
            for (int i = 0; i < val.length; ++i) {
                value = val[i];
                if (value.contains("<ANAF:OBJ>")) {
                    tokens = new StringBuilder("");
                    tokens.append(value.replace("<ANAF:OBJ>", ""));
                    tokens.append(",");
                    isReadingTxtTag = true;
                    continue;
                }
                if (isReadingTxtTag) {
                    if (value.contains("</ANAF:OBJ>")) {
                        tokens.append(value.replace("</ANAF:OBJ>", ""));
                        value = tokens.toString();
                        isReadingTxtTag = false;
                    } else {
                        tokens.append(value);
                        tokens.append(",");
                        continue;
                    }
                }
                if (types[++valIndex - 1].contains("N")) {
                    if (value.equalsIgnoreCase("NULL")) {
                        this.setNullValue(valIndex, 8);
                    } else {
                        this.setDoubleValue(valIndex, value);
                    }
                } else if (types[valIndex - 1].contains("D")) {
                    if (value.equalsIgnoreCase("NULL")) {
                        this.setNullValue(valIndex, 91);
                    } else {
                        this.setDateValue(valIndex, value);
                    }
                } else if (value.equalsIgnoreCase("NULL")) {
                    this.setNullValue(valIndex, 12);
                } else {
                    this.setStringValue(valIndex, value);
                }
                rowDebug = i == val.length - 1 ? rowDebug + value + "[" + valIndex + "]" : rowDebug + value + "[" + valIndex + "]" + ",";
            }
            if (this.prepStatement != null) {
                this.prepStatement.addBatch();
            }
            this.counter = (short)(this.counter + 1);
        }
        catch (Throwable e) {
            LogTrace.log((String)("Throwable: THREAD call addBatch prepStatement.setXXX[" + valIndex + ", " + value + "]  threadID:[" + Thread.currentThread().getId() + "] batch current size:[" + this.counter + "]"), (int)0);
            LogTrace.log((String)("Throwable: THREAD call addBatch threadID:[" + Thread.currentThread().getId() + "] batch current size:[" + this.counter + "]\n" + ValidatorExtension2Impl.getStackTrace(e)), (int)0);
            throw e;
        }
    }

    private void setStringValue(int valIndex, String value) throws SQLException {
        if (this.prepStatement != null) {
            this.prepStatement.setString(valIndex, value);
        } else {
            LogTrace.log((String)String.format("setStringValue(%s,%s)", valIndex, value), (int)0);
        }
    }

    private void setDateValue(int valIndex, String value) throws SQLException {
        if (this.prepStatement != null) {
            this.prepStatement.setDate(valIndex, Date.valueOf(value));
        } else {
            LogTrace.log((String)String.format("setDateValue(%s,%s)", valIndex, Date.valueOf(value)), (int)0);
        }
    }

    private void setDoubleValue(int valIndex, String value) throws NumberFormatException, SQLException {
        if (this.prepStatement != null) {
            this.prepStatement.setDouble(valIndex, Double.parseDouble(value));
        } else {
            LogTrace.log((String)String.format("setDoubleValue(%s,%s)", valIndex, Double.parseDouble(value)), (int)0);
        }
    }

    private void setNullValue(int valIndex, int type) throws SQLException {
        if (this.prepStatement != null) {
            this.prepStatement.setNull(valIndex, type);
        } else {
            LogTrace.log((String)String.format("setNullValue(%s,%s)", valIndex, type), (int)0);
        }
    }

    public BatchRunner(PreparedStatement s) {
        this.prepStatement = s;
    }

    public short getCounter() {
        return this.counter;
    }

    public PreparedStatement getStatement() {
        return this.prepStatement;
    }

    public void setStatement(PreparedStatement statement) {
        this.prepStatement = statement;
    }
}

