/*
 * Decompiled with CFR 0.152.
 */
package d395validator.v1;

import d395validator.v1.D395;
import d395validator.v1.DbAccessImpl;
import d395validator.v1.Lista;
import d395validator.v1.Lista2;
import dec.DECDbAccessRoot;
import dec.DECTag;
import dec.DECValidatorRoot;
import dec.Info;

public class ValidatorImpl
extends DECValidatorRoot {
    static final String DEC_NAMESPACE = "mfp:anaf:dgti:d395:declaratie:v1";
    static final int ID_D395 = 0;
    static final int ID_LISTA = 1;
    static final int MAX_OCC_LISTA = 400000;
    static final int ID_LISTA2 = 2;
    static final int MAX_OCC_LISTA2 = 1;
    private static DECTag[] _taguri = new DECTag[]{new DECTag("D395", 0, 1, 1, true), new DECTag("lista", 1, 0, 400000, false), new DECTag("lista2", 2, 0, 1, false)};
    private static long[] _tabelPrecedenta = new long[]{ValidatorImpl.start((int)0), ValidatorImpl.startStart((int)1, (int)0), ValidatorImpl.startEnd((int)1, (int)1), ValidatorImpl.startStart((int)2, (int)0), ValidatorImpl.startEnd((int)2, (int)1), ValidatorImpl.endStart((int)0, (int)0), ValidatorImpl.endEnd((int)0, (int)1), ValidatorImpl.endEnd((int)0, (int)2), ValidatorImpl.endStart((int)1, (int)1)};
    private DbAccessImpl _dbObj = null;
    D395 _D395 = null;
    Lista _lista = null;
    Lista2 _lista2 = null;
    int _cntLista;
    int _cntLista2;
    boolean _existsLista;
    boolean _existsLista2;

    public ValidatorImpl() {
        this.init(_taguri, _tabelPrecedenta, DEC_NAMESPACE);
    }

    public void initializareDocument() {
        if (this._D395 == null) {
            this._D395 = new D395(this, null);
            this._lista = new Lista(this, this._D395);
            this._lista2 = new Lista2(this, this._D395);
        } else {
            this._D395.setParams();
            this._lista.setParams();
            this._lista2.setParams();
        }
    }

    public void finalizareDocument(Info info) {
        if (this._dbObj != null) {
            return;
        }
        info._tipPerioada = "L";
        info._an = this.adjustString(this._D395._an);
        info._luna = this.adjustString(this._D395._luna);
        info._perioada = this.adjustString(this._D395._luna);
        if (this._extractValuesFlag != 0) {
            return;
        }
        info._rec = this.adjustString(this._D395._d_rec);
        info._sumaControl = this.adjustString(this._D395._totalPlata_A);
        info._cif = this.adjustString(this._D395._cif);
        info._denumire = this.adjustString(this._D395._den);
        info._adresa = this.adjustString(this._D395._adresa);
        info._telefon = this.adjustString(this._D395._telefon);
        info._mail = this.adjustString(this._D395._mail);
    }

    protected DECDbAccessRoot getDbAccess() {
        this._dbObj = new DbAccessImpl();
        return this._dbObj;
    }

    public int validareStartTag(int index) {
        switch (index) {
            case 0: {
                this._existsLista = false;
                this._cntLista = 0;
                this._D395.initialization();
                this._D395.checkTag(0);
                if (this._extractValuesFlag == 1) {
                    this._extractValuesFlag = 2;
                }
                if (!this._writeDB) break;
                this._dbObj.insertD395(this._D395);
                break;
            }
            case 1: {
                this._existsLista = true;
                this._lista.initialization();
                this._lista.checkTag(0);
                if (!this._writeDB) break;
                this._dbObj.insertLista(this._lista);
                break;
            }
            case 2: {
                this._existsLista2 = true;
                this._lista2.initialization();
                this._lista2.checkTag(0);
                if (!this._writeDB) break;
                this._dbObj.insertLista2(this._lista2);
            }
        }
        return 0;
    }

    public int validareIban(String iban) {
        if (iban == null) {
            return 0;
        }
        if (iban.length() < 5) {
            return -1;
        }
        iban = iban.substring(4) + iban.substring(0, 4);
        char[] charIban = iban.toCharArray();
        int[] val = new int[charIban.length];
        int k = 0;
        int r = 0;
        for (int i = 0; i < val.length; ++i) {
            val[i] = charIban[i];
            if (val[i] >= 48 && val[i] <= 57) {
                if (i == val.length - 4 || i == val.length - 3) {
                    return -1;
                }
                k = val[i] - 48;
            } else if (val[i] >= 65 && val[i] <= 90) {
                if (i == val.length - 2 || i == val.length - 1) {
                    return -1;
                }
                k = val[i] - 55;
            } else {
                return -1;
            }
            r = k > 9 ? (100 * r + k) % 97 : (10 * r + k) % 97;
        }
        if (r != 1) {
            return -1;
        }
        return 0;
    }

    public int validareEndTag(int index) {
        switch (index) {
            case 0: {
                this._D395.aggregation(0);
                break;
            }
            case 1: {
                this._lista.aggregation(0);
                ++this._cntLista;
                break;
            }
            case 2: {
                this._lista2.aggregation(0);
                ++this._cntLista2;
            }
        }
        return 0;
    }

    protected void endDeclaratie(int val) {
        this._dbObj.endDeclaratie(val);
    }
}

