/*
 * Decompiled with CFR 0.152.
 */
package d395validator.v0;

import d395validator.v0.D395;
import d395validator.v0.DataObjectRoot;
import d395validator.v0.ValidatorImpl;
import java.util.Date;

public class Lista
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_LISTA = 0;
    String _nr_doc;
    boolean _nr_doc_ok;
    String _data_doc;
    Date _data_doc_f;
    boolean _data_doc_ok;
    String _val_ramb;
    double _val_ramb_f;
    boolean _val_ramb_ok;
    String _den_expeditor;
    boolean _den_expeditor_ok;
    String _cif_expeditor;
    boolean _cif_expeditor_ok;
    String _jud_preluare;
    boolean _jud_preluare_ok;
    String _adresa_preluare;
    boolean _adresa_preluare_ok;
    String _adresa_oficiu;
    boolean _adresa_oficiu_ok;
    String _mod;
    long _mod_f;
    boolean _mod_ok;
    String _iban;
    boolean _iban_ok;
    String _den_receptionat;
    boolean _den_receptionat_ok;
    String _den_destinatar;
    boolean _den_destinatar_ok;
    String _rec_s;
    boolean _rec_s_ok;
    String _cif_declarant;
    boolean _cif_declarant_ok;
    String _cif_expeditor_str;
    boolean _cif_expeditor_str_ok;
    String _cod_tara_str;
    long _cod_tara_str_f;
    boolean _cod_tara_str_ok;

    public Lista(ValidatorImpl validator, DataObjectRoot parent) {
        super(validator, parent, 1);
    }

    public void checkTag(int codTag) {
        this.startValidation(codTag);
        this._nr_doc = this._validator.nextAttribute("nr_doc", 50, 4, 1);
        this._nr_doc_ok = this._validator._attributeOK;
        this._data_doc = this._validator.nextAttribute("data_doc", 0, 3, 1);
        this._data_doc_f = this._validator._dateValue;
        this._data_doc_ok = this._validator._attributeOK;
        this._rec_s = this._validator.nextAttributeInList(this._params._listaRecs, "rec_s", 256, 4, 0);
        this._rec_s_ok = this._validator._attributeOK;
        long rectificare = 0L;
        if (this._rec_s != null && this._rec_s.equals("S")) {
            rectificare = 1L;
        }
        if (rectificare == 0L) {
            this._val_ramb = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "val_ramb", 1);
            this._val_ramb_f = this._validator._realValue;
            this._val_ramb_ok = this._validator._attributeOK;
            this._den_expeditor = this._validator.nextAttribute("den_expeditor", 200, 4, 1);
            this._den_expeditor_ok = this._validator._attributeOK;
            this._cif_expeditor = this._validator.nextAttributeAsCif("cif_expeditor", 0);
            this._cif_expeditor_ok = this._validator._attributeOK;
            this._cif_expeditor_str = this._validator.nextAttribute("cif_expeditor_str", 50, 4, 0);
            this._cif_expeditor_str_ok = this._validator._attributeOK;
            this._jud_preluare = this._validator.nextAttributeInList(this._params._listaJudet, "jud_preluare", 2, 1, 0);
            this._jud_preluare_ok = this._validator._attributeOK;
            this._adresa_preluare = this._validator.nextAttribute("adresa_preluare", 1000, 4, 0);
            this._adresa_preluare_ok = this._validator._attributeOK;
            this._adresa_oficiu = this._validator.nextAttribute("adresa_oficiu", 1000, 4, 0);
            this._adresa_oficiu_ok = this._validator._attributeOK;
            this._mod = this._validator.nextAttributeInInterval(1L, 2L, "mod", 0, 1, 1);
            this._mod_f = this._validator._integerValue;
            this._mod_ok = this._validator._attributeOK;
            this._iban = this._validator.nextAttribute("iban", 30, 4, 0);
            this._iban_ok = this._validator._attributeOK;
            this._den_receptionat = this._validator.nextAttribute("den_receptionat", 200, 4, 0);
            this._den_receptionat_ok = this._validator._attributeOK;
            this._den_destinatar = this._validator.nextAttribute("den_destinatar", 200, 4, 1);
            this._den_destinatar_ok = this._validator._attributeOK;
            this._cod_tara_str = this._validator.nextAttributeInList(this._params._nomenclatorTari, "cod_tara_str", 3, 1, 0);
            this._cod_tara_str_f = this._validator._integerValue;
            this._cod_tara_str_ok = this._validator._attributeOK;
        }
        if (rectificare == 1L) {
            this._val_ramb = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "val_ramb", 2);
            this._val_ramb_f = this._validator._realValue;
            this._val_ramb_ok = this._validator._attributeOK;
            this._den_expeditor = this._validator.nextAttribute("den_expeditor", 200, 4, 2);
            this._den_expeditor_ok = this._validator._attributeOK;
            this._cif_expeditor = this._validator.nextAttributeAsCif("cif_expeditor", 2);
            this._cif_expeditor_ok = this._validator._attributeOK;
            this._jud_preluare = this._validator.nextAttributeInList(this._params._listaJudet, "jud_preluare", 2, 1, 2);
            this._jud_preluare_ok = this._validator._attributeOK;
            this._adresa_preluare = this._validator.nextAttribute("adresa_preluare", 1000, 4, 2);
            this._adresa_preluare_ok = this._validator._attributeOK;
            this._adresa_oficiu = this._validator.nextAttribute("adresa_oficiu", 1000, 4, 2);
            this._adresa_oficiu_ok = this._validator._attributeOK;
            this._mod = this._validator.nextAttributeInInterval(1L, 2L, "mod", 0, 1, 2);
            this._mod_f = this._validator._integerValue;
            this._mod_ok = this._validator._attributeOK;
            this._iban = this._validator.nextAttribute("iban", 30, 4, 2);
            this._iban_ok = this._validator._attributeOK;
            this._den_receptionat = this._validator.nextAttribute("den_receptionat", 200, 4, 2);
            this._den_receptionat_ok = this._validator._attributeOK;
            this._den_destinatar = this._validator.nextAttribute("den_destinatar", 200, 4, 2);
            this._den_destinatar_ok = this._validator._attributeOK;
            this._cif_expeditor_str = this._validator.nextAttribute("cif_expeditor_str", 50, 4, 2);
            this._cif_expeditor_str_ok = this._validator._attributeOK;
            this._cod_tara_str = this._validator.nextAttributeInList(this._params._nomenclatorTari, "cod_tara_str", 3, 1, 2);
            this._cod_tara_str_f = this._validator._integerValue;
            this._cod_tara_str_ok = this._validator._attributeOK;
        }
        this.endValidation(codTag);
    }

    public void aggregation(int codTag) {
        D395 d395 = (D395)this._parent;
        if (this._nr_doc != null) {
            if (d395._idUnic.contains(this._nr_doc)) {
                this._validator.addError(1, "R.Nrdoc", "", this._validator.fillParams("Nrdoc = @0@ nu este unic in declaratie", new Object[]{this._nr_doc}));
            } else {
                d395._idUnic.add(this._nr_doc);
            }
        }
        String an_doc = null;
        String luna_doc = null;
        String ziua_doc = null;
        ziua_doc = this._data_doc.substring(0, 2);
        luna_doc = this._data_doc.substring(3, 5);
        an_doc = this._data_doc.substring(6);
        String data_doc2 = an_doc + luna_doc + ziua_doc;
        String data_doc3 = null;
        data_doc3 = d395._an + Long.toString(d395._luna_f + 1L) + "01";
        String data_doc3_1 = null;
        data_doc3_1 = d395._luna + "." + d395._an;
        if (d395._an_f < Long.parseLong(an_doc)) {
            this._validator.addError(1, "R21.1", "", this._validator.fillParams("data_doc (@0@) trebuie sa fie anterioara sau cel mult egala perioadei de raportare (@1@)", new Object[]{this._data_doc, data_doc3_1}));
        }
        if (d395._an_f == Long.parseLong(an_doc) && d395._luna_f < Long.parseLong(luna_doc)) {
            this._validator.addError(1, "R21.2", "", this._validator.fillParams("data_doc (@0@) trebuie sa fie anterioara sau cel mult egala perioadei de raportare (@1@)", new Object[]{this._data_doc, data_doc3_1}));
        }
        long rectificare = 0L;
        if (this._rec_s != null && this._rec_s.equals("S")) {
            rectificare = 1L;
        }
        if (rectificare == 0L) {
            if (this._adresa_oficiu != null && this._adresa_preluare != null) {
                this._validator.addError(1, "R27", "", this._validator.fillParams("adresa_oficiu (@0@) si adresa_preluare (@1@) nu pot fi simultan completate", new Object[]{this._adresa_oficiu, this._adresa_preluare}));
            }
            if (this._adresa_oficiu == null && this._adresa_preluare == null) {
                this._validator.addError(1, "R27.1", "", this._validator.fillParams("adresa_oficiu (@0@) si adresa_preluare (@1@) nu pot fi simultan necompletate", new Object[]{this._adresa_oficiu, this._adresa_preluare}));
            }
            if (this._jud_preluare != null && this._adresa_preluare == null && this._adresa_oficiu == null) {
                this._validator.addError(1, "R27.1", "", this._validator.fillParams("judet preluare/oficiu si (adresa preluare sau adresa oficiu ) trebuie sa fie simultan nule sau simultan nenule ", new Object[]{this._adresa_oficiu, this._adresa_preluare}));
            }
            if (this._jud_preluare == null && (this._adresa_preluare != null || this._adresa_oficiu != null)) {
                this._validator.addError(1, "R27.2", "", this._validator.fillParams("judet preluare/oficiu si (adresa preluare sau adresa oficiu ) trebuie sa fie simultan nule sau simultan nenule ", new Object[]{this._adresa_oficiu, this._adresa_preluare}));
            }
            if (this._mod_f == 1L && this._iban == null) {
                this._validator.addError(1, "R29", "", this._validator.fillParams("mod=1 (@0@) daca si numai daca iban (@1@) este completat", new Object[]{this._mod, this._iban}));
            }
            if (this._iban != null && this._iban != "" && this._validator.validareIban(this._iban) < 0) {
                this._validator.addError(31, "Riban", "", this._validator.fillParams("cont IBAN (@0@) incorect", new Object[]{this._iban}), 0);
            }
            if (this._mod_f == 2L && this._den_receptionat == null) {
                this._validator.addError(1, "R30", "", this._validator.fillParams("mod=2 (@0@) daca si numai daca den_receptionat (@1@) este completat", new Object[]{this._mod, this._den_receptionat}));
            }
        }
        if (this._cif_expeditor_str != null && this._cod_tara_str_f == 0L) {
            this._validator.addError(1, "R36", "", this._validator.fillParams("cif_expeditor_str si cod_tara_str sunt simultan nule sau simultan nenule", new Object[]{this._mod, this._den_receptionat}));
        }
        if (this._cif_expeditor_str == null && this._cod_tara_str_f > 0L) {
            this._validator.addError(1, "R36", "", this._validator.fillParams("cif_expeditor_str si cod_tara_str sunt simultan nule sau simultan nenule", new Object[]{this._mod, this._den_receptionat}));
        }
        if (this._cif_expeditor_str != null && this._cif_expeditor != null) {
            this._validator.addError(1, "R35", "", this._validator.fillParams("cif_expeditor_str si cif_expeditor nu pot fi simultan nenule", new Object[]{this._mod, this._den_receptionat}));
        }
    }

    public void initialization() {
        this._nr_doc = null;
        this._nr_doc_ok = false;
        this._data_doc = null;
        this._data_doc_f = null;
        this._data_doc_ok = false;
        this._val_ramb = null;
        this._val_ramb_f = 0.0;
        this._val_ramb_ok = false;
        this._den_expeditor = null;
        this._den_expeditor_ok = false;
        this._cif_expeditor = null;
        this._cif_expeditor_ok = false;
        this._jud_preluare = null;
        this._jud_preluare_ok = false;
        this._adresa_preluare = null;
        this._adresa_preluare_ok = false;
        this._adresa_oficiu = null;
        this._adresa_oficiu_ok = false;
        this._mod = null;
        this._mod_f = 0L;
        this._mod_ok = false;
        this._iban = null;
        this._iban_ok = false;
        this._den_receptionat = null;
        this._den_receptionat_ok = false;
        this._den_destinatar = null;
        this._den_destinatar_ok = false;
        this._rec_s = null;
        this._rec_s_ok = false;
        this._cif_declarant_ok = false;
        this._cif_expeditor_str = null;
        this._cif_expeditor_str_ok = false;
        this._cod_tara_str = null;
        this._cod_tara_str_f = 0L;
        this._cod_tara_str_ok = false;
    }

    private Object SimpleDateFormat(String ddmmyyyy) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

