/*
 * Decompiled with CFR 0.152.
 */
package d205validator.v0;

import d205validator.v0.CheckCNP;
import d205validator.v0.DataObjectRoot;
import d205validator.v0.Identificare;
import d205validator.v0.ValidatorImpl;
import dec.DECConst;
import java.util.Arrays;

public class Benef
extends DataObjectRoot {
    String tip_venit1;
    String den1;
    String cif1;
    long cif1_f;
    String tip_plata;
    long tip_plata_f;
    String castig1;
    long castig1_f;
    String pierdere1;
    long pierdere1_f;
    String tip_functie;
    long tip_functie_f;
    String Vbrut;
    long Vbrut_f;
    String dedu_pers;
    long dedu_pers_f;
    String dedu_alte;
    long dedu_alte_f;
    String baza1;
    long baza1_f;
    String imp1;
    long imp1_f;
    String cheie_unica;
    boolean flag_venit1_ok;

    public Benef(ValidatorImpl validator, DataObjectRoot parent) {
        super(validator, parent);
    }

    public void checkTag(int codTag) {
        this.startValidation(codTag);
        this.tip_venit1 = this._validator.nextAttributeInList(this._params.nomencl_ven, "tip_venit1", 2, 4, 1);
        this.flag_venit1_ok = this._validator._attributeOK;
        this.den1 = this._validator.nextAttribute("den1", 100, 4, 1);
        this.cif1 = this._validator.nextAttribute("cif1", 13, 4, 1);
        if (this.cif1 != null) {
            if (this.cif1.length() <= 10) {
                if (new CheckCNP().checkCUI(this.cif1) < 0) {
                    this._validator.addError(1, "R29", "", this._validator.fillParams("cif1(@0@) este invalid", new Object[]{this.cif1}));
                }
            } else if (new CheckCNP().checkNIF(this.cif1) < 0) {
                this._validator.addError(1, "R29", "", this._validator.fillParams("cif1(@0@) este invalid", new Object[]{this.cif1}));
            }
        }
        this.tip_plata = this._validator.nextAttributeInInterval(1L, 2L, "tip_plata", 0, 1, 1);
        this.tip_plata_f = this._validator._integerValue;
        this.castig1 = this._validator.nextAttributeInInterval(0L, DECConst.LONG_15, "castig1", 0, 1, 0);
        this.castig1_f = this._validator._integerValue;
        this.pierdere1 = this._validator.nextAttributeInInterval(0L, DECConst.LONG_15, "pierdere1", 0, 1, 0);
        this.pierdere1_f = this._validator._integerValue;
        this.tip_functie = this._validator.nextAttributeInInterval(1L, 2L, "tip_functie", 0, 1, 0);
        this.tip_functie_f = this._validator._integerValue;
        this.Vbrut = this._validator.nextAttributeInInterval(0L, DECConst.LONG_15, "vbrut", 0, 1, 0);
        this.Vbrut_f = this._validator._integerValue;
        this.dedu_pers = this._validator.nextAttributeInInterval(0L, DECConst.LONG_15, "dedu_pers", 0, 1, 0);
        this.dedu_pers_f = this._validator._integerValue;
        this.dedu_alte = this._validator.nextAttributeInInterval(0L, DECConst.LONG_15, "dedu_alte", 0, 1, 0);
        this.dedu_alte_f = this._validator._integerValue;
        this.baza1 = this._validator.nextAttributeInInterval(0L, DECConst.LONG_15, "baza1", 0, 1, 1);
        this.baza1_f = this._validator._integerValue;
        this.imp1 = this._validator.nextAttributeInInterval(0L, DECConst.LONG_15, "imp1", 0, 1, 1);
        this.imp1_f = this._validator._integerValue;
        this.endValidation(codTag);
    }

    public void aggregation(int codTag) {
        long val = 0L;
        if (this.tip_plata_f == 1L && Arrays.binarySearch(this._params.r30_1, this.tip_venit1) < 0) {
            this._validator.addError(1, "R30", "tip plata eronat", this._validator.fillParams("tip_plata(@0@) nu corespunde cu tip_venit(@1@) la cif1=@2@", new Object[]{this.tip_plata, this.tip_venit1, this.cif1}));
        }
        if (this.tip_plata_f == 2L && Arrays.binarySearch(this._params.r30_2, this.tip_venit1) < 0) {
            this._validator.addError(1, "R30", "tip plata eronat", this._validator.fillParams("tip_plata(@0@) nu corespunde cu tip_venit(@1@) la cif1=@2@", new Object[]{this.tip_plata, this.tip_venit1, this.cif1}));
        }
        if (this.tip_venit1 != null && !this.tip_venit1.equals("05") && !this.tip_venit1.equals("06") && this.castig1_f > 0L) {
            this._validator.addError(1, "R31", "campul castig nu se completeaza pt. tip_venit1<>05,06", this._validator.fillParams("pentru tip_venit1(@0@), castig1(@1@)=0 la cif1=@2@", new Object[]{this.tip_venit1, this.castig1, this.cif1}));
        }
        if (this.tip_venit1 != null && !this.tip_venit1.equals("05") && !this.tip_venit1.equals("06") && this.pierdere1_f > 0L) {
            this._validator.addError(1, "R32", "campul pierdere nu se completeaza pt. tip_venit1<>05,06", this._validator.fillParams("pentru tip_venit1(@0@), pierdere1(@1@)=0 la cif1=@2@", new Object[]{this.tip_venit1, this.pierdere1, this.cif1}));
        }
        if (this.tip_venit1 != null && !this.tip_venit1.equals("07") && this.tip_functie_f > 0L) {
            this._validator.addError(1, "R33", "campul tip_functie nu se completeaza pt. tip_venit1<>07", this._validator.fillParams("pentru tip_venit1(@0@), tip_functie(@1@) nu se completeaza la cif1=@2@", new Object[]{this.tip_venit1, this.tip_functie, this.cif1}));
        }
        if (this.tip_venit1 != null && this.tip_venit1.equals("07") && this.tip_functie == null) {
            this._validator.addError(1, "R33.1", "campul tip_functie  se completeaza pt. tip_venit1=07", this._validator.fillParams("pentru tip_venit1=07, tip_functie(@0@)  este 1 sau 2 la cif1=@1@", new Object[]{this.tip_functie, this.cif1}));
        }
        if (this.tip_venit1 != null && !this.tip_venit1.equals("07") && this.Vbrut_f > 0L) {
            this._validator.addError(1, "R34", "campul Vbrut nu se completeaza pt. tip_venit1<>07", this._validator.fillParams("pentru tip_venit1(@0@), Vbrut(@1@) nu se completeaza la cif1=@2@", new Object[]{this.tip_venit1, this.Vbrut, this.cif1}));
        }
        if (this.tip_venit1 != null && this.tip_venit1.equals("07") && this.Vbrut == null) {
            this._validator.addError(1, "R34.1", " campul vbrut necompletat pt. tip_venit1=07", this._validator.fillParams("pentru tip_venit1(@0@), Vbrut se completeaza la cif1=@1@", new Object[]{this.tip_venit1, this.cif1}));
        }
        if (this.tip_venit1 != null && !this.tip_venit1.equals("07") && this.dedu_pers_f > 0L) {
            this._validator.addError(1, "R35", "campul dedu_pers nu se completeaza pt. tip_venit1<>07", this._validator.fillParams("pentru tip_venit1(@0@), dedu_pers(@1@) nu se completeaza la cif1=@2@", new Object[]{this.tip_venit1, this.dedu_pers, this.cif1}));
        }
        if (this.tip_venit1 != null && this.tip_venit1.equals("07") && this.tip_functie_f == 2L && this.dedu_pers_f > 0L) {
            this._validator.addError(1, "R35.1", "campul dedu_pers nu se completeaza pt. tip_venit1=07 si tip_functie =2", this._validator.fillParams("pentru tip_venit1(@0@), tip_functie_f(@1@), dedu_pers_f(@2@) nu se completeaza la cif1=@3@", new Object[]{this.tip_venit1, this.tip_functie, this.dedu_pers, this.cif1}));
        }
        if (this.tip_venit1 != null && this.tip_venit1.equals("07") && this.dedu_pers_f > 7800L) {
            this._validator.addError(1, "R35.2", "valoarea campului dedu_pers trebuie sa fie pozitiva sau egala cu 0 si mai mica sau egala cu 7800", this._validator.fillParams("pentru tip_venit1(@0@), dedu_pers_f(@1@) trebuie sa fie < sau = cu 7800 la cif1=@2@", new Object[]{this.tip_venit1, this.dedu_pers, this.cif1}));
        }
        if (this.tip_venit1 != null && !this.tip_venit1.equals("07") && this.dedu_alte_f > 0L) {
            this._validator.addError(1, "R36", "campul dedu_alte nu se completeaza pt. tip_venit1<>07", this._validator.fillParams("pentru tip_venit1(@0@), dedu_alte(@1@) nu se completeaza la cif1=@2@", new Object[]{this.tip_venit1, this.dedu_alte, this.cif1}));
        }
        if (this.tip_venit1 != null && this.tip_venit1.equals("07") && this.tip_functie_f == 2L && this.dedu_alte_f > 0L) {
            this._validator.addError(1, "R36.1", "campul dedu_alte nu se completeaza pt. tip_venit1=07 si tip_functie =2", this._validator.fillParams("pentru tip_venit1(@0@), tip_functie_f(@1@), dedu_alte_f(@2@) nu se completeaza la cif1=@3@", new Object[]{this.tip_venit1, this.tip_functie, this.dedu_alte, this.cif1}));
        }
        if (this.tip_venit1 != null && this.tip_venit1.equals("05") && this.baza1_f != this.castig1_f) {
            this._validator.addError(1, "R37", "baza1<>castig pt. tip_venit1=05", this._validator.fillParams("pentru tip_venit1(@0@), baza1(@1@)=castig1(@2@) la cif1=@3@", new Object[]{this.tip_venit1, this.baza1, this.castig1, this.cif1}));
        }
        if (this.tip_venit1 != null && this.tip_venit1.equals("06") && this.baza1_f != 0L) {
            this._validator.addError(1, "R37.2", "  valoare camp baza1   trebuie sa fie 0 pt. tip venit=06", this._validator.fillParams("pentru tip_venit1(@0@), baza1(@1@)=0 la cif1=@2@", new Object[]{this.tip_venit1, this.baza1, this.cif1}));
        }
        if (this.tip_venit1 != null && this.tip_venit1.equals("06") && this.imp1_f != 0L) {
            this._validator.addError(1, "R38", "campul imp1<>0 pt. tip_venit1=06", this._validator.fillParams("pentru tip_venit1(@0@), imp1(@1@) trebuie sa fie 0 la cif1=@2@", new Object[]{this.tip_venit1, this.imp1, this.cif1}));
        }
        Identificare _ident = (Identificare)this._parent;
        if (this.flag_venit1_ok) {
            _ident._agg_benef_nrben.put(this.tip_venit1, (Long)_ident._agg_benef_nrben.get(this.tip_venit1) + 1L);
            _ident._agg_benef_Tcastig.put(this.tip_venit1, (Long)_ident._agg_benef_Tcastig.get(this.tip_venit1) + this.castig1_f);
            _ident._agg_benef_Tpierdere.put(this.tip_venit1, (Long)_ident._agg_benef_Tpierdere.get(this.tip_venit1) + this.pierdere1_f);
            _ident._agg_benef_Tbaza.put(this.tip_venit1, (Long)_ident._agg_benef_Tbaza.get(this.tip_venit1) + this.baza1_f);
            _ident._agg_benef_Timp.put(this.tip_venit1, (Long)_ident._agg_benef_Timp.get(this.tip_venit1) + this.imp1_f);
        }
        this.cheie_unica = this.tip_venit1 + "_" + this.tip_plata + "_" + this.tip_functie + "_" + this.cif1;
        if (_ident._agg_s.contains(this.cheie_unica)) {
            this._validator.addError(1, "R41", "(tip_venit1 + tip_plata + tip_functie + cif1)     cheie unica", this._validator.fillParams("combinatia @0@ nu este unica la cif1=@1@", new Object[]{this.cheie_unica, this.cif1}));
        } else {
            _ident._agg_s.add(this.cheie_unica);
        }
    }

    public void initialization() {
        this.flag_venit1_ok = true;
        this.tip_venit1 = null;
        this.den1 = null;
        this.cif1 = null;
        this.cif1_f = 0L;
        this.tip_plata = null;
        this.tip_plata_f = 0L;
        this.castig1 = null;
        this.castig1_f = 0L;
        this.pierdere1 = null;
        this.pierdere1_f = 0L;
        this.tip_functie = null;
        this.tip_functie_f = 0L;
        this.Vbrut = null;
        this.Vbrut_f = 0L;
        this.dedu_pers = null;
        this.dedu_pers_f = 0L;
        this.dedu_alte = null;
        this.dedu_alte_f = 0L;
        this.baza1 = null;
        this.baza1_f = 0L;
        this.imp1 = null;
        this.imp1_f = 0L;
        this.cheie_unica = null;
    }
}

