/*
 * Decompiled with CFR 0.152.
 */
package d205validator.v8;

public class CheckCNP {
    private static final int[] _monthLen = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    private char[] getBinaryValues(String str) {
        int len = str.length();
        char[] chr = new char[len];
        str.getChars(0, len, chr, 0);
        for (int i = 0; i < len; ++i) {
            char val = chr[i];
            if (val < '0' || val > '9') {
                return null;
            }
            chr[i] = (char)(val - 48);
        }
        return chr;
    }

    public int checkCNP(String cnp) {
        if (cnp.length() == 0) {
            return 0;
        }
        if (cnp.length() != 13) {
            return -1;
        }
        char[] cnp1 = this.getBinaryValues(cnp);
        if (cnp1 == null) {
            return -1;
        }
        char chr = cnp1[0];
        if (chr != '\u0001' && chr != '\u0002' && chr != '\u0005' && chr != '\u0006' && chr != '\u0007' && chr != '\b' && chr != '\u0003' && chr != '\u0004') {
            return -1;
        }
        int year = cnp1[1] * 10 + cnp1[2];
        int month = cnp1[3] * 10 + cnp1[4];
        int day = cnp1[5] * 10 + cnp1[6];
        if (month == 0 || month > 12 || day == 0 || day > _monthLen[month - 1] || month == 2 && day == 29 && year % 4 != 0) {
            return -1;
        }
        day = (cnp1[0] * 2 + cnp1[1] * 7 + cnp1[2] * 9 + cnp1[3] * '\u0001' + cnp1[4] * 4 + cnp1[5] * 6 + cnp1[6] * 3 + cnp1[7] * 5 + cnp1[8] * 8 + cnp1[9] * 2 + cnp1[10] * 7 + cnp1[11] * 9) % 11;
        if (day == 10) {
            day = 1;
        }
        if (day != cnp1[12]) {
            return -1;
        }
        return 0;
    }

    public int checkNIF(String cnp) {
        if (cnp.length() == 0) {
            return 0;
        }
        if (cnp.length() != 13) {
            return -1;
        }
        char[] cnp1 = this.getBinaryValues(cnp);
        if (cnp1 == null) {
            return -1;
        }
        char chr = cnp1[0];
        if (chr == '\t') {
            int val = (cnp1[0] * 2 + cnp1[1] * 7 + cnp1[2] * 9 + cnp1[3] * '\u0001' + cnp1[4] * 4 + cnp1[5] * 6 + cnp1[6] * 3 + cnp1[7] * 5 + cnp1[8] * 8 + cnp1[9] * 2 + cnp1[10] * 7 + cnp1[11] * 9) % 11;
            if (val == 10) {
                val = 1;
            }
            if (val != cnp1[12]) {
                return -1;
            }
        } else {
            return this.checkCNP(cnp);
        }
        return 0;
    }

    int checkCUI(String cui) {
        int i;
        char[] cui2 = new char[10];
        int len = cui.length();
        if (len == 0) {
            return 0;
        }
        if (len > 10 || cui.startsWith("0")) {
            return -1;
        }
        char[] cui1 = this.getBinaryValues(cui);
        if (cui1 == null) {
            return -1;
        }
        for (i = 0; i < 10 - len; ++i) {
            cui2[i] = '\u0000';
        }
        for (i = 0; i < len; ++i) {
            cui2[i + 10 - len] = cui1[i];
        }
        len = (cui2[0] * 7 + cui2[1] * 5 + cui2[2] * 3 + cui2[3] * 2 + cui2[4] * '\u0001' + cui2[5] * 7 + cui2[6] * 5 + cui2[7] * 3 + cui2[8] * 2) * 10 % 11;
        if (len == 10) {
            len = 0;
        }
        if (len != cui2[9]) {
            return -1;
        }
        return 0;
    }
}

