/*
 * Decompiled with CFR 0.152.
 */
package d205validator.v4;

import d205validator.v4.CheckCNP;
import d205validator.v4.DataObjectRoot;
import d205validator.v4.Identificare;
import d205validator.v4.ValidatorImpl;
import dec.DECConst;
import java.util.Arrays;

public class Benef
extends DataObjectRoot {
    String tip_venit1;
    String den1;
    String cif1;
    long cif1_f;
    String tip_plata;
    String castig1;
    long castig1_f;
    String pierdere1;
    long pierdere1_f;
    String Rezid;
    long Rezid_f;
    String Stat_R;
    String cifS;
    String baza1;
    long baza1_f;
    String imp1;
    long imp1_f;
    String cheie_unica;
    boolean flag_venit1_ok;
    String id_inreg;
    long id_inreg_f;

    public Benef(ValidatorImpl validator, DataObjectRoot parent) {
        super(validator, parent);
    }

    public void checkTag(int codTag) {
        Identificare ident = (Identificare)this._parent;
        this.startValidation(codTag);
        this.id_inreg = this._validator.nextAttributeInInterval(DECConst.M_LONG_15, DECConst.LONG_15, "id_inreg", 0, 1, 1);
        this.id_inreg_f = this._validator._integerValue;
        this.tip_venit1 = this._validator.nextAttributeInList(this._params.nomencl_ven, "tip_venit1", 2, 4, 1);
        this.flag_venit1_ok = this._validator._attributeOK;
        this.den1 = this._validator.nextAttribute("den1", 100, 4, 1);
        this.cif1 = this._validator.nextAttribute("cifR", 13, 4, 1);
        if (this.cif1 != null) {
            if (this.cif1.length() <= 10) {
                if (new CheckCNP().checkCUI(this.cif1) < 0) {
                    this._validator.addError(1, "R29", "", this._validator.fillParams("cif1(@0@) este invalid", new Object[]{this.cif1}));
                }
            } else if (new CheckCNP().checkNIF(this.cif1) < 0) {
                this._validator.addError(1, "R29", "", this._validator.fillParams("cif1(@0@) este invalid", new Object[]{this.cif1}));
            }
        }
        this.tip_plata = this._validator.nextAttributeInList(this._params.tip_plata, "tip_plata", 2, 4, 1);
        this.castig1 = this._validator.nextAttributeInInterval(0L, DECConst.LONG_15, "castig1", 0, 1, 0);
        this.castig1_f = this._validator._integerValue;
        this.pierdere1 = this._validator.nextAttributeInInterval(0L, DECConst.LONG_15, "pierdere1", 0, 1, 0);
        this.pierdere1_f = this._validator._integerValue;
        this.Rezid = this._validator.nextAttributeInInterval(1L, 2L, "Rezid", 0, 1, 1);
        this.Rezid_f = this._validator._integerValue;
        this.Stat_R = this._validator.nextAttribute("Stat_R", 2, 4, 0);
        this.cifS = this._validator.nextAttribute("cifS", 20, 4, 0);
        this.baza1 = this._validator.nextAttributeInInterval(0L, DECConst.LONG_15, "baza1", 0, 1, 0);
        this.baza1_f = this._validator._integerValue;
        this.imp1 = this._validator.nextAttributeInInterval(0L, DECConst.LONG_15, "imp1", 0, 1, 0);
        this.imp1_f = this._validator._integerValue;
        this.endValidation(codTag);
    }

    public void aggregation(int codTag) {
        long val = 0L;
        if (this.Rezid_f == 1L && this.cifS != null) {
            this._validator.addError(1, "R35", "", this._validator.fillParams("Daca Rezid=1 atunci cifS nu trebuie completat", new Object[0]));
        }
        if (this.tip_venit1 != null && this.tip_plata != null && this.tip_plata.equals("0") && Arrays.binarySearch(this._params.r30_1, this.tip_venit1) < 0) {
            this._validator.addError(1, "R37", "tip plata eronat", this._validator.fillParams("tip_plata(@0@) nu corespunde cu tip_venit(@1@) la id_inreg=@2@", new Object[]{this.tip_plata, this.tip_venit1, this.id_inreg}));
        }
        if (this.tip_venit1 != null && this.tip_plata != null && this.tip_plata.equals("2") && Arrays.binarySearch(this._params.r30_2, this.tip_venit1) < 0) {
            this._validator.addError(1, "R37", "tip plata eronat", this._validator.fillParams("tip_plata(@0@) nu corespunde cu tip_venit(@1@) la id_inreg=@2@", new Object[]{this.tip_plata, this.tip_venit1, this.id_inreg}));
        }
        if (this.tip_venit1 != null && this.tip_plata != null && this.tip_plata.equals("3") && this.tip_venit1 != null && !this.tip_venit1.equals("22")) {
            this._validator.addError(1, "R37", "tip plata eronat", this._validator.fillParams("tip_plata(@0@) nu corespunde cu tip_venit(@1@) la id_inreg=@2@", new Object[]{this.tip_plata, this.tip_venit1, this.id_inreg}));
        }
        if (this.tip_venit1 != null && !this.tip_venit1.equals("21") && !this.tip_venit1.equals("22") && this.castig1_f > 0L) {
            this._validator.addError(1, "R38", "campul castig nu se completeaza pt. tip_venit1<>21,22", this._validator.fillParams("pentru tip_venit1(@0@), castig1(@1@)=0 la id_inreg=@2@", new Object[]{this.tip_venit1, this.castig1, this.id_inreg}));
        }
        if (this.tip_venit1 != null && !this.tip_venit1.equals("22") && this.pierdere1_f > 0L) {
            this._validator.addError(1, "R39", "campul pierdere nu se completeaza pt. tip_venit1<>22", this._validator.fillParams("pentru tip_venit1(@0@), pierdere1(@1@)=0 la id_inreg=@2@", new Object[]{this.tip_venit1, this.pierdere1, this.id_inreg}));
        }
        if (this.tip_venit1 != null && !this.tip_venit1.equals("21") && !this.tip_venit1.equals("22") && this.castig1_f > 0L) {
            this._validator.addError(1, "R44", "campul baza de calcul a impozitului nu se completeaza pt. tip_venit1<>21,22", this._validator.fillParams("pentru tip_venit1(@0@), baza1(@1@)=0 la id_inreg=@2@", new Object[]{this.tip_venit1, this.baza1, this.id_inreg}));
        }
        if (this.tip_venit1 != null && !this.tip_venit1.equals("22") && !this.tip_venit1.equals("21") && this.pierdere1_f > 0L) {
            this._validator.addError(1, "R45", "campul impozit retinut nu se completeaza pt. tip_venit1<>21,22", this._validator.fillParams("pentru tip_venit1(@0@), imp1(@1@)=0 la id_inreg=@2@", new Object[]{this.tip_venit1, this.imp1, this.id_inreg}));
        }
        Identificare _ident = (Identificare)this._parent;
        if (this.flag_venit1_ok) {
            if (_ident._agg_benef_nrben != null) {
                _ident._agg_benef_nrben.put(this.tip_venit1, (_ident._agg_benef_nrben.get(this.tip_venit1) == null ? Long.valueOf(0L) : _ident._agg_benef_nrben.get(this.tip_venit1)) + 1L);
            }
            if (_ident._agg_benef_Tcastig != null) {
                _ident._agg_benef_Tcastig.put(this.tip_venit1, (_ident._agg_benef_Tcastig.get(this.tip_venit1) == null ? Long.valueOf(0L) : _ident._agg_benef_Tcastig.get(this.tip_venit1)) + this.castig1_f);
            }
            if (_ident._agg_benef_Tpierdere != null) {
                _ident._agg_benef_Tpierdere.put(this.tip_venit1, (_ident._agg_benef_Tpierdere.get(this.tip_venit1) == null ? Long.valueOf(0L) : _ident._agg_benef_Tpierdere.get(this.tip_venit1)) + this.pierdere1_f);
            }
            if (_ident._agg_benef_Tbaza != null) {
                _ident._agg_benef_Tbaza.put(this.tip_venit1, (_ident._agg_benef_Tbaza.get(this.tip_venit1) == null ? Long.valueOf(0L) : _ident._agg_benef_Tbaza.get(this.tip_venit1)) + this.baza1_f);
            }
            if (_ident._agg_benef_Timp != null) {
                _ident._agg_benef_Timp.put(this.tip_venit1, (_ident._agg_benef_Timp.get(this.tip_venit1) == null ? Long.valueOf(0L) : _ident._agg_benef_Timp.get(this.tip_venit1)) + this.imp1_f);
            }
        }
        if (this.tip_venit1 != null && !this.tip_venit1.equals("21")) {
            this.cheie_unica = this.tip_venit1 + "_" + this.tip_plata + "_" + this.cif1;
            if (_ident._agg_s.contains(this.cheie_unica)) {
                this._validator.addError(1, "R41", "(tip_venit1 + tip_plata  + cif1)     cheie unica", this._validator.fillParams("combinatia @0@ nu este unica la id_inreg=@1@", new Object[]{this.cheie_unica, this.id_inreg}));
            } else {
                _ident._agg_s.add(this.cheie_unica);
            }
            if (this.id_inreg != null) {
                if (_ident._agg_id.contains(this.id_inreg)) {
                    this._validator.addError(1, "R27", "", this._validator.fillParams("id-ul @0@ nu este unic", new Object[]{this.id_inreg}));
                } else {
                    _ident._agg_id.add(this.id_inreg);
                }
            }
        }
    }

    public void initialization() {
        this.flag_venit1_ok = true;
        this.tip_venit1 = null;
        this.den1 = null;
        this.cif1 = null;
        this.cif1_f = 0L;
        this.tip_plata = null;
        this.castig1 = null;
        this.castig1_f = 0L;
        this.pierdere1 = null;
        this.pierdere1_f = 0L;
        this.Rezid = null;
        this.Rezid_f = 0L;
        this.Stat_R = null;
        this.cifS = null;
        this.baza1 = null;
        this.baza1_f = 0L;
        this.imp1 = null;
        this.imp1_f = 0L;
        this.cheie_unica = null;
        this.id_inreg = null;
        this.id_inreg_f = 0L;
    }
}

