/*
 * Decompiled with CFR 0.152.
 */
package d204validator.v2;

import d204validator.v2.DataObjectRoot;
import d204validator.v2.ValidatorImpl;
import dec.DECConst;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Produse
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_PRODUSE = 0;
    String _nume;
    long _nume_f;
    boolean _nume_ok;
    String _supr;
    double _supr_f;
    boolean _supr_ok;
    String _suprImp;
    double _suprImp_f;
    boolean _suprImp_ok;
    String _suprNimp;
    double _suprNimp_f;
    boolean _suprNimp_ok;
    String _norma;
    double _norma_f;
    boolean _norma_ok;
    String _normaRed;
    double _normaRed_f;
    boolean _normaRed_ok;
    String _venit;
    long _venit_f;
    boolean _venit_ok;

    public Produse(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._nume = this._validator.nextAttributeInList(this._params._nume, "nume", 0, 1, 1);
        this._nume_f = this._validator._integerValue;
        this._nume_ok = this._validator._attributeOK;
        this._supr = this._validator.nextAttributeDblPattern(0.0, null, 13, 2, "supr", 1);
        this._supr_f = this._validator._realValue;
        this._supr_ok = this._validator._attributeOK;
        this._suprImp = this._validator.nextAttributeDblPattern(0.0, null, 13, 2, "suprImp", 1);
        this._suprImp_f = this._validator._realValue;
        this._suprImp_ok = this._validator._attributeOK;
        this._suprNimp = this._validator.nextAttributeDblPattern(0.0, null, 5, 2, "suprNimp", 0);
        this._suprNimp_f = this._validator._realValue;
        this._suprNimp_ok = this._validator._attributeOK;
        this._norma = this._validator.nextAttributeDblPattern(0.0, null, 13, 2, "norma", 1);
        this._norma_f = this._validator._realValue;
        this._norma_ok = this._validator._attributeOK;
        this._normaRed = this._validator.nextAttributeDblPattern(0.0, null, 13, 2, "normaRed", 0);
        this._normaRed_f = this._validator._realValue;
        this._normaRed_ok = this._validator._attributeOK;
        this._venit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "venit", 0, 1, 1);
        this._venit_f = this._validator._integerValue;
        this._venit_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        if (this._supr_f <= 0.0) {
            this._validator.addError(1, "R63", "", this._validator.fillParams("Total suprafata trebuie sa fie > 0", new Object[]{this._supr}));
        }
        double d = 0.0;
        if (this._supr_f > this._suprNimp_f) {
            d = this._supr_f - this._suprNimp_f;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        if (this._suprImp_f != (bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP)).doubleValue()) {
            this._validator.addError(1, "R64", "", this._validator.fillParams("nr_unit_impoz (@0@) diferit de suma calculata (@1@)", new Object[]{Double.toString(this._suprImp_f), Double.toString(bigDecimal.doubleValue())}));
        }
        if (this._normaRed_f > this._norma_f) {
            this._validator.addError(1, "R67", "", this._validator.fillParams(" Norma de venit redusa (@0@) trebuie sa fie mai mica sau egala cu norma de venit (@1@)", new Object[]{this._normaRed, this._norma}));
        }
        long l = 0L;
        if (this._normaRed != null) {
            l = Math.round(this._normaRed_f * this._suprImp_f);
            if (this._venit_f != l) {
                this._validator.addError(1, "R68", "", this._validator.fillParams("daca norma de venit redusa (@0@) este completata atunci venit net anual impozabil (@1@) trebuie sa fie egal cu norma de venit redusa * suprafata neimpozabila (@2@)", new Object[]{this._normaRed, this._venit, Long.toString(l)}));
            }
        } else if (this._norma != null && this._venit_f != (l = Math.round(this._norma_f * this._suprImp_f))) {
            this._validator.addError(1, "R68", "", this._validator.fillParams("daca norma de venit redusa este necompletata atunci venit net anual impozabil (@0@) trebuie sa fie egal cu norma de venit * suprafata neimpozabila (@1@)", new Object[]{this._venit, Long.toString(l)}));
        }
    }

    public void initialization() {
        this._nume = null;
        this._nume_f = 0L;
        this._nume_ok = false;
        this._supr = null;
        this._supr_f = 0.0;
        this._supr_ok = false;
        this._suprImp = null;
        this._suprImp_f = 0.0;
        this._suprImp_ok = false;
        this._suprNimp = null;
        this._suprNimp_f = 0.0;
        this._suprNimp_ok = false;
        this._norma = null;
        this._norma_f = 0.0;
        this._norma_ok = false;
        this._normaRed = null;
        this._normaRed_f = 0.0;
        this._normaRed_ok = false;
        this._venit = null;
        this._venit_f = 0L;
        this._venit_ok = false;
    }
}

