/*
 * Decompiled with CFR 0.152.
 */
package d204validator.v2;

import d204validator.v2.D204;
import d204validator.v2.DataObjectRoot;
import d204validator.v2.ValidatorImpl;
import dec.DECConst;

public class Asociat
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_ASOCIAT = 0;
    String _nume_d;
    boolean _nume_d_ok;
    String _cif_d;
    boolean _cif_d_ok;
    String _dom_d;
    boolean _dom_d_ok;
    String _cota_d;
    double _cota_d_f;
    boolean _cota_d_ok;
    String _venit_d;
    long _venit_d_f;
    boolean _venit_d_ok;
    String _pierd_d;
    long _pierd_d_f;
    boolean _pierd_d_ok;

    public Asociat(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._nume_d = this._validator.nextAttribute("nume_d", 75, 4, 1);
        this._nume_d_ok = this._validator._attributeOK;
        this._cif_d = this._validator.nextAttributeAsNif("cif_d", 1);
        this._cif_d_ok = this._validator._attributeOK;
        this._dom_d = this._validator.nextAttribute("dom_d", 200, 4, 0);
        this._dom_d_ok = this._validator._attributeOK;
        this._cota_d = this._validator.nextAttributeDblPattern(0.0, 100.0, 3, 2, "cota_d", 1);
        this._cota_d_f = this._validator._realValue;
        this._cota_d_ok = this._validator._attributeOK;
        this._venit_d = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "venit_d", 0, 1, 1);
        this._venit_d_f = this._validator._integerValue;
        this._venit_d_ok = this._validator._attributeOK;
        this._pierd_d = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "pierd_d", 0, 1, 1);
        this._pierd_d_f = this._validator._integerValue;
        this._pierd_d_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        long l = 0L;
        D204 d204 = (D204)this._parent;
        d204._agregareCota += Math.round(this._cota_d_f * 100.0);
        d204._agregareVenit += this._venit_d_f;
        d204._agregarePierdere += this._pierd_d_f;
        if (this._cota_d_f > 100.0) {
            this._validator.addError(1, "R52", "", this._validator.fillParams(" cota_d (@0@) nu poate fi mai mare de 100", new Object[]{this._cota_d}), 0);
        }
        l = (long)(this._cota_d_f * (double)d204._net3_f);
        if (Math.abs(this._venit_d_f - (l /= 100L)) > 1L) {
            this._validator.addError(1, "R57.2", "", this._validator.fillParams("diferenta dintre venitul net estimat distribuit (@0@) si venitul net distribuit calculat (@1@) depaseste marja +-1", new Object[]{this._venit_d, Long.toString(l)}), 0);
        }
        l = (long)(this._cota_d_f * (double)d204._pierd3_f);
        if (Math.abs(this._pierd_d_f - (l /= 100L)) > 1L) {
            this._validator.addError(1, "R58.2", "", this._validator.fillParams("diferenta dintre pierderea distribuita (@0@) si pierderea fiscala calculata (@1@) depaseste marja +-1", new Object[]{this._pierd_d, Long.toString(l)}), 0);
        }
    }

    public void initialization() {
        this._nume_d = null;
        this._nume_d_ok = false;
        this._cif_d = null;
        this._cif_d_ok = false;
        this._dom_d = null;
        this._dom_d_ok = false;
        this._cota_d = null;
        this._cota_d_f = 0.0;
        this._cota_d_ok = false;
        this._venit_d = null;
        this._venit_d_f = 0L;
        this._venit_d_ok = false;
        this._pierd_d = null;
        this._pierd_d_f = 0L;
        this._pierd_d_ok = false;
    }
}

