/*
 * Decompiled with CFR 0.152.
 */
package d112validator.v28;

import d112validator.Parameters;
import d112validator.v28.Angajator;
import d112validator.v28.AngajatorA;
import d112validator.v28.AngajatorF2;
import d112validator.v28.AngajatorG;
import d112validator.v28.Asigurat;
import d112validator.v28.AsiguratA;
import d112validator.v28.AsiguratA1;
import d112validator.v28.AsiguratB1;
import d112validator.v28.AsiguratB2;
import d112validator.v28.AsiguratB41;
import d112validator.v28.AsiguratC;
import d112validator.v28.AsiguratD;
import d112validator.v28.AsiguratDet1;
import d112validator.v28.AsiguratE1;
import d112validator.v28.AsiguratE2;
import d112validator.v28.AsiguratE3;
import d112validator.v28.AsiguratE4;
import d112validator.v28.CoAsigurati;
import d112validator.v28.Const;
import d112validator.v28.DUKTag;
import d112validator.v28.DbAccessImpl;
import dec.DECValidation;
import dec.Info;
import dec.LogTrace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidatorImpl
extends DefaultHandler
implements DECValidation {
    public String DEC_NAMESPACE = "mfp:anaf:dgti:declaratie_unica:declaratie:v6";
    long _integerValue;
    double _realValue;
    Date _dateValue;
    String _stringValue;
    boolean _attributeExists;
    static SimpleDateFormat _dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    static String _nl = System.getProperty("line.separator");
    Pattern _dblPattern = Pattern.compile("\\.");
    Pattern _emailPattern = Pattern.compile("[A-Za-z0-9._%-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}");
    long _option;
    private String _xmlFile;
    private String _errFile;
    private Attributes _attrib;
    private OutputStreamWriter _errorFile;
    private String _idAsig;
    private int _errorStatus;
    private String[] _tagNameStack = new String[3];
    private int[] _countStack = new int[3];
    private int _indStack;
    private int _tagCount;
    private int _tagDepth;
    private boolean[] _tagStack = new boolean[10];
    private int _tagStackInd;
    private String _lastTag;
    private int _status;
    private static final int[] _monthLen = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int ID_DECLARATIEUNICA = 0;
    static final int ID_ANGAJATOR = 1;
    static final int ID_ANGAJATORA = 2;
    static final int ID_ANGAJATORB = 3;
    static final int ID_ANGAJATORC1 = 4;
    static final int ID_ANGAJATORC2 = 5;
    static final int ID_ANGAJATORC3 = 6;
    static final int ID_ANGAJATORC4 = 7;
    static final int ID_ANGAJATORC5 = 8;
    static final int ID_ANGAJATORC6 = 9;
    static final int ID_ANGAJATORC7 = 10;
    static final int ID_ANGAJATORD = 11;
    static final int ID_ANGAJATORE1 = 12;
    static final int ID_ANGAJATORE2 = 13;
    static final int ID_ANGAJATORE3 = 14;
    static final int ID_ANGAJATORE4 = 15;
    static final int ID_ANGAJATORF1 = 16;
    static final int ID_ANGAJATORF2 = 17;
    static final int ID_ASIGURAT = 18;
    static final int ID_COASIGURATI = 19;
    static final int ID_ASIGURATA = 20;
    static final int ID_ASIGURATB1 = 21;
    static final int ID_ASIGURATB11 = 22;
    static final int ID_ASIGURATB2 = 23;
    static final int ID_ASIGURATB3 = 24;
    static final int ID_ASIGURATB4 = 25;
    static final int ID_ASIGURATC = 26;
    static final int ID_ASIGURATD = 27;
    static final int ID_ASIGURATE1 = 28;
    static final int ID_ASIGURATE2 = 29;
    static final int ID_ASIGURATE3 = 30;
    static final int ID_ANGAJATORG = 31;
    static final int ID_ASIGURATE4 = 32;
    static final int ID_ASIGURATA1 = 33;
    static final int ID_ASIGURATB41 = 34;
    static final int ID_ASIGURATDET1 = 35;
    public static final int MAX_OCC_ANGAJATORA = 65;
    public static final int MAX_OCC_ANGAJATORC5 = 11;
    public static final int MAX_OCC_ANGAJATORF2 = 2000;
    public static final int MAX_OCC_COASIGURATI = 3;
    public static final int MAX_OCC_ASIGURATB1 = 10;
    public static final int MAX_OCC_ASIGURATB11 = 100;
    public static final int MAX_OCC_ASIGURATD = 10;
    public static final int MAX_OCC_ASIGURATC = 10;
    public static final int MAX_OCC_ASIGURATE3 = 20;
    public static final int MAX_OCC_ASIGURATE4 = 10;
    public static final int MAX_OCC_ANGAJATORG = 100;
    private static DUKTag[] _tags = new DUKTag[]{new DUKTag("declaratieUnica", 0, 0, true), new DUKTag("angajator", 1, 1, true), new DUKTag("angajatorA", 2, 2), new DUKTag("angajatorB", 3, 2), new DUKTag("angajatorC1", 4, 2), new DUKTag("angajatorC2", 5, 2), new DUKTag("angajatorC3", 6, 2), new DUKTag("angajatorC4", 7, 2), new DUKTag("angajatorC5", 8, 2), new DUKTag("angajatorD", 11, 2), new DUKTag("angajatorE1", 12, 2), new DUKTag("angajatorE2", 13, 2), new DUKTag("angajatorE3", 14, 2), new DUKTag("angajatorE4", 15, 2), new DUKTag("angajatorF1", 16, 2), new DUKTag("angajatorF2", 17, 2), new DUKTag("angajatorG", 31, 2), new DUKTag("asigurat", 18, 1, true), new DUKTag("det1", 35, 2), new DUKTag("coAsigurati", 19, 2), new DUKTag("asiguratA", 20, 2), new DUKTag("asiguratA1", 33, 2), new DUKTag("asiguratB1", 21, 2, true), new DUKTag("asiguratB2", 23, 2), new DUKTag("asiguratB3", 24, 2), new DUKTag("asiguratB4", 25, 2), new DUKTag("asiguratB41", 34, 2), new DUKTag("asiguratC", 26, 2), new DUKTag("asiguratD", 27, 2), new DUKTag("asiguratE1", 28, 2), new DUKTag("asiguratE2", 29, 2), new DUKTag("asiguratE3", 30, 2, true), new DUKTag("asiguratE4", 32, 2)};
    private HashSet<String> _attribFullList;
    private boolean _emptyAttribListFlag;
    private int _effectiveAttribCount;
    private DbAccessImpl _dbObj = null;
    private boolean _writeDB;
    private Object _params = null;
    public Info _info = null;
    private Angajator _angajator = null;
    private AngajatorA[] _angajatorA = new AngajatorA[65];
    private int _cntAngajatorA;
    private int _cntAngajatorC5;
    private AngajatorF2[] _angajatorF2 = new AngajatorF2[2000];
    private int _cntAngajatorF2;
    private AngajatorG[] _angajatorG = new AngajatorG[100];
    private int _cntAngajatorG;
    private Asigurat _asigurat;
    long _cntAsigurat;
    private CoAsigurati[] _coAsigurati = new CoAsigurati[3];
    private int _cntCoAsigurati;
    private AsiguratDet1[] _AsiguratDet1 = new AsiguratDet1[100];
    private int _cntAsiguratDet1;
    private AsiguratA _asiguratA;
    private AsiguratA1 _asiguratA1;
    private AsiguratB2 _asiguratB2;
    private AsiguratB41 _asiguratB41;
    private AsiguratB1[] _asiguratB1 = new AsiguratB1[10];
    private int _cntAsiguratB1;
    private int _cntAsiguratB11;
    private int _indAsiguratB11perB1;
    private AsiguratC[] _asiguratC = new AsiguratC[10];
    private AsiguratD[] _asiguratD = new AsiguratD[10];
    private AsiguratE1 _asiguratE1;
    private AsiguratE2 _asiguratE2;
    private AsiguratE4[] _asiguratE4 = new AsiguratE4[10];
    private AsiguratE3[] _asiguratE3 = new AsiguratE3[20];
    private int _cntAsiguratD;
    private int _cntAsiguratC;
    private int _cntAsiguratE3;
    private int _cntAsiguratE4;
    boolean _existsAngajatorC1;
    boolean _existsAngajatorC2;
    boolean _existsAngajatorC3;
    boolean _existsAngajatorC4;
    boolean _existsAngajatorC5;
    boolean _existsAngajatorD;
    boolean _existsAngajatorE1;
    boolean _existsAngajatorE2;
    boolean _existsAngajatorE3;
    boolean _existsAngajatorE4;
    boolean _existsAngajatorF1;
    boolean _existsAngajatorF2;
    boolean _existsAngajatorG;
    int _asigType;
    boolean _existsAsiguratB2;
    boolean _existsAsiguratB3;
    boolean _existsAsiguratC;
    boolean _existsAsiguratE1;
    boolean _existsAsiguratE2;
    boolean _existsAsiguratE4;
    boolean _existsAsiguratA1;
    boolean _existsAsiguratB41;
    int _extractValuesFlag = 0;

    public int parseDocument(String xmlFile, String errFile, Info info, Object params) {
        int ret = this.parseDocument(xmlFile, errFile, info, params, 0);
        return ret;
    }

    public int parseDocument(String xmlFile, String errFile, Info info, Object params, int extractValuesFlag) {
        int i;
        int level = 2;
        String errMsg = null;
        this._extractValuesFlag = extractValuesFlag;
        this._params = params;
        info._schemaNamespace = null;
        this._info = info;
        this._xmlFile = xmlFile;
        this._errFile = errFile == null || errFile.equals("") ? this._xmlFile + ".err.txt" : errFile;
        this._tagStackInd = -1;
        this._indStack = -1;
        this._errorFile = null;
        this._errorStatus = 0;
        this._tagCount = 0;
        this._tagDepth = -1;
        this._status = -1;
        this._idAsig = "";
        this._cntAsigurat = 0L;
        if (this._angajator == null) {
            this._angajator = new Angajator(this, null);
            for (i = 0; i < this._angajatorA.length; ++i) {
                this._angajatorA[i] = new AngajatorA(this, this._angajator);
            }
            for (i = 0; i < this._angajatorF2.length; ++i) {
                this._angajatorF2[i] = new AngajatorF2(this, this._angajator);
            }
            for (i = 0; i < this._angajatorG.length; ++i) {
                this._angajatorG[i] = new AngajatorG(this, this._angajator);
            }
            this._asigurat = new Asigurat(this, this._angajator);
            for (i = 0; i < this._coAsigurati.length; ++i) {
                this._coAsigurati[i] = new CoAsigurati(this, this._asigurat);
            }
            for (i = 0; i < this._AsiguratDet1.length; ++i) {
                this._AsiguratDet1[i] = new AsiguratDet1(this, this._asigurat);
            }
            this._asiguratA = new AsiguratA(this, this._asigurat);
            this._asiguratA1 = new AsiguratA1(this, this._asigurat);
            this._asiguratB2 = new AsiguratB2(this, this._asigurat);
            this._asiguratB41 = new AsiguratB41(this, this._asigurat);
            for (i = 0; i < this._asiguratB1.length; ++i) {
                this._asiguratB1[i] = new AsiguratB1(this, this._asigurat);
            }
            for (i = 0; i < this._asiguratC.length; ++i) {
                this._asiguratC[i] = new AsiguratC(this, this._asigurat);
            }
            for (i = 0; i < this._asiguratD.length; ++i) {
                this._asiguratD[i] = new AsiguratD(this, this._asigurat);
            }
            this._asiguratE1 = new AsiguratE1(this, this._asigurat);
            this._asiguratE2 = new AsiguratE2(this, this._asigurat);
            for (i = 0; i < this._asiguratE4.length; ++i) {
                this._asiguratE4[i] = new AsiguratE4(this, this._asigurat);
            }
            for (i = 0; i < this._asiguratE3.length; ++i) {
                this._asiguratE3[i] = new AsiguratE3(this, this._asigurat);
            }
        } else {
            this._angajator.setParams();
            for (i = 0; i < this._angajatorA.length; ++i) {
                this._angajatorA[i].setParams();
            }
            for (i = 0; i < this._angajatorF2.length; ++i) {
                this._angajatorF2[i].setParams();
            }
            for (i = 0; i < this._angajatorG.length; ++i) {
                this._angajatorG[i].setParams();
            }
            this._asigurat.setParams();
            for (i = 0; i < this._coAsigurati.length; ++i) {
                this._coAsigurati[i].setParams();
            }
            for (i = 0; i < this._AsiguratDet1.length; ++i) {
                this._AsiguratDet1[i].setParams();
            }
            this._asiguratA.setParams();
            this._asiguratB2.setParams();
            for (i = 0; i < this._asiguratB1.length; ++i) {
                this._asiguratB1[i].setParams();
            }
            for (i = 0; i < this._asiguratC.length; ++i) {
                this._asiguratC[i].setParams();
            }
            for (i = 0; i < this._asiguratD.length; ++i) {
                this._asiguratD[i].setParams();
            }
            this._asiguratE1.setParams();
            this._asiguratE2.setParams();
            for (i = 0; i < this._asiguratE4.length; ++i) {
                this._asiguratE4[i].setParams();
            }
            for (i = 0; i < this._asiguratE3.length; ++i) {
                this._asiguratE3[i].setParams();
            }
        }
        this._cntAngajatorA = 0;
        this._cntAngajatorC5 = 0;
        this._cntAngajatorF2 = 0;
        this._cntAngajatorG = 0;
        this._cntCoAsigurati = 0;
        this._cntAsiguratDet1 = 0;
        this._cntAsiguratB1 = 0;
        this._cntAsiguratB11 = 0;
        this._indAsiguratB11perB1 = 0;
        this._cntAsiguratD = 0;
        this._cntAsiguratC = 0;
        this._cntAsiguratE3 = 0;
        this._cntAsiguratE4 = 0;
        this._existsAngajatorC1 = false;
        this._existsAngajatorC2 = false;
        this._existsAngajatorC3 = false;
        this._existsAngajatorC4 = false;
        this._existsAngajatorC5 = false;
        this._existsAngajatorD = false;
        this._existsAngajatorE1 = false;
        this._existsAngajatorE2 = false;
        this._existsAngajatorE3 = false;
        this._existsAngajatorE4 = false;
        this._existsAngajatorF1 = false;
        this._existsAngajatorF2 = false;
        this._asigType = -1;
        this._existsAsiguratB2 = false;
        this._existsAsiguratB3 = false;
        this._existsAsiguratC = false;
        this._existsAsiguratE1 = false;
        this._existsAsiguratE2 = false;
        this._existsAsiguratE4 = false;
        this._existsAsiguratA1 = false;
        this._existsAsiguratB41 = false;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(this._xmlFile, (DefaultHandler)this);
        }
        catch (FileNotFoundException ex) {
            level = 3;
            errMsg = ex.getMessage();
        }
        catch (IOException ex) {
            errMsg = ex.getMessage();
        }
        catch (ParserConfigurationException ex) {
            errMsg = ex.getMessage();
        }
        catch (SAXParseException ex) {
            errMsg = ex.getMessage();
        }
        catch (SAXException ex) {
            errMsg = ex.getMessage();
        }
        catch (Throwable err) {
            errMsg = err.toString();
        }
        if (errMsg != null) {
            this.addError(3, "", "", this.fillParams("Eroare fatala de parsare: '@0@'", errMsg), level);
        }
        try {
            if (this._errorFile != null) {
                this._errorFile.close();
            }
        }
        catch (Throwable ex) {
            LogTrace.log((String)("Eroare fatala: " + ex.getMessage()), (int)2);
            this._errorStatus |= 0xF;
        }
        int val = 0;
        if (this.getErrors() != 0) {
            val = -1;
            if (this.hasFatalErrors() != 0) {
                val = -2;
                if (this.hasTechnicalErrors() != 0) {
                    val = -3;
                }
            }
        }
        if (this._dbObj != null && val != -3) {
            try {
                File xml = new File(this._xmlFile);
                xml.delete();
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if (this._dbObj != null && this._errorStatus != 0) {
            BufferedReader errorInputFile = null;
            String line = null;
            String header = null;
            String rez = null;
            String[] line0 = null;
            StringBuffer error = new StringBuffer(500);
            boolean flag = false;
            boolean flagLine = false;
            try {
                errorInputFile = new BufferedReader(new FileReader(errFile));
                while (true) {
                    if ((line = errorInputFile.readLine()) == null || !line.startsWith(" ")) {
                        if (flag && (rez = this._dbObj.insertError(header, error.toString())) != null) {
                            LogTrace.log((String)("Eroare fatala: " + rez), (int)2);
                            this._errorStatus |= 0xF;
                            val = -3;
                            break;
                        }
                        if (line == null) break;
                        flag = true;
                        flagLine = false;
                        error.setLength(0);
                        line0 = line.split("\\|", 2);
                        if (line0.length < 2) {
                            header = "E???";
                        } else {
                            header = line0[0];
                            line = line0[1];
                        }
                    }
                    if (flagLine) {
                        error.append(_nl);
                    }
                    flagLine = true;
                    error.append(line);
                }
            }
            catch (Throwable ex) {
                LogTrace.log((String)("Eroare fatala: " + ex.getMessage()), (int)2);
                this._errorStatus |= 0xF;
                val = -3;
            }
            try {
                errorInputFile.close();
                if (val != -3) {
                    File err = new File(this._errFile);
                    err.delete();
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if (this._dbObj != null) {
            this._dbObj.endDeclaratie(val);
        }
        if (val < 0) {
            return val;
        }
        info._luna = this.adjustString(this._angajator._luna_r);
        info._an = this.adjustString(this._angajator._an_r);
        info._rec = this.adjustString(this._angajator._tip_rec);
        info._tipPerioada = "L";
        info._perioada = info._luna;
        if (info._rec.equals("")) {
            info._rec = "0";
        }
        info._numeDeclar = this.adjustString(this._angajator._nume_declar);
        info._prenumeDeclar = this.adjustString(this._angajator._prenume_declar);
        info._functieDeclar = this.adjustString(this._angajator._functie_declar);
        info._cif = this.adjustString(this._angajator._cif);
        info.setValue("cifS", (Object)this.adjustString(this._angajator._cifS));
        info._denumire = this.adjustString(this._angajator._den);
        info._adresa = this.adjustString(this._angajator._adrFisc);
        info._telefon = this.adjustString(this._angajator._telFisc);
        info._fax = this.adjustString(this._angajator._faxFisc);
        info._mail = this.adjustString(this._angajator._mailFisc);
        info._sumaControl = this.adjustString(this._angajator._totalPlata_A);
        info.setValue("_rgCom", (Object)this.adjustString(this._angajator._rgCom));
        String[] codOblig = new String[this._cntAngajatorA];
        String[] codBugetar = new String[this._cntAngajatorA];
        String[] datorat = new String[this._cntAngajatorA];
        String[] deductibil = new String[this._cntAngajatorA];
        String[] scutit = new String[this._cntAngajatorA];
        String[] plata = new String[this._cntAngajatorA];
        String[] numeOblig = new String[this._cntAngajatorA];
        String[] idOblig = new String[this._cntAngajatorA];
        info.setValue("_cnt", (Object)Long.toString(this._cntAngajatorA));
        info.setValue("_codOblig", (Object)codOblig);
        info.setValue("_numeOblig", (Object)numeOblig);
        info.setValue("_idOblig", (Object)idOblig);
        info.setValue("_codBugetar", (Object)codBugetar);
        info.setValue("_datorat", (Object)datorat);
        info.setValue("_deductibil", (Object)deductibil);
        info.setValue("_plata", (Object)plata);
        info.setValue("_scutit", (Object)scutit);
        Parameters.DUKOblig key = new Parameters.DUKOblig("", "", -1, "");
        for (int i2 = 0; i2 < this._cntAngajatorA; ++i2) {
            codBugetar[i2] = this.adjustString(this._angajatorA[i2]._A_codBugetar);
            key._oblig = this._angajatorA[i2]._A_codOblig;
            int indOblig = Arrays.binarySearch(((Parameters)this._params)._A_codOblig_Bugetar, key);
            numeOblig[i2] = this.adjustString(((Parameters)this._params)._A_codOblig_Bugetar[indOblig]._name);
            idOblig[i2] = Integer.toString(((Parameters)this._params)._A_codOblig_Bugetar[indOblig]._index + 1);
            codOblig[i2] = this.adjustString(this._angajatorA[i2]._A_codOblig);
            datorat[i2] = this.adjustString(this._angajatorA[i2]._A_datorat);
            deductibil[i2] = this.adjustString(this._angajatorA[i2]._A_deductibil);
            plata[i2] = this.adjustString(this._angajatorA[i2]._A_plata);
            scutit[i2] = this.adjustString(this._angajatorA[i2]._A_scutit);
        }
        if (this.getWarnings() != 0) {
            return 1;
        }
        return 0;
    }

    int addError(int errType, String ruleOrAttrib, String message0, String message) {
        return this.addError(errType, ruleOrAttrib, message0, message, 1);
    }

    int addError(int errType, String ruleOrAttrib, String message0, String message, int level) {
        String errStr;
        StringBuffer result = new StringBuffer(500);
        String string = errStr = level == 0 ? "atentionare" : "eroare";
        if (this._errorFile == null) {
            try {
                this._errorFile = new OutputStreamWriter((OutputStream)new FileOutputStream(this._errFile), "UTF-8");
            }
            catch (IOException ex) {
                LogTrace.log((String)("Eroare fatala: " + ex.getMessage()), (int)2);
                this._errorStatus |= 0xF;
                return this._errorStatus;
            }
        }
        if (this._dbObj != null) {
            switch (level) {
                case 0: {
                    result.append("A");
                    break;
                }
                case 3: {
                    result.append("T");
                    break;
                }
                default: {
                    result.append("E");
                }
            }
            switch (errType) {
                case 0: {
                    result.append("C");
                    break;
                }
                case 1: {
                    result.append("R");
                    break;
                }
                case 2: {
                    result.append("S");
                    break;
                }
                case 3: {
                    result.append("G");
                }
            }
            result.append(ruleOrAttrib);
            result.append("|");
        }
        if (level == 0) {
            result.append("A:");
        } else if (level == 1) {
            result.append("E:");
        } else if (level == 2) {
            result.append("F:");
        } else {
            result.append("T:");
        }
        if (level > 0 && this._writeDB) {
            this._dbObj.rollBack();
            this._writeDB = false;
        }
        for (int i = 0; i <= this._indStack; ++i) {
            result.append(" " + (i == 0 ? "" : "sectiune ") + this._tagNameStack[i] + " (" + Integer.toString(this._countStack[i]) + ")");
            if (i != 0 || this._idAsig == null || this._idAsig.equals("")) continue;
            result.append(" [" + this._idAsig + "]");
        }
        if (this._indStack < 0) {
            result.append(" validari globale");
        }
        if (message0 != null && !message0.equals("")) {
            result.append(_nl + " " + message0);
        }
        result.append(_nl);
        switch (errType) {
            case 0: {
                result.append(" " + errStr + " atribut: " + ruleOrAttrib + ": ");
                break;
            }
            case 1: {
                result.append(" " + errStr + " regula: " + ruleOrAttrib + (!ruleOrAttrib.equals("") ? ": " : ""));
                break;
            }
            case 2: {
                result.append(" " + errStr + " structura: ");
                break;
            }
            case 3: {
                result.append(" ");
            }
        }
        result.append(message + _nl);
        try {
            this._errorFile.write(result.toString());
        }
        catch (IOException ex) {
            LogTrace.log((String)("Eroare fatala: " + ex.getMessage()), (int)2);
            this._errorStatus |= 0xF;
            return this._errorStatus;
        }
        this._errorStatus = level == 0 ? (this._errorStatus |= 0x10) : (level == 1 ? (this._errorStatus |= 3) : (level == 2 ? (this._errorStatus |= 7) : (this._errorStatus |= 0xF)));
        return this._errorStatus;
    }

    String nextAttribute(String attributeName, int maxLen, int type, int mandatoryFlag) {
        this._stringValue = null;
        this._integerValue = 0L;
        this._realValue = 0.0;
        this._dateValue = null;
        this._attributeExists = false;
        if ((this._errorStatus & 1) != 0) {
            this._errorStatus |= 2;
        }
        this._errorStatus &= 0xFFFFFFFE;
        if (this._emptyAttribListFlag) {
            this._attribFullList.add(attributeName);
        }
        if (this._attrib != null) {
            this._stringValue = this._attrib.getValue(attributeName);
        }
        if (this._stringValue != null) {
            if ((mandatoryFlag & 8) == 0) {
                this._stringValue = this._stringValue.trim();
            }
            this._attributeExists = true;
            ++this._effectiveAttribCount;
        }
        if (this._stringValue != null && !this._stringValue.equals("")) {
            switch (type) {
                case 1: {
                    try {
                        this._integerValue = Long.parseLong(this._stringValue);
                    }
                    catch (NumberFormatException err) {
                        this.addError(0, attributeName, "", this.fillParams("numar intreg eronat: '@0@'", this._stringValue));
                    }
                    break;
                }
                case 2: {
                    try {
                        this._realValue = Double.parseDouble(this._stringValue);
                    }
                    catch (NumberFormatException err) {
                        this.addError(0, attributeName, "", this.fillParams("numar real eronat: '@0@'", this._stringValue));
                    }
                    break;
                }
                case 3: {
                    try {
                        this._dateValue = _dateFormat.parse(this._stringValue);
                        if (this._dateValue.getYear() < 0) {
                            throw new ParseException("", 0);
                        }
                    }
                    catch (ParseException err) {
                        this.addError(0, attributeName, "", this.fillParams("data calendaristica eronata: '@0@'", this._stringValue));
                    }
                    break;
                }
                case 4: {
                    if (this._stringValue.length() <= maxLen) break;
                    this.addError(0, attributeName, "", this.fillParams("sir mai lung de @0@ caractere ('@1@')", Integer.toString(maxLen), this._stringValue));
                    break;
                }
                default: {
                    this.addError(0, attributeName, "", "eroare interna sau de programare");
                }
            }
            if ((mandatoryFlag & 3) == 2) {
                this.addError(0, attributeName, "", this.fillParams("atributul cu valoarea: '@0@' nu trebuie sa existe aici", this._stringValue));
            }
        } else if (this._stringValue != null && this._stringValue.equals("")) {
            if ((mandatoryFlag & 4) == 0) {
                this.addError(0, attributeName, "", "atribut prezent dar vid nepermis");
            }
        } else if ((mandatoryFlag & 3) == 1) {
            this.addError(0, attributeName, "", "atributul trebuie sa existe");
        }
        return this._stringValue;
    }

    String nextAttributeInList(Object[] list, String attributeName, int maxLen, int type, int mandatoryFlag) {
        int i = 0;
        String res = this.nextAttribute(attributeName, maxLen, type, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        switch (type) {
            case 1: {
                if (Arrays.binarySearch(list, (Object)this._integerValue) < 0) {
                    i = list.length;
                    break;
                }
                i = 0;
                break;
            }
            case 2: {
                for (i = 0; i < list.length && this._realValue != (Double)list[i]; ++i) {
                }
                break;
            }
            case 3: {
                for (i = 0; i < list.length && !this._dateValue.equals((Date)list[i]); ++i) {
                }
                break;
            }
            case 4: {
                i = Arrays.binarySearch(list, this._stringValue) < 0 ? list.length : 0;
            }
        }
        if (i >= list.length) {
            this.addError(0, attributeName, "", this.fillParams("valoarea '@0@' nu se afla in lista", this._stringValue));
        }
        return res;
    }

    String nextAttributeInInterval(Object limInf, Object limSup, String attributeName, int maxLen, int type, int mandatoryFlag) {
        boolean ok = false;
        String res = this.nextAttribute(attributeName, maxLen, type, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        switch (type) {
            case 1: {
                if (limSup != null && this._integerValue > (Long)limSup || limInf != null && this._integerValue < (Long)limInf) break;
                ok = true;
                break;
            }
            case 2: {
                if (limSup != null && !(this._realValue <= (Double)limSup) || limInf != null && !(this._realValue >= (Double)limInf)) break;
                ok = true;
                break;
            }
            case 3: {
                if (limSup != null && !this._dateValue.before((Date)limSup) && !this._dateValue.equals((Date)limSup) || limInf != null && !this._dateValue.after((Date)limInf) && !this._dateValue.equals((Date)limInf)) break;
                ok = true;
                break;
            }
            case 4: {
                if (limSup != null && this._stringValue.compareTo((String)limSup) > 0 || limInf != null && this._stringValue.compareTo((String)limInf) < 0) break;
                ok = true;
            }
        }
        if (!ok) {
            this.addError(0, attributeName, "", this.fillParams("valoarea '@0@' nu se incadreaza in intervalul cerut", this._stringValue));
        }
        return res;
    }

    String nextAttributeDblPattern(Object limInf, Object limSup, int intPositions, int fractPositions, String attributeName, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, 0, 2, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        if (limSup != null && this._realValue > (Double)limSup || limInf != null && this._realValue < (Double)limInf) {
            this.addError(0, attributeName, "", this.fillParams("valoarea '@0@' nu se incadreaza in intervalul cerut", this._stringValue));
            return res;
        }
        String[] fld = this._dblPattern.split(res, 0);
        boolean err = false;
        if (fld.length > 0 && fld[0].length() > intPositions) {
            err = true;
        }
        if (fld.length > 1 && fld[1].length() > fractPositions) {
            err = true;
        }
        if (err) {
            this.addError(0, attributeName, "", this.fillParams("numarul zecimal ('@0@') nu respecta modelul: @1@.@2@", this._stringValue, Integer.toString(intPositions), Integer.toString(fractPositions)));
        }
        return res;
    }

    char[] getBinaryValues(String str) {
        int len = str.length();
        char[] chr = new char[len];
        str.getChars(0, len, chr, 0);
        for (int i = 0; i < len; ++i) {
            char val = chr[i];
            if (val < '0' || val > '9') {
                return null;
            }
            chr[i] = (char)(val - 48);
        }
        return chr;
    }

    public int checkCNP(String cnp) {
        int year;
        int year2 = 0;
        if (cnp.length() == 0) {
            return 0;
        }
        if (cnp.length() != 13) {
            return -1;
        }
        char[] cnp1 = this.getBinaryValues(cnp);
        if (cnp1 == null) {
            return -1;
        }
        char chr = cnp1[0];
        if (chr == '\u0000' || chr == '\t') {
            return -1;
        }
        if (chr <= '\u0002' || chr >= '\u0007') {
            if (chr >= '\u0007') {
                year2 = 2000;
            }
            year = 1900;
        } else {
            year = chr >= '\u0005' ? 2000 : 1800;
        }
        if (year2 > 0) {
            year2 += cnp1[1] * 10 + cnp1[2];
        }
        int month = cnp1[3] * 10 + cnp1[4];
        int day = cnp1[5] * 10 + cnp1[6];
        if (year2 == 0 && (month == 0 || month > 12 || day == 0 || day > _monthLen[month - 1] || month == 2 && day == 29 && ((year += cnp1[1] * 10 + cnp1[2]) % 4 != 0 || year % 100 == 0 && year % 400 != 0))) {
            return -1;
        }
        if (year2 > 0 && (month == 0 || month > 12 || day == 0 || day > _monthLen[month - 1] || month == 2 && day == 29 && (year % 4 != 0 || year % 100 == 0 && year % 400 != 0) && month == 2 && day == 29 && (year2 % 4 != 0 || year2 % 100 == 0 && year2 % 400 != 0))) {
            return -1;
        }
        day = (cnp1[0] * 2 + cnp1[1] * 7 + cnp1[2] * 9 + cnp1[3] * '\u0001' + cnp1[4] * 4 + cnp1[5] * 6 + cnp1[6] * 3 + cnp1[7] * 5 + cnp1[8] * 8 + cnp1[9] * 2 + cnp1[10] * 7 + cnp1[11] * 9) % 11;
        if (day == 10) {
            day = 1;
        }
        if (day != cnp1[12]) {
            return -1;
        }
        return 0;
    }

    int checkNIF(String cnp) {
        if (cnp.length() == 0) {
            return 0;
        }
        if (cnp.length() != 13) {
            return -1;
        }
        char[] cnp1 = this.getBinaryValues(cnp);
        if (cnp1 == null) {
            return -1;
        }
        char chr = cnp1[0];
        if (chr == '\t') {
            int val = (cnp1[0] * 2 + cnp1[1] * 7 + cnp1[2] * 9 + cnp1[3] * '\u0001' + cnp1[4] * 4 + cnp1[5] * 6 + cnp1[6] * 3 + cnp1[7] * 5 + cnp1[8] * 8 + cnp1[9] * 2 + cnp1[10] * 7 + cnp1[11] * 9) % 11;
            if (val == 10) {
                val = 1;
            }
            if (val != cnp1[12]) {
                return -1;
            }
        } else {
            return this.checkCNP(cnp);
        }
        return 0;
    }

    int checkCUI(String cui) {
        int i;
        char[] cui2 = new char[10];
        int len = cui.length();
        if (len == 0) {
            return 0;
        }
        if (len > 10 || cui.startsWith("0")) {
            return -1;
        }
        char[] cui1 = this.getBinaryValues(cui);
        if (cui1 == null) {
            return -1;
        }
        for (i = 0; i < 10 - len; ++i) {
            cui2[i] = '\u0000';
        }
        for (i = 0; i < len; ++i) {
            cui2[i + 10 - len] = cui1[i];
        }
        len = (cui2[0] * 7 + cui2[1] * 5 + cui2[2] * 3 + cui2[3] * 2 + cui2[4] * '\u0001' + cui2[5] * 7 + cui2[6] * 5 + cui2[7] * 3 + cui2[8] * 2) * 10 % 11;
        if (len == 10) {
            len = 0;
        }
        if (len != cui2[9]) {
            return -1;
        }
        return 0;
    }

    String nextAttributeStringAsLong(String attributeName, int maxLen, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, maxLen, 4, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        if (this.getBinaryValues(res) == null) {
            this.addError(0, attributeName, "", this.fillParams("valoare nenumerica ('@0@')", this._stringValue));
        }
        return res;
    }

    String nextAttributeEmail(String attributeName, int maxLen, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, maxLen, 4, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        Matcher emailMatcher = this._emailPattern.matcher(res);
        if (!emailMatcher.matches()) {
            this.addError(0, attributeName, "", this.fillParams("Email invalid ('@0@')", this._stringValue), 0);
        }
        return res;
    }

    String nextAttributeAsCnp(String attributeName, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, 13, 4, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        if (this.checkCNP(res) != 0) {
            this.addError(0, attributeName, "", this.fillParams("CNP invalid ('@0@')", this._stringValue));
        }
        return res;
    }

    String nextAttributeAsNif(String attributeName, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, 13, 4, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        if (this.checkNIF(res) != 0) {
            this.addError(0, attributeName, "", this.fillParams("CNP invalid ('@0@')", this._stringValue));
        }
        return res;
    }

    String nextAttributeAsCui(String attributeName, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, 10, 4, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        if (this.checkCUI(res) != 0) {
            this.addError(0, attributeName, "", this.fillParams("CUI invalid ('@0@')", this._stringValue));
        }
        return res;
    }

    String nextAttributeAsCif(String attributeName, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, 13, 4, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        if (res.length() <= 10) {
            if (this.checkCUI(res) != 0) {
                this.addError(0, attributeName, "", this.fillParams("CUI invalid ('@0@')", this._stringValue));
            }
        } else if (res.length() == 13) {
            if (this.checkNIF(res) != 0) {
                this.addError(0, attributeName, "", this.fillParams("CNP invalid ('@0@')", this._stringValue));
            }
        } else {
            this.addError(0, attributeName, "", this.fillParams("Cod identificare fiscala (CIF) invalid ('@0@')", this._stringValue));
        }
        return res;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        DUKTag key = new DUKTag(localName, 0, 0);
        if (this._info._schemaNamespace == null) {
            this._info._schemaNamespace = uri;
        }
        ++this._tagCount;
        if (this.hasFatalErrors() != 0 || this._extractValuesFlag == 2) {
            return;
        }
        ++this._tagDepth;
        this._effectiveAttribCount = 0;
        this._attrib = attributes;
        int index = Arrays.binarySearch(_tags, key);
        if (index < 0) {
            this.addError(2, null, "", this.fillParams("sectiune necunoscuta ('@0@')", localName), 2);
            return;
        }
        int depth = ValidatorImpl._tags[index]._tagDepth;
        ++this._tagStackInd;
        this._lastTag = localName;
        this._tagStack[this._tagStackInd] = ValidatorImpl._tags[index]._whiteSpaceFlag;
        index = ValidatorImpl._tags[index]._tagId;
        int type = -1;
        switch (index) {
            case 0: {
                if (this._status != -1) {
                    type = 0;
                    break;
                }
                this._angajator.initialization();
                this._angajator.checkTag(0);
                if (this._extractValuesFlag != 1) break;
                this._extractValuesFlag = 2;
                break;
            }
            case 1: {
                if (this._status != 0) {
                    type = 0;
                    break;
                }
                this._indStack = 0;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(1);
                break;
            }
            case 2: {
                if (this._status != 2 && this._status != 5) {
                    if (depth != this._tagDepth) {
                        type = 1;
                        break;
                    }
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                if (this._status == 2) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n = this._indStack;
                    this._countStack[n] = this._countStack[n] + 1;
                }
                if (this._cntAngajatorA >= this._angajatorA.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._angajatorA.length)), 2);
                    break;
                }
                this._angajatorA[this._cntAngajatorA].initialization();
                this._angajatorA[this._cntAngajatorA].checkTag(0);
                break;
            }
            case 3: {
                if (this._status != 5 && this._status != 2) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(2);
                break;
            }
            case 4: {
                this._existsAngajatorC1 = true;
                if (this._status != 7) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(3);
                break;
            }
            case 5: {
                this._existsAngajatorC2 = true;
                if (this._status != 7 && this._status != 9) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(4);
                break;
            }
            case 6: {
                this._existsAngajatorC3 = true;
                if (this._status != 7 && this._status != 9 && this._status != 11) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(5);
                break;
            }
            case 7: {
                this._existsAngajatorC4 = true;
                if (this._status != 7 && this._status != 9 && this._status != 11 && this._status != 13) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(6);
                break;
            }
            case 8: {
                this._existsAngajatorC5 = true;
                if (this._status != 7 && this._status != 9 && this._status != 11 && this._status != 13 && this._status != 15) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(15);
                break;
            }
            case 11: {
                this._existsAngajatorD = true;
                if (this._status != 17 && this._status != 15 && this._status != 13) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(9);
                break;
            }
            case 12: {
                this._existsAngajatorE1 = true;
                if (this._status != 13 && this._status != 15 && this._status != 23 && this._status != 17) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(10);
                break;
            }
            case 13: {
                this._existsAngajatorE2 = true;
                if (this._status != 13 && this._status != 15 && this._status != 23 && this._status != 25 && this._status != 17) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(11);
                break;
            }
            case 14: {
                this._existsAngajatorE3 = true;
                if (this._status != 13 && this._status != 15 && this._status != 23 && this._status != 25 && this._status != 27 && this._status != 17) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(12);
                break;
            }
            case 15: {
                this._existsAngajatorE4 = true;
                if (this._status != 13 && this._status != 15 && this._status != 23 && this._status != 25 && this._status != 27 && this._status != 29 && this._status != 17) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(13);
                break;
            }
            case 16: {
                this._existsAngajatorF1 = true;
                if (this._status != 13 && this._status != 15 && this._status != 23 && this._status != 25 && this._status != 27 && this._status != 29 && this._status != 31 && this._status != 17) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(14);
                break;
            }
            case 17: {
                this._existsAngajatorF2 = true;
                if (this._status != 33 && this._status != 35) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                if (this._status != 35) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n = this._indStack;
                    this._countStack[n] = this._countStack[n] + 1;
                }
                if (this._cntAngajatorF2 >= this._angajatorF2.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._angajatorF2.length)), 2);
                    break;
                }
                this._angajatorF2[this._cntAngajatorF2].initialization();
                this._angajatorF2[this._cntAngajatorF2].checkTag(0);
                break;
            }
            case 31: {
                if (this._status != 13 && this._status != 15 && this._status != 17 && this._status != 23 && this._status != 25 && this._status != 27 && this._status != 29 && this._status != 31 && this._status != 63 && this._status != 35 && this._status != 33) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                if (this._status != 63) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n = this._indStack;
                    this._countStack[n] = this._countStack[n] + 1;
                }
                if (this._cntAngajatorG >= this._angajatorG.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._angajatorG.length)), 2);
                    break;
                }
                this._angajatorG[this._cntAngajatorG].initialization();
                this._angajatorG[this._cntAngajatorG].checkTag(0);
                break;
            }
            case 18: {
                if (this._status != 3 && this._status != 37) {
                    type = 2;
                } else {
                    this._indStack = 0;
                    this._tagNameStack[this._indStack] = localName;
                    if (this._status == 3) {
                        this._countStack[this._indStack] = 1;
                    } else {
                        int n = this._indStack;
                        this._countStack[n] = this._countStack[n] + 1;
                    }
                    this._asigurat.initialization();
                    this._asigurat.checkTag(0);
                }
                this._cntCoAsigurati = 0;
                this._cntAsiguratDet1 = 0;
                this._cntAsiguratB1 = 0;
                this._cntAsiguratB11 = 0;
                this._indAsiguratB11perB1 = 0;
                this._cntAsiguratD = 0;
                this._cntAsiguratC = 0;
                this._cntAsiguratE3 = 0;
                this._cntAsiguratE4 = 0;
                this._asigType = -1;
                this._existsAsiguratB2 = false;
                this._existsAsiguratB3 = false;
                this._existsAsiguratC = false;
                this._existsAsiguratE1 = false;
                this._existsAsiguratE2 = false;
                this._existsAsiguratE4 = false;
                this._existsAsiguratA1 = false;
                this._existsAsiguratB41 = false;
                break;
            }
            case 35: {
                if (this._status != 39 && this._status != 71 && this._status != 36) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                if (this._status == 36) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n = this._indStack;
                    this._countStack[n] = this._countStack[n] + 1;
                }
                if (this._cntAsiguratDet1 >= this._AsiguratDet1.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._AsiguratDet1.length)), 2);
                    break;
                }
                this._AsiguratDet1[this._cntAsiguratDet1].initialization();
                this._AsiguratDet1[this._cntAsiguratDet1].checkTag(0);
                break;
            }
            case 19: {
                if (this._status != 39 && this._status != 36) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                if (this._status == 36) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n = this._indStack;
                    this._countStack[n] = this._countStack[n] + 1;
                }
                if (this._cntCoAsigurati >= this._coAsigurati.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._coAsigurati.length)), 2);
                    break;
                }
                this._coAsigurati[this._cntCoAsigurati].initialization();
                this._coAsigurati[this._cntCoAsigurati].checkTag(0);
                break;
            }
            case 20: {
                if (this._status != 39 && this._status != 71 && this._status != 36) {
                    type = 2;
                } else {
                    this._indStack = 1;
                    this._tagNameStack[this._indStack] = localName;
                    this._countStack[this._indStack] = 1;
                    this._asiguratA.initialization();
                    this._asiguratA.checkTag(0);
                }
                this._asigType = 0;
                break;
            }
            case 33: {
                this._existsAsiguratA1 = true;
                if (this._status != 41) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._asiguratA1.initialization();
                this._asiguratA1.checkTag(0);
                break;
            }
            case 21: {
                if (this._status != 39 && this._status != 71 && this._status != 36 && this._status != 43) {
                    type = 2;
                } else {
                    this._indStack = 1;
                    this._tagNameStack[this._indStack] = localName;
                    if (this._status != 43) {
                        this._countStack[this._indStack] = 1;
                    } else {
                        int n = this._indStack;
                        this._countStack[n] = this._countStack[n] + 1;
                    }
                    if (this._cntAsiguratB1 >= this._asiguratB1.length) {
                        this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._asiguratB1.length)), 2);
                    } else {
                        this._asiguratB1[this._cntAsiguratB1].initialization();
                        this._asiguratB1[this._cntAsiguratB1].checkTag(0);
                    }
                }
                this._indAsiguratB11perB1 = 0;
                this._asigType = 1;
                break;
            }
            case 23: {
                this._existsAsiguratB2 = true;
                if (this._status != 43) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._asiguratB2.initialization();
                this._asiguratB2.checkTag(0);
                break;
            }
            case 24: {
                this._existsAsiguratB3 = true;
                if (this._status != 43 && this._status != 47) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                if (!this._existsAsiguratB2) {
                    this._asiguratB2.initialization();
                }
                this._asiguratB2.checkTag(1);
                break;
            }
            case 25: {
                if (this._status != 43 && this._status != 47 && this._status != 49) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                if (!this._existsAsiguratB2 && !this._existsAsiguratB3) {
                    this._asiguratB2.initialization();
                }
                this._asiguratB2.checkTag(2);
                break;
            }
            case 34: {
                this._existsAsiguratB41 = true;
                if (this._status != 51) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._asiguratB41.initialization();
                this._asiguratB41.checkTag(0);
                break;
            }
            case 26: {
                if (this._asigType < 0) {
                    this._asigType = 2;
                }
                this._existsAsiguratC = true;
                if (this._status != 39 && this._status != 36 && this._status != 41 && this._status != 67 && this._status != 51 && this._status != 69 && this._status != 53 && this._status != 71) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                if (this._status != 53) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n = this._indStack;
                    this._countStack[n] = this._countStack[n] + 1;
                }
                if (this._cntAsiguratC >= this._asiguratC.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._asiguratC.length)), 2);
                    break;
                }
                this._asiguratC[this._cntAsiguratC].initialization();
                this._asiguratC[this._cntAsiguratC].checkTag(0);
                break;
            }
            case 27: {
                if (this._status != 51 && this._status != 69 && this._status != 53 && this._status != 55) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                if (this._status != 55) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n = this._indStack;
                    this._countStack[n] = this._countStack[n] + 1;
                }
                if (this._cntAsiguratD >= this._asiguratD.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._asiguratD.length)), 2);
                    break;
                }
                this._asiguratD[this._cntAsiguratD].initialization();
                this._asiguratD[this._cntAsiguratD].checkTag(0);
                break;
            }
            case 28: {
                this._existsAsiguratE1 = true;
                if (this._status != 41 && this._status != 67 && this._status != 51 && this._status != 69 && this._status != 53 && this._status != 55) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._asiguratE1.initialization();
                this._asiguratE1.checkTag(0);
                break;
            }
            case 29: {
                this._existsAsiguratE2 = true;
                if (this._status != 41 && this._status != 67 && this._status != 51 && this._status != 69 && this._status != 53 && this._status != 55 && this._status != 57) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                this._countStack[this._indStack] = 1;
                this._asiguratE2.initialization();
                this._asiguratE2.checkTag(0);
                break;
            }
            case 30: {
                if (this._status != 41 && this._status != 67 && this._status != 51 && this._status != 69 && this._status != 53 && this._status != 55 && this._status != 57 && this._status != 59 && this._status != 61) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                if (this._status != 61) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n = this._indStack;
                    this._countStack[n] = this._countStack[n] + 1;
                }
                if (this._cntAsiguratE3 >= this._asiguratE3.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._asiguratE3.length)), 2);
                    break;
                }
                this._asiguratE3[this._cntAsiguratE3].initialization();
                this._asiguratE3[this._cntAsiguratE3].checkTag(0);
                break;
            }
            case 32: {
                this._existsAsiguratE4 = true;
                if (this._status != 61 && this._status != 65) {
                    type = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = localName;
                if (this._status != 65) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n = this._indStack;
                    this._countStack[n] = this._countStack[n] + 1;
                }
                if (this._cntAsiguratE4 >= this._asiguratE4.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._asiguratE4.length)), 2);
                    break;
                }
                this._asiguratE4[this._cntAsiguratE4].initialization();
                this._asiguratE4[this._cntAsiguratE4].checkTag(0);
            }
        }
        if (!uri.equals(this.DEC_NAMESPACE)) {
            this.addError(2, null, "", this.fillParams("namespace ('@0@') lipsa sau incorect la sectiunea @1@. Valoarea corecta este xmlns='@2@'", uri, localName, this.DEC_NAMESPACE), 2);
            return;
        }
        if (type >= 0) {
            String msg = "";
            switch (type) {
                case 0: {
                    msg = "sectiunea @0@' nu poate aparea de mai multe ori in acest context";
                    break;
                }
                case 1: {
                    msg = "sectiunea '@0@' apare pe un nivel incorect";
                    break;
                }
                case 2: {
                    msg = "sectiunea '@0@' este gresit pozitionata sau lipsesc sectiuni anterioare obligatorii";
                }
            }
            this.addError(2, null, "", this.fillParams(msg, localName), 2);
        }
        this._status = 2 * index;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        DUKTag key = new DUKTag(localName, 0, 0);
        if (this.hasFatalErrors() != 0 || this._extractValuesFlag == 2) {
            return;
        }
        --this._tagDepth;
        --this._tagStackInd;
        int index = Arrays.binarySearch(_tags, key);
        if (index < 0) {
            this.addError(2, null, "", this.fillParams("sectiune necunoscuta ('@0@')", localName), 2);
            return;
        }
        int depth = ValidatorImpl._tags[index]._tagDepth;
        index = ValidatorImpl._tags[index]._tagId;
        int type = -1;
        switch (index) {
            case 0: {
                this._indStack = -1;
                if (this._status != 37 && this._status != 3) {
                    type = 0;
                    break;
                }
                this._angajator.aggregation(0);
                if (!this._writeDB) break;
                this._dbObj.validariFinale();
                if (this._writeDB) break;
                break;
            }
            case 1: {
                this._indStack = 0;
                if (this._status != 63 && this._status != 35 && this._status != 63 && this._status != 33 && this._status != 31 && this._status != 29 && this._status != 27 && this._status != 25 && this._status != 23 && this._status != 17 && this._status != 15 && this._status != 13) {
                    type = 0;
                    break;
                }
                this._angajator.aggregation(1);
                if (!this._writeDB) break;
                this._dbObj.insertAngajator(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorA(this._cntAngajatorA, this._angajatorA);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorB(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorC1(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorC2(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorC3(this._angajator);
                if (!this._writeDB) break;
                if (this._existsAngajatorC4) {
                    this._dbObj.insertAngajatorC4(this._angajator);
                    if (!this._writeDB) break;
                }
                if (this._existsAngajatorC5) {
                    this._dbObj.insertAngajatorC5(this._angajator);
                    if (!this._writeDB) break;
                }
                this._dbObj.insertAngajatorD(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorE1(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorE2(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorE3(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorE4(this._angajator);
                if (!this._writeDB) break;
                if (this._existsAngajatorF1) {
                    if (!this._existsAngajatorF2 && this._angajator._exists_A21_1 && this._angajator._F1_suma_f == 0L && this._angajator._F1_suma_ded_f == 0L && this._angajator._F1_deplata_f == 0L && this._angajator._F1_suma_scut_f == 0L) {
                        this._angajator._F1_suma = Long.toString(this._angajator._val_A21_1);
                        this._angajator._F1_suma_ded = Long.toString(this._angajator._val_A21_1_ded);
                        this._angajator._F1_deplata = Long.toString(this._angajator._val_A21_1_deplata);
                        this._angajator._F1_suma_scut = Long.toString(this._angajator._val_A21_1_scutit);
                    }
                    this._dbObj.insertAngajatorF1(this._angajator);
                    if (!this._writeDB) {
                        break;
                    }
                } else if (this._angajator._exists_A21_1) {
                    this._angajator._F1_suma_f = this._angajator._val_A21_1;
                    this._angajator._F1_suma = Long.toString(this._angajator._val_A21_1);
                    this._angajator._F1_suma_ded_f = this._angajator._val_A21_1_ded;
                    this._angajator._F1_suma_ded = Long.toString(this._angajator._val_A21_1_ded);
                    this._angajator._F1_deplata_f = this._angajator._val_A21_1_deplata;
                    this._angajator._F1_deplata = Long.toString(this._angajator._val_A21_1_deplata);
                    this._angajator._F1_suma_scut_f = this._angajator._val_A21_1_scutit;
                    this._angajator._F1_suma_scut = Long.toString(this._angajator._val_A21_1_scutit);
                    this._dbObj.insertAngajatorF1(this._angajator);
                    if (!this._writeDB) break;
                }
                if (this._existsAngajatorF2) {
                    this._dbObj.insertAngajatorF2(this._cntAngajatorF2, this._angajatorF2);
                    if (!this._writeDB) break;
                }
                this._dbObj.insertAngajatorG(this._cntAngajatorG, this._angajatorG);
                if (this._writeDB) break;
                break;
            }
            case 2: {
                if (this._status != 4) {
                    type = 0;
                } else {
                    this._angajatorA[this._cntAngajatorA].aggregation(0);
                }
                ++this._cntAngajatorA;
                break;
            }
            case 3: {
                if (this._status != 6) {
                    type = 0;
                    break;
                }
                this._angajator.aggregation(2);
                break;
            }
            case 4: {
                if (this._status != 8) {
                    type = 0;
                    break;
                }
                this._angajator.aggregation(3);
                break;
            }
            case 5: {
                if (this._status != 10) {
                    type = 0;
                    break;
                }
                this._angajator.aggregation(4);
                break;
            }
            case 6: {
                if (this._status != 12) {
                    type = 0;
                    break;
                }
                this._angajator.aggregation(5);
                break;
            }
            case 7: {
                if (this._status != 14) {
                    type = 0;
                } else {
                    this._angajator.aggregation(6);
                }
                this._existsAngajatorC4 = true;
                break;
            }
            case 8: {
                if (this._status != 16) {
                    type = 0;
                } else {
                    this._angajator.aggregation(15);
                }
                this._existsAngajatorC5 = true;
                break;
            }
            case 11: {
                if (this._status != 22) {
                    type = 0;
                } else {
                    this._angajator.aggregation(9);
                }
                this._existsAngajatorD = true;
                break;
            }
            case 12: {
                if (this._status != 24) {
                    type = 0;
                    break;
                }
                this._angajator.aggregation(10);
                break;
            }
            case 13: {
                if (this._status != 26) {
                    type = 0;
                    break;
                }
                this._angajator.aggregation(11);
                break;
            }
            case 14: {
                if (this._status != 28) {
                    type = 0;
                    break;
                }
                this._angajator.aggregation(12);
                break;
            }
            case 15: {
                if (this._status != 30) {
                    type = 0;
                    break;
                }
                this._angajator.aggregation(13);
                break;
            }
            case 16: {
                if (this._status != 32) {
                    type = 0;
                } else {
                    this._angajator.aggregation(14);
                }
                this._existsAngajatorF1 = true;
                break;
            }
            case 17: {
                if (this._status != 34) {
                    type = 0;
                } else {
                    this._angajatorF2[this._cntAngajatorF2].aggregation(0);
                }
                ++this._cntAngajatorF2;
                break;
            }
            case 31: {
                if (this._status != 62) {
                    type = 0;
                } else {
                    this._angajatorG[this._cntAngajatorG].aggregation(0);
                }
                ++this._cntAngajatorG;
                break;
            }
            case 18: {
                this._indStack = 0;
                ++this._cntAsigurat;
                if (this._status != 61 && this._status != 65) {
                    type = 0;
                    break;
                }
                this._asigurat.aggregation(0);
                if (!this._writeDB) break;
                this._dbObj.insertAsigurat(this._asigurat);
                if (!this._writeDB) break;
                this._dbObj.insertAsiguratDet1(this._cntAsiguratDet1, this._AsiguratDet1);
                if (!this._writeDB) break;
                this._dbObj.insertAsiguratCo(this._cntCoAsigurati, this._coAsigurati);
                if (!this._writeDB) break;
                if (this._asigType == 0) {
                    this._dbObj.insertAsiguratA(this._asiguratA);
                    if (!this._writeDB) break;
                    if (this._existsAsiguratA1) {
                        this._dbObj.insertAsiguratA1(this._asiguratA1);
                        if (!this._writeDB) break;
                    }
                    this._dbObj.insertAsiguratC(this._cntAsiguratC, this._asiguratC);
                    if (!this._writeDB) break;
                    this._dbObj.insertAsiguratD(this._cntAsiguratD, this._asiguratD);
                    if (!this._writeDB) break;
                    if (this._existsAsiguratE1) {
                        this._dbObj.insertAsiguratE1(this._asiguratE1);
                        if (!this._writeDB) break;
                    }
                    if (this._existsAsiguratE2) {
                        this._dbObj.insertAsiguratE2(this._asiguratE2);
                        if (!this._writeDB) break;
                    }
                    this._dbObj.insertAsiguratE3(this._cntAsiguratE3, this._asiguratE3);
                    if (!this._writeDB || !this._existsAsiguratE4) break;
                    this._dbObj.insertAsiguratE4(this._cntAsiguratE4, this._asiguratE4);
                    if (this._writeDB) break;
                    break;
                }
                if (this._asigType == 1) {
                    this._dbObj.insertAsiguratB1(this._cntAsiguratB1, this._asiguratB1, this._cntAsiguratB11);
                    if (!this._writeDB) break;
                    if (this._existsAsiguratB2) {
                        this._dbObj.insertAsiguratB2(this._asiguratB2);
                        if (!this._writeDB) break;
                    }
                    if (this._existsAsiguratB3) {
                        this._dbObj.insertAsiguratB3(this._asiguratB2);
                        if (!this._writeDB) break;
                    }
                    this._dbObj.insertAsiguratB4(this._asiguratB2);
                    if (!this._writeDB) break;
                    if (this._existsAsiguratB41) {
                        this._dbObj.insertAsiguratB41(this._asiguratB41);
                        if (!this._writeDB) break;
                    }
                    this._dbObj.insertAsiguratC(this._cntAsiguratC, this._asiguratC);
                    if (!this._writeDB) break;
                    this._dbObj.insertAsiguratD(this._cntAsiguratD, this._asiguratD);
                    if (!this._writeDB) break;
                    if (this._existsAsiguratE1) {
                        this._dbObj.insertAsiguratE1(this._asiguratE1);
                        if (!this._writeDB) break;
                    }
                    if (this._existsAsiguratE2) {
                        this._dbObj.insertAsiguratE2(this._asiguratE2);
                        if (!this._writeDB) break;
                    }
                    this._dbObj.insertAsiguratE3(this._cntAsiguratE3, this._asiguratE3);
                    if (!this._writeDB || !this._existsAsiguratE4) break;
                    this._dbObj.insertAsiguratE4(this._cntAsiguratE4, this._asiguratE4);
                    if (this._writeDB) break;
                    break;
                }
                this._dbObj.insertAsiguratC(this._cntAsiguratC, this._asiguratC);
                if (!this._writeDB) break;
                this._dbObj.insertAsiguratD(this._cntAsiguratD, this._asiguratD);
                if (!this._writeDB) break;
                if (this._existsAsiguratE1) {
                    this._dbObj.insertAsiguratE1(this._asiguratE1);
                    if (!this._writeDB) break;
                }
                if (this._existsAsiguratE2) {
                    this._dbObj.insertAsiguratE2(this._asiguratE2);
                    if (!this._writeDB) break;
                }
                this._dbObj.insertAsiguratE3(this._cntAsiguratE3, this._asiguratE3);
                if (!this._writeDB || !this._existsAsiguratE4) break;
                this._dbObj.insertAsiguratE4(this._cntAsiguratE4, this._asiguratE4);
                if (this._writeDB) break;
                break;
            }
            case 35: {
                if (this._status != 70) {
                    type = 0;
                } else {
                    this._AsiguratDet1[this._cntAsiguratDet1].aggregation(0);
                }
                ++this._cntAsiguratDet1;
                break;
            }
            case 19: {
                if (this._status != 38) {
                    type = 0;
                } else {
                    this._coAsigurati[this._cntCoAsigurati].aggregation(0);
                }
                ++this._cntCoAsigurati;
                break;
            }
            case 20: {
                if (this._status != 40) {
                    type = 0;
                    break;
                }
                this._asiguratA.aggregation(0);
                break;
            }
            case 33: {
                if (this._status != 66) {
                    type = 0;
                    break;
                }
                this._asiguratA1.aggregation(0);
                break;
            }
            case 21: {
                this._indStack = 1;
                if (this._status != 42 && this._status != 45) {
                    type = 0;
                } else {
                    this._asiguratB1[this._cntAsiguratB1].aggregation(0);
                }
                ++this._cntAsiguratB1;
                break;
            }
            case 23: {
                if (this._status != 46) {
                    type = 0;
                    break;
                }
                this._asiguratB2.aggregation(0);
                break;
            }
            case 24: {
                if (this._status != 48) {
                    type = 0;
                    break;
                }
                this._asiguratB2.aggregation(1);
                break;
            }
            case 25: {
                if (this._status != 50) {
                    type = 0;
                    break;
                }
                this._asiguratB2.aggregation(2);
                break;
            }
            case 34: {
                if (this._status != 68) {
                    type = 0;
                    break;
                }
                this._asiguratB41.aggregation(0);
                break;
            }
            case 26: {
                if (this._status != 52) {
                    type = 0;
                } else {
                    this._asiguratC[this._cntAsiguratC].aggregation(0);
                }
                ++this._cntAsiguratC;
                break;
            }
            case 27: {
                if (this._status != 54) {
                    type = 0;
                } else {
                    this._asiguratD[this._cntAsiguratD].aggregation(0);
                }
                ++this._cntAsiguratD;
                break;
            }
            case 28: {
                if (this._status != 56) {
                    type = 0;
                    break;
                }
                this._asiguratE1.aggregation(0);
                break;
            }
            case 29: {
                if (this._status != 58) {
                    type = 0;
                    break;
                }
                this._asiguratE2.aggregation(0);
                break;
            }
            case 30: {
                if (this._status != 60) {
                    type = 0;
                } else {
                    this._asiguratE3[this._cntAsiguratE3].aggregation(0);
                }
                ++this._cntAsiguratE3;
                break;
            }
            case 32: {
                if (this._status != 64) {
                    type = 0;
                } else {
                    this._asiguratE4[this._cntAsiguratE4].aggregation(0);
                }
                ++this._cntAsiguratE4;
            }
        }
        if (type >= 0) {
            this.addError(2, null, "", this.fillParams("lipsa sectiune obligatorie inainte de sfarsitul sectiunii '@0@'", localName), 2);
        }
        this._status = 2 * index + 1;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.hasFatalErrors() != 0 || this._extractValuesFlag == 2) {
            return;
        }
        String str = new String(ch, start, length).trim();
        if (str.length() != 0) {
            this.addError(2, null, "", this.fillParams("continut nepermis ('@0@') in sau dupa sectiunea @1@", str, this._lastTag), 2);
            return;
        }
        if (!this._tagStack[this._tagStackInd]) {
            this.addError(2, null, "", this.fillParams("continut nepermis (spatii) in sectiunea @0@", this._lastTag), 2);
            return;
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
    }

    int getErrors() {
        return this._errorStatus & 0xF;
    }

    int getWarnings() {
        return this._errorStatus & 0x10;
    }

    int hasCurrentAttributeErrors() {
        return this._errorStatus & 1;
    }

    int hasFatalErrors() {
        return this._errorStatus & 4;
    }

    int hasTechnicalErrors() {
        return this._errorStatus & 8;
    }

    void setIdAsig(String value) {
        this._idAsig = value;
    }

    String adjustString(String par) {
        return par == null ? "" : par;
    }

    String fillParams(String msg, Object ... params) {
        String res = msg;
        for (int i = 0; i < params.length; ++i) {
            res = res.replaceAll("@" + Integer.toString(i) + "@", (params[i] == null ? "'lipsa'" : (String)params[i]).trim());
        }
        return res;
    }

    void initializeAtribList(Object attrFullList) {
        if (attrFullList == null) {
            this._emptyAttribListFlag = true;
            this._attribFullList = new HashSet();
        } else {
            this._emptyAttribListFlag = false;
            this._attribFullList = (HashSet)attrFullList;
        }
    }

    Object finalizeAttribCheck() {
        if (this._attrib.getLength() > this._effectiveAttribCount) {
            int len = this._attrib.getLength();
            for (int cnt = 0; cnt < len; ++cnt) {
                boolean isXsi;
                String attrib = this._attrib.getLocalName(cnt);
                if (this._attribFullList.contains(attrib) || (isXsi = this._attrib.getURI(cnt).equals("http://www.w3.org/2001/XMLSchema-instance")) && (!isXsi || attrib.equals("nil") || attrib.equals("type") || attrib.equals("schemaLocation") || attrib.equals("noNamespaceSchemaLocation"))) continue;
                this.addError(0, attrib, "", this.fillParams("atribut necunoscut ('@0@') in namespace='@1@'", attrib, isXsi ? "http://www.w3.org/2001/XMLSchema-instance" : this.DEC_NAMESPACE));
            }
        }
        if (this._emptyAttribListFlag) {
            return this._attribFullList;
        }
        return null;
    }

    public int setDbConnection(Connection con) {
        if (this._dbObj != null) {
            return 1;
        }
        if (con == null) {
            return -1;
        }
        this._dbObj = new DbAccessImpl();
        if (this._dbObj.connectDB(con) != null) {
            return -2;
        }
        this._dbObj.setValidator(this);
        return 0;
    }

    public void setOption(long option) {
        this._option = option;
        Const.LEVEL_ERR_21 = this._option == 0L ? Const.LEVEL_ERR_21_DEFAULT : Const.LEVEL_ERR_21_US;
    }

    public void enableDbOperation() {
        if (this._dbObj != null) {
            this._writeDB = true;
        }
    }

    public void disableDbOperation() {
        this._writeDB = false;
    }

    public long round(double val) {
        long ret = Math.round(val);
        if (ret == 0L && val != 0.0) {
            return 1L;
        }
        return ret;
    }

    public Object getParams() {
        return this._params;
    }

    public String getSchemaNamespace() {
        return this.DEC_NAMESPACE;
    }

    static {
        Arrays.sort(_tags);
        _dateFormat.setLenient(false);
    }
}

