/*
 * Decompiled with CFR 0.152.
 */
package d100validator.v9;

import d100validator.v9.DataObjectRoot;
import d100validator.v9.Obligatie;
import d100validator.v9.ValidatorImpl;
import dec.DECConst;
import java.util.Date;

public class Declaratie100
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    long _sumaControl;
    int _total_oblig_1;
    int _total_oblig_2;
    String _luna;
    long _luna_f;
    boolean _luna_ok;
    String _an;
    long _an_f;
    boolean _an_ok;
    String _d_anulare;
    long _d_anulare_f;
    boolean _d_anulare_ok;
    String _temei;
    long _temei_f;
    boolean _temei_ok;
    String _d_succ;
    long _d_succ_f;
    boolean _d_succ_ok;
    String _cifS;
    boolean _cifS_ok;
    String _d_dizolv;
    long _d_dizolv_f;
    boolean _d_dizolv_ok;
    String _d_energie;
    long _d_energie_f;
    boolean _d_energie_ok;
    String _nume_declar;
    String _prenume_declar;
    String _functie_declar;
    String _cui;
    String _den;
    String _adresa;
    String _telefon;
    String _fax;
    String _mail;
    String _totalPlata_A;
    long _totalPlata_A_f;
    String d_modif;
    long d_modif_f;
    String _cuiR;
    String _denR;
    String _adresaR;
    String _telefonR;
    String _faxR;
    String _mailR;
    String _Data_I;
    Date _Data_I_f;
    boolean _Data_I_ok;
    String _Data_IC;
    Date _Data_IC_f;
    boolean _Data_IC_ok;
    String _d_nInf;
    long _d_nInf_f;
    boolean _d_nInf_ok;
    String _d_bonif;
    long _d_bonif_f;
    boolean _d_bonif_ok;
    boolean este701;

    public Declaratie100(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        long l;
        this.startValidation(n);
        this._luna = this._validator.nextAttributeInInterval(1L, 12L, "luna", 0, 1, 1);
        this._luna_f = this._validator._integerValue;
        this._luna_ok = this._validator._attributeOK;
        this._an = this._validator.nextAttributeInInterval(2011L, 2100L, "an", 0, 1, 1);
        this._an_f = this._validator._integerValue;
        this._an_ok = this._validator._attributeOK;
        if (this._validator._extractValuesFlag == 1) {
            return;
        }
        this._d_anulare = this._validator.nextAttributeInInterval(0L, 1L, "d_anulare", 0, 1, 1);
        this._d_anulare_f = this._validator._integerValue;
        this._d_anulare_ok = this._validator._attributeOK;
        this._temei = this._validator.nextAttributeInInterval(1L, 2L, "temei", 0, 1, 0);
        this._temei_f = this._validator._integerValue;
        this._temei_ok = this._validator._attributeOK;
        this._d_succ = this._validator.nextAttributeInInterval(0L, 1L, "d_succ", 0, 1, 0);
        this._d_succ_f = this._validator._integerValue;
        this._d_succ_ok = this._validator._attributeOK;
        this._cifS = this._validator.nextAttributeAsCif("cifS", 0);
        this._cifS_ok = this._validator._attributeOK;
        this._d_dizolv = this._validator.nextAttributeInInterval(0L, 1L, "d_dizolv", 0, 1, 0);
        this._d_dizolv_f = this._validator._integerValue;
        this._d_dizolv_ok = this._validator._attributeOK;
        this._d_energie = this._validator.nextAttributeInInterval(0L, 0L, "d_energie", 0, 1, 0);
        this._d_energie_f = this._validator._integerValue;
        this._d_energie_ok = this._validator._attributeOK;
        this.d_modif = this._validator.nextAttributeInInterval(0L, 1L, "d_modif", 0, 1, 0);
        this.d_modif_f = this._validator._integerValue;
        this._nume_declar = this._validator.nextAttribute("nume_declar", 75, 4, 1);
        this._prenume_declar = this._validator.nextAttribute("prenume_declar", 75, 4, 1);
        this._functie_declar = this._validator.nextAttribute("functie_declar", 50, 4, 1);
        this._cui = this._validator.nextAttributeAsCif("cui", 1);
        this._den = this._validator.nextAttribute("den", 200, 4, 1);
        this._adresa = this._validator.nextAttribute("adresa", 1000, 4, 1);
        this._telefon = this._validator.nextAttribute("telefon", 15, 4, 0);
        this._fax = this._validator.nextAttribute("fax", 15, 4, 0);
        this._mail = this._validator.nextAttributeEmail("mail", 200, 0);
        this._totalPlata_A = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "totalPlata_A", 0, 1, 1);
        this._totalPlata_A_f = this._validator._integerValue;
        this._cuiR = this._validator.nextAttributeAsCif("cifR", 0);
        this._denR = this._validator.nextAttribute("denR", 200, 4, 0);
        this._adresaR = this._validator.nextAttribute("adrR", 1000, 4, 0);
        this._telefonR = this._validator.nextAttribute("telR", 15, 4, 0);
        this._faxR = this._validator.nextAttribute("faxR", 15, 4, 0);
        this._mailR = this._validator.nextAttributeEmail("emailR", 200, 0);
        this._Data_I = this._validator.nextAttribute("Data_I", 0, 3, 0);
        this._Data_I_f = this._validator._dateValue;
        this._Data_I_ok = this._validator._attributeOK;
        if (this._Data_I != null) {
            l = Long.parseLong(this._Data_I.substring(3, 5));
            long l2 = Long.parseLong(this._Data_I.substring(6, 10));
            if (l != this._luna_f || l2 != this._an_f) {
                this._validator.addError(1, "Rdata_I", "", this._validator.fillParams("luna, an ( @0@, @1@ ) din data_I diferite de luna, an raportare ( @2@, @3@ )", new Object[]{this._Data_I.substring(3, 5), this._Data_I.substring(6, 10), this._luna, this._an}));
            }
        }
        this._Data_IC = this._validator.nextAttribute("Data_IC", 0, 3, 0);
        this._Data_IC_f = this._validator._dateValue;
        this._Data_IC_ok = this._validator._attributeOK;
        this._d_nInf = this._validator.nextAttributeInInterval(0L, 1L, "d_nInf", 0, 1, 0);
        this._d_nInf_f = this._validator._integerValue;
        this._d_nInf_ok = this._validator._attributeOK;
        this._d_bonif = this._validator.nextAttributeInInterval(0L, 1L, "d_bonif", 0, 1, 0);
        this._d_bonif_f = this._validator._integerValue;
        this._d_bonif_ok = this._validator._attributeOK;
        if (this._Data_IC == null || (l = Long.parseLong(this._Data_IC.substring(6, 10))) != this._an_f) {
            // empty if block
        }
        if (this._an_f < 2011L || this._an_f == 2011L && this._luna_f < 11L) {
            this._validator.addError(1, "R2", "", this._validator.fillParams("nu puteti depune declaratia D100 in format XML pt. perioade anterioare lui 11.2011 (luna @0@, anul @1@)", new Object[]{this._luna, this._an}));
        }
        this.endValidation(n);
    }

    public void aggregation(int n) {
        if (this._totalPlata_A_f != this._sumaControl) {
            this._validator.addError(1, "R11b", "", this._validator.fillParams("totalPlata_A (@0@) = Suma(suma_dat + suma_ded + suma_plata + suma_rest) (@1@)", new Object[]{this._totalPlata_A, Long.toString(this._sumaControl)}));
        }
        if (this._d_anulare_f != 0L && this._temei_f == 0L) {
            this._validator.addError(1, "R2b", "", "daca atributul d_anulare este diferit de zero (bifat) atunci atributul temei trebuie sa fie completat");
        }
        if (this._d_succ_ok && this._cifS_ok && this._d_succ_f != 0L && this._cifS == null) {
            this._validator.addError(1, "R2d", "", "daca atributul d_succ este diferit de zero (bifat) atunci atributul cifS trebuie sa fie completat");
        }
        if (this._d_nInf_f + this._d_dizolv_f > 2L || this._d_nInf_f + this._d_bonif_f > 2L || this._d_bonif_f + this._d_dizolv_f > 2L) {
            this._validator.addError(1, "Rbife", "", "aceasta combinatie de bife nu este permisa");
        }
        if (this._Data_IC != null && !this.este701) {
            this._validator.addError(1, "RdataIC", "", "dacaIC trebuie sa fie null");
        }
        if (!this.este701 && this._d_nInf_f + this._d_bonif_f > 0L) {
            this._validator.addError(1, "Rbife2", "", "bifa nou infiintat si bifa bonificatie trebuie sa fie null daca nu exista cod impozit 701");
        }
    }

    public void initialization() {
        this._luna = null;
        this._luna_f = 0L;
        this._luna_ok = false;
        this._an = null;
        this._an_f = 0L;
        this._an_ok = false;
        this._d_anulare = null;
        this._d_anulare_f = 0L;
        this._d_anulare_ok = false;
        this._temei = null;
        this._temei_f = 0L;
        this._temei_ok = false;
        this._d_succ = null;
        this._d_succ_f = 0L;
        this._d_succ_ok = false;
        this._cifS = null;
        this._cifS_ok = false;
        this._d_dizolv = null;
        this._d_dizolv_f = 0L;
        this._d_dizolv_ok = false;
        this._nume_declar = null;
        this._prenume_declar = null;
        this._functie_declar = null;
        this._cui = null;
        this._den = null;
        this._adresa = null;
        this._telefon = null;
        this._fax = null;
        this._mail = null;
        this._totalPlata_A = null;
        this._totalPlata_A_f = 0L;
        this._sumaControl = 0L;
        this._total_oblig_1 = 0;
        this._total_oblig_2 = 0;
        this._d_energie = null;
        this._d_energie_f = 0L;
        this._d_energie_ok = false;
        this.d_modif = null;
        this.d_modif_f = 0L;
        this._cuiR = null;
        this._denR = null;
        this._adresaR = null;
        this._telefonR = null;
        this._faxR = null;
        this._mailR = null;
        this._Data_I = null;
        this._Data_I_f = null;
        this._Data_I_ok = false;
        this._Data_IC = null;
        this._Data_IC_f = null;
        this._Data_IC_ok = false;
        this._d_nInf = null;
        this._d_nInf_f = 0L;
        this._d_nInf_ok = false;
        this._d_bonif = null;
        this._d_bonif_f = 0L;
        this._d_bonif_ok = false;
        this.este701 = false;
    }

    public void checkUniqueness(Obligatie[] obligatieArray, int n) {
        Obligatie obligatie = null;
        Obligatie obligatie2 = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            obligatie = obligatieArray[i];
            n2 = (int)obligatie._cod_oblig_f;
            if (obligatie2 != null && (long)n2 == obligatie2._cod_oblig_f) {
                if (n2 != 510 && (n2 < 200 || n2 > 299)) {
                    this._validator.addError(1, "R15", "", this._validator.fillParams("nu se accepta mai multe declaratii cu cod_oblig = @0@ in aceeasi luna", new Object[]{obligatie._cod_oblig}));
                }
                if (n2 == 510 && i >= 2 && (long)n2 == obligatieArray[i - 2]._cod_oblig_f) {
                    this._validator.addError(1, "R15.1", "", this._validator.fillParams("nu se accepta mai mult de 2 declaratii cu cod_oblig = @0@ in aceeasi luna", new Object[]{obligatie._cod_oblig}));
                } else if (obligatie2._scadentaFormatSort.equals(obligatie._scadentaFormatSort)) {
                    this._validator.addError(1, "R15.2", "", this._validator.fillParams("nu se accepta mai multe declaratii cu cod_oblig = @0@ si avand aceeasi scadenta (@1@)", new Object[]{obligatie._cod_oblig, obligatie._scadenta}));
                }
            }
            obligatie2 = obligatie;
        }
    }
}

