/*
 * Decompiled with CFR 0.152.
 */
package d100validator.v4;

import d100validator.v4.DataObjectRoot;
import d100validator.v4.Declaratie100;
import d100validator.v4.ValidatorImpl;

public class Distrib
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    String _cod_judet;
    long _cod_judet_f;
    String _den_uat;
    String _cif_uat;
    long _cif_uat_f;
    String _total_impozit;
    double _total_impozit_f;
    String _cota;
    double _cota_f;
    boolean _cota_ok;

    public Distrib(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        Declaratie100 declaratie100 = (Declaratie100)this._parent;
        this.startValidation(n);
        this._cod_judet = this._validator.nextAttributeInList(this._params.codJudet, "cod_judet", 256, 4, 1);
        this._den_uat = this._validator.nextAttribute("den_uat", 200, 4, 1);
        this._cif_uat = this._validator.nextAttributeAsCif("cif_uat", 1);
        this._total_impozit = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "total_impozit", 1);
        this._total_impozit_f = this._validator._realValue;
        this._cota = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "cota", 1);
        this._cota_f = this._validator._realValue;
        double d = 0.0;
        d = 0.5 * this._total_impozit_f;
        long l = this._validator.round(d * 10000.0);
        double d2 = (double)l / 100.0;
        l = this._validator.round(d2);
        double d3 = (double)l / 100.0;
        if (this._cota_f != d3) {
            this._validator.addError(1, "Rdistrib6", "", this._validator.fillParams("cota (@0@) diferita de suma calculata (@1@)", new Object[]{Double.toString(this._cota_f), Double.toString(d3)}));
        }
        this.endValidation(n);
    }

    public void aggregation(int n) {
        Declaratie100 declaratie100 = (Declaratie100)this._parent;
        declaratie100.val_distribuita += this._cota_f;
        declaratie100.e_distrib = 1L;
        declaratie100.distrib += this._validator.round(this._cota_f * 100.0);
        if (this._cif_uat != null) {
            if (Declaratie100._cnpUnic.contains(this._cif_uat)) {
                this._validator.addError(1, "Rcif_uat", "", this._validator.fillParams("cif_uat trebuie sa fie unic pe declaratie", new Object[0]));
            } else {
                Declaratie100._cnpUnic.add(this._cif_uat);
            }
        }
    }

    public void initialization() {
        this._cod_judet = null;
        this._cod_judet_f = 0L;
        this._den_uat = null;
        this._cif_uat = null;
        this._cif_uat_f = 0L;
        this._total_impozit = null;
        this._total_impozit_f = 0.0;
        this._cota = null;
        this._cota_f = 0.0;
        this._cota_ok = false;
    }
}

