/*
 * Decompiled with CFR 0.152.
 */
package d100validator.v3;

import d100validator.v3.DataObjectRoot;
import d100validator.v3.Obligatie;
import d100validator.v3.ValidatorImpl;
import dec.DECConst;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Declaratie100
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    long _sumaControl;
    int _total_oblig_1;
    int _total_oblig_2;
    String _luna;
    long _luna_f;
    boolean _luna_ok;
    String _an;
    long _an_f;
    boolean _an_ok;
    String _d_anulare;
    long _d_anulare_f;
    boolean _d_anulare_ok;
    String _temei;
    long _temei_f;
    boolean _temei_ok;
    String _d_succ;
    long _d_succ_f;
    boolean _d_succ_ok;
    String _cifS;
    boolean _cifS_ok;
    String _d_dizolv;
    long _d_dizolv_f;
    boolean _d_dizolv_ok;
    String _nume_declar;
    String _prenume_declar;
    String _functie_declar;
    String _cui;
    String _den;
    String _adresa;
    String _telefon;
    String _fax;
    String _mail;
    String _totalPlata_A;
    long _totalPlata_A_f;
    String _suma_distrib;
    double _suma_distrib_f;
    boolean _suma_distrib_ok;
    double val_distribuita;
    long suma620 = 0L;
    long distrib = 0L;
    long e_distrib;
    long e_620;
    String _nr_borderou;
    boolean _nr_borderou_ok;
    String _nr_data_borderou;
    Date _nr_data_borderou_f;
    boolean _nr_data_borderou_ok;
    public static Set<String> _cnpUnic = new HashSet<String>();
    long impozit620;
    long obligatie620;

    public Declaratie100(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._luna = this._validator.nextAttributeInInterval(1L, 12L, "luna", 0, 1, 1);
        this._luna_f = this._validator._integerValue;
        this._luna_ok = this._validator._attributeOK;
        this._an = this._validator.nextAttributeInInterval(2011L, 2100L, "an", 0, 1, 1);
        this._an_f = this._validator._integerValue;
        this._an_ok = this._validator._attributeOK;
        if (this._validator._extractValuesFlag == 1) {
            return;
        }
        this._d_anulare = this._validator.nextAttributeInInterval(0L, 1L, "d_anulare", 0, 1, 1);
        this._d_anulare_f = this._validator._integerValue;
        this._d_anulare_ok = this._validator._attributeOK;
        this._temei = this._validator.nextAttributeInInterval(1L, 2L, "temei", 0, 1, 0);
        this._temei_f = this._validator._integerValue;
        this._temei_ok = this._validator._attributeOK;
        this._d_succ = this._validator.nextAttributeInInterval(0L, 1L, "d_succ", 0, 1, 0);
        this._d_succ_f = this._validator._integerValue;
        this._d_succ_ok = this._validator._attributeOK;
        this._cifS = this._validator.nextAttributeAsCif("cifS", 0);
        this._cifS_ok = this._validator._attributeOK;
        this._d_dizolv = this._validator.nextAttributeInInterval(0L, 1L, "d_dizolv", 0, 1, 0);
        this._d_dizolv_f = this._validator._integerValue;
        this._d_dizolv_ok = this._validator._attributeOK;
        this._nume_declar = this._validator.nextAttribute("nume_declar", 75, 4, 1);
        this._prenume_declar = this._validator.nextAttribute("prenume_declar", 75, 4, 1);
        this._functie_declar = this._validator.nextAttribute("functie_declar", 50, 4, 1);
        this._cui = this._validator.nextAttributeAsCif("cui", 1);
        this._den = this._validator.nextAttribute("den", 200, 4, 1);
        this._adresa = this._validator.nextAttribute("adresa", 1000, 4, 1);
        this._telefon = this._validator.nextAttribute("telefon", 15, 4, 0);
        this._fax = this._validator.nextAttribute("fax", 15, 4, 0);
        this._mail = this._validator.nextAttributeEmail("mail", 200, 0);
        this._totalPlata_A = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "totalPlata_A", 0, 1, 1);
        this._totalPlata_A_f = this._validator._integerValue;
        this._suma_distrib = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "suma_distrib", 0);
        this._suma_distrib_f = this._validator._realValue;
        this._suma_distrib_ok = this._validator._attributeOK;
        this._nr_borderou = this._validator.nextAttribute("nr_borderou", 20, 4, 0);
        this._nr_borderou_ok = this._validator._attributeOK;
        this._nr_data_borderou = this._validator.nextAttribute("data_borderou", 0, 3, 0);
        this._nr_data_borderou_f = this._validator._dateValue;
        this._nr_data_borderou_ok = this._validator._attributeOK;
        if (this._an_f < 2011L || this._an_f == 2011L && this._luna_f < 11L) {
            this._validator.addError(1, "R2", "", this._validator.fillParams("nu puteti depune declaratia D100 in format XML pt. perioade anterioare lui 11.2011 (luna @0@, anul @1@)", new Object[]{this._luna, this._an}));
        }
        this.endValidation(n);
    }

    public void aggregation(int n) {
        double d;
        if (this._totalPlata_A_f != this._sumaControl) {
            this._validator.addError(1, "R11b", "", this._validator.fillParams("totalPlata_A (@0@) = Suma(suma_dat + suma_ded + suma_plata + suma_rest) (@1@)", new Object[]{this._totalPlata_A, Long.toString(this._sumaControl)}));
        }
        if (this._d_anulare_f != 0L && this._temei_f == 0L) {
            this._validator.addError(1, "R2b", "", "daca atributul d_anulare este diferit de zero (bifat) atunci atributul temei trebuie sa fie completat");
        }
        if (this._d_succ_ok && this._cifS_ok && this._d_succ_f != 0L && this._cifS == null) {
            this._validator.addError(1, "R2d", "", "daca atributul d_succ este diferit de zero (bifat) atunci atributul cifS trebuie sa fie completat");
        }
        if ((d = (double)this.distrib / 100.0) != this._suma_distrib_f) {
            this._validator.addError(1, "R11e", "", this._validator.fillParams("suma_distrib (@0@) diferita de suma calculata (@1@)", new Object[]{this._suma_distrib, Double.toString(d)}));
        }
        if (this.obligatie620 != this._validator.round(this.impozit620 / 100L)) {
            this._validator.addError(1, "R11f", "", this._validator.fillParams("total plata obligatie 620 (@0@)diferit de suma calculata (@1@)", new Object[]{Long.toString(this.obligatie620), Long.toString(this._validator.round(this.impozit620 / 100L))}));
        }
        if (this.suma620 < this._validator.round(this._suma_distrib_f)) {
            this._validator.addError(1, "R11e", "", this._validator.fillParams("suma_distrib (@0@) nu poate depasi suma de plata pt cod oblig 620 (@1@)", new Object[]{this._suma_distrib, Long.toString(this.suma620)}));
        }
        if (this.e_620 * this.e_distrib == 0L && this.e_620 + this.e_distrib > 0L) {
            this._validator.addError(1, "R11e", "", this._validator.fillParams("sectiunea distrib apare <=> cod_oblig=620 si suma_dat >0", new Object[0]));
        }
    }

    public void initialization() {
        this._luna = null;
        this._luna_f = 0L;
        this._luna_ok = false;
        this._an = null;
        this._an_f = 0L;
        this._an_ok = false;
        this._d_anulare = null;
        this._d_anulare_f = 0L;
        this._d_anulare_ok = false;
        this._temei = null;
        this._temei_f = 0L;
        this._temei_ok = false;
        this._d_succ = null;
        this._d_succ_f = 0L;
        this._d_succ_ok = false;
        this._cifS = null;
        this._cifS_ok = false;
        this._d_dizolv = null;
        this._d_dizolv_f = 0L;
        this._d_dizolv_ok = false;
        this._nume_declar = null;
        this._prenume_declar = null;
        this._functie_declar = null;
        this._cui = null;
        this._den = null;
        this._adresa = null;
        this._telefon = null;
        this._fax = null;
        this._mail = null;
        this._totalPlata_A = null;
        this._totalPlata_A_f = 0L;
        this._sumaControl = 0L;
        this._total_oblig_1 = 0;
        this._total_oblig_2 = 0;
        this._nr_borderou = null;
        this._nr_borderou_ok = false;
        this._nr_data_borderou = null;
        this._nr_data_borderou_f = null;
        this._nr_data_borderou_ok = false;
        this._suma_distrib = null;
        this._suma_distrib_f = 0.0;
        this._suma_distrib_ok = false;
        this.val_distribuita = 0.0;
        this.suma620 = 0L;
        this.distrib = 0L;
        _cnpUnic.clear();
        this.e_distrib = 0L;
        this.e_620 = 0L;
        this.impozit620 = 0L;
        this.obligatie620 = 0L;
    }

    public void checkUniqueness(Obligatie[] obligatieArray, int n) {
        Obligatie obligatie = null;
        Obligatie obligatie2 = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            obligatie = obligatieArray[i];
            n2 = (int)obligatie._cod_oblig_f;
            if (obligatie2 != null && (long)n2 == obligatie2._cod_oblig_f) {
                if (n2 != 510 && (n2 < 200 || n2 > 299)) {
                    this._validator.addError(1, "R15", "", this._validator.fillParams("nu se accepta mai multe declaratii cu cod_oblig = @0@ in aceeasi luna", new Object[]{obligatie._cod_oblig}));
                }
                if (n2 == 510 && i >= 2 && (long)n2 == obligatieArray[i - 2]._cod_oblig_f) {
                    this._validator.addError(1, "R15.1", "", this._validator.fillParams("nu se accepta mai mult de 2 declaratii cu cod_oblig = @0@ in aceeasi luna", new Object[]{obligatie._cod_oblig}));
                } else if (obligatie2._scadentaFormatSort.equals(obligatie._scadentaFormatSort)) {
                    this._validator.addError(1, "R15.2", "", this._validator.fillParams("nu se accepta mai multe declaratii cu cod_oblig = @0@ si avand aceeasi scadenta (@1@)", new Object[]{obligatie._cod_oblig, obligatie._scadenta}));
                }
            }
            obligatie2 = obligatie;
        }
    }
}

