/*
 * Decompiled with CFR 0.152.
 */
package d100validator.v2;

import d100validator.Parameters;
import d100validator.v2.DataObjectRoot;
import d100validator.v2.Declaratie100;
import d100validator.v2.ValidatorImpl;
import dec.DECConst;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class Obligatie
extends DataObjectRoot
implements Comparable {
    public static final int TAG_COUNT = 1;
    static SimpleDateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    static SimpleDateFormat _dateFormat1 = new SimpleDateFormat("dd.MM.yyyy");
    final String _idMask = "cod_oblig=@0@ scadenta=@1@";
    String _name;
    String _scadentaFormatSort;
    String _scadentaFormatDeclaratie;
    String _tip_oblig;
    String _cod_oblig;
    long _cod_oblig_f;
    boolean _cod_oblig_ok;
    String _cod_bugetar;
    String _scadenta;
    Date _scadenta_f;
    boolean _scadenta_ok;
    String _nr_evid;
    long _nr_evid_f;
    boolean _nr_evid_ok;
    String _suma_dat;
    long _suma_dat_f;
    String _suma_ded;
    long _suma_ded_f;
    String _suma_plata;
    long _suma_plata_f;
    String _suma_rest;
    long _suma_rest_f;
    String _cota;
    long _cota_f;
    boolean _cota_ok;
    String _suma_bonif;
    long _suma_bonif_f;
    boolean _suma_bonif_ok;

    public Obligatie(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        Declaratie100 declaratie100 = (Declaratie100)this._parent;
        long l = 0L;
        long l2 = 0L;
        String string = null;
        String string2 = null;
        this.startValidation(n);
        this._validator.initDeferredError("cod_oblig=@0@ scadenta=@1@");
        this._cod_oblig = this._validator.nextAttributeInList(this._params._listaCodOblig, "cod_oblig", 0, 1, 1);
        this._cod_oblig_f = this._validator._integerValue;
        this._cod_oblig_ok = this._validator._attributeOK;
        this._scadenta = this._validator.nextAttribute("scadenta", 0, 3, 1);
        this._scadenta_f = this._validator._dateValue;
        this._scadenta_ok = this._validator._attributeOK;
        this._validator.exitDeferredError(new Object[]{this._cod_oblig, this._scadenta});
        this._cod_bugetar = this._validator.nextAttribute("cod_bugetar", 10, 4, 1);
        this._nr_evid = this._validator.nextAttributeStringAsLong("nr_evid", 23, 1);
        this._nr_evid_ok = this._validator._attributeOK;
        this._suma_dat = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "suma_dat", 0, 1, 0);
        this._suma_dat_f = this._validator._integerValue;
        this._suma_bonif = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "suma_bonif", 0, 1, 0);
        this._suma_bonif_f = this._validator._integerValue;
        this._suma_ded = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "suma_ded", 0, 1, 0);
        this._suma_ded_f = this._validator._integerValue;
        this._suma_plata = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "suma_plata", 0, 1, 0);
        this._suma_plata_f = this._validator._integerValue;
        this._suma_rest = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "suma_rest", 0, 1, 0);
        this._suma_rest_f = this._validator._integerValue;
        this._cota = this._validator.nextAttributeInList(this._params._listaCote, "cota", 0, 1, 0);
        this._cota_f = this._validator._integerValue;
        this._cota_ok = this._validator._attributeOK;
        if (this._suma_bonif_f > 0L && (declaratie100._an_f == 2020L && declaratie100._luna_f >= 12L || declaratie100._an_f > 2020L)) {
            this._validator.addError(1, "Rbonif3", "", this._validator.fillParams("suma_bonif(@0@) trebuie sa fie egal cu 0 incepand cu luna 06 an 2020", new Object[]{this._suma_bonif}));
        }
        declaratie100._sumaControl += this._suma_dat_f + this._suma_ded_f + this._suma_plata_f + this._suma_rest_f + this._suma_bonif_f;
        if (this._scadenta_ok) {
            this._scadentaFormatSort = _dateFormat.format(this._scadenta_f);
            this._scadentaFormatDeclaratie = _dateFormat1.format(this._scadenta_f);
        }
        if (this._cod_oblig_ok) {
            Parameters.StatusTable statusTable = new Parameters.StatusTable();
            Parameters.ObligatieIsActive obligatieIsActive = new Parameters.ObligatieIsActive();
            obligatieIsActive._codOblig = (int)this._cod_oblig_f;
            obligatieIsActive._aux = 0;
            int n2 = Arrays.binarySearch(this._params._obligActiveTable, obligatieIsActive);
            if (n2 >= 0) {
                while (n2 < this._params._obligActiveTable.length) {
                    obligatieIsActive = this._params._obligActiveTable[n2];
                    if (obligatieIsActive._codOblig != (int)this._cod_oblig_f || declaratie100._an_f >= (long)obligatieIsActive._startYear && (declaratie100._an_f != (long)obligatieIsActive._startYear || declaratie100._luna_f >= (long)obligatieIsActive._startMonth) && declaratie100._an_f <= (long)obligatieIsActive._endYear && (declaratie100._an_f != (long)obligatieIsActive._endYear || declaratie100._luna_f <= (long)obligatieIsActive._endMonth)) break;
                    ++n2;
                }
                if (n2 >= this._params._obligActiveTable.length || obligatieIsActive._codOblig != (int)this._cod_oblig_f) {
                    this._validator.addError(1, "R13.1", "", this._validator.fillParams("cod obligatie (@0@) nu poate fi folosit pentru perioada @1@.@2@", new Object[]{this._cod_oblig, declaratie100._luna, declaratie100._an}));
                    n2 = 0;
                } else {
                    n2 = this._params._obligActiveTable[n2]._auxY;
                }
            } else {
                n2 = 0;
            }
            statusTable._codOblig = (int)this._cod_oblig_f;
            statusTable._auxY = n2;
            n2 = Arrays.binarySearch(this._params._statusTable, statusTable);
            if (n2 < 0) {
                this._validator.addError(3, "eroare interna", "", this._validator.fillParams("cod obligatie (@0@) negasit in tabela statusTable", new Object[]{this._cod_oblig}));
            } else {
                statusTable = this._params._statusTable[n2];
                this._name = statusTable._name;
                n2 = Arrays.binarySearch(this._params._contUnic, this._cod_oblig_f);
                if (n2 >= 0) {
                    declaratie100._total_oblig_1 = (int)((long)declaratie100._total_oblig_1 + this._suma_plata_f);
                    this._tip_oblig = "1";
                } else {
                    declaratie100._total_oblig_2 = (int)((long)declaratie100._total_oblig_2 + this._suma_plata_f);
                    this._tip_oblig = "2";
                }
                if (declaratie100._d_dizolv_f == 0L || Arrays.binarySearch(this._params._exceptiiPerioadaDizolv, (int)this._cod_oblig_f) < 0) {
                    if (statusTable._period.equals("T") && declaratie100._luna_f % 3L != 0L) {
                        this._validator.addError(1, "R13", "", this._validator.fillParams("cod obligatie (@0@) necesita raportare trimestriala si luna (@1@) trebuie sa fie 3, 6, 9 sau 12", new Object[]{this._cod_oblig, declaratie100._luna}));
                    }
                    if (statusTable._period.equals("S") && declaratie100._luna_f % 6L != 0L && declaratie100._an_f != 2017L) {
                        this._validator.addError(1, "R13", "", this._validator.fillParams("cod obligatie (@0@) necesita raportare semestriala si luna (@1@) trebuie sa fie 6 sau 12", new Object[]{this._cod_oblig, declaratie100._luna}));
                    }
                    if (declaratie100._an_f == 2017L) {
                        if (statusTable._period.equals("S") && declaratie100._luna_f % 6L != 0L && this._cod_oblig_f != 130L) {
                            this._validator.addError(1, "R13", "", this._validator.fillParams("cod obligatie (@0@) necesita raportare semestriala si luna (@1@) trebuie sa fie 6 sau 12", new Object[]{this._cod_oblig, declaratie100._luna}));
                        }
                        if (statusTable._period.equals("S") && declaratie100._luna_f != 7L && declaratie100._luna_f != 6L && declaratie100._luna_f != 12L && this._cod_oblig_f == 130L) {
                            this._validator.addError(1, "R13", "", this._validator.fillParams("cod obligatie (@0@) necesita luna de raportare = 7 pt an = 2017 sau raportare semestriala si luna (@1@) trebuie sa fie 6 sau 12 ", new Object[]{this._cod_oblig, declaratie100._luna}));
                        }
                    }
                }
                if (!statusTable._codBugetar.equals("X")) {
                    if (!statusTable._codBugetar.equals(this._cod_bugetar.replaceAll("X", "").replaceAll("x", "")) && !"5503".equals(this._cod_bugetar.replaceAll("X", "").replaceAll("x", "")) && (statusTable._codBugetar.equals("5502") || statusTable._codBugetar.equals("20470101"))) {
                        this._validator.addError(1, "R14a", "", this._validator.fillParams("cod bugetar (@0@) trebuie sa fie = @1@ pt. acest cod_oblig", new Object[]{this._cod_bugetar, statusTable._codBugetar}), 0);
                    }
                    if (!(statusTable._codBugetar.equals(this._cod_bugetar.replaceAll("X", "").replaceAll("x", "")) || statusTable._codBugetar.equals("5502") || statusTable._codBugetar.equals("20470101"))) {
                        this._validator.addError(1, "R14b", "", this._validator.fillParams("cod bugetar (@0@) trebuie sa fie = @1@ pt. acest cod_oblig", new Object[]{this._cod_bugetar, statusTable._codBugetar}), 0);
                    }
                }
                if (this._cod_oblig_f != 102L && this._cod_oblig_f != 103L && this._cod_oblig_f != 105L && this._cod_oblig_f != 121L && this._suma_bonif_f > 0L) {
                    this._validator.addError(1, "Rbonif", "", this._validator.fillParams("suma_bonif > 0 daca si numai daca cod_oblig in (102,103,105,121)", new Object[0]));
                }
                if (this._cod_oblig_f == 103L && declaratie100._an_f == 2012L && declaratie100._luna_f == 12L) {
                    this._validator.addError(1, "R15.1", "", this._validator.fillParams("cod obligatie = @0@ nu poate fi folosit pt. perioada 12.2012", new Object[]{this._cod_oblig}));
                }
                if (this._scadenta_ok && declaratie100._luna_ok && declaratie100._an_ok) {
                    n2 = statusTable._scadentaType;
                    l2 = declaratie100._an_f;
                    l = declaratie100._luna_f;
                    switch (n2) {
                        case 9: {
                            string = (l2 % 4L == 0L ? "28" : "29") + ".07." + Long.toString(l2);
                            break;
                        }
                        case 6: {
                            if ((l += 2L) > 12L) {
                                ++l2;
                                l -= 12L;
                            }
                            string = "25." + (l < 10L ? "0" : "") + Long.toString(l) + "." + Long.toString(l2);
                            break;
                        }
                        case 1: {
                            ++l;
                            if (this._cod_oblig_f == 130L && declaratie100._luna_f == 6L && declaratie100._an_f == 2020L) {
                                l += 3L;
                            }
                            if (l > 12L) {
                                ++l2;
                                l -= 12L;
                            }
                            string = "25." + (l < 10L ? "0" : "") + Long.toString(l) + "." + Long.toString(l2);
                            break;
                        }
                        case 2: {
                            if (++l > 12L) {
                                ++l2;
                                l -= 12L;
                            }
                            if (!(string = "25." + (l < 10L ? "0" : "") + Long.toString(l) + "." + Long.toString(l2)).equals(this._scadentaFormatDeclaratie) && declaratie100._luna_f != (long)Integer.parseInt(this._scadentaFormatDeclaratie.substring(3, 5))) {
                                this._validator.addError(1, "R15", "", this._validator.fillParams("scadenta (@0@) ar fi trebuit sa fie @1@ sau orice data din luna @2@", new Object[]{this._scadentaFormatDeclaratie, string, declaratie100._luna}), 0);
                            }
                            string = this._scadentaFormatDeclaratie;
                            break;
                        }
                        case 3: {
                            if (l != 12L) {
                                ++l;
                            }
                            string = "25." + (l < 10L ? "0" : "") + Long.toString(l) + "." + Long.toString(l2);
                            break;
                        }
                        case 4: {
                            l = l >= 6L ? 6L : ++l;
                            string = "25." + (l < 10L ? "0" : "") + Long.toString(l) + "." + Long.toString(l2);
                            break;
                        }
                        case 5: {
                            string = this._scadentaFormatDeclaratie;
                            break;
                        }
                        case 7: {
                            if (++l > 12L) {
                                ++l2;
                                l -= 10L;
                            }
                            string = "25." + (l < 10L ? "0" : "") + Long.toString(l) + "." + Long.toString(l2);
                            break;
                        }
                        case 8: {
                            if (++l > 12L) {
                                ++l2;
                                l -= 12L;
                            }
                            if (!(string = "25." + (l < 10L ? "0" : "") + Long.toString(l) + "." + Long.toString(l2)).equals(this._scadentaFormatDeclaratie) && declaratie100._luna_f == 12L && !(string2 = "25." + ((l += 2L) < 10L ? "0" : "") + Long.toString(l) + "." + Long.toString(l2)).equals(this._scadentaFormatDeclaratie)) {
                                this._validator.addError(1, "R15", "", this._validator.fillParams("scadenta (@0@) ar fi trebuit sa fie @1@ sau @2@ pt. cod obligatie=@3@", new Object[]{this._scadentaFormatDeclaratie, string, string2, this._cod_oblig}));
                            }
                            string = this._scadentaFormatDeclaratie;
                            break;
                        }
                        case 10: {
                            string = "25.05." + Long.toString(l2);
                            break;
                        }
                        case 11: {
                            string2 = "25." + (l < 10L ? "0" : "") + Long.toString(l) + "." + Long.toString(l2);
                            if (++l > 12L) {
                                ++l2;
                                l -= 12L;
                            }
                            if (!(string = "25." + (l < 10L ? "0" : "") + Long.toString(l) + "." + Long.toString(l2)).equals(this._scadentaFormatDeclaratie) && !string2.equals(this._scadentaFormatDeclaratie)) {
                                this._validator.addError(1, "R15", "", this._validator.fillParams("scadenta (@0@) ar fi trebuit sa fie @1@ sau @2@ pt. cod obligatie=@3@", new Object[]{this._scadentaFormatDeclaratie, string, string2, this._cod_oblig}));
                            }
                            string = this._scadentaFormatDeclaratie;
                            break;
                        }
                        case 12: {
                            if ((l += 2L) > 12L) {
                                ++l2;
                                l -= 12L;
                            }
                            string2 = "25." + (l < 10L ? "0" : "") + Long.toString(l) + "." + Long.toString(l2);
                            if ((l += 2L) > 12L) {
                                ++l2;
                                l -= 12L;
                            }
                            if (!(string = "25." + (l < 10L ? "0" : "") + Long.toString(l) + "." + Long.toString(l2)).equals(this._scadentaFormatDeclaratie) && !string2.equals(this._scadentaFormatDeclaratie)) {
                                this._validator.addError(1, "R15", "", this._validator.fillParams("scadenta (@0@) ar fi trebuit sa fie @1@ sau @2@ pt. cod obligatie=@3@", new Object[]{this._scadentaFormatDeclaratie, string, string2, this._cod_oblig}));
                            }
                            string = this._scadentaFormatDeclaratie;
                        }
                    }
                    if (!string.equals(this._scadentaFormatDeclaratie)) {
                        this._validator.addError(1, "R15", "", this._validator.fillParams("scadenta (@0@) ar fi trebuit sa fie @1@ pt. cod obligatie @2@", new Object[]{this._scadentaFormatDeclaratie, string, this._cod_oblig}));
                    }
                }
            }
            if (this._nr_evid_ok && declaratie100._luna_ok && declaratie100._an_ok) {
                if (this._nr_evid.length() != 23) {
                    this._validator.addError(1, "R16", "Nr. de evidenta a platii este eronat", this._validator.fillParams("nr_evid (@0@) trebuie sa aibe lungimea de 23 caractere", new Object[]{this._nr_evid}));
                } else {
                    if (!(this._nr_evid.substring(0, 2) + this._nr_evid.substring(5, 7) + this._nr_evid.substring(17, 21)).equals("10010000")) {
                        this._validator.addError(1, "R16", "Nr. de evidenta a platii este eronat", this._validator.fillParams("nr_evid (@0@) - pozitii fixe eronate", new Object[]{this._nr_evid}));
                    }
                    if ((long)(n2 = Integer.parseInt(this._nr_evid.substring(2, 5))) != this._cod_oblig_f) {
                        this._validator.addError(1, "R16", "Nr. de evidenta a platii este eronat", this._validator.fillParams("nr_evid (@0@) - cod obligatie (pozitiile 3-5) nu concorda cod_oblig (@1@)", new Object[]{this._nr_evid, this._cod_oblig}));
                    }
                    if (!this._nr_evid.substring(7, 11).equals((declaratie100._luna_f < 10L ? "0" : "") + Long.toString(declaratie100._luna_f) + declaratie100._an.substring(2))) {
                        this._validator.addError(1, "R16", "Nr. de evidenta a platii este eronat", this._validator.fillParams("nr_evid (@0@) - perioada raportare eronata", new Object[]{this._nr_evid}));
                    }
                    if (this._scadenta_ok) {
                        string = this._scadentaFormatSort.substring(8) + this._scadentaFormatSort.substring(5, 7) + this._scadentaFormatSort.substring(2, 4);
                        if (!this._nr_evid.substring(11, 17).equals(string)) {
                            this._validator.addError(1, "R16", "Nr. de evidenta a platii este eronat", this._validator.fillParams("nr_evid (@0@) - scadenta platii eronata", new Object[]{this._nr_evid}));
                        }
                    }
                    char[] cArray = this._validator.getBinaryValues(this._nr_evid);
                    l = 0L;
                    for (int i = 0; i < 21; ++i) {
                        l += (long)cArray[i];
                    }
                    if (l != (long)(cArray[21] * 10 + cArray[22])) {
                        this._validator.addError(1, "R16", "Nr. de evidenta a platii este eronat", this._validator.fillParams("nr_evid (@0@) - cifra control eronata", new Object[]{this._nr_evid}));
                    }
                }
            }
            switch (statusTable._mode) {
                case 1: {
                    if (this._suma_ded_f <= 0L && this._suma_rest_f <= 0L && this._suma_plata_f == this._suma_dat_f) break;
                    this._validator.addError(1, "R17-20.1", "", this._validator.fillParams("Cf. model 1# suma_plata (@0@) = suma_dat (@1@) iar suma_ded (@2@) si suma_rest (@3@) nu se completeaza", new Object[]{this._suma_plata, this._suma_dat, this._suma_ded, this._suma_rest}));
                    break;
                }
                case 2: {
                    if (this._suma_ded_f <= 0L && this._suma_rest_f <= 0L && this._suma_plata_f <= 0L) break;
                    this._validator.addError(1, "R17-20.2", "", this._validator.fillParams("Cf. model 2# suma_dat (@0@) >= 0 iar suma_ded (@1@), suma_plata (@2@) si suma_rest (@3@) nu se completeaza", new Object[]{this._suma_dat, this._suma_ded, this._suma_plata, this._suma_rest}));
                    break;
                }
                case 3: {
                    if (this._suma_rest_f > 0L && (this._suma_dat_f > 0L || this._suma_ded_f > 0L || this._suma_plata_f > 0L)) {
                        this._validator.addError(1, "R17-20.3.2", "", this._validator.fillParams("Cf. model 3# daca suma_rest (@0@) > 0 atunci suma_dat (@1@), suma_ded (@2@) si suma_plata (@3@) nu se completeaza", new Object[]{this._suma_rest, this._suma_dat, this._suma_ded, this._suma_plata}));
                        break;
                    }
                    if (this._suma_rest_f != 0L || this._suma_ded_f <= 0L && this._suma_dat_f == this._suma_plata_f) break;
                    this._validator.addError(1, "R17-20.3.1", "", this._validator.fillParams("Cf. model 3# daca suma_rest (@0@) = 0 atunci suma_dat (@1@) = suma_plata (@2@) si suma_ded (@3@) nu se completeaza", new Object[]{this._suma_rest, this._suma_dat, this._suma_plata, this._suma_ded}));
                    break;
                }
                case 4: {
                    if (this._suma_ded_f <= 0L && this._suma_rest_f <= 0L && this._suma_plata_f <= 0L) break;
                    this._validator.addError(1, "R17-20.4", "", this._validator.fillParams("Cf. model 4# suma_ded (@0@), suma_plata (@1@) si suma_rest (@2@) nu se completeaza", new Object[]{this._suma_ded, this._suma_plata, this._suma_rest}));
                    break;
                }
                case 5: {
                    if (this._suma_plata_f == Math.max(this._suma_dat_f - this._suma_ded_f, 0L)) break;
                    this._validator.addError(1, "R17-20.5", "", this._validator.fillParams("Cf. model 5# suma_plata (@0@) = Maximum(suma_dat (@1@) - suma_ded (@2@), 0)", new Object[]{this._suma_plata, this._suma_dat, this._suma_ded}));
                    break;
                }
                case 6: {
                    if (this._suma_rest_f <= 0L && this._suma_plata_f == Math.max(this._suma_dat_f - this._suma_ded_f, 0L)) break;
                    this._validator.addError(1, "R17-20.6", "", this._validator.fillParams("Cf. model 6# suma_plata (@0@) = Maximum(suma_dat (@1@) - suma_ded (@2@), 0) si suma_rest (@3@) nu se completeaza", new Object[]{this._suma_plata, this._suma_dat, this._suma_ded, this._suma_rest}));
                    break;
                }
                case 7: {
                    if ((this._suma_dat_f < this._suma_ded_f || this._suma_plata_f == this._suma_dat_f - this._suma_ded_f && this._suma_rest_f == 0L) && (this._suma_dat_f >= this._suma_ded_f || this._suma_rest_f == this._suma_ded_f - this._suma_dat_f && this._suma_plata_f == 0L)) break;
                    this._validator.addError(1, "R17-20.7", "", this._validator.fillParams("Cf. model 7# daca suma_dat (@0@) >= suma_ded (@1@) atunci suma_plata (@2@) = suma_dat - suma_ded si suma_rest (@3@) = 0 sau daca suma_ded > suma_dat atunci suma_rest = suma_ded - suma_dat si suma_plata = 0", new Object[]{this._suma_dat, this._suma_ded, this._suma_plata, this._suma_rest}));
                    break;
                }
                case 8: {
                    if ((this._suma_ded_f > 0L || this._suma_rest_f > 0L || this._suma_plata_f != this._suma_dat_f - this._suma_bonif_f) && this._cod_oblig_f != 121L) {
                        this._validator.addError(1, "R17-20.1", "", this._validator.fillParams("Cf. model 8# suma_plata (@0@) = suma_dat - suma_bonif (@1@) iar suma_ded (@2@) si suma_rest (@3@) nu se completeaza", new Object[]{this._suma_plata, Long.toString(this._suma_dat_f - this._suma_bonif_f), this._suma_ded, this._suma_rest}));
                    }
                    if ((this._suma_rest_f > 0L || this._suma_plata_f != this._suma_dat_f - this._suma_bonif_f - this._suma_ded_f) && this._cod_oblig_f == 121L) {
                        this._validator.addError(1, "R17-20.1", "", this._validator.fillParams("Cf. model 8# suma_plata (@0@) = suma_dat - suma_bonif - suma_ded (@1@) iar suma_rest (@2@) nu se completeaza pt cod_oblig = 121", new Object[]{this._suma_plata, Long.toString(this._suma_dat_f - this._suma_bonif_f - this._suma_ded_f), this._suma_rest}));
                    }
                    if (this._suma_bonif_f <= Math.round((double)this._suma_dat_f / 10.0)) break;
                    this._validator.addError(1, "Rbonif2", "", this._validator.fillParams("suma_bonif(@0@) nu poate depasi round(0.1 * suma_dat) (@1@)", new Object[]{this._suma_bonif, Long.toString(Math.round((double)this._suma_dat_f / 10.0))}));
                }
            }
        }
        this.endValidation(n);
    }

    public void aggregation(int n) {
        Declaratie100 declaratie100 = (Declaratie100)this._parent;
        if (this._cod_oblig_f == 121L && declaratie100._luna_f != 3L && declaratie100._luna_f != 6L && declaratie100._luna_f != 9L && declaratie100._luna_f != 12L) {
            this._validator.addError(1, "R121", "", this._validator.fillParams("impozitul pe veniturile microintreprinderilor se declara trimestrial ( luna in (3,6,9,12))", new Object[]{this._cota, this._cod_oblig}));
        }
        if (this._cod_oblig_ok && this._cota_ok && (this._cod_oblig_f == 121L && this._cota_f == 0L || this._cod_oblig_f != 121L && this._cota_f != 0L)) {
            this._validator.addError(1, "R17", "", this._validator.fillParams("Cota impozit pe veniturile microintreprinderilor (@0@) se completeaza daca si numai daca cod_oblig (@1@) = 121", new Object[]{this._cota, this._cod_oblig}));
        }
        if (this._cota_ok && this._cota_f == 2L && declaratie100._an_f >= 2017L) {
            this._validator.addError(1, "R17.1", "", this._validator.fillParams("Cota impozit pe veniturile microintreprinderilor (@0@) nu mai este admisa incepand cu perioada de raportare 01.2017", new Object[]{this._cota}));
        }
    }

    public void initialization() {
        this._tip_oblig = null;
        this._cod_oblig = null;
        this._cod_oblig_f = 0L;
        this._cod_oblig_ok = false;
        this._cod_bugetar = null;
        this._scadenta = null;
        this._scadenta_f = null;
        this._scadenta_ok = false;
        this._nr_evid = null;
        this._nr_evid_f = 0L;
        this._nr_evid_ok = false;
        this._suma_dat = null;
        this._suma_dat_f = 0L;
        this._suma_bonif = null;
        this._suma_bonif_f = 0L;
        this._suma_ded = null;
        this._suma_ded_f = 0L;
        this._suma_plata = null;
        this._suma_plata_f = 0L;
        this._suma_rest = null;
        this._suma_rest_f = 0L;
        this._cota = null;
        this._cota_f = 0L;
        this._cota_ok = false;
        this._name = "";
        this._scadentaFormatSort = "";
        this._scadentaFormatDeclaratie = "";
    }

    public int compareTo(Object object) {
        int n = (int)(this._cod_oblig_f - ((Obligatie)object)._cod_oblig_f);
        if (n == 0) {
            n = this._scadentaFormatSort.compareTo(((Obligatie)object)._scadentaFormatSort);
        }
        return n;
    }

    static {
        _dateFormat.setLenient(false);
        _dateFormat1.setLenient(false);
    }
}

